/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.FontAndColorsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SyntaxColoringPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JComboBox cbLanguages = new JComboBox();
    private JList lCategories = new JList();
    private JTextField tfFont = new JTextField("");
    private JButton bFont = new JButton("...");
    private ColorComboBox foregroundColorChooser = new ColorComboBox();
    private JButton bForeground = new JButton("...");
    private ColorComboBox backgroundColorChooser = new ColorComboBox();
    private JButton bBackground = new JButton("...");
    private JComboBox cbEffects = new JComboBox();
    private ColorComboBox effectsColorChooser = new ColorComboBox();
    private JPanel previewPanel = new JPanel();
    private ColorModel.Preview preview;
    private RequestProcessor.Task selectTask;
    private FontAndColorsPanel fontAndColorsPanel;
    private ColorModel colorModel = null;
    private String currentLanguage;
    private String currentProfile;
    private Map profiles = new HashMap();
    private Map toBeSaved = new HashMap();
    private boolean listen = false;
    private boolean blink = true;
    private int blinkSequence = 0;
    private RequestProcessor.Task task = new RequestProcessor("SyntaxColoringPanel").create(new Runnable(){

        public void run() {
            SyntaxColoringPanel.this.updatePreview();
            if (SyntaxColoringPanel.this.blinkSequence == 0) {
                return;
            }
            SyntaxColoringPanel.this.blinkSequence--;
            SyntaxColoringPanel.this.task.schedule(250);
        }
    });
    private Map defaults = new HashMap();
    private static Map convertALC = new HashMap();
    private static Integer defaultFontSize;

    public SyntaxColoringPanel(FontAndColorsPanel fontAndColorsPanel) {
        this.fontAndColorsPanel = fontAndColorsPanel;
        this.cbLanguages.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Languages"));
        this.cbLanguages.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Languages"));
        this.lCategories.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Categories"));
        this.bFont.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Font"));
        this.bFont.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Font"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Foreground_Chooser"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Foreground_Chooser"));
        this.bForeground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Foreground"));
        this.bForeground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Foreground"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Background_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Background_Chooser"));
        this.bBackground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Background"));
        this.bBackground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Background"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color_Chooser"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color_Chooser"));
        this.effectsColorChooser.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color"));
        this.effectsColorChooser.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color"));
        this.cbLanguages.addActionListener(this);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!SyntaxColoringPanel.this.listen) {
                    return;
                }
                SyntaxColoringPanel.this.selectTask.schedule(200);
            }
        });
        this.tfFont.setEditable(false);
        this.bFont.addActionListener(this);
        this.bFont.setMargin(new Insets(0, 0, 0, 0));
        this.bForeground.addActionListener(this);
        this.bForeground.setMargin(new Insets(0, 0, 0, 0));
        this.bBackground.addActionListener(this);
        this.bBackground.setMargin(new Insets(0, 0, 0, 0));
        this.foregroundColorChooser.addPropertyChangeListener(this);
        this.backgroundColorChooser.addPropertyChangeListener(this);
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_None"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Wave_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Strike_Through"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Effects"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Effects"));
        this.cbEffects.addActionListener(this);
        this.effectsColorChooser = new ColorComboBox();
        this.effectsColorChooser.addPropertyChangeListener(this);
        JLabel jLabel = new JLabel();
        SyntaxColoringPanel.loc(jLabel, "CTL_Category");
        jLabel.setLabelFor(this.lCategories);
        JLabel jLabel2 = new JLabel();
        SyntaxColoringPanel.loc(jLabel2, "CTL_Font");
        jLabel2.setLabelFor(this.bFont);
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.setBorder(new EtchedBorder());
        FormLayout formLayout = new FormLayout("p, 3dlu, 120dlu", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.addLabel(SyntaxColoringPanel.loc("CTL_Languages"), cellConstraints2.xy(1, 1), (Component)this.cbLanguages, cellConstraints.xy(3, 1));
        JPanel jPanel = panelBuilder.getPanel();
        formLayout = new FormLayout("p:g, 10dlu, p, 3dlu, p:g, 1dlu, p", "p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 5dlu, p, 3dlu, f:130dlu:g");
        panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.add((Component)jPanel, cellConstraints.xyw(1, 1, 5));
        panelBuilder.add((Component)jLabel, cellConstraints2.xy(1, 3));
        panelBuilder.add((Component)new JScrollPane(this.lCategories), cellConstraints.xywh(1, 5, 1, 9));
        panelBuilder.add((Component)jLabel2, cellConstraints2.xy(3, 5));
        panelBuilder.add((Component)this.tfFont, cellConstraints.xy(5, 5));
        panelBuilder.add((Component)this.bFont, cellConstraints.xy(7, 5));
        panelBuilder.addLabel(SyntaxColoringPanel.loc("CTL_Foreground_label"), cellConstraints2.xy(3, 7), (Component)this.foregroundColorChooser, cellConstraints.xyw(5, 7, 3));
        panelBuilder.addLabel(SyntaxColoringPanel.loc("CTL_Background_label"), cellConstraints2.xy(3, 9), (Component)this.backgroundColorChooser, cellConstraints.xyw(5, 9, 3));
        panelBuilder.addLabel(SyntaxColoringPanel.loc("CTL_Effects_label"), cellConstraints2.xy(3, 11), (Component)this.cbEffects, cellConstraints.xyw(5, 11, 3));
        panelBuilder.addLabel(SyntaxColoringPanel.loc("CTL_Effects_color"), cellConstraints2.xy(3, 13), (Component)this.effectsColorChooser, cellConstraints.xyw(5, 13, 3));
        panelBuilder.addLabel(SyntaxColoringPanel.loc("CTL_Preview"), cellConstraints2.xyw(1, 15, 7), (Component)this.previewPanel, cellConstraints.xyw(1, 17, 7));
        this.selectTask = new RequestProcessor("SyntaxColoringPanel1").create(new Runnable(){

            public void run() {
                SyntaxColoringPanel.this.refreshUI();
                if (!SyntaxColoringPanel.this.blink) {
                    return;
                }
                SyntaxColoringPanel.this.startBlinking();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        if (actionEvent.getSource() == this.cbEffects) {
            this.effectsColorChooser.setEnabled(this.cbEffects.getSelectedIndex() > 0);
            if (this.cbEffects.getSelectedIndex() == 0) {
                this.effectsColorChooser.setColor(null);
            }
            this.updateData();
        } else if (actionEvent.getSource() == this.cbLanguages) {
            this.setCurrentLanguage((String)this.cbLanguages.getSelectedItem());
        } else if (actionEvent.getSource() == this.bFont) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Font.class);
            AttributeSet attributeSet = this.getCurrentCategory();
            Font font = this.getFont(attributeSet);
            propertyEditor.setValue(font);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyEditor.getCustomEditor(), SyntaxColoringPanel.loc("CTL_Font_Chooser"));
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                font = (Font)propertyEditor.getValue();
                attributeSet = this.modifyFont(attributeSet, font);
                this.replaceCurrrentCategory(attributeSet);
                this.setToBeSaved(this.currentProfile, this.currentLanguage);
                this.refreshUI();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listen) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() == "currentAElement") {
            String string = (String)propertyChangeEvent.getNewValue();
            Vector vector = this.getCategories(this.currentProfile, this.currentLanguage);
            if (this.currentLanguage.equals(ColorModel.ALL_LANGUAGES)) {
                string = (String)convertALC.get(string);
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                AttributeSet attributeSet = (AttributeSet)vector.get(i);
                if (!string.equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) continue;
                this.blink = false;
                this.lCategories.setSelectedIndex(i);
                this.lCategories.ensureIndexIsVisible(i);
                this.blink = true;
                return;
            }
        }
        if (propertyChangeEvent.getPropertyName() != "color") {
            return;
        }
        this.updateData();
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.currentLanguage = (String)colorModel.getLanguages().iterator().next();
        if (this.preview != null) {
            this.preview.removePropertyChangeListener("currentAElement", this);
        }
        Component component = colorModel.getSyntaxColoringPreviewComponent(this.currentLanguage);
        this.preview = (ColorModel.Preview)component;
        this.previewPanel.removeAll();
        this.previewPanel.add("Center", component);
        this.preview.addPropertyChangeListener("currentAElement", this);
        this.listen = false;
        ArrayList arrayList = new ArrayList(colorModel.getLanguages());
        Collections.sort(arrayList, new LanguagesComparator());
        Iterator iterator = arrayList.iterator();
        this.cbLanguages.removeAllItems();
        while (iterator.hasNext()) {
            this.cbLanguages.addItem(iterator.next());
        }
        this.listen = true;
        this.cbLanguages.setSelectedIndex(0);
    }

    void cancel() {
        this.toBeSaved = new HashMap();
        this.profiles = new HashMap();
    }

    void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator iterator = this.toBeSaved.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)this.toBeSaved.get(string);
            Map map = (Map)this.profiles.get(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                this.colorModel.setCategories(string, string2, (Vector)map.get(string2));
            }
        }
        this.toBeSaved = new HashMap();
        this.profiles = new HashMap();
    }

    boolean isChanged() {
        return !this.toBeSaved.isEmpty();
    }

    public void setCurrentProfile(String string) {
        String string2 = this.currentProfile;
        this.currentProfile = string;
        if (!this.colorModel.getProfiles().contains(string)) {
            this.cloneScheme(string2, string);
        }
        Vector vector = this.getCategories(string, this.currentLanguage);
        this.lCategories.setListData(vector);
        this.blink = false;
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    void deleteProfile(String string) {
        Iterator iterator = this.colorModel.getLanguages().iterator();
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        boolean bl = this.colorModel.isCustomProfile(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (bl) {
                hashMap.put(string2, null);
                continue;
            }
            hashMap.put(string2, this.getDefaults(string, string2));
        }
        this.profiles.put(string, hashMap);
        this.toBeSaved.put(string, new HashSet(this.colorModel.getLanguages()));
        if (!bl) {
            this.refreshUI();
        }
    }

    private void cloneScheme(String string, String string2) {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.colorModel.getLanguages().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Vector vector = this.getCategories(string, string3);
            hashMap.put(string3, new Vector(vector));
            this.setToBeSaved(string2, string3);
        }
        this.profiles.put(string2, hashMap);
    }

    Collection getAllLanguages() {
        return this.getCategories(this.currentProfile, ColorModel.ALL_LANGUAGES);
    }

    Collection getSyntaxColorings() {
        return this.getCategories(this.currentProfile, this.currentLanguage);
    }

    private void setCurrentLanguage(String string) {
        this.currentLanguage = string;
        this.blink = false;
        this.lCategories.setListData(this.getCategories(this.currentProfile, this.currentLanguage));
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)SyntaxColoringPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)SyntaxColoringPanel.loc(string));
        }
    }

    private void updateData() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            return;
        }
        AttributeSet attributeSet = this.getCurrentCategory();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (this.cbEffects.getSelectedIndex() == 1) {
            color = this.effectsColorChooser.getColor();
        }
        if (this.cbEffects.getSelectedIndex() == 2) {
            color2 = this.effectsColorChooser.getColor();
        }
        if (this.cbEffects.getSelectedIndex() == 3) {
            color3 = this.effectsColorChooser.getColor();
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        if (this.backgroundColorChooser.getColor() != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, this.backgroundColorChooser.getColor());
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Background);
        }
        if (this.foregroundColorChooser.getColor() != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, this.foregroundColorChooser.getColor());
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
        }
        if (color != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Underline, color);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Underline);
        }
        if (color3 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, color3);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.StrikeThrough);
        }
        if (color2 != null) {
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, color2);
        } else {
            simpleAttributeSet.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.replaceCurrrentCategory(simpleAttributeSet);
        this.setToBeSaved(this.currentProfile, this.currentLanguage);
        this.updatePreview();
    }

    private void startBlinking() {
        this.blinkSequence = 5;
        this.task.schedule(0);
    }

    private void updatePreview() {
        Collection collection = this.getSyntaxColorings();
        Collection collection2 = this.getAllLanguages();
        if (this.blinkSequence % 2 == 1) {
            if (this.currentLanguage == ColorModel.ALL_LANGUAGES) {
                collection2 = this.invertCategory(collection2, this.getCurrentCategory());
            } else {
                collection = this.invertCategory(collection, this.getCurrentCategory());
            }
        }
        this.preview.setParameters(this.currentLanguage, collection2, this.fontAndColorsPanel.getHighlights(), collection);
    }

    private Collection invertCategory(Collection collection, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return collection;
        }
        ArrayList<SimpleAttributeSet> arrayList = new ArrayList<SimpleAttributeSet>(collection);
        int n = arrayList.indexOf(attributeSet);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        Color color = (Color)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Background);
        if (color == null) {
            return arrayList;
        }
        Color color2 = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        simpleAttributeSet.addAttribute(StyleConstants.Underline, color2);
        arrayList.set(n, simpleAttributeSet);
        return arrayList;
    }

    private void refreshUI() {
        this.listen = false;
        AttributeSet attributeSet = this.getCurrentCategory();
        if (attributeSet == null) {
            this.tfFont.setText("");
            this.bFont.setEnabled(false);
            this.cbEffects.setEnabled(false);
            this.foregroundColorChooser.setEnabled(false);
            this.foregroundColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
            this.backgroundColorChooser.setEnabled(false);
            this.backgroundColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
            this.effectsColorChooser.setEnabled(false);
            this.effectsColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
            this.updatePreview();
            return;
        }
        this.bFont.setEnabled(true);
        this.cbEffects.setEnabled(true);
        this.foregroundColorChooser.setEnabled(true);
        this.backgroundColorChooser.setEnabled(true);
        Color color = (Color)this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Foreground);
        if (color == null) {
            color = Color.black;
        }
        this.foregroundColorChooser.setInheritedColor(color);
        Color color2 = (Color)this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Background);
        if (color2 == null) {
            color2 = Color.white;
        }
        this.backgroundColorChooser.setInheritedColor(color2);
        String string = this.fontToString(attributeSet);
        this.tfFont.setText(string);
        this.foregroundColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.Foreground));
        this.backgroundColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.Background));
        if (attributeSet.getAttribute(StyleConstants.Underline) != null) {
            this.cbEffects.setSelectedIndex(1);
            this.effectsColorChooser.setEnabled(true);
            this.effectsColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.Underline));
        } else if (attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor) != null) {
            this.cbEffects.setSelectedIndex(2);
            this.effectsColorChooser.setEnabled(true);
            this.effectsColorChooser.setColor((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        } else if (attributeSet.getAttribute(StyleConstants.StrikeThrough) != null) {
            this.cbEffects.setSelectedIndex(3);
            this.effectsColorChooser.setEnabled(true);
            this.effectsColorChooser.setColor((Color)attributeSet.getAttribute(StyleConstants.StrikeThrough));
        } else {
            this.cbEffects.setSelectedIndex(0);
            this.effectsColorChooser.setEnabled(false);
            this.effectsColorChooser.setSelectedItem(new ColorComboBox.Value(null, null));
        }
        this.updatePreview();
        this.listen = true;
    }

    private void setToBeSaved(String string, String string2) {
        HashSet<String> hashSet = (HashSet<String>)this.toBeSaved.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.toBeSaved.put(string, hashSet);
        }
        hashSet.add(string2);
    }

    private Vector getCategories(String string, String string2) {
        Vector vector;
        if (this.colorModel == null) {
            return null;
        }
        HashMap hashMap = (HashMap)this.profiles.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.profiles.put(string, hashMap);
        }
        if ((vector = (Vector)hashMap.get(string2)) == null) {
            Collection collection = this.colorModel.getCategories(string, string2);
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            vector = new Vector(arrayList);
            hashMap.put(string2, vector);
        }
        return vector;
    }

    private Vector getDefaults(String string, String string2) {
        Vector vector;
        HashMap hashMap = (HashMap)this.defaults.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.defaults.put(string, hashMap);
        }
        if ((vector = (Vector)hashMap.get(string2)) == null) {
            Collection collection = this.colorModel.getDefaults(string, string2);
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            vector = new Vector(arrayList);
            hashMap.put(string2, vector);
        }
        return new Vector(vector);
    }

    private AttributeSet getCurrentCategory() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return (AttributeSet)this.getCategories(this.currentProfile, this.currentLanguage).get(n);
    }

    private void replaceCurrrentCategory(AttributeSet attributeSet) {
        int n = this.lCategories.getSelectedIndex();
        this.getCategories(this.currentProfile, this.currentLanguage).set(n, attributeSet);
    }

    private AttributeSet getCategory(String string, String string2, String string3) {
        Vector vector = this.getCategories(string, string2);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            if (!attributeSet.getAttribute(StyleConstants.NameAttribute).equals(string3)) continue;
            return attributeSet;
        }
        return null;
    }

    private Object getValue(String string, AttributeSet attributeSet, Object object) {
        if (attributeSet.isDefined(object)) {
            return attributeSet.getAttribute(object);
        }
        return this.getDefault(string, attributeSet, object);
    }

    private Object getDefault(String string, AttributeSet attributeSet, Object object) {
        AttributeSet attributeSet2;
        String string2 = (String)attributeSet.getAttribute(EditorStyleConstants.Default);
        if (string2 == null) {
            string2 = "default";
        }
        if (!string2.equals(attributeSet.getAttribute(StyleConstants.NameAttribute)) && (attributeSet2 = this.getCategory(this.currentProfile, string, string2)) != null) {
            return this.getValue(string, attributeSet2, object);
        }
        if (!string.equals(ColorModel.ALL_LANGUAGES) && (attributeSet2 = this.getCategory(this.currentProfile, ColorModel.ALL_LANGUAGES, string2)) != null) {
            return this.getValue(ColorModel.ALL_LANGUAGES, attributeSet2, object);
        }
        if (object == StyleConstants.FontFamily) {
            return "Monospaced";
        }
        if (object == StyleConstants.FontSize) {
            return SyntaxColoringPanel.getDefaultFontSize();
        }
        return null;
    }

    private Font getFont(AttributeSet attributeSet) {
        int n;
        Boolean bl;
        Boolean bl2;
        Integer n2;
        String string = (String)this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontFamily);
        if (string == null) {
            string = "Monospaced";
        }
        if ((n2 = (Integer)this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontSize)) == null) {
            n2 = SyntaxColoringPanel.getDefaultFontSize();
        }
        if ((bl2 = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Bold)) == null) {
            bl2 = Boolean.FALSE;
        }
        if ((bl = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Italic)) == null) {
            bl = Boolean.FALSE;
        }
        int n3 = n = bl2 != false ? 1 : 0;
        if (bl.booleanValue()) {
            n += 2;
        }
        return new Font(string, n, n2);
    }

    private AttributeSet modifyFont(AttributeSet attributeSet, Font font) {
        String string = font.getName();
        Integer n = new Integer(font.getSize());
        Boolean bl = font.isBold();
        Boolean bl2 = font.isItalic();
        boolean bl3 = "default".equals(attributeSet.getAttribute(StyleConstants.NameAttribute));
        if (string.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.FontFamily)) && !bl3) {
            string = null;
        }
        if (n.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.FontSize)) && !bl3) {
            n = null;
        }
        if (bl.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Bold))) {
            bl = null;
        } else if (bl.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Bold) == null) {
            bl = null;
        }
        if (bl2.equals(this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Italic))) {
            bl2 = null;
        } else if (bl2.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, attributeSet, StyleConstants.Italic) == null) {
            bl2 = null;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        if (string != null) {
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, string);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.FontFamily);
        }
        if (n != null) {
            simpleAttributeSet.addAttribute(StyleConstants.FontSize, n);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.FontSize);
        }
        if (bl != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Bold, bl);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Bold);
        }
        if (bl2 != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Italic, bl2);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Italic);
        }
        return simpleAttributeSet;
    }

    private String fontToString(AttributeSet attributeSet) {
        if ("default".equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) {
            Boolean bl;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontFamily));
            stringBuffer.append(' ');
            stringBuffer.append(this.getValue(this.currentLanguage, attributeSet, StyleConstants.FontSize));
            Boolean bl2 = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Bold);
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append(' ').append(SyntaxColoringPanel.loc("CTL_Bold"));
            }
            if ((bl = (Boolean)this.getValue(this.currentLanguage, attributeSet, StyleConstants.Italic)) != null && bl.booleanValue()) {
                stringBuffer.append(' ').append(SyntaxColoringPanel.loc("CTL_Italic"));
            }
            return stringBuffer.toString();
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (attributeSet.getAttribute(StyleConstants.FontFamily) != null) {
            stringBuffer.append('+').append(attributeSet.getAttribute(StyleConstants.FontFamily));
        } else {
            bl = true;
        }
        if (attributeSet.getAttribute(StyleConstants.FontSize) != null) {
            stringBuffer.append('+').append(attributeSet.getAttribute(StyleConstants.FontSize));
        } else {
            bl = true;
        }
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Bold))) {
            stringBuffer.append('+').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.FALSE.equals(attributeSet.getAttribute(StyleConstants.Bold))) {
            stringBuffer.append('-').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Italic))) {
            stringBuffer.append('+').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (Boolean.FALSE.equals(attributeSet.getAttribute(StyleConstants.Italic))) {
            stringBuffer.append('-').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (bl) {
            stringBuffer.insert(0, SyntaxColoringPanel.loc("CTL_Inherited"));
            return stringBuffer.toString();
        }
        String string = stringBuffer.toString();
        return string.replace('+', ' ');
    }

    private static Integer getDefaultFontSize() {
        if (defaultFontSize == null && (defaultFontSize = (Integer)UIManager.get("customFontSize")) == null) {
            int n = UIManager.getFont("TextField.font").getSize();
            if (n < 12) {
                n = 12;
            }
            defaultFontSize = new Integer(n);
        }
        return defaultFontSize;
    }

    static {
        convertALC.put("java-block-comment", "comment");
        convertALC.put("java-keywords", "keyword");
        convertALC.put("java-line-comment", "comment");
        convertALC.put("java-dentifier", "identifier");
        convertALC.put("java-numeric-literals", "number");
        convertALC.put("java-operators", "operator");
        convertALC.put("java-char-literal", "char");
        convertALC.put("java-string-literal", "string");
        convertALC.put("java-whitespace", "whitespace");
        convertALC.put("java-identifier", "identifier");
        convertALC.put("java-error", "error");
    }

    private static class LanguagesComparator
    implements Comparator {
        private LanguagesComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object.equals(ColorModel.ALL_LANGUAGES)) {
                return object2.equals(ColorModel.ALL_LANGUAGES) ? 0 : -1;
            }
            return ((String)object).compareTo((String)object2);
        }
    }
}

