/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.general;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.IDESettings;
import org.netbeans.modules.options.general.GeneralOptionsModel;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private JRadioButton rbFlatternPackages = new JRadioButton();
    private JRadioButton rbTreePackages = new JRadioButton();
    private JComboBox cbWebBrowser = new JComboBox();
    private JRadioButton rbNoProxy = new JRadioButton();
    private JRadioButton rbSystemProxy = new JRadioButton();
    private JRadioButton rbHTTPProxy = new JRadioButton();
    private JTextField tfHost = new JTextField();
    private JTextField tfPort = new JTextField();
    private JComboBox cbUpdatePeriod = new JComboBox<String>(new String[]{GeneralOptionsPanel.loc("CTL_Update_every_startup"), GeneralOptionsPanel.loc("CTL_Update_every_day"), GeneralOptionsPanel.loc("CTL_Update_every_week"), GeneralOptionsPanel.loc("CTL_Update_every_2weeks"), GeneralOptionsPanel.loc("CTL_Update_every_month"), GeneralOptionsPanel.loc("CTL_Update_never")});
    private JCheckBox cbAskBeforeCheck = new JCheckBox();
    private boolean changed = false;
    private GeneralOptionsModel model;

    GeneralOptionsPanel() {
        this.cbWebBrowser.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Web_Browser"));
        this.cbWebBrowser.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Web_Browser"));
        this.tfHost.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Host"));
        this.tfHost.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Host"));
        this.tfPort.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Port"));
        this.tfPort.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Port"));
        this.cbUpdatePeriod.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Update_Period"));
        this.cbUpdatePeriod.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Update_Period"));
        this.cbAskBeforeCheck.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Ask_Before_Check"));
        this.cbAskBeforeCheck.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Ask_Before_Check"));
        this.rbNoProxy.addActionListener(this);
        this.rbSystemProxy.addActionListener(this);
        this.rbHTTPProxy.addActionListener(this);
        this.rbFlatternPackages.addActionListener(this);
        this.rbTreePackages.addActionListener(this);
        this.cbWebBrowser.addActionListener(this);
        this.tfHost.addActionListener(this);
        this.tfPort.addActionListener(this);
        this.cbUpdatePeriod.addActionListener(this);
        this.cbAskBeforeCheck.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFlatternPackages);
        buttonGroup.add(this.rbTreePackages);
        GeneralOptionsPanel.loc(this.rbFlatternPackages, "Flattern_Packages");
        GeneralOptionsPanel.loc(this.rbTreePackages, "Tree_Packages");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rbNoProxy);
        buttonGroup2.add(this.rbSystemProxy);
        buttonGroup2.add(this.rbHTTPProxy);
        GeneralOptionsPanel.loc(this.rbNoProxy, "No_Proxy");
        GeneralOptionsPanel.loc(this.rbSystemProxy, "Use_System_Proxy_Settings");
        GeneralOptionsPanel.loc(this.rbHTTPProxy, "Use_HTTP_Proxy");
        FormLayout formLayout = new FormLayout("5dlu, l:p, 5dlu, p:g, 1dlu, p", "p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.addSeparator(GeneralOptionsPanel.loc("General"), cellConstraints.xyw(1, 1, 6));
        panelBuilder.addLabel(GeneralOptionsPanel.loc("Package_View_Type"), cellConstraints2.xy(2, 3), (Component)this.rbFlatternPackages, cellConstraints.xyw(4, 3, 3));
        panelBuilder.add((Component)this.rbTreePackages, cellConstraints.xyw(4, 5, 3));
        panelBuilder.addLabel(GeneralOptionsPanel.loc("Web_Browser"), cellConstraints2.xy(2, 7), (Component)this.cbWebBrowser, cellConstraints.xy(4, 7));
        panelBuilder.addSeparator(GeneralOptionsPanel.loc("Proxy_Settings"), cellConstraints.xyw(1, 9, 6));
        panelBuilder.addLabel(GeneralOptionsPanel.loc("Web_Proxy"), cellConstraints2.xy(2, 11), (Component)this.rbNoProxy, cellConstraints.xyw(4, 11, 3));
        panelBuilder.add((Component)this.rbSystemProxy, cellConstraints.xyw(4, 13, 3));
        panelBuilder.add((Component)this.rbHTTPProxy, cellConstraints.xyw(4, 15, 3));
        panelBuilder.addLabel(GeneralOptionsPanel.loc("Proxy_Host"), cellConstraints2.xy(2, 17), (Component)this.tfHost, cellConstraints.xyw(4, 17, 3));
        panelBuilder.addLabel(GeneralOptionsPanel.loc("Proxy_Port"), cellConstraints2.xy(2, 19), (Component)this.tfPort, cellConstraints.xyw(4, 19, 3));
        panelBuilder.addSeparator(GeneralOptionsPanel.loc("Auto_Update"), cellConstraints.xyw(1, 21, 6));
        panelBuilder.addLabel(GeneralOptionsPanel.loc("Check_Period"), cellConstraints2.xy(2, 23), (Component)this.cbUpdatePeriod, cellConstraints.xyw(4, 23, 3));
        panelBuilder.addLabel(GeneralOptionsPanel.loc("Ask_Before_Check"), cellConstraints2.xy(2, 25), (Component)this.cbAskBeforeCheck, cellConstraints.xyw(4, 25, 3));
        if (System.getProperty("netbeans.system_http_proxy") == null) {
            this.rbSystemProxy.setEnabled(false);
        }
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)GeneralOptionsPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)GeneralOptionsPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)GeneralOptionsPanel.loc("CTL_" + string));
        }
    }

    void update() {
        this.model = new GeneralOptionsModel();
        this.rbFlatternPackages.setSelected(true);
        switch (this.model.getProxyType()) {
            case 0: {
                this.rbNoProxy.setSelected(true);
                this.tfHost.setEnabled(false);
                this.tfPort.setEnabled(false);
                break;
            }
            case 1: {
                this.rbSystemProxy.setSelected(true);
                this.tfHost.setEnabled(false);
                this.tfPort.setEnabled(false);
                break;
            }
            default: {
                this.rbHTTPProxy.setSelected(true);
                this.tfHost.setEnabled(true);
                this.tfPort.setEnabled(true);
            }
        }
        this.tfHost.setText(this.model.getProxyHost());
        int n = this.model.getProxyPort();
        if (n > 0) {
            this.tfPort.setText(Integer.toString(n));
        } else {
            this.tfPort.setText("");
        }
        this.cbAskBeforeCheck.setSelected(this.model.getAutoUpdateAskBeforeCheck());
        this.cbUpdatePeriod.setSelectedIndex(this.model.getAutoUpdatePeriod());
        IDESettings iDESettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        HtmlBrowser.FactoryEditor factoryEditor = new HtmlBrowser.FactoryEditor();
        factoryEditor.setValue((Object)iDESettings.getWWWBrowser());
        this.cbWebBrowser.removeAllItems();
        String[] stringArray = factoryEditor.getTags();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            this.cbWebBrowser.addItem(stringArray[i]);
        }
        this.cbWebBrowser.setSelectedItem(factoryEditor.getAsText());
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.java.project.PackageViewSettings");
            SystemOption systemOption = (SystemOption)SystemOption.findObject(clazz, (boolean)true);
            Method method = clazz.getMethod("getPackageViewType", new Class[0]);
            Integer n3 = (Integer)method.invoke((Object)systemOption, new Object[0]);
            if (n3 == 0) {
                this.rbFlatternPackages.setSelected(true);
            } else {
                this.rbTreePackages.setSelected(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.changed = false;
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        this.model.setProxyHost(this.tfHost.getText());
        try {
            this.model.setProxyPort(Math.max(Integer.parseInt(this.tfPort.getText()), 0));
        }
        catch (NumberFormatException numberFormatException) {
            this.model.setProxyPort(0);
        }
        if (this.rbNoProxy.isSelected()) {
            this.model.setProxyType(0);
        } else if (this.rbSystemProxy.isSelected()) {
            this.model.setProxyType(1);
        } else {
            this.model.setProxyType(2);
        }
        this.model.setAutoUpdateAskBeforeCheck(this.cbAskBeforeCheck.isSelected());
        this.model.setAutoUpdatePeriod(this.cbUpdatePeriod.getSelectedIndex());
        IDESettings iDESettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        HtmlBrowser.FactoryEditor factoryEditor = new HtmlBrowser.FactoryEditor();
        factoryEditor.setAsText((String)this.cbWebBrowser.getSelectedItem());
        iDESettings.setWWWBrowser((HtmlBrowser.Factory)factoryEditor.getValue());
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.java.project.PackageViewSettings");
            SystemOption systemOption = (SystemOption)SystemOption.findObject(clazz, (boolean)true);
            Method method = clazz.getMethod("setPackageViewType", Integer.TYPE);
            Integer n = new Integer(1);
            if (this.rbFlatternPackages.isSelected()) {
                n = new Integer(0);
            }
            method.invoke((Object)systemOption, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void cancel() {
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        if (!this.tfHost.getText().equals(this.model.getProxyHost())) {
            return true;
        }
        if (this.model.getProxyPort() > 0 ? !this.tfPort.getText().equals(Integer.toString(this.model.getProxyPort())) : !this.tfPort.getText().equals("")) {
            return true;
        }
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.changed = true;
        this.tfHost.setEnabled(this.rbHTTPProxy.isSelected());
        this.tfPort.setEnabled(this.rbHTTPProxy.isSelected());
    }
}

