/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.options.generaleditor.Model;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class GeneralEditorPanel
extends JPanel
implements ActionListener {
    private JCheckBox cbShowCodeFolding = new JCheckBox();
    private JCheckBox cbFoldMethods = new JCheckBox();
    private JCheckBox cbFoldInnerClasses = new JCheckBox();
    private JCheckBox cbFoldImports = new JCheckBox();
    private JCheckBox cbFoldJavaDocComments = new JCheckBox();
    private JCheckBox cbFoldInitialComment = new JCheckBox();
    private JCheckBox cbAutoPopup = new JCheckBox();
    private JCheckBox cbInsertSingleProposals = new JCheckBox();
    private JCheckBox cbCaseSensitive = new JCheckBox();
    private JCheckBox cbShowDeprecated = new JCheckBox();
    private JCheckBox cbPairCharacterCompletion = new JCheckBox();
    private boolean changed = false;
    private boolean listen = false;
    private Model model;

    public GeneralEditorPanel() {
        GeneralEditorPanel.loc(this.cbShowCodeFolding, "Use_Folding");
        GeneralEditorPanel.loc(this.cbFoldMethods, "Fold_Methods");
        GeneralEditorPanel.loc(this.cbFoldInnerClasses, "Fold_Classes");
        GeneralEditorPanel.loc(this.cbFoldImports, "Fold_Imports");
        GeneralEditorPanel.loc(this.cbFoldJavaDocComments, "Fold_JavaDoc");
        GeneralEditorPanel.loc(this.cbFoldInitialComment, "Fold_Licence");
        GeneralEditorPanel.loc(this.cbAutoPopup, "Auto_Popup_Completion_Window");
        GeneralEditorPanel.loc(this.cbInsertSingleProposals, "Insert_Single_Proposals_Automatically");
        GeneralEditorPanel.loc(this.cbCaseSensitive, "Case_Sensitive_Code_Completion");
        GeneralEditorPanel.loc(this.cbShowDeprecated, "Show_Deprecated_Members");
        GeneralEditorPanel.loc(this.cbPairCharacterCompletion, "Pair_Character_Completion");
        FormLayout formLayout = new FormLayout("5dlu, p, 5dlu, p:g", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p,5dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.addSeparator(GeneralEditorPanel.loc("Code_Folding"), cellConstraints.xyw(1, 1, 4));
        panelBuilder.addLabel(GeneralEditorPanel.loc("Code_Folding_Section"), cellConstraints2.xy(2, 3), (Component)this.cbShowCodeFolding, cellConstraints.xy(4, 3));
        panelBuilder.addLabel(GeneralEditorPanel.loc("Fold_by_Default"), cellConstraints2.xy(2, 5), (Component)this.cbFoldMethods, cellConstraints.xy(4, 5));
        panelBuilder.add((Component)this.cbFoldInnerClasses, cellConstraints.xy(4, 7));
        panelBuilder.add((Component)this.cbFoldImports, cellConstraints.xy(4, 9));
        panelBuilder.add((Component)this.cbFoldJavaDocComments, cellConstraints.xy(4, 11));
        panelBuilder.add((Component)this.cbFoldInitialComment, cellConstraints.xy(4, 13));
        panelBuilder.addSeparator(GeneralEditorPanel.loc("Code_Completion"), cellConstraints.xyw(1, 15, 4));
        panelBuilder.addLabel(GeneralEditorPanel.loc("Code_Completion_Section"), cellConstraints2.xy(2, 17), (Component)this.cbAutoPopup, cellConstraints.xy(4, 17));
        panelBuilder.add((Component)this.cbInsertSingleProposals, cellConstraints.xy(4, 19));
        panelBuilder.add((Component)this.cbCaseSensitive, cellConstraints.xy(4, 21));
        panelBuilder.add((Component)this.cbShowDeprecated, cellConstraints.xy(4, 23));
        panelBuilder.add((Component)this.cbPairCharacterCompletion, cellConstraints.xy(4, 25));
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)GeneralEditorPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(GeneralEditorPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(GeneralEditorPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)GeneralEditorPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)GeneralEditorPanel.loc("CTL_" + string));
        }
    }

    void update() {
        this.listen = false;
        if (this.model == null) {
            this.model = new Model();
            this.cbShowCodeFolding.addActionListener(this);
            this.cbFoldMethods.addActionListener(this);
            this.cbFoldInnerClasses.addActionListener(this);
            this.cbFoldImports.addActionListener(this);
            this.cbFoldJavaDocComments.addActionListener(this);
            this.cbFoldInitialComment.addActionListener(this);
            this.cbAutoPopup.addActionListener(this);
            this.cbInsertSingleProposals.addActionListener(this);
            this.cbCaseSensitive.addActionListener(this);
            this.cbShowDeprecated.addActionListener(this);
            this.cbPairCharacterCompletion.addActionListener(this);
        }
        this.cbShowCodeFolding.setSelected(this.model.isShowCodeFolding());
        this.cbFoldImports.setSelected(this.model.isFoldImports());
        this.cbFoldInitialComment.setSelected(this.model.isFoldInitialComment());
        this.cbFoldInnerClasses.setSelected(this.model.isFoldInnerClasses());
        this.cbFoldJavaDocComments.setSelected(this.model.isFoldJavaDocComments());
        this.cbFoldMethods.setSelected(this.model.isFoldMethods());
        this.updateEnabledState();
        this.cbPairCharacterCompletion.setSelected(this.model.isPairCharacterCompletion());
        this.cbAutoPopup.setSelected(this.model.isCompletionAutoPopup());
        this.cbShowDeprecated.setSelected(this.model.isShowDeprecatedMembers());
        this.cbInsertSingleProposals.setSelected(this.model.isCompletionInstantSubstitution());
        this.cbCaseSensitive.setSelected(this.model.isCompletionCaseSensitive());
        this.listen = true;
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        this.model.setFoldingOptions(this.cbShowCodeFolding.isSelected(), this.cbFoldImports.isSelected(), this.cbFoldInitialComment.isSelected(), this.cbFoldInnerClasses.isSelected(), this.cbFoldJavaDocComments.isSelected(), this.cbFoldMethods.isSelected());
        this.model.setCompletionOptions(this.cbPairCharacterCompletion.isSelected(), this.cbAutoPopup.isSelected(), this.cbShowDeprecated.isSelected(), this.cbInsertSingleProposals.isSelected(), this.cbCaseSensitive.isSelected());
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        if (actionEvent.getSource() == this.cbShowCodeFolding) {
            this.updateEnabledState();
        }
        this.changed = true;
    }

    private void updateEnabledState() {
        boolean bl = this.cbShowCodeFolding.isSelected();
        this.cbFoldImports.setEnabled(bl);
        this.cbFoldInitialComment.setEnabled(bl);
        this.cbFoldInnerClasses.setEnabled(bl);
        this.cbFoldJavaDocComments.setEnabled(bl);
        this.cbFoldMethods.setEnabled(bl);
    }
}

