/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

class IndentationModel {
    private boolean originalExpandedTabs = this.isExpandTabs();
    private boolean originalAddStar = this.getJavaFormatLeadingStarInComment();
    private boolean originalNewLine = this.getJavaFormatNewlineBeforeBrace();
    private boolean originalSpace = this.getJavaFormatSpaceBeforeParenthesis();
    private int originalStatementIndent = this.getJavaFormatStatementContinuationIndent();
    private int originalIndent = this.getSpacesPerTab();
    private boolean changed = false;
    private IndentEngine javaIndentEngine;
    private ClassLoader classLoader;

    IndentationModel() {
    }

    boolean isExpandTabs() {
        return (Boolean)this.getParameter("isExpandTabs", Boolean.FALSE);
    }

    void setExpandTabs(boolean bl) {
        this.setParameter("setExpandTabs", bl, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatLeadingStarInComment() {
        return (Boolean)this.getParameter("getJavaFormatLeadingStarInComment", Boolean.FALSE);
    }

    void setJavaFormatLeadingStarInComment(boolean bl) {
        this.setParameter("setJavaFormatLeadingStarInComment", bl, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatSpaceBeforeParenthesis() {
        return (Boolean)this.getParameter("getJavaFormatSpaceBeforeParenthesis", Boolean.FALSE);
    }

    void setJavaFormatSpaceBeforeParenthesis(boolean bl) {
        this.setParameter("setJavaFormatSpaceBeforeParenthesis", bl, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatNewlineBeforeBrace() {
        return (Boolean)this.getParameter("getJavaFormatNewlineBeforeBrace", Boolean.FALSE);
    }

    void setJavaFormatNewlineBeforeBrace(boolean bl) {
        this.setParameter("setJavaFormatNewlineBeforeBrace", bl, Boolean.TYPE);
        this.updateChanged();
    }

    Integer getJavaFormatStatementContinuationIndent() {
        return (Integer)this.getParameter("getJavaFormatStatementContinuationIndent", new Integer(4));
    }

    void setJavaFormatStatementContinuationIndent(Integer n) {
        if (n > 0) {
            this.setParameter("setJavaFormatStatementContinuationIndent", n, Integer.TYPE);
        }
        this.updateChanged();
    }

    Integer getSpacesPerTab() {
        return (Integer)this.getParameter("getSpacesPerTab", new Integer(4));
    }

    void setSpacesPerTab(Integer n) {
        if (n > 0) {
            this.setParameter("setSpacesPerTab", n, Integer.TYPE);
        }
        this.updateChanged();
    }

    boolean isChanged() {
        return this.changed;
    }

    void revertChanges() {
        if (!this.changed) {
            return;
        }
        if (this.getJavaFormatLeadingStarInComment() != this.originalAddStar) {
            this.setJavaFormatLeadingStarInComment(this.originalAddStar);
        }
        if (this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine) {
            this.setJavaFormatNewlineBeforeBrace(this.originalNewLine);
        }
        if (this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace) {
            this.setJavaFormatSpaceBeforeParenthesis(this.originalSpace);
        }
        if (this.isExpandTabs() != this.originalExpandedTabs) {
            this.setExpandTabs(this.originalExpandedTabs);
        }
        if (this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent && this.originalStatementIndent > 0) {
            this.setJavaFormatStatementContinuationIndent(new Integer(this.originalStatementIndent));
        }
        if (this.getSpacesPerTab() != this.originalIndent && this.originalIndent > 0) {
            this.setSpacesPerTab(new Integer(this.originalIndent));
        }
    }

    private void updateChanged() {
        this.changed = this.isExpandTabs() != this.originalExpandedTabs || this.getJavaFormatLeadingStarInComment() != this.originalAddStar || this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine || this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace || this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent || this.getSpacesPerTab() != this.originalIndent;
    }

    private Object getParameter(String string, Object object) {
        Object object2;
        if (this.javaIndentEngine == null) {
            object2 = IndentationModel.getOptions("text/x-java");
            if (object2 == null) {
                object2 = IndentationModel.getOptions("text/plain");
            }
            if (object2 == null) {
                return object;
            }
            this.javaIndentEngine = object2.getIndentEngine();
        }
        try {
            object2 = this.javaIndentEngine.getClass().getMethod(string, new Class[0]);
            return ((Method)object2).invoke((Object)this.javaIndentEngine, new Object[0]);
        }
        catch (Exception exception) {
            return object;
        }
    }

    private void setParameter(String string, Object object, Class clazz) {
        Iterator iterator = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)clazz2, (boolean)true);
            IndentEngine indentEngine = baseOptions.getIndentEngine();
            try {
                GenericDeclaration genericDeclaration;
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.java.editor.options.JavaOptions") && !indentEngine.getClass().getName().equals("org.netbeans.modules.editor.java.JavaIndentEngine")) {
                    genericDeclaration = this.getClassLoader().loadClass("org.netbeans.modules.editor.java.JavaIndentEngine");
                    indentEngine = (IndentEngine)Lookup.getDefault().lookup(genericDeclaration);
                    baseOptions.setIndentEngine(indentEngine);
                }
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JSPOptions") && !indentEngine.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JspIndentEngine")) {
                    genericDeclaration = this.getClassLoader().loadClass("org.netbeans.modules.web.core.syntax.JspIndentEngine");
                    indentEngine = (IndentEngine)Lookup.getDefault().lookup(genericDeclaration);
                    baseOptions.setIndentEngine(indentEngine);
                }
                genericDeclaration = indentEngine.getClass().getMethod(string, clazz);
                ((Method)genericDeclaration).invoke(indentEngine, object);
            }
            catch (Exception exception) {}
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        }
        return this.classLoader;
    }

    private static BaseOptions getOptions(String string) {
        Iterator iterator = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)clazz, (boolean)true);
            BaseKit baseKit = BaseKit.getKit((Class)baseOptions.getKitClass());
            if (!baseKit.getContentType().equals(string)) continue;
            return baseOptions;
        }
        return null;
    }
}

