/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class EditorBridge {
    private Map actions;
    private Map editorActionsMap;
    private Map actionNameToMimeTypes = new HashMap();
    private EditorSettings editorSettings;
    private Map keyBindingSettings = new HashMap();
    private Listener listener;
    static /* synthetic */ Class class$org$netbeans$modules$options$keymap$EditorBridge;

    Map getActions() {
        if (this.actions == null) {
            Map map = EditorBridge.readCategories();
            this.actions = new HashMap();
            Iterator iterator = this.getEditorActionsMap().values().iterator();
            while (iterator.hasNext()) {
                HashSet<ActionImpl> hashSet;
                ActionImpl actionImpl = (ActionImpl)iterator.next();
                String string = (String)map.get(actionImpl.getId());
                if (string == null) {
                    string = NbBundle.getMessage((Class)(class$org$netbeans$modules$options$keymap$EditorBridge == null ? EditorBridge.class$("org.netbeans.modules.options.keymap.EditorBridge") : class$org$netbeans$modules$options$keymap$EditorBridge), (String)"CTL_Other");
                }
                if ((hashSet = (HashSet<ActionImpl>)this.actions.get(string)) == null) {
                    hashSet = new HashSet<ActionImpl>();
                    this.actions.put(string, hashSet);
                }
                hashSet.add(actionImpl);
            }
            this.actions.remove("Hidden");
        }
        return this.actions;
    }

    void refreshActions() {
        this.editorActionsMap = null;
        this.actions = null;
        this.actionNameToMimeTypes = new HashMap();
    }

    String getCurrentProfile() {
        return this.getEditorSettings().getCurrentKeyMapProfile();
    }

    void setCurrentProfile(String string) {
        this.getEditorSettings().setCurrentKeyMapProfile(string);
    }

    boolean isCustomProfile(String string) {
        return this.getEditorSettings().isCustomKeymapProfile(string);
    }

    Map readKeymap(String string) {
        HashMap hashMap = new HashMap();
        this.readKeymap(string, "text/base", false, hashMap);
        Iterator iterator = this.getEditorSettings().getMimeTypes().iterator();
        while (iterator.hasNext()) {
            this.readKeymap(string, (String)iterator.next(), false, hashMap);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    Map readKeymapDefaults(String string) {
        HashMap hashMap = new HashMap();
        this.readKeymap(string, "text/base", true, hashMap);
        Iterator iterator = this.getEditorSettings().getMimeTypes().iterator();
        while (iterator.hasNext()) {
            this.readKeymap(string, (String)iterator.next(), true, hashMap);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    void deleteProfile(String string) {
        KeyBindingSettingsFactory keyBindingSettingsFactory = this.getKeyBindingSettings("text/base");
        keyBindingSettingsFactory.setKeyBindings(string, null);
    }

    void saveKeymap(String string, Map map) {
        Set set;
        Object object;
        HashMap<String, ArrayList<MultiKeyBinding>> hashMap = new HashMap<String, ArrayList<MultiKeyBinding>>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (ActionImpl)iterator.next();
            set = (Set)map.get(object);
            if (object instanceof CompoundAction) {
                object = ((CompoundAction)object).getEditorAction();
            }
            if (!(object instanceof EditorAction)) continue;
            EditorAction editorAction = (EditorAction)object;
            Set set2 = this.getMimeTypes(editorAction);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                MultiKeyBinding multiKeyBinding = new MultiKeyBinding(Utils.stringToKeyStrokes2(string2), editorAction.getId());
                Iterator iterator3 = set2.iterator();
                while (iterator3.hasNext()) {
                    String string3 = (String)iterator3.next();
                    ArrayList<MultiKeyBinding> arrayList = (ArrayList<MultiKeyBinding>)hashMap.get(string3);
                    if (arrayList == null) {
                        arrayList = new ArrayList<MultiKeyBinding>();
                        hashMap.put(string3, arrayList);
                    }
                    arrayList.add(multiKeyBinding);
                }
            }
        }
        iterator = this.keyBindingSettings.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            set = (KeyBindingSettingsFactory)this.keyBindingSettings.get(object);
            set.setKeyBindings(string, (List)hashMap.get(object));
        }
    }

    private Map getEditorActionsMap() {
        if (this.editorActionsMap == null) {
            this.editorActionsMap = new HashMap();
            Iterator iterator = this.getEditorSettings().getMimeTypes().iterator();
            while (iterator.hasNext()) {
                this.initActionMap((String)iterator.next());
            }
            this.initActionMap("text/base");
        }
        return this.editorActionsMap;
    }

    private Set getMimeTypes(EditorAction editorAction) {
        this.getEditorActionsMap();
        return (Set)this.actionNameToMimeTypes.get(editorAction.getId());
    }

    private void initActionMap(String string) {
        Action[] actionArray;
        Object object = null;
        if (string.equals("text/base")) {
            object = BaseKit.getKit((Class)ExtKit.class);
        } else {
            actionArray = MimeLookup.getMimeLookup((String)string);
            object = (EditorKit)actionArray.lookup(EditorKit.class);
        }
        if (object == null) {
            if (System.getProperty("org.netbeans.optionsDialog") != null) {
                System.out.println("KeymapModel EditorKit not found for: " + string);
            }
            return;
        }
        actionArray = object.getActions();
        int n = actionArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = actionArray[i].getValue("no-keybinding");
            if (object2 instanceof Boolean && ((Boolean)object2).booleanValue()) continue;
            EditorAction editorAction = new EditorAction((TextAction)actionArray[i]);
            String string2 = editorAction.getId();
            this.editorActionsMap.put(string2, editorAction);
            if (string.equals("text/base")) {
                this.actionNameToMimeTypes.put(string2, Collections.singleton("text/base"));
                continue;
            }
            HashSet<String> hashSet = (HashSet<String>)this.actionNameToMimeTypes.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.actionNameToMimeTypes.put(string2, hashSet);
            }
            hashSet.add(string);
        }
    }

    private EditorSettings getEditorSettings() {
        if (this.editorSettings == null) {
            this.editorSettings = EditorSettings.getDefault();
        }
        return this.editorSettings;
    }

    private KeyBindingSettingsFactory getKeyBindingSettings(String string) {
        if (this.keyBindingSettings.containsKey(string)) {
            return (KeyBindingSettingsFactory)this.keyBindingSettings.get(string);
        }
        KeyBindingSettingsFactory keyBindingSettingsFactory = EditorSettings.getDefault().getKeyBindingSettings(new String[]{string});
        this.keyBindingSettings.put(string, keyBindingSettingsFactory);
        this.getListener().add(keyBindingSettingsFactory);
        return keyBindingSettingsFactory;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    private void readKeymap(String string, String string2, boolean bl, Map map) {
        List list;
        KeyBindingSettingsFactory keyBindingSettingsFactory = this.getKeyBindingSettings(string2);
        if (keyBindingSettingsFactory == null) {
            return;
        }
        List list2 = list = bl ? keyBindingSettingsFactory.getKeyBindingDefaults(string) : keyBindingSettingsFactory.getKeyBindings(string);
        if (list == null) {
            return;
        }
        Map map2 = EditorBridge.convertKeymap(list);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Set set = (Set)map2.get(string3);
            ActionImpl actionImpl = (ActionImpl)this.getEditorActionsMap().get(string3);
            if (actionImpl == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("action not found " + string3);
                continue;
            }
            Set set2 = (Set)map.get(actionImpl);
            if (set2 == null) {
                map.put(actionImpl, set);
                continue;
            }
            set2.addAll(set);
        }
    }

    private static Map convertKeymap(List list) {
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            HashSet<String> hashSet;
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)list.get(i);
            String string = "";
            Iterator iterator = multiKeyBinding.getKeyStrokeList().iterator();
            if (iterator.hasNext()) {
                hashSet = new StringBuffer(Utilities.keyToString((KeyStroke)((KeyStroke)iterator.next())));
                while (iterator.hasNext()) {
                    ((StringBuffer)((Object)hashSet)).append(' ').append(Utilities.keyToString((KeyStroke)((KeyStroke)iterator.next())));
                }
                string = ((StringBuffer)((Object)hashSet)).toString();
            }
            if ((hashSet = (Set)hashMap.get(multiKeyBinding.getActionName())) == null) {
                hashSet = new HashSet<String>();
                hashMap.put(multiKeyBinding.getActionName(), hashSet);
            }
            hashSet.add(string);
        }
        return hashMap;
    }

    private static Map readCategories() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("OptionsDialog/Actions");
        if (fileObject == null) {
            return hashMap;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = fileObjectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = fileObjectArray[i].getName();
            String string2 = (String)fileObjectArray[i].getAttribute("SystemFileSystem.localizingBundle");
            if (string2 != null) {
                try {
                    string = NbBundle.getBundle((String)string2).getString(fileObjectArray[i].getPath());
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().notify((Throwable)missingResourceException);
                }
            }
            FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
            int n2 = fileObjectArray2.length;
            for (int j = 0; j < n2; ++j) {
                if (fileObjectArray2[j].getExt().length() > 0) continue;
                String string3 = fileObjectArray2[j].getName();
                hashMap.put(string3, string);
            }
        }
        return hashMap;
    }

    public static class EditorAction
    implements ActionImpl {
        private TextAction action;
        private String name;
        private String id;
        private String delegaitngActionId;

        public EditorAction(TextAction textAction) {
            this.action = textAction;
        }

        public String getDisplayName() {
            if (this.name == null) {
                this.name = (String)this.action.getValue("ShortDescription");
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        public String getId() {
            if (this.id == null) {
                this.id = (String)this.action.getValue("Name");
            }
            return this.id;
        }

        public String getDelegatingActionId() {
            if (this.delegaitngActionId == null) {
                this.delegaitngActionId = (String)this.action.getValue("systemActionClassName");
            }
            return this.delegaitngActionId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof EditorAction)) {
                return false;
            }
            return ((EditorAction)object).getId().equals(this.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return super.toString() + ":" + this.getId();
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference model;
        private Set settings = new HashSet();

        Listener(EditorBridge editorBridge) {
            this.model = new WeakReference<EditorBridge>(editorBridge);
        }

        void add(KeyBindingSettingsFactory keyBindingSettingsFactory) {
            this.settings.add(keyBindingSettingsFactory);
            keyBindingSettingsFactory.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private EditorBridge getModel() {
            EditorBridge editorBridge = (EditorBridge)this.model.get();
            if (editorBridge != null) {
                return editorBridge;
            }
            Iterator iterator = this.settings.iterator();
            while (iterator.hasNext()) {
                ((KeyBindingSettingsFactory)iterator.next()).removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.settings = new HashSet();
            return null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EditorBridge editorBridge = this.getModel();
            if (editorBridge == null) {
                return;
            }
        }
    }
}

