/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapListRenderer;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KeymapPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
ListSelectionListener {
    private JButton bDelete = new JButton();
    private JButton bClone = new JButton();
    private ButtonGroup bgViewAs = new ButtonGroup();
    private JComboBox cbProfiles = new JComboBox();
    private JRadioButton rbAction = new JRadioButton();
    private JRadioButton rbShortcut = new JRadioButton();
    private JTree tree = new JTree();
    private JList lShortcuts = new JList();
    private JButton bAddShortcut = new JButton();
    private JButton bRemoveShortcut = new JButton();
    private boolean listen = false;
    private boolean initialized = false;
    private KeymapViewModel model;

    public KeymapPanel() {
        KeymapPanel.loc(this.bClone, "Duplicate");
        KeymapPanel.loc(this.bDelete, "Delete");
        KeymapPanel.loc(this.rbAction, "Show_Actions");
        KeymapPanel.loc(this.rbShortcut, "Show_Shortcuts");
        this.lShortcuts.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Shortcuts"));
        this.lShortcuts.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Shortcuts"));
        this.tree.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Actions"));
        this.tree.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Actions"));
        this.cbProfiles.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Profiles"));
        this.cbProfiles.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Profiles"));
        this.bgViewAs.add(this.rbAction);
        this.bgViewAs.add(this.rbShortcut);
        this.bClone.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.rbAction.setSelected(true);
        this.rbAction.addActionListener(this);
        this.rbShortcut.addActionListener(this);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setPreferredSize(new Dimension(10, 10));
        this.cbProfiles.addActionListener(this);
        KeymapPanel.loc(this.bAddShortcut, "Add_Shortcut");
        KeymapPanel.loc(this.bRemoveShortcut, "Remove_Shortcut");
        this.bAddShortcut.addActionListener(this);
        this.bRemoveShortcut.addActionListener(this);
        this.lShortcuts.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.lShortcuts);
        jScrollPane2.setPreferredSize(new Dimension(10, 10));
        this.bAddShortcut.setEnabled(false);
        this.bRemoveShortcut.setEnabled(false);
        JLabel jLabel = new JLabel();
        KeymapPanel.loc(jLabel, "Shortcuts");
        jLabel.setLabelFor(this.lShortcuts);
        JLabel jLabel2 = new JLabel();
        KeymapPanel.loc(jLabel2, "Actions");
        jLabel2.setLabelFor(this.tree);
        FormLayout formLayout = new FormLayout("p", "p, 3dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.add((Component)this.bAddShortcut, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.bRemoveShortcut, cellConstraints.xy(1, 3));
        JPanel jPanel = panelBuilder.getPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 3, 3));
        jPanel2.add(this.bClone);
        jPanel2.add(this.bDelete);
        formLayout = new FormLayout("p:g, 3dlu, p:g", "p, 1dlu, p");
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3}});
        panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.add((Component)jLabel, cellConstraints2.xy(1, 1));
        panelBuilder.add((Component)jScrollPane2, cellConstraints.xy(1, 3, "f, f"));
        panelBuilder.add((Component)jPanel, cellConstraints.xy(3, 3));
        JPanel jPanel3 = panelBuilder.getPanel();
        formLayout = new FormLayout("p, 3dlu, p:g, 5dlu, p", "p, 3dlu, p, 1dlu, 50dlu:g, 5dlu, p");
        panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        panelBuilder.addLabel(KeymapPanel.loc("Keymap_Name"), cellConstraints2.xy(1, 1), (Component)this.cbProfiles, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints2.xyw(1, 3, 5));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 5, 5, 1, "f, f"));
        panelBuilder.add((Component)jPanel3, cellConstraints.xyw(1, 7, 5));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.bAddShortcut) {
            Object object2 = this.tree.getSelectionPath().getLastPathComponent();
            String string = ShortcutsDialog.getShortcut(this.getModel());
            if (string == null) {
                return;
            }
            this.getModel().addShortcut(this.tree.getSelectionPath(), string);
            this.selectAction(object2);
            if (this.lShortcuts.getModel().getSize() > 0) {
                this.lShortcuts.setSelectedIndex(0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KeymapPanel.this.lShortcuts.requestFocus();
                }
            });
        } else if (object == this.bRemoveShortcut) {
            int n = this.lShortcuts.getSelectedIndex();
            Object object3 = this.tree.getSelectionPath().getLastPathComponent();
            String string = (String)this.lShortcuts.getSelectedValue();
            this.getModel().removeShortcut(this.tree.getSelectionPath(), string);
            this.selectAction(object3);
            if (this.lShortcuts.getModel().getSize() > n) {
                this.lShortcuts.setSelectedIndex(n);
            } else if (this.lShortcuts.getModel().getSize() > 0) {
                this.lShortcuts.setSelectedIndex(0);
            }
        } else if (object == this.bDelete) {
            this.deleteCurrentProfile();
        } else if (object == this.cbProfiles) {
            String string = (String)this.cbProfiles.getSelectedItem();
            this.getModel().setCurrentProfile(string);
            if (this.getModel().isCustomProfile(string)) {
                KeymapPanel.loc(this.bDelete, "Delete");
            } else {
                KeymapPanel.loc(this.bDelete, "Restore");
            }
            this.refreshAction();
        } else if (object == this.bClone) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(KeymapPanel.loc("CTL_Create_New_Profile_Message"), KeymapPanel.loc("CTL_Create_New_Profile_Title"));
            inputLine.setInputText((String)this.cbProfiles.getSelectedItem());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
                String string = inputLine.getInputText();
                Iterator iterator = this.getModel().getProfiles().iterator();
                while (iterator.hasNext()) {
                    if (!string.equals(iterator.next())) continue;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)KeymapPanel.loc("CTL_Duplicate_Profile_Name"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                this.getModel().cloneProfile(string);
                this.cbProfiles.addItem(inputLine.getInputText());
                this.cbProfiles.setSelectedItem(inputLine.getInputText());
            }
            return;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.listen) {
            return;
        }
        this.refreshAction();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.listen) {
            return;
        }
        int n = this.lShortcuts.getSelectedIndex();
        if (n < 0) {
            this.bRemoveShortcut.setEnabled(false);
            return;
        }
        this.bRemoveShortcut.setEnabled(true);
    }

    void update() {
        if (!this.initialized) {
            this.initialized = true;
            this.listen = false;
            this.tree.setCellRenderer(new KeymapListRenderer(this.getModel()));
            this.tree.setModel(this.getModel());
            List list = this.getModel().getProfiles();
            this.cbProfiles.removeAllItems();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.cbProfiles.addItem(list.get(i));
            }
            this.listen = true;
        }
        this.cbProfiles.setSelectedItem(this.getModel().getCurrentProfile());
    }

    private void deleteCurrentProfile() {
        String string = (String)this.cbProfiles.getSelectedItem();
        this.getModel().deleteProfile(string);
        if (this.getModel().isCustomProfile(string)) {
            this.cbProfiles.removeItem(string);
            this.cbProfiles.setSelectedIndex(0);
        }
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        this.getModel().apply();
    }

    void cancel() {
        if (this.model == null) {
            return;
        }
        this.model.cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.getModel().isChanged();
    }

    KeymapViewModel getModel() {
        if (this.model == null) {
            this.model = new KeymapViewModel();
        }
        return this.model;
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)KeymapPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)KeymapPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)KeymapPanel.loc("CTL_" + string));
        }
    }

    void refreshAction() {
        Object object = this.tree.getSelectionPath() == null ? null : this.tree.getSelectionPath().getLastPathComponent();
        this.selectAction(object);
        if (this.lShortcuts.getModel().getSize() > 0) {
            this.lShortcuts.setSelectedIndex(0);
        }
    }

    void selectAction(Object object) {
        if (object == null || object instanceof String) {
            this.lShortcuts.setModel(new DefaultListModel());
            this.bAddShortcut.setEnabled(false);
            this.bRemoveShortcut.setEnabled(false);
            return;
        }
        this.bAddShortcut.setEnabled(true);
        this.bRemoveShortcut.setEnabled(false);
        final String[] stringArray = this.getModel().getShortcuts((ActionImpl)object);
        this.lShortcuts.setModel(new AbstractListModel(){

            public int getSize() {
                return stringArray.length;
            }

            public Object getElementAt(int n) {
                return stringArray[n];
            }
        });
    }
}

