/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Action;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.NbBundle;

public class LayersBridge {
    static final String KEYMAPS_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String TOOLBARS_FOLDER = "Toolbars";
    private Map actionToDataObject = new HashMap();
    private Map categoryToActions;
    private Set actions = new HashSet();
    private List keymapNames;
    private Map keymaps = new HashMap();
    private Map keymapDefaults = new HashMap();

    Map getActions() {
        if (this.categoryToActions == null) {
            this.categoryToActions = new HashMap();
            this.initActions("OptionsDialog/Actions", null);
            this.initActions("Actions", NbBundle.getMessage((Class)LayersBridge.class, (String)"CTL_Other"));
            this.categoryToActions.remove("Hidden");
            this.categoryToActions = Collections.unmodifiableMap(this.categoryToActions);
        }
        return this.categoryToActions;
    }

    private void initActions(String string, String string2) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null) {
            return;
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        Enumeration enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!(dataObject instanceof DataFolder)) continue;
            this.initActions((DataFolder)dataObject, null, string2);
        }
    }

    private void initActions(DataFolder dataFolder, String string, String string2) {
        Object object;
        String string3 = dataFolder.getName();
        if (string2 != null) {
            string3 = string2;
        } else {
            object = (String)dataFolder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
            if (object != null) {
                try {
                    string3 = NbBundle.getBundle((String)object).getString(dataFolder.getPrimaryFile().getPath());
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().notify((Throwable)missingResourceException);
                }
            }
            if (string != null) {
                string3 = string + '/' + string3;
            }
        }
        object = dataFolder.children();
        while (object.hasMoreElements()) {
            DataObject dataObject = (DataObject)object.nextElement();
            if (dataObject instanceof DataFolder) {
                this.initActions((DataFolder)dataObject, string3, string2);
                continue;
            }
            GlobalAction globalAction = this.createAction(dataObject);
            if (this.actions.contains(globalAction) || globalAction == null) continue;
            this.actions.add(globalAction);
            HashSet<GlobalAction> hashSet = (HashSet<GlobalAction>)this.categoryToActions.get(string3);
            if (hashSet == null) {
                hashSet = new HashSet<GlobalAction>();
                this.categoryToActions.put(string3, hashSet);
            }
            hashSet.add(globalAction);
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            this.actionToDataObject.put(globalAction, dataObject);
        }
    }

    List getProfiles() {
        if (this.keymapNames == null) {
            DataFolder dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
            Enumeration enumeration = dataFolder.children(false);
            this.keymapNames = new ArrayList();
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                if (!(dataObject instanceof DataFolder)) continue;
                this.keymapNames.add(dataObject.getName());
            }
            if (!this.keymapNames.contains("NetBeans")) {
                this.keymapNames.add("NetBeans");
            }
        }
        return Collections.unmodifiableList(this.keymapNames);
    }

    Map getKeymap(String string) {
        if (!this.keymaps.containsKey(string)) {
            DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map map = this.readKeymap(dataFolder);
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
            map.putAll(this.readKeymap(dataFolder));
            this.keymaps.put(string, map);
        }
        return Collections.unmodifiableMap((Map)this.keymaps.get(string));
    }

    Map getKeymapDefaults(String string) {
        if (!this.keymapDefaults.containsKey(string)) {
            DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map map = this.readKeymap(dataFolder);
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
            map.putAll(this.readKeymap(dataFolder));
            this.keymapDefaults.put(string, map);
        }
        return Collections.unmodifiableMap((Map)this.keymapDefaults.get(string));
    }

    DataObject getDataObject(Object object) {
        return (DataObject)this.actionToDataObject.get(object);
    }

    private Map readKeymap(DataFolder dataFolder) {
        HashMap<GlobalAction, HashSet<String>> hashMap = new HashMap<GlobalAction, HashSet<String>>();
        if (dataFolder == null) {
            return hashMap;
        }
        Enumeration enumeration = dataFolder.children(false);
        while (enumeration.hasMoreElements()) {
            GlobalAction globalAction;
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (dataObject instanceof DataFolder || (globalAction = this.createAction(dataObject)) == null) continue;
            String string = dataObject.getName();
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(globalAction);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(globalAction, hashSet);
            }
            hashSet.add(string);
        }
        return hashMap;
    }

    void deleteProfile(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        if ((fileObject = fileObject.getFileObject(KEYMAPS_FOLDER)) == null) {
            return;
        }
        if ((fileObject = fileObject.getFileObject(string)) == null) {
            return;
        }
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    void saveKeymap(String string, Map map) {
        DataFolder dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
        if (dataFolder == null) {
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
            try {
                dataFolder = DataFolder.create((DataFolder)dataFolder, (String)string);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
        }
        this.saveKeymap(dataFolder, map, true);
        dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
        this.saveKeymap(dataFolder, map, false);
    }

    private void saveKeymap(DataFolder dataFolder, Map map, boolean bl) {
        GlobalAction globalAction;
        Object object;
        Object object2;
        Map map2 = LayersBridge.shortcutToAction(map);
        Enumeration enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            object2 = (DataObject)enumeration.nextElement();
            object = (GlobalAction)map2.get(object2.getName());
            if (object != null) {
                globalAction = this.createAction((DataObject)object2);
                if (globalAction == null) continue;
                if (globalAction.equals(object)) {
                    map2.remove(object2.getName());
                    continue;
                }
            }
            try {
                object2.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!bl) {
            return;
        }
        object2 = map2.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            globalAction = (GlobalAction)map2.get(object);
            DataObject dataObject = (DataObject)this.actionToDataObject.get(globalAction);
            if (dataObject == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("No original DataObject specified! Not possible to create shadow1. " + globalAction);
                continue;
            }
            try {
                DataShadow.create((DataFolder)dataFolder, (String)object, (DataObject)dataObject);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static DataFolder getRootFolder(String string, String string2) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        FileObject fileObject2 = fileObject.getFileObject(string);
        try {
            if (fileObject2 == null) {
                fileObject.createFolder(string);
            }
            if (fileObject2 == null) {
                return null;
            }
            if (string2 == null) {
                return DataFolder.findFolder((FileObject)fileObject2);
            }
            FileObject fileObject3 = fileObject2.getFileObject(string2);
            if (fileObject3 == null) {
                fileObject2.createFolder(string2);
            }
            if (fileObject3 == null) {
                return null;
            }
            return DataFolder.findFolder((FileObject)fileObject3);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    private GlobalAction createAction(DataObject dataObject) {
        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        if (instanceCookie == null) {
            return null;
        }
        try {
            Object object = instanceCookie.instanceCreate();
            if (object == null) {
                return null;
            }
            if (!(object instanceof Action)) {
                return null;
            }
            return new GlobalAction((Action)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static Map shortcutToAction(Map map) {
        HashMap<String, ActionImpl> hashMap = new HashMap<String, ActionImpl>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ActionImpl actionImpl = (ActionImpl)iterator.next();
            Set set = (Set)map.get(actionImpl);
            if (actionImpl instanceof CompoundAction) {
                actionImpl = ((CompoundAction)actionImpl).getLayersAction();
            }
            if (!(actionImpl instanceof GlobalAction)) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                hashMap.put(string, actionImpl);
            }
        }
        return hashMap;
    }

    private static String[] toArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("can not parse shortcut: " + string);
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static class GlobalAction
    implements ActionImpl {
        private Action action;
        private String name;
        private String id;

        private GlobalAction(Action action) {
            this.action = action;
        }

        public String getDisplayName() {
            if (this.name == null) {
                this.name = (String)this.action.getValue("Name");
                if (this.name == null) {
                    this.name = this.action.toString();
                }
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        public String getId() {
            if (this.id == null) {
                this.id = this.action.getClass().getName();
            }
            return this.id;
        }

        public String getDelegatingActionId() {
            return null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GlobalAction)) {
                return false;
            }
            return ((GlobalAction)object).action.equals(this.action);
        }

        public int hashCode() {
            return this.action.hashCode();
        }

        public String toString() {
            return super.toString() + ":" + this.getDisplayName();
        }
    }
}

