/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.macros.MacrosPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class MacrosModel {
    private KeymapViewModel keymapModel;
    private Map macroNameToText;
    private DefaultTableModel tableModel;
    private boolean changed = false;

    MacrosModel(Lookup lookup) {
        this.keymapModel = (KeymapViewModel)lookup.lookup(KeymapViewModel.class);
        this.init();
    }

    private void init() {
        Object object;
        Serializable serializable;
        this.macroNameToText = new HashMap();
        Iterator<Object> iterator = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (iterator.hasNext()) {
            serializable = (Class)iterator.next();
            object = (BaseOptions)BaseOptions.findObject((Class)serializable, (boolean)true);
            this.macroNameToText.putAll(object.getMacroMap());
        }
        this.macroNameToText.remove(null);
        iterator = this.macroNameToText.keySet().iterator();
        serializable = new Vector();
        while (iterator.hasNext()) {
            String[] stringArray;
            object = (String)iterator.next();
            String string = "";
            ActionImpl actionImpl = this.keymapModel.findActionForId("macro-" + (String)object);
            if (actionImpl == null) {
                actionImpl = this.keymapModel.findActionForId((String)object);
            }
            if (actionImpl != null && (stringArray = this.keymapModel.getShortcuts(actionImpl)).length > 0) {
                string = stringArray[0];
            }
            stringArray = new Vector();
            stringArray.add(object);
            stringArray.add(string);
            ((Vector)serializable).add(stringArray);
        }
        Collections.sort(serializable, new MComparator());
        object = new Vector(2);
        ((Vector)object).add(MacrosModel.loc("Macro_Name_Title"));
        ((Vector)object).add(MacrosModel.loc("Macro_Code_Title"));
        this.tableModel = new DefaultTableModel((Vector)serializable, (Vector)object){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.tableModel.getColumnName(2);
    }

    DefaultTableModel getShortcutsTableModel() {
        return this.tableModel;
    }

    boolean isChanged() {
        return this.changed;
    }

    Collection getMacroNames() {
        return Collections.unmodifiableCollection(this.macroNameToText.keySet());
    }

    String getMacroText(String string) {
        return (String)this.macroNameToText.get(string);
    }

    void addMacro(String string, String string2) {
        this.tableModel.insertRow(0, new Object[]{string, string2});
        this.macroNameToText.put(string, string2);
    }

    void removeMacro(int n) {
        String string = (String)this.tableModel.getValueAt(n, 0);
        this.macroNameToText.remove(string);
        this.tableModel.removeRow(n);
    }

    void setMacroText(String string, String string2) {
        if (this.macroNameToText.containsKey(string) && string2.equals(this.macroNameToText.get(string))) {
            return;
        }
        this.macroNameToText.put(string, string2);
        this.changed = true;
    }

    void setShortcut(int n, String string) {
        this.tableModel.setValueAt(string, n, 1);
        this.saveMacros();
        this.keymapModel.refreshActions();
        ActionImpl actionImpl = this.keymapModel.findActionForId("macro-" + this.tableModel.getValueAt(n, 0));
        this.keymapModel.setShortcuts(actionImpl, Collections.singleton(string));
        this.changed = true;
    }

    void applyChanges() {
        this.saveMacros();
        this.changed = false;
    }

    void cancel() {
        this.init();
        this.changed = false;
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)MacrosPanel.class, (String)string);
    }

    private void saveMacros() {
        Iterator iterator = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)clazz, (boolean)true);
            baseOptions.setMacroMap(new HashMap(this.macroNameToText));
        }
    }

    private static class MComparator
    implements Comparator {
        private MComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)((Vector)object).get(0);
            String string2 = (String)((Vector)object2).get(0);
            return string.compareTo(string2);
        }
    }
}

