/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.netbeans.modules.options.macros.MacrosModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MacrosPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JTable tMacros = new JTable();
    private JScrollPane spTable = new JScrollPane(this.tMacros);
    private JEditorPane epMacro = new JEditorPane();
    private JButton bNew = new JButton();
    private JButton bRemove = new JButton();
    private JButton bShortcut = new JButton();
    private MacrosModel model;
    private boolean listen = true;
    private String currentMacro;
    private Lookup lookup;

    public MacrosPanel() {
        this.tMacros.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macros_Table"));
        this.tMacros.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macros_Table"));
        this.epMacro.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macro"));
        this.epMacro.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macro"));
        this.bRemove.setEnabled(false);
        this.bShortcut.setEnabled(false);
        MacrosPanel.loc(this.bNew, "New_Macro");
        MacrosPanel.loc(this.bRemove, "Remove_Macro");
        MacrosPanel.loc(this.bShortcut, "Shortcut");
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.bShortcut.addActionListener(this);
        this.tMacros.getSelectionModel().setSelectionMode(0);
        this.tMacros.getSelectionModel().addListSelectionListener(this);
        this.tMacros.getTableHeader().setReorderingAllowed(false);
        this.spTable.setPreferredSize(new Dimension(10, 10));
        this.epMacro.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        this.epMacro.setPreferredSize(new Dimension(10, 10));
        JScrollPane jScrollPane = new JScrollPane(this.epMacro);
        jScrollPane.setPreferredSize(new Dimension(10, 10));
        JLabel jLabel = new JLabel();
        MacrosPanel.loc(jLabel, "Macro_List");
        jLabel.setLabelFor(this.tMacros);
        JLabel jLabel2 = new JLabel();
        MacrosPanel.loc(jLabel2, "Macro_Code");
        jLabel2.setLabelFor(this.epMacro);
        FormLayout formLayout = new FormLayout("200dlu:g, 5dlu, p", "p, 1dlu, p, 3dlu, p, 3dlu, p, f:20dlu:g, 5dlu, p, 1dlu, f:20dlu:g");
        formLayout.setRowGroups((int[][])new int[][]{{3, 7}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder.add((Component)jLabel, cellConstraints2.xy(1, 1));
        panelBuilder.add((Component)this.spTable, cellConstraints.xywh(1, 3, 1, 6));
        panelBuilder.add((Component)this.bNew, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.bShortcut, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)this.bRemove, cellConstraints.xy(3, 7));
        panelBuilder.add((Component)jLabel2, cellConstraints2.xy(1, 10));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(1, 12));
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)MacrosPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)MacrosPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)MacrosPanel.loc("CTL_" + string));
        }
    }

    public void update() {
        this.model = new MacrosModel(this.lookup);
        this.listen = false;
        DefaultTableModel defaultTableModel = this.model.getShortcutsTableModel();
        this.currentMacro = null;
        defaultTableModel.setColumnIdentifiers(new String[]{MacrosPanel.loc("Macro_Name_Title"), MacrosPanel.loc("Macro_Code_Title")});
        this.tMacros.setModel(defaultTableModel);
        this.listen = true;
        if (this.model.getMacroNames().size() > 0) {
            this.tMacros.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void applyChanges() {
        this.saveCurrentMacro();
        if (this.model != null) {
            this.model.applyChanges();
        }
    }

    public void cancel() {
        if (this.model != null) {
            this.model.cancel();
        }
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        if (actionEvent.getSource() == this.bNew) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(MacrosPanel.loc("CTL_Enter_macro_name"), MacrosPanel.loc("CTL_New_macro_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.InputLine.OK_OPTION) {
                String string = inputLine.getInputText().trim();
                if (string.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MacrosPanel.loc("CTL_Empty_Macro_Name"), 0));
                } else {
                    Iterator iterator = this.model.getMacroNames().iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!string.equals(string2)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MacrosPanel.loc("CTL_Duplicate_Macro_Name"), 0));
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.listen = false;
                        this.model.addMacro(string, "");
                        this.listen = true;
                        this.tMacros.getSelectionModel().setSelectionInterval(0, 0);
                        this.spTable.getVerticalScrollBar().setValue(0);
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MacrosPanel.this.epMacro.requestFocus();
                }
            });
        } else if (actionEvent.getSource() == this.bRemove) {
            int n = this.tMacros.getSelectedRow();
            this.listen = false;
            this.model.removeMacro(n);
            this.listen = true;
            this.currentMacro = null;
            if (n < this.tMacros.getModel().getRowCount()) {
                this.tMacros.getSelectionModel().setSelectionInterval(n, n);
            } else if (this.tMacros.getModel().getRowCount() > 0) {
                this.tMacros.getSelectionModel().setSelectionInterval(this.tMacros.getModel().getRowCount() - 1, this.tMacros.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
                this.bShortcut.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.bShortcut) {
            int n = this.tMacros.getSelectedRow();
            String string = ShortcutsDialog.getShortcut((KeymapViewModel)this.lookup.lookup(KeymapViewModel.class));
            this.saveCurrentMacro();
            if (string != null) {
                this.model.setShortcut(n, string);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MacrosPanel.this.epMacro.requestFocus();
                }
            });
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tMacros.getSelectedRow();
        if (n < 0) {
            this.epMacro.setText("");
            this.bRemove.setEnabled(false);
            this.bShortcut.setEnabled(false);
            return;
        }
        this.saveCurrentMacro();
        this.bRemove.setEnabled(true);
        this.bShortcut.setEnabled(true);
        String string = this.getCurrentMacro();
        String string2 = this.model.getMacroText(string);
        this.epMacro.setText(string2);
        this.currentMacro = string;
    }

    private String getCurrentMacro() {
        int n = this.tMacros.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return (String)this.tMacros.getModel().getValueAt(n, 0);
    }

    private void saveCurrentMacro() {
        if (this.currentMacro == null) {
            return;
        }
        if (this.epMacro.getText().equals(this.model.getMacroText(this.currentMacro))) {
            return;
        }
        this.model.setMacroText(this.currentMacro, this.epMacro.getText());
        this.firePropertyChange("changed", null, null);
    }
}

