/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.awt.Image;
import java.lang.reflect.Modifier;
import java.text.Format;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.javadoc.comments.AutoCommenter;
import org.openide.util.Utilities;

final class ElementDescriptor {
    private static final int offsetPublic = 0;
    private static final int offsetPackage = 4;
    private static final int offsetProtected = 8;
    private static final int offsetPrivate = 12;
    private static final int iconNothing = 0;
    private static final int iconClass = 1;
    private static final int iconInterface = 2;
    private static final int iconField = 3;
    private static final int iconConstructor = 16;
    private static final int iconMethod = 29;
    private static final int iconEnum = 42;
    private static final int iconAnnType = 55;
    private static final int iconConstant = 68;
    private static String[] EMPTY_ARRAY;
    private String name;
    private String formattedName;
    private int modifiers;
    private int effectiveAccess;
    private ImageIcon icon;
    private String declaringClassName;
    private String[] paramNames = EMPTY_ARRAY;
    private String[] throwFQNames = EMPTY_ARRAY;
    private String typeFQName;
    private final AutoCommenter.Element element;
    private final String identity;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ElementDescriptor(AutoCommenter.Element element, Format format) throws JmiException {
        this.element = element;
        ClassMember classMember = element.getSrcElement();
        this.name = classMember.getName();
        this.formattedName = format.format(classMember);
        this.modifiers = classMember.getModifiers();
        ClassDefinition classDefinition = classMember.getDeclaringClass();
        if (classDefinition != null) {
            this.declaringClassName = classDefinition.getName();
        }
        if (classMember instanceof CallableFeature) {
            CallableFeature callableFeature = (CallableFeature)classMember;
            this.paramNames = ElementDescriptor.getParameterNames(callableFeature);
            this.throwFQNames = ElementDescriptor.getThrowFQNames(callableFeature);
        }
        if (classMember instanceof TypedElement) {
            this.typeFQName = ((TypedElement)classMember).getType().getName();
        }
        this.effectiveAccess = ElementDescriptor.getEffectiveAccess(classMember);
        this.identity = classMember.refMofId();
    }

    public final String getName() {
        return this.name;
    }

    public final String getFormattedName() {
        return this.formattedName;
    }

    public final String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final int getEffectiveAccess() {
        return this.effectiveAccess;
    }

    public final String[] getParameterNames() {
        return this.paramNames;
    }

    public final String[] getThrowFQNames() {
        return this.throwFQNames;
    }

    public final String getTypeFQName() {
        return this.typeFQName;
    }

    public final Icon getIcon() {
        if (!$assertionsDisabled && this.icon == null) {
            throw new AssertionError();
        }
        return this.icon;
    }

    public String getIdentity() {
        return this.identity;
    }

    public final void recomputeIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon();
        }
        this.icon.setImage(this.getMergedImage());
    }

    private static String[] getParameterNames(CallableFeature callableFeature) {
        List list = callableFeature.getParameters();
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            stringArray[n] = parameter.getName();
            ++n;
        }
        return stringArray;
    }

    private static String[] getThrowFQNames(CallableFeature callableFeature) {
        List list = callableFeature.getExceptions();
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            stringArray[n] = javaClass.getName();
            ++n;
        }
        return stringArray;
    }

    private Image getMergedImage() {
        int n = this.element.getErrorNumber();
        int n2 = this.resolveIconIndex();
        Image image = ElementDescriptor.getImage(n);
        Image image2 = ElementDescriptor.getMemberImage(n2);
        return Utilities.mergeImages((Image)image, (Image)image2, (int)18, (int)0);
    }

    private int resolveIconIndex() throws JmiException {
        ClassMember classMember = this.element.getSrcElement();
        int n = (1 & this.modifiers) != 0 ? 0 : ((2 & this.modifiers) != 0 ? 12 : ((4 & this.modifiers) != 0 ? 8 : 4));
        if (classMember instanceof JavaEnum) {
            return n + 42;
        }
        if (classMember instanceof AnnotationType) {
            return n + 55;
        }
        if (classMember instanceof JavaClass) {
            return n + (Modifier.isInterface(this.modifiers) ? 2 : 1);
        }
        if (classMember instanceof Method || classMember instanceof Attribute) {
            return n + 29;
        }
        if (classMember instanceof Constructor) {
            return n + 16;
        }
        if (classMember instanceof EnumConstant) {
            return 68;
        }
        if (classMember instanceof Field) {
            return n + 3;
        }
        return 0;
    }

    private static Image getMemberImage(int n) {
        switch (n) {
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                return Utilities.loadImage((String)"org/openide/src/resources/class.gif");
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                return Utilities.loadImage((String)"org/openide/src/resources/interface.gif");
            }
            case 42: 
            case 46: 
            case 50: 
            case 54: {
                return Utilities.loadImage((String)"org/netbeans/modules/java/resources/enum.gif");
            }
            case 55: 
            case 59: 
            case 63: 
            case 67: {
                return Utilities.loadImage((String)"org/netbeans/modules/java/resources/annotation_type.gif");
            }
            case 68: {
                return Utilities.loadImage((String)"org/netbeans/modules/java/resources/constant.gif");
            }
            case 3: {
                return Utilities.loadImage((String)"org/openide/src/resources/variablePublic.gif");
            }
            case 7: {
                return Utilities.loadImage((String)"org/openide/src/resources/variablePackage.gif");
            }
            case 11: {
                return Utilities.loadImage((String)"org/openide/src/resources/variableProtected.gif");
            }
            case 15: {
                return Utilities.loadImage((String)"org/openide/src/resources/variablePrivate.gif");
            }
            case 16: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorPublic.gif");
            }
            case 20: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorPackage.gif");
            }
            case 24: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorProtected.gif");
            }
            case 28: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorPrivate.gif");
            }
            case 29: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodPublic.gif");
            }
            case 33: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodPackage.gif");
            }
            case 37: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodProtected.gif");
            }
            case 41: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodPrivate.gif");
            }
        }
        return null;
    }

    private static Image getImage(int n) {
        switch (n) {
            case 1: {
                return Utilities.loadImage((String)"org/netbeans/modules/javadoc/comments/resources/ok.gif");
            }
            case 2: {
                return Utilities.loadImage((String)"org/netbeans/modules/javadoc/comments/resources/missing.gif");
            }
            case 4: {
                return Utilities.loadImage((String)"org/netbeans/modules/javadoc/comments/resources/error.gif");
            }
        }
        return null;
    }

    private static int getEffectiveAccess(ClassMember classMember) {
        int n = classMember.getModifiers() & 7;
        if (n == 2) {
            return n;
        }
        JavaClass javaClass = (JavaClass)classMember.getDeclaringClass();
        if (javaClass == null) {
            return n;
        }
        if (javaClass.isInterface()) {
            n = 1;
        }
        int n2 = ElementDescriptor.getEffectiveAccess((ClassMember)javaClass);
        switch (n2) {
            case 0: 
            case 2: {
                return n2;
            }
            case 4: {
                return n == 0 ? 0 : n2;
            }
        }
        return n;
    }

    static {
        $assertionsDisabled = !ElementDescriptor.class.desiredAssertionStatus();
        EMPTY_ARRAY = new String[0];
    }
}

