/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Resource;

public final class JMIUtils {
    public static List getAllClasses(Resource resource) throws JmiException {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = resource.getClassifiers().iterator();
        while (iterator.hasNext()) {
            JMIUtils.addAllClasses((JavaClass)iterator.next(), linkedList);
        }
        return linkedList;
    }

    public static String multipartIdToName(MultipartId multipartId) {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (multipartId != null) {
            if (multipartId.getTypeArguments().size() > 0) {
                return "java.lang.Object";
            }
            linkedList.addFirst(multipartId.getName());
            multipartId = multipartId.getParent();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    private static void addAllClasses(JavaClass javaClass, List list) throws JmiException {
        list.add(javaClass);
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClass)) continue;
            JMIUtils.addAllClasses((JavaClass)e, list);
        }
    }
}

