/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.jmi.reflect.InvalidObjectException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.javadoc.comments.AutoCommenter;
import org.netbeans.modules.javadoc.comments.EmptyTagPanel;
import org.netbeans.modules.javadoc.comments.NewTagDialog;
import org.netbeans.modules.javadoc.comments.ParamTagPanel;
import org.netbeans.modules.javadoc.comments.SeeTagPanel;
import org.netbeans.modules.javadoc.comments.SerialFieldTagPanel;
import org.netbeans.modules.javadoc.comments.StandardTagPanel;
import org.netbeans.modules.javadoc.comments.TagPanel;
import org.netbeans.modules.javadoc.comments.ThrowsTagPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.JavaDocTag;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;

public class JavaDocEditorPanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    private JavaDoc javaDoc;
    private DefaultListModel listModel;
    private int lastSelection = -1;
    private EmptyTagPanel emptyTagPanel;
    private StandardTagPanel standardTagPanel;
    private SeeTagPanel seeTagPanel;
    private ParamTagPanel paramTagPanel;
    private ThrowsTagPanel throwsTagPanel;
    private SerialFieldTagPanel serialFieldTagPanel;
    private NewTagDialog newTagDialog;
    private AutoCommenter.Element element;
    private MnemonicsDistributor mnemonicsDistributor;
    static final long serialVersionUID = 7005703844831686911L;
    private boolean dirty;
    private boolean updatingTagList;
    private boolean grabFocusAfterNewButton = false;
    private JButton boldButton;
    private JButton codeButton;
    private JLabel commentLabel;
    private JScrollPane commentScrollPane;
    private JEditorPane commentTextArea;
    private JButton deleteButton;
    private JPanel htmlToolBar;
    private JButton italicButton;
    private JButton linkButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newButton;
    private JButton preButton;
    private JList tagList;
    private JLabel tagListLabel;
    private JPanel tagPanel;
    private JPanel tagParamPanel;
    private JScrollPane tagScrollPane;
    private JPanel textPanel;
    private JButton underlineButton;

    public JavaDocEditorPanel() {
        this.initComponents();
        this.newButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.newButton_Mnemonic").charAt(0));
        this.deleteButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.deleteButton_Mnemonic").charAt(0));
        this.moveUpButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveUpButton_Mnemonic").charAt(0));
        this.moveDownButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveDownButton_Mnemonic").charAt(0));
        this.boldButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.boldButton").charAt(0));
        this.italicButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.italicButton").charAt(0));
        this.underlineButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.underlineButton").charAt(0));
        this.codeButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.codeButton").charAt(0));
        this.preButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.preButton").charAt(0));
        this.linkButton.setMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.linkButton").charAt(0));
        this.commentLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.textPane").charAt(0));
        this.tagListLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.tagPanel").charAt(0));
        this.enableButtons(false);
        this.mnemonicsDistributor = new MnemonicsDistributor();
        this.commentTextArea.setContentType("text/html");
        this.commentTextArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                JavaDocEditorPanel.this.dirty = true;
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JavaDocEditorPanel.this.dirty = true;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JavaDocEditorPanel.this.dirty = true;
            }
        });
        this.mnemonicsDistributor.registerComponent(this.commentTextArea);
        this.tagList.setVisibleRowCount(4);
        this.tagList.getSelectionModel().setSelectionMode(0);
        this.emptyTagPanel = new EmptyTagPanel(this);
        this.tagParamPanel.add((Component)this.emptyTagPanel, this.emptyTagPanel.getCardName());
        this.standardTagPanel = new StandardTagPanel(this);
        this.tagParamPanel.add((Component)this.standardTagPanel, this.standardTagPanel.getCardName());
        this.seeTagPanel = new SeeTagPanel(this);
        this.tagParamPanel.add((Component)this.seeTagPanel, this.seeTagPanel.getCardName());
        this.paramTagPanel = new ParamTagPanel(this);
        this.tagParamPanel.add((Component)this.paramTagPanel, this.paramTagPanel.getCardName());
        this.throwsTagPanel = new ThrowsTagPanel(this);
        this.tagParamPanel.add((Component)this.throwsTagPanel, this.throwsTagPanel.getCardName());
        this.serialFieldTagPanel = new SerialFieldTagPanel(this);
        this.tagParamPanel.add((Component)this.serialFieldTagPanel, this.serialFieldTagPanel.getCardName());
        this.initAccessibility();
    }

    public JavaDocEditorPanel(AutoCommenter.Element element, JavaDoc javaDoc) {
        this();
        this.setElement(element);
        this.setJavaDoc(javaDoc);
    }

    public void clear() {
        this.commentTextArea.setText("");
        this.newButton.setEnabled(false);
        this.setTagListModel();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tagList.setEnabled(bl);
        this.commentTextArea.setEnabled(bl);
        this.newButton.setEnabled(bl);
    }

    public void updateForClosing() {
        this.commitTagChange();
    }

    private void setTagListModel() {
        this.lastSelection = -1;
        this.listModel = new DefaultListModel();
        this.tagList.setModel(this.listModel);
        this.deleteButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.listModel.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                JavaDocEditorPanel.this.dirty = true;
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                JavaDocEditorPanel.this.dirty = true;
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                JavaDocEditorPanel.this.dirty = true;
            }
        });
    }

    public void setJavaDoc(JavaDoc javaDoc) {
        this.javaDoc = javaDoc;
        if (javaDoc != null) {
            this.javaDoc = javaDoc;
            this.commentTextArea.setText(javaDoc.getText());
            this.commentTextArea.setCaretPosition(0);
        } else {
            this.commentTextArea.setText(null);
        }
        this.setTagListModel();
        if (javaDoc != null) {
            JavaDocTag[] javaDocTagArray = javaDoc.getTags();
            for (int i = 0; i < javaDocTagArray.length; ++i) {
                this.listModel.addElement(javaDocTagArray[i]);
            }
            if (this.listModel.getSize() < 0) {
                this.tagList.setSelectedIndex(0);
            }
        }
        try {
            this.standardTagPanel.setElement(this.element.getSrcElement());
            this.paramTagPanel.setElement(this.element.getSrcElement());
            this.throwsTagPanel.setElement(this.element.getSrcElement());
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
        this.setDirty(false);
        this.revalidate();
        this.repaint();
    }

    public void setElement(AutoCommenter.Element element) {
        this.element = element;
    }

    public AutoCommenter.Element getElement() {
        return this.element;
    }

    private void initAccessibility() {
        this.commentTextArea.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.commentTextAreaA11yName"));
        this.tagList.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.tagListA11yName"));
    }

    private void initComponents() {
        this.textPanel = new JPanel();
        this.commentScrollPane = new JScrollPane();
        this.commentTextArea = new JEditorPane();
        this.tagPanel = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.tagScrollPane = new JScrollPane();
        this.tagList = new JList();
        this.tagParamPanel = new JPanel();
        this.tagListLabel = new JLabel();
        this.htmlToolBar = new JPanel();
        this.boldButton = new JButton();
        this.italicButton = new JButton();
        this.underlineButton = new JButton();
        this.codeButton = new JButton();
        this.preButton = new JButton();
        this.linkButton = new JButton();
        this.commentLabel = new JLabel();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.textPanel.setLayout(new GridBagLayout());
        this.commentScrollPane.setMinimumSize(new Dimension(22, 60));
        this.commentTextArea.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.commentTextAreaA11yDesc"));
        this.commentTextArea.setContentType("text/html");
        this.commentTextArea.addFocusListener(formListener);
        this.commentScrollPane.setViewportView(this.commentTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.textPanel.add((Component)this.commentScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 7);
        this.add((Component)this.textPanel, gridBagConstraints);
        this.tagPanel.setLayout(new GridBagLayout());
        this.newButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.newButton.text"));
        this.newButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.newButton.textA11yDesc"));
        this.newButton.setMargin(new Insets(2, 12, 2, 12));
        this.newButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tagPanel.add((Component)this.newButton, gridBagConstraints);
        this.deleteButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.deleteButton.text"));
        this.deleteButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.deleteButton.textA11yDesc"));
        this.deleteButton.setMargin(new Insets(2, 12, 2, 12));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.tagPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.moveUpButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveUpButton.text"));
        this.moveUpButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.moveUpButton.textA11yDesc"));
        this.moveUpButton.setActionCommand("UP");
        this.moveUpButton.setMargin(new Insets(2, 12, 2, 12));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 5, 0);
        this.tagPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveDownButton.text"));
        this.moveDownButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.moveDownButton.textA11yDesc"));
        this.moveDownButton.setActionCommand("DOWN");
        this.moveDownButton.setMargin(new Insets(2, 12, 2, 12));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.tagPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.tagList.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.tagListA11yDesc"));
        this.tagList.addListSelectionListener(formListener);
        this.tagScrollPane.setViewportView(this.tagList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.tagPanel.add((Component)this.tagScrollPane, gridBagConstraints);
        this.tagParamPanel.setLayout(new CardLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.tagPanel.add((Component)this.tagParamPanel, gridBagConstraints);
        this.tagListLabel.setLabelFor(this.tagList);
        this.tagListLabel.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.tagPanel.title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.tagPanel.add((Component)this.tagListLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 11, 7);
        this.add((Component)this.tagPanel, gridBagConstraints);
        this.htmlToolBar.setLayout(new GridLayout(1, 6));
        this.boldButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.boldButton.text"));
        this.boldButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.boldButton.textA11yDesc"));
        this.boldButton.setActionCommand("B");
        this.boldButton.setHorizontalTextPosition(0);
        this.boldButton.setMinimumSize(new Dimension(32, 27));
        this.boldButton.setRequestFocusEnabled(false);
        this.boldButton.addActionListener(formListener);
        this.htmlToolBar.add(this.boldButton);
        this.italicButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.italicButton.text"));
        this.italicButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.italicButton.textA11yDesc"));
        this.italicButton.setActionCommand("I");
        this.italicButton.setHorizontalTextPosition(0);
        this.italicButton.setMinimumSize(new Dimension(32, 27));
        this.italicButton.setRequestFocusEnabled(false);
        this.italicButton.addActionListener(formListener);
        this.htmlToolBar.add(this.italicButton);
        this.underlineButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.underlineButton.text"));
        this.underlineButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.underlineButton.textA11yDesc"));
        this.underlineButton.setActionCommand("U");
        this.underlineButton.setHorizontalTextPosition(0);
        this.underlineButton.setMinimumSize(new Dimension(32, 27));
        this.underlineButton.setRequestFocusEnabled(false);
        this.underlineButton.addActionListener(formListener);
        this.htmlToolBar.add(this.underlineButton);
        this.codeButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.codeButton.text"));
        this.codeButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.codeButton.textA11yDesc"));
        this.codeButton.setActionCommand("CODE");
        this.codeButton.setHorizontalTextPosition(0);
        this.codeButton.setMinimumSize(new Dimension(32, 27));
        this.codeButton.setRequestFocusEnabled(false);
        this.codeButton.addActionListener(formListener);
        this.htmlToolBar.add(this.codeButton);
        this.preButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.preButton.text"));
        this.preButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.preButton.textA11yDesc"));
        this.preButton.setActionCommand("PRE");
        this.preButton.setHorizontalTextPosition(0);
        this.preButton.setMinimumSize(new Dimension(32, 27));
        this.preButton.setRequestFocusEnabled(false);
        this.preButton.addActionListener(formListener);
        this.htmlToolBar.add(this.preButton);
        this.linkButton.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.linkButton.text"));
        this.linkButton.setToolTipText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.linkButton.textA11yDesc"));
        this.linkButton.setActionCommand("link");
        this.linkButton.setHorizontalTextPosition(0);
        this.linkButton.setMinimumSize(new Dimension(32, 27));
        this.linkButton.setRequestFocusEnabled(false);
        this.linkButton.addActionListener(formListener);
        this.htmlToolBar.add(this.linkButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 7, 11, 7);
        this.add((Component)this.htmlToolBar, gridBagConstraints);
        this.commentLabel.setLabelFor(this.commentTextArea);
        this.commentLabel.setText(NbBundle.getBundle((Class)JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.textPanel.title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 3, 0, 0);
        this.add((Component)this.commentLabel, gridBagConstraints);
    }

    private void tagListValueChanged(ListSelectionEvent listSelectionEvent) {
        TagPanel tagPanel;
        Object object;
        if (!this.updatingTagList) {
            this.deleteButton.setEnabled(true);
            this.moveUpButton.setEnabled(true);
            this.moveDownButton.setEnabled(true);
        }
        int n = this.tagList.getMinSelectionIndex();
        if (this.lastSelection >= 0 && this.lastSelection != n && this.lastSelection < this.listModel.getSize()) {
            object = (JavaDocTag)this.listModel.get(this.lastSelection);
            tagPanel = this.getPanelForTag((JavaDocTag)object);
            JavaDocTag javaDocTag = tagPanel.getTag(object.name());
            this.listModel.setElementAt(javaDocTag, this.lastSelection);
        }
        this.lastSelection = n;
        if (n < 0) {
            tagPanel = this.emptyTagPanel;
            this.enableButtons(false);
        } else {
            object = (JavaDocTag)this.listModel.get(n);
            tagPanel = this.getPanelForTag((JavaDocTag)object);
            tagPanel.setData((JavaDocTag)object);
        }
        object = (CardLayout)this.tagParamPanel.getLayout();
        ((CardLayout)object).show(this.tagParamPanel, tagPanel.getCardName());
        if (tagPanel != this.emptyTagPanel && this.grabFocusAfterNewButton && listSelectionEvent.getFirstIndex() != listSelectionEvent.getLastIndex() && !listSelectionEvent.getValueIsAdjusting()) {
            this.grabFocusAfterNewButton = false;
            tagPanel.grabFirstFocus();
        }
    }

    private void commentTextAreaFocusLost(FocusEvent focusEvent) {
        this.enableButtons(false);
    }

    private void commentTextAreaFocusGained(FocusEvent focusEvent) {
        this.enableButtons(true);
    }

    private void newTagButtonActionPerformed(ActionEvent actionEvent) {
        this.newTagDialog = new NewTagDialog(this.element.getSrcElement());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.newTagDialog, NbBundle.getMessage((Class)JavaDocEditorPanel.class, (String)"NewTagDialog.Form.title"), true, 2, DialogDescriptor.OK_OPTION, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        JavaDocTag javaDocTag = null;
        if (object == DialogDescriptor.OK_OPTION && (javaDocTag = this.newTagDialog.getResult()) != null) {
            this.listModel.addElement(javaDocTag);
            this.tagList.ensureIndexIsVisible(this.listModel.getSize());
            this.grabFocusAfterNewButton = true;
            this.tagList.setSelectedIndex(this.listModel.getSize() - 1);
        }
    }

    private void delTagButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.tagList.getMinSelectionIndex();
        if (n != -1) {
            this.lastSelection = -1;
            this.listModel.removeElementAt(n);
        }
        if (this.listModel.getSize() > 0) {
            this.tagList.setSelectedIndex(n == this.listModel.getSize() ? n - 1 : n);
        } else {
            CardLayout cardLayout = (CardLayout)this.tagParamPanel.getLayout();
            cardLayout.show(this.tagParamPanel, this.emptyTagPanel.getCardName());
        }
    }

    private void chgTagButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTagChange();
    }

    private void moveTagButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getActionCommand().equals("UP")) {
            int n2 = this.tagList.getMinSelectionIndex();
            if (n2 > 0) {
                Object e = this.listModel.get(n2);
                this.lastSelection = -1;
                this.listModel.removeElementAt(n2);
                this.listModel.insertElementAt(e, n2 - 1);
                this.tagList.setSelectedIndex(n2 - 1);
            }
        } else if (actionEvent.getActionCommand().equals("DOWN") && (n = this.tagList.getMinSelectionIndex()) >= 0 && n < this.listModel.getSize() - 1) {
            Object e = this.listModel.get(n);
            this.lastSelection = -1;
            this.listModel.removeElementAt(n);
            this.listModel.insertElementAt(e, n + 1);
            this.tagList.setSelectedIndex(n + 1);
        }
    }

    private void formatButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        String string2;
        String string3 = actionEvent.getActionCommand();
        if (string3.equals("link")) {
            string2 = "{@link ";
            string = "}";
        } else {
            string2 = "<" + string3 + ">";
            string = "</" + string3 + ">";
        }
        if (this.commentTextArea.hasFocus()) {
            int n = this.commentTextArea.getCaretPosition();
            try {
                this.commentTextArea.getDocument().insertString(this.commentTextArea.getSelectionStart(), string2, null);
                this.commentTextArea.getDocument().insertString(this.commentTextArea.getSelectionEnd(), string, null);
                this.commentTextArea.setCaretPosition(n + 2 + actionEvent.getActionCommand().length());
            }
            catch (BadLocationException badLocationException) {}
        } else {
            JavaDocTag javaDocTag = (JavaDocTag)this.listModel.get(this.tagList.getMinSelectionIndex());
            TagPanel tagPanel = this.getPanelForTag(javaDocTag);
            tagPanel.handleFormatButton(string2, string);
        }
    }

    String getRawText() {
        JavaDoc javaDoc = this.getUpdatedJavaDoc();
        return javaDoc.getRawText();
    }

    JavaDoc getUpdatedJavaDoc() {
        JavaDoc javaDoc = JavaDocSupport.createJavaDoc((String)"");
        try {
            javaDoc.setText(this.commentTextArea.getDocument().getText(0, this.commentTextArea.getDocument().getLength()));
            Object[] objectArray = new JavaDocTag[this.listModel.getSize()];
            this.listModel.copyInto(objectArray);
            javaDoc.changeTags((JavaDocTag[])objectArray, 3);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return javaDoc;
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            this.javaDoc.setRawText(this.getRawText());
        }
        catch (SourceException sourceException) {
            throw new IllegalStateException();
        }
        return this.javaDoc;
    }

    TagPanel getPanelForTag(JavaDocTag javaDocTag) {
        if (javaDocTag instanceof JavaDocTag.Param) {
            return this.paramTagPanel;
        }
        if (javaDocTag instanceof JavaDocTag.Throws) {
            return this.throwsTagPanel;
        }
        if (javaDocTag instanceof JavaDocTag.SerialField) {
            return this.serialFieldTagPanel;
        }
        if (javaDocTag instanceof JavaDocTag.See) {
            return this.seeTagPanel;
        }
        return this.standardTagPanel;
    }

    void commitTagChange() {
        this.updatingTagList = true;
        int n = this.tagList.getMinSelectionIndex();
        if (n >= 0) {
            JavaDocTag javaDocTag = (JavaDocTag)this.listModel.get(n);
            TagPanel tagPanel = this.getPanelForTag(javaDocTag);
            JavaDocTag javaDocTag2 = tagPanel.getTag(javaDocTag.name());
            this.listModel.setElementAt(javaDocTag2, n);
            this.dirty = true;
        }
        this.updatingTagList = false;
    }

    void enableButtons(boolean bl) {
        this.boldButton.setEnabled(bl);
        this.italicButton.setEnabled(bl);
        this.underlineButton.setEnabled(bl);
        this.codeButton.setEnabled(bl);
        this.preButton.setEnabled(bl);
        this.linkButton.setEnabled(bl);
    }

    void registerComponent(Component component) {
        this.mnemonicsDistributor.registerComponent(component);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    class MnemonicsDistributor
    extends KeyAdapter {
        private static final int ALT_LESS_MASK = 8640;

        MnemonicsDistributor() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            int n = keyStroke.getModifiers();
            if ((n & 8) != 0 && (n & 0x21C0) == 0) {
                switch (keyStroke.getKeyCode()) {
                    case 66: {
                        JavaDocEditorPanel.this.boldButton.doClick();
                        keyEvent.consume();
                        break;
                    }
                    case 73: {
                        JavaDocEditorPanel.this.italicButton.doClick();
                        keyEvent.consume();
                        break;
                    }
                    case 85: {
                        JavaDocEditorPanel.this.underlineButton.doClick();
                        keyEvent.consume();
                        break;
                    }
                    case 67: {
                        JavaDocEditorPanel.this.codeButton.doClick();
                        keyEvent.consume();
                        break;
                    }
                    case 80: {
                        JavaDocEditorPanel.this.preButton.doClick();
                        keyEvent.consume();
                        break;
                    }
                    case 76: {
                        JavaDocEditorPanel.this.linkButton.doClick();
                        keyEvent.consume();
                    }
                }
            }
        }

        void registerComponent(Component component) {
            component.addKeyListener(this);
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ListSelectionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == JavaDocEditorPanel.this.newButton) {
                JavaDocEditorPanel.this.newTagButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.deleteButton) {
                JavaDocEditorPanel.this.delTagButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.moveUpButton) {
                JavaDocEditorPanel.this.moveTagButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.moveDownButton) {
                JavaDocEditorPanel.this.moveTagButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.boldButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.italicButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.underlineButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.codeButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.preButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JavaDocEditorPanel.this.linkButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(actionEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == JavaDocEditorPanel.this.commentTextArea) {
                JavaDocEditorPanel.this.commentTextAreaFocusGained(focusEvent);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == JavaDocEditorPanel.this.commentTextArea) {
                JavaDocEditorPanel.this.commentTextAreaFocusLost(focusEvent);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == JavaDocEditorPanel.this.tagList) {
                JavaDocEditorPanel.this.tagListValueChanged(listSelectionEvent);
            }
        }
    }
}

