/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Parser;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IndexBuilder
implements Runnable,
ChangeListener {
    private static final String[] INDEX_FILE_NAMES = new String[]{"overview-summary.html", "index.html", "index.htm"};
    private static IndexBuilder INSTANCE;
    private static RequestProcessor.Task task;
    private final ErrorManager err;
    private Reference cachedData;
    private JavadocRegistry jdocRegs;
    Map filesystemInfo = Collections.EMPTY_MAP;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$search$IndexBuilder;

    private IndexBuilder() {
        this.jdocRegs = JavadocRegistry.getDefault();
        this.jdocRegs.addChangeListener(this);
        this.err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexBuilder");
        if (this.err.isLoggable(1)) {
            this.err.log("new IndexBuilder");
        }
    }

    public static synchronized IndexBuilder getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new IndexBuilder();
        IndexBuilder.scheduleTask();
        return INSTANCE;
    }

    public void run() {
        this.cachedData = null;
        this.refreshIndex();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        IndexBuilder.scheduleTask();
    }

    public List[] getIndices() {
        List[] listArray;
        Object object;
        Object object2;
        task.waitFinished();
        if (this.cachedData != null && (object2 = (List[])this.cachedData.get()) != null) {
            if (this.err.isLoggable(1)) {
                this.err.log("getIndices (cached)");
            }
            return object2;
        }
        if (this.err.isLoggable(1)) {
            this.err.log("getIndices");
        }
        object2 = this.filesystemInfo;
        Iterator iterator = object2.entrySet().iterator();
        Collator collator = Collator.getInstance();
        class Pair
        implements Comparable {
            public String display;
            public FileObject fo;
            private final /* synthetic */ Collator val$c;

            Pair(Collator collator) {
                this.val$c = collator;
            }

            public int compareTo(Object object) {
                return this.val$c.compare(this.display, ((Pair)object).display);
            }
        }
        TreeSet<Pair> treeSet = new TreeSet<Pair>();
        for (int i = 0; i < object2.size(); ++i) {
            object = iterator.next();
            listArray = (FileObject)object.getKey();
            Info info = (Info)object.getValue();
            FileObject fileObject = listArray.getFileObject(info.indexFileName);
            if (fileObject == null) continue;
            Pair pair = new Pair(collator);
            pair.display = info.title;
            pair.fo = fileObject;
            treeSet.add(pair);
        }
        ArrayList<String> arrayList = new ArrayList<String>(treeSet.size());
        object = new ArrayList(treeSet.size());
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            listArray = (Pair)((Object)iterator.next());
            arrayList.add(listArray.display);
            object.add(listArray.fo);
        }
        listArray = new List[]{arrayList, object};
        this.cachedData = new WeakReference<List[]>(listArray);
        return listArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void refreshIndex() {
        if (this.err.isLoggable(1)) {
            this.err.log("refreshIndex");
        }
        FileObject[] fileObjectArray = this;
        // MONITORENTER : this
        Map map = this.filesystemInfo;
        // MONITOREXIT : fileObjectArray
        fileObjectArray = this.jdocRegs.getDocRoots();
        WeakHashMap<FileObject, Object> weakHashMap = new WeakHashMap<FileObject, Object>();
        int n = 0;
        while (n < fileObjectArray.length) {
            block22: {
                Object object;
                block23: {
                    Object object2;
                    FileObject fileObject;
                    FileObject fileObject2;
                    block24: {
                        FileObject fileObject3;
                        block21: {
                            fileObject2 = fileObjectArray[n];
                            Info info = (Info)map.get(fileObject2);
                            if (info == null) break block21;
                            weakHashMap.put(fileObject2, info);
                            break block22;
                        }
                        fileObject = null;
                        for (int i = 0; i < INDEX_FILE_NAMES.length && (fileObject = fileObject2.getFileObject(INDEX_FILE_NAMES[i])) == null; ++i) {
                        }
                        if ((fileObject == null || fileObject.getName().equals("index")) && (fileObject3 = fileObject2.getFileObject("package-list")) != null) {
                            try {
                                object2 = fileObject3.getInputStream();
                                try {
                                    String string;
                                    FileObject fileObject4;
                                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object2));
                                    String string2 = bufferedReader.readLine();
                                    if (string2 != null && bufferedReader.readLine() == null && (fileObject4 = fileObject2.getFileObject(string = string2.replace('.', '/') + "/package-summary.html")) != null) {
                                        fileObject = fileObject4;
                                    }
                                }
                                finally {
                                    object2.close();
                                }
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                        if (fileObject == null) break block23;
                        object = super.parseTitle(fileObject);
                        if (object == null) break block24;
                        object2 = this.jdocRegs.findSearchType(fileObject2);
                        if (object2 == null) break block22;
                        object = ((JavadocSearchType)((Object)object2)).getOverviewTitleBase((String)object);
                    }
                    if ("".equals(object)) {
                        object = NbBundle.getMessage((Class)(class$org$netbeans$modules$javadoc$search$IndexBuilder == null ? IndexBuilder.class$("org.netbeans.modules.javadoc.search.IndexBuilder") : class$org$netbeans$modules$javadoc$search$IndexBuilder), (String)"FMT_NoOverviewTitle", (Object[])new Object[]{fileObject.getPath(), fileObject2.getName(), fileObject2.getName()});
                    }
                    object2 = new Info();
                    ((Info)object2).title = object == null ? fileObject2.getName() : object;
                    ((Info)object2).indexFileName = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                    weakHashMap.put(fileObject2, object2);
                }
                object = this;
                // MONITORENTER : this
                this.filesystemInfo = weakHashMap;
                // MONITOREXIT : object
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseTitle(FileObject fileObject) {
        String string;
        Object object;
        String[] stringArray;
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!string2.equalsIgnoreCase("<title>") || (stringArray = bufferedReader.readLine()) == null || !"</title>".equalsIgnoreCase((String)(object = bufferedReader.readLine()))) continue;
            if (this.err.isLoggable(1)) {
                this.err.log("Fast parsing of " + (String)stringArray);
            }
            return stringArray;
        }
        stringArray = new String[1];
        object = new InputStreamReader(fileObject.getInputStream());
        try {
            class TitleParser
            extends Parser {
                private final /* synthetic */ String[] val$title;

                public TitleParser(String[] stringArray) throws IOException {
                    this.val$title = stringArray;
                    super(DTD.getDTD("html32"));
                }

                protected void handleTitle(char[] cArray) {
                    this.val$title[0] = new String(cArray);
                    if (IndexBuilder.this.err.isLoggable(1)) {
                        IndexBuilder.this.err.log("Slow parsing of " + this.val$title[0]);
                    }
                }
            }
            new TitleParser(stringArray).parse((Reader)object);
            string = stringArray[0];
        }
        catch (Throwable throwable) {
            try {
                ((Reader)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                return null;
            }
        }
        ((Reader)object).close();
        return string;
    }

    private static synchronized void scheduleTask() {
        if (task == null) {
            task = new RequestProcessor("Javadoc Index Builder").create((Runnable)IndexBuilder.getDefault());
        }
        task.schedule(100);
    }

    private static class Info {
        String title;
        String indexFileName;

        private Info() {
        }
    }
}

