/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexListCellRenderer;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.SrcFinder;
import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.OpenCookie;
import org.openide.src.Element;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class IndexSearch
extends TopComponent
implements Externalizable {
    private static final String INDEX_SEARCH_HELP_CTX_KEY = "javadoc.search.window";
    private static final Dimension PREFFERED_SIZE = new Dimension(580, 430);
    static final long serialVersionUID = 1200348578933093459L;
    private static Reference refIndexSearch;
    private static Object[] MRU;
    private JavadocSearchEngine searchEngine = null;
    private DocumentationSettings ds = DocumentationSettings.getDefault();
    private String quickFind;
    private String currentSort = "A";
    private JScrollPane resultsScrollPane;
    private JList resultsList;
    private HtmlBrowser quickBrowser;
    private JSplitPane splitPanel;
    private static final String STR_FIND;
    private static final String STR_STOP;
    private ArrayList results = new ArrayList();
    private DefaultListModel referenceModel = null;
    private DefaultListModel typeModel = null;
    private DefaultListModel alphaModel = null;
    private int oldSplit = DocumentationSettings.getDefault().getIdxSearchSplit();
    private final DefaultListModel waitModel = new DefaultListModel();
    private final DefaultListModel notModel = new DefaultListModel();
    private boolean setDividerLocation;
    RequestProcessor.Task task = null;
    private JToggleButton byNameButton;
    private JToggleButton byReferenceButton;
    private JToggleButton byTypeButton;
    private JButton helpButton;
    private JPanel jPanel1;
    private JToggleButton quickViewButton;
    private JButton searchButton;
    private JComboBox searchComboBox;
    private JButton sourceButton;

    public IndexSearch() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)IndexSearch.class);
        DocIndexItem docIndexItem = new DocIndexItem(resourceBundle.getString("CTL_SEARCH_Wait"), "", null, "");
        docIndexItem.setIconIndex(14);
        this.waitModel.addElement(docIndexItem);
        DocIndexItem docIndexItem2 = new DocIndexItem(resourceBundle.getString("CTL_SEARCH_NotFound"), "", null, "");
        docIndexItem2.setIconIndex(13);
        this.notModel.addElement(docIndexItem2);
        this.initComponents();
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        ComboBoxEditor comboBoxEditor = this.searchComboBox.getEditor();
        comboBoxEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (IndexSearch.this.searchEngine == null) {
                    IndexSearch.this.searchButtonActionPerformed(actionEvent);
                }
            }
        });
        this.splitPanel = new JSplitPane(0);
        this.splitPanel.setPreferredSize(PREFFERED_SIZE);
        this.splitPanel.setDividerLocation((double)this.oldSplit / 100.0);
        this.setDividerLocation = true;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.splitPanel, gridBagConstraints);
        this.resultsScrollPane = new JScrollPane();
        this.resultsList = new JList();
        this.resultsList.setSelectionMode(0);
        this.resultsList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                IndexSearch.this.resultsListKeyPressed(keyEvent);
            }
        });
        this.resultsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                IndexSearch.this.resultsListMouseClicked(mouseEvent);
            }
        });
        this.resultsScrollPane.setViewportView(this.resultsList);
        this.splitPanel.setTopComponent(this.resultsScrollPane);
        this.quickBrowser = new HtmlBrowser(true, false);
        this.quickBrowser.setEnableLocation(false);
        this.quickBrowser.setEnableHome(false);
        this.quickBrowser.setBorder((Border)new EmptyBorder(new Insets(8, 0, 0, 0)));
        this.splitPanel.setBottomComponent((Component)this.quickBrowser);
        DefaultListModel defaultListModel = new DefaultListModel();
        this.resultsList.setModel(defaultListModel);
        IndexListCellRenderer indexListCellRenderer = new IndexListCellRenderer();
        this.resultsList.setCellRenderer(indexListCellRenderer);
        this.resultsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                IndexSearch.this.showHelp(true);
            }
        });
        this.resultsScrollPane.validate();
        this.searchButton.setText(STR_FIND);
        this.sourceButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/javadoc/resources/showSource.gif")));
        this.byReferenceButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/javadoc/resources/refSort.gif")));
        this.byTypeButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/javadoc/resources/typeSort.gif")));
        this.byNameButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/javadoc/resources/alphaSort.gif")));
        this.quickViewButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/javadoc/resources/list_html.gif")));
        this.quickViewButton.setSelectedIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/javadoc/resources/list_only.gif")));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.byReferenceButton);
        buttonGroup.add(this.byTypeButton);
        buttonGroup.add(this.byNameButton);
        this.searchButton.setToolTipText(resourceBundle.getString("CTL_SEARCH_search_ToolTip"));
        this.byReferenceButton.setToolTipText(resourceBundle.getString("CTL_SEARCH_byReference_ToolTip"));
        this.byReferenceButton.setMnemonic(resourceBundle.getString("CTL_SEARCH_byReference_Mnemonic").charAt(0));
        this.byTypeButton.setToolTipText(resourceBundle.getString("CTL_SEARCH_byType_ToolTip"));
        this.byTypeButton.setMnemonic(resourceBundle.getString("CTL_SEARCH_byType_Mnemonic").charAt(0));
        this.byNameButton.setToolTipText(resourceBundle.getString("CTL_SEARCH_byName_ToolTip"));
        this.byNameButton.setMnemonic(resourceBundle.getString("CTL_SEARCH_byName_Mnemonic").charAt(0));
        this.quickViewButton.setToolTipText(resourceBundle.getString("CTL_SEARCH_quickView_ToolTip"));
        this.quickViewButton.setMnemonic(resourceBundle.getString("CTL_SEARCH_quickView_Mnemonic").charAt(0));
        this.sourceButton.setToolTipText(resourceBundle.getString("CTL_SEARCH_showSource_ToolTip"));
        this.sourceButton.setMnemonic(resourceBundle.getString("CTL_SEARCH_showSource_Mnemonic").charAt(0));
        this.searchComboBox.setToolTipText(resourceBundle.getString("ACS_SEARCH_SearchComboBoxA11yDesc"));
        this.resultsList.setToolTipText(resourceBundle.getString("ACS_SEARCH_ResultsListA11yDesc"));
        this.quickBrowser.setToolTipText(resourceBundle.getString("ACS_SEARCH_QuickBrowserA11yDesc"));
        this.searchButton.setMnemonic(resourceBundle.getString("CTL_SEARCH_ButtonFind_Mnemonic").charAt(0));
        this.helpButton.setMnemonic(resourceBundle.getString("CTL_SEARCH_ButtonHelp_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return "JavaDocIndexSearch";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(INDEX_SEARCH_HELP_CTX_KEY);
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)IndexSearch.class);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_SEARCH_PanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_SEARCH_PanelA11yDesc"));
        this.searchComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_SEARCH_SearchComboBoxA11yName"));
        this.searchComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_SEARCH_SearchComboBoxA11yDesc"));
        this.resultsList.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_SEARCH_ResultsListA11yName"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_SEARCH_ResultsListA11yDesc"));
        this.quickBrowser.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_SEARCH_QuickBrowserA11yName"));
        this.quickBrowser.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_SEARCH_QuickBrowserA11yDesc"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.searchComboBox = new JComboBox<Object>(MRU);
        this.searchButton = new JButton();
        this.sourceButton = new JButton();
        this.byNameButton = new JToggleButton();
        this.byReferenceButton = new JToggleButton();
        this.byTypeButton = new JToggleButton();
        this.quickViewButton = new JToggleButton();
        this.helpButton = new JButton();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.searchComboBox.setEditable(true);
        this.searchComboBox.addActionListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.jPanel1.add((Component)this.searchComboBox, gridBagConstraints);
        this.searchButton.setText(NbBundle.getBundle((Class)IndexSearch.class).getString("IndexSearch.searchButton.text"));
        this.searchButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.searchButton, gridBagConstraints);
        this.sourceButton.setPreferredSize(new Dimension(25, 25));
        this.sourceButton.setMinimumSize(new Dimension(25, 25));
        this.sourceButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.sourceButton, gridBagConstraints);
        this.byNameButton.setSelected(true);
        this.byNameButton.setPreferredSize(new Dimension(25, 25));
        this.byNameButton.setActionCommand("A");
        this.byNameButton.setMinimumSize(new Dimension(25, 25));
        this.byNameButton.setRequestFocusEnabled(false);
        this.byNameButton.addActionListener(formListener);
        this.jPanel1.add((Component)this.byNameButton, new GridBagConstraints());
        this.byReferenceButton.setPreferredSize(new Dimension(25, 25));
        this.byReferenceButton.setActionCommand("R");
        this.byReferenceButton.setMinimumSize(new Dimension(25, 25));
        this.byReferenceButton.setRequestFocusEnabled(false);
        this.byReferenceButton.addActionListener(formListener);
        this.jPanel1.add((Component)this.byReferenceButton, new GridBagConstraints());
        this.byTypeButton.setPreferredSize(new Dimension(25, 25));
        this.byTypeButton.setActionCommand("T");
        this.byTypeButton.setMinimumSize(new Dimension(25, 25));
        this.byTypeButton.setRequestFocusEnabled(false);
        this.byTypeButton.addActionListener(formListener);
        this.jPanel1.add((Component)this.byTypeButton, new GridBagConstraints());
        this.quickViewButton.setSelected(true);
        this.quickViewButton.setRequestFocusEnabled(false);
        this.quickViewButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.quickViewButton, gridBagConstraints);
        this.helpButton.setToolTipText(NbBundle.getBundle((Class)IndexSearch.class).getString("CTL_SEARCH_ButtonHelp_tooltip"));
        this.helpButton.setText(NbBundle.getBundle((Class)IndexSearch.class).getString("CTL_SEARCH_ButtonHelp"));
        this.helpButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.jPanel1, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        help.showHelp(this.getHelpCtx());
    }

    private void showSource(ActionEvent actionEvent) {
        this.showSource();
    }

    private void sortButtonActionPerformed(ActionEvent actionEvent) {
        this.currentSort = actionEvent.getActionCommand();
        this.ds.setIdxSearchSort(this.currentSort);
        this.sortResults();
    }

    private void quickViewButtonActionPerformed(ActionEvent actionEvent) {
        if (this.quickViewButton.isSelected()) {
            this.splitPanel.setDividerLocation(this.oldSplit == 100 ? 0.5 : (double)this.oldSplit / 100.0);
            this.ds.setIdxSearchSplit(this.oldSplit == 100 ? 50 : this.oldSplit);
            this.ds.setIdxSearchNoHtml(false);
            this.showHelp(true);
        } else {
            this.oldSplit = (int)((double)this.splitPanel.getDividerLocation() / this.splitPanel.getSize().getHeight() * 100.0);
            this.splitPanel.setDividerLocation(1.0);
            this.ds.setIdxSearchSplit(100);
            this.ds.setIdxSearchNoHtml(true);
        }
    }

    private void resultsListKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
            this.showHelp();
        }
    }

    private void resultsListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            if (mouseEvent.isShiftDown()) {
                this.showSource();
                mouseEvent.consume();
            } else {
                this.showHelp();
            }
        }
    }

    private void showHelp() {
        this.showHelp(false);
    }

    private void showHelp(boolean bl) {
        if (bl && this.splitPanel.getDividerLocation() == 100) {
            return;
        }
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem docIndexItem = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            URL uRL = docIndexItem.getURL();
            if (uRL == null) {
                return;
            }
            String string = uRL.toString();
            if (string.startsWith("nbfs:") && string.charAt(5) != '/') {
                uRL = new URL("nbfs:/" + string.substring(5));
            }
            if (bl) {
                final URL uRL2 = uRL;
                if (this.task != null) {
                    this.task.cancel();
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        IndexSearch.this.quickBrowser.setURL(uRL2);
                    }
                }, 100);
            } else {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void showSource() {
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem docIndexItem = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            Element element = SrcFinder.findSource(docIndexItem.getPackage(), docIndexItem.getURL());
            if (element != null) {
                OpenCookie openCookie = (OpenCookie)element.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                } else {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)IndexSearch.class, (String)"MSG_SEARCH_SrcNotFound"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            } else {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)IndexSearch.class, (String)"MSG_SEARCH_SrcNotFound"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void searchComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        if (this.searchEngine == null) {
            if (this.searchComboBox.getEditor().getItem().toString() != null && this.searchComboBox.getEditor().getItem().toString().length() > 0) {
                this.searchEngine = JavadocSearchEngine.getDefault();
                this.go();
            }
        } else {
            this.searchEngine.stop();
            this.searchEngine = null;
        }
    }

    private void searchStoped() {
        this.searchEngine = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndexSearch.this.searchButton.setText(STR_FIND);
                IndexSearch.this.searchButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch), (String)"CTL_SEARCH_ButtonFind_Mnemonic").charAt(0));
                if (IndexSearch.this.resultsList.getModel().getSize() > 0) {
                    IndexSearch.this.resultsList.setSelectedIndex(0);
                    IndexSearch.this.resultsList.grabFocus();
                }
                IndexSearch.this.referenceModel = (IndexSearch.this.typeModel = (IndexSearch.this.alphaModel = null));
                IndexSearch.this.sortResults();
            }
        });
    }

    void setTextToFind(String string) {
        this.quickFind = string;
    }

    public void open() {
        super.open();
        if (this.quickFind != null) {
            this.searchComboBox.getEditor().setItem(this.quickFind);
            if (this.searchEngine == null) {
                this.searchButtonActionPerformed(null);
            }
        }
        this.quickFind = null;
        this.searchComboBox.getEditor().selectAll();
        if (this.setDividerLocation) {
            this.splitPanel.setDividerLocation((double)this.oldSplit / 100.0);
            this.setDividerLocation = false;
        }
    }

    Dimension getPrefferedSize() {
        return PREFFERED_SIZE;
    }

    public static IndexSearch getDefault() {
        IndexSearch indexSearch;
        if (refIndexSearch == null || null == (indexSearch = (IndexSearch)refIndexSearch.get())) {
            indexSearch = new IndexSearch();
            refIndexSearch = new SoftReference<IndexSearch>(indexSearch);
            indexSearch.setName(NbBundle.getMessage((Class)IndexSearch.class, (String)"CTL_SEARCH_WindowTitle"));
            indexSearch.setIcon(Utilities.loadImage((String)"org/netbeans/modules/javadoc/resources/searchDoc.gif"));
        }
        return indexSearch;
    }

    public void resolveButtonState() {
        final String string = this.ds.getIdxSearchSort();
        final boolean bl = this.ds.isIdxSearchNoHtml();
        final int n = this.ds.getIdxSearchSplit();
        this.currentSort = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndexSearch.this.byNameButton.setSelected(string.equals("A"));
                IndexSearch.this.byReferenceButton.setSelected(string.equals("R"));
                IndexSearch.this.byTypeButton.setSelected(string.equals("T"));
                IndexSearch.this.quickViewButton.setSelected(!bl);
                IndexSearch.this.splitPanel.setDividerLocation((double)n / 100.0);
            }
        });
    }

    private Object readResolve() throws ObjectStreamException {
        return IndexSearch.getDefault();
    }

    void go() {
        String string = this.searchComboBox.getEditor().getItem().toString().trim();
        this.results = new ArrayList();
        this.referenceModel = null;
        this.typeModel = null;
        this.alphaModel = null;
        for (int i = 0; i < this.searchComboBox.getItemCount(); ++i) {
            if (!this.searchComboBox.getItemAt(i).toString().equals(string) && i < 10) continue;
            this.searchComboBox.removeItemAt(i);
        }
        this.searchComboBox.insertItemAt(string, 0);
        this.mirrorMRUStrings();
        this.searchComboBox.getEditor().setItem(string);
        this.resultsList.setModel(this.waitModel);
        try {
            this.searchEngine.search(new String[]{string}, new JavadocSearchEngine.SearchEngineCallback(){

                public void finished() {
                    IndexSearch.this.searchStoped();
                }

                public void addItem(DocIndexItem docIndexItem) {
                    IndexSearch.this.results.add(docIndexItem);
                }
            });
        }
        catch (NoJavadocException noJavadocException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)noJavadocException.getMessage()));
            this.searchStoped();
            return;
        }
        this.searchButton.setText(STR_STOP);
        this.searchButton.setMnemonic(NbBundle.getMessage((Class)IndexSearch.class, (String)"CTL_SEARCH_ButtonStop_Mnemonic").charAt(0));
    }

    private void mirrorMRUStrings() {
        ComboBoxModel comboBoxModel = this.searchComboBox.getModel();
        int n = comboBoxModel.getSize();
        MRU = new Object[n];
        for (int i = 0; i < n; ++i) {
            IndexSearch.MRU[i] = comboBoxModel.getElementAt(i);
        }
    }

    DefaultListModel generateModel(Comparator comparator) {
        DefaultListModel<DocIndexItem> defaultListModel = new DefaultListModel<DocIndexItem>();
        Collections.sort(this.results, comparator);
        Iterator iterator = this.results.iterator();
        String string = null;
        while (iterator.hasNext()) {
            DocIndexItem docIndexItem = (DocIndexItem)iterator.next();
            if (comparator == DocIndexItem.REFERENCE_COMPARATOR && !docIndexItem.getPackage().equals(string) && docIndexItem.getIconIndex() != 1) {
                DocIndexItem docIndexItem2 = new DocIndexItem("PACKAGE ", docIndexItem.getPackage(), null, "");
                docIndexItem2.setIconIndex(1);
                defaultListModel.addElement(docIndexItem2);
                string = docIndexItem.getPackage();
            }
            defaultListModel.addElement(docIndexItem);
        }
        return defaultListModel;
    }

    void sortResults() {
        if (this.results.size() < 1) {
            this.resultsList.setModel(this.notModel);
        } else if (this.currentSort.equals("R")) {
            if (this.referenceModel == null) {
                this.resultsList.setModel(this.waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.referenceModel = this.generateModel(DocIndexItem.REFERENCE_COMPARATOR);
            }
            this.resultsList.setModel(this.referenceModel);
        } else if (this.currentSort.equals("T")) {
            if (this.typeModel == null) {
                this.resultsList.setModel(this.waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.typeModel = this.generateModel(DocIndexItem.TYPE_COMPARATOR);
            }
            this.resultsList.setModel(this.typeModel);
        } else if (this.currentSort.equals("A")) {
            if (this.alphaModel == null) {
                this.resultsList.setModel(this.waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.alphaModel = this.generateModel(DocIndexItem.ALPHA_COMPARATOR);
            }
            this.resultsList.setModel(this.alphaModel);
        }
        this.resultsList.invalidate();
        this.resultsList.revalidate();
        this.resultsList.repaint();
    }

    static {
        MRU = new Object[0];
        STR_FIND = NbBundle.getMessage((Class)IndexSearch.class, (String)"CTL_SEARCH_ButtonFind");
        STR_STOP = NbBundle.getMessage((Class)IndexSearch.class, (String)"CTL_SEARCH_ButtonStop");
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == IndexSearch.this.searchComboBox) {
                IndexSearch.this.searchComboBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IndexSearch.this.searchButton) {
                IndexSearch.this.searchButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IndexSearch.this.sourceButton) {
                IndexSearch.this.showSource(actionEvent);
            } else if (actionEvent.getSource() == IndexSearch.this.byNameButton) {
                IndexSearch.this.sortButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IndexSearch.this.byReferenceButton) {
                IndexSearch.this.sortButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IndexSearch.this.byTypeButton) {
                IndexSearch.this.sortButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IndexSearch.this.quickViewButton) {
                IndexSearch.this.quickViewButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IndexSearch.this.helpButton) {
                IndexSearch.this.helpButtonActionPerformed(actionEvent);
            }
        }
    }
}

