/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class JavadocSearchType
extends ServiceType {
    static final long serialVersionUID = -7643543247564581246L;
    private Pattern[] overviewLabelFilters;

    public abstract FileObject getDocFileObject(FileObject var1);

    private synchronized void prepareOverviewFilter() {
        if (this.overviewLabelFilters != null) {
            return;
        }
        String string = NbBundle.getMessage((Class)JavadocSearchType.class, (String)"FILTER_OverviewIndiceLabel");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        LinkedList<Pattern> linkedList = new LinkedList<Pattern>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken();
                Pattern pattern = Pattern.compile(string2);
                linkedList.add(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ErrorManager.getDefault().notify(1, (Throwable)patternSyntaxException);
            }
        }
        this.overviewLabelFilters = linkedList.toArray(new Pattern[linkedList.size()]);
    }

    public String getOverviewTitleBase(String string) {
        this.prepareOverviewFilter();
        String string2 = string.trim();
        for (int i = 0; i < this.overviewLabelFilters.length; ++i) {
            Matcher matcher = this.overviewLabelFilters[i].matcher(string2);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return string;
    }

    public abstract IndexSearchThread getSearchThread(String var1, FileObject var2, IndexSearchThread.DocIndexItemConsumer var3);

    public abstract boolean accepts(FileObject var1, String var2);
}

