/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import org.openide.ErrorManager;
import org.openide.actions.UndoAction;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class RedoAction
extends CallableSystemAction {
    private static String SWING_DEFAULT_LABEL = UIManager.getString("AbstractUndoableEdit.redoText");

    public boolean isEnabled() {
        UndoAction.initializeUndoRedo();
        return super.isEnabled();
    }

    public String getName() {
        String string = UndoAction.getUndoRedo().getRedoPresentationName();
        if (string != null && SWING_DEFAULT_LABEL != null && string.startsWith(SWING_DEFAULT_LABEL)) {
            string = string.substring(0, SWING_DEFAULT_LABEL.length()).trim();
        }
        return NbBundle.getMessage((Class)RedoAction.class, (String)"Redo", (Object)string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RedoAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/redo.gif";
    }

    public void performAction() {
        try {
            UndoRedo undoRedo = UndoAction.getUndoRedo();
            if (undoRedo.canRedo()) {
                undoRedo.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            ErrorManager.getDefault().notify((Throwable)cannotRedoException);
        }
        UndoAction.updateStatus();
    }

    protected boolean asynchronous() {
        return false;
    }
}

