/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.core.windows.ConfigFactory;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.persistence.GroupConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.PersistenceObserver;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.WindowManagerConfig;
import org.openide.ErrorManager;
import org.openide.awt.ToolbarPool;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class PersistenceHandler
implements PersistenceObserver {
    private final Map name2mode = new WeakHashMap(10);
    private final Map name2group = new WeakHashMap(10);
    private static PersistenceHandler defaultInstance;
    private static final boolean DEBUG;

    private PersistenceHandler() {
    }

    public static synchronized PersistenceHandler getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PersistenceHandler();
        }
        return defaultInstance;
    }

    public boolean isTopComponentPersistentWhenClosed(TopComponent topComponent) {
        int n = topComponent.getPersistenceType();
        return n == 0;
    }

    public void load() {
        TopComponent topComponent;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        WindowManagerConfig windowManagerConfig;
        if (DEBUG) {
            PersistenceHandler.debugLog("## PersistenceHandler.load");
        }
        if ((windowManagerConfig = PersistenceManager.getDefault().loadWindowSystem()) == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Cannot load window system persistent data. Using internally predefined configuration"));
            windowManagerConfig = ConfigFactory.createDefaultConfig();
        }
        ToolbarPool.getDefault().setPreferredIconSize(windowManagerConfig.preferredToolbarIconSize);
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (windowManagerConfig.tcIdViewList.length > 0) {
            object5 = new ArrayList(windowManagerConfig.tcIdViewList.length);
            for (int i = 0; i < windowManagerConfig.tcIdViewList.length; ++i) {
                object4 = this.getTopComponentForID(windowManagerConfig.tcIdViewList[i]);
                if (object4 == null) continue;
                object5.add(object4);
            }
            object3 = object5.toArray(new TopComponent[object5.size()]);
            windowManagerImpl.setRecentViewList((TopComponent[])object3);
        } else {
            object5 = new ArrayList<ModeConfig>();
            for (int i = 0; i < windowManagerConfig.modes.length; ++i) {
                object4 = windowManagerConfig.modes[i];
                for (int j = 0; j < ((ModeConfig)object4).tcRefConfigs.length; ++j) {
                    TopComponent topComponent2;
                    if (!((ModeConfig)object4).tcRefConfigs[j].opened || (topComponent2 = this.getTopComponentForID(((ModeConfig)object4).tcRefConfigs[j].tc_id)) == null) continue;
                    object5.add(topComponent2);
                }
            }
            object3 = object5.toArray(new TopComponent[object5.size()]);
            windowManagerImpl.setRecentViewList((TopComponent[])object3);
        }
        windowManagerImpl.setEditorAreaConstraints(windowManagerConfig.editorAreaConstraints);
        if (Constants.SWITCH_START_IN_SEPARATE_MODE) {
            windowManagerImpl.setEditorAreaState(1);
        } else {
            windowManagerImpl.setEditorAreaState(windowManagerConfig.editorAreaState);
        }
        object5 = null;
        object3 = null;
        object4 = new HashMap();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < windowManagerConfig.modes.length; ++i) {
            object2 = windowManagerConfig.modes[i];
            object = this.getModeFromConfig((ModeConfig)object2);
            object4.put(object, object2);
            if (((ModeConfig)object2).name.equals(windowManagerConfig.activeModeName)) {
                object5 = object;
            }
            if (!((ModeConfig)object2).name.equals(windowManagerConfig.maximizedModeName)) continue;
            object3 = object;
        }
        Iterator iterator = object4.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (ModeImpl)iterator.next();
            object = (ModeConfig)object4.get(object2);
            this.initModeFromConfig((ModeImpl)object2, (ModeConfig)object);
            this.initPreviousModes((ModeImpl)object2, (ModeConfig)object, (Map)object4);
            if (((ModeConfig)object).selectedTopComponentID == null) continue;
            ((ModeImpl)object2).setUnloadedSelectedTopComponent(((ModeConfig)object).selectedTopComponentID);
        }
        for (int i = 0; i < windowManagerConfig.groups.length; ++i) {
            object2 = windowManagerConfig.groups[i];
            this.createTopComponentGroupFromConfig((GroupConfig)object2);
        }
        if (object5 != null && (topComponent = ((ModeImpl)object5).getSelectedTopComponent()) != null) {
            WindowManagerImpl.getInstance().specialPersistenceCompShow(topComponent);
        }
        windowManagerImpl.setActiveMode((ModeImpl)object5);
        windowManagerImpl.setMaximizedMode((ModeImpl)object3);
        Rectangle rectangle = PersistenceHandler.computeBounds(windowManagerConfig.centeredHorizontallyJoined, windowManagerConfig.centeredVerticallyJoined, windowManagerConfig.xJoined, windowManagerConfig.yJoined, windowManagerConfig.widthJoined, windowManagerConfig.heightJoined, windowManagerConfig.relativeXJoined, windowManagerConfig.relativeYJoined, windowManagerConfig.relativeWidthJoined, windowManagerConfig.relativeHeightJoined);
        if (rectangle != null) {
            windowManagerImpl.setMainWindowBoundsJoined(rectangle);
        }
        if ((object2 = PersistenceHandler.computeBounds(windowManagerConfig.centeredHorizontallySeparated, windowManagerConfig.centeredVerticallySeparated, windowManagerConfig.xSeparated, windowManagerConfig.ySeparated, windowManagerConfig.widthSeparated, windowManagerConfig.heightSeparated, windowManagerConfig.relativeXSeparated, windowManagerConfig.relativeYSeparated, windowManagerConfig.relativeWidthSeparated, windowManagerConfig.relativeHeightSeparated)) != null) {
            windowManagerImpl.setMainWindowBoundsSeparated((Rectangle)object2);
        }
        windowManagerImpl.setMainWindowFrameStateJoined(windowManagerConfig.mainWindowFrameStateJoined);
        windowManagerImpl.setMainWindowFrameStateSeparated(windowManagerConfig.mainWindowFrameStateSeparated);
        object = windowManagerConfig.editorAreaBounds == null ? new Rectangle() : windowManagerConfig.editorAreaBounds;
        Rectangle rectangle2 = windowManagerConfig.editorAreaRelativeBounds == null ? new Rectangle() : windowManagerConfig.editorAreaRelativeBounds;
        Rectangle rectangle3 = PersistenceHandler.computeBounds(false, false, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height, (float)rectangle2.x / 100.0f, (float)rectangle2.y / 100.0f, (float)rectangle2.width / 100.0f, (float)rectangle2.height / 100.0f);
        windowManagerImpl.setEditorAreaBounds(rectangle3);
        windowManagerImpl.setEditorAreaFrameState(windowManagerConfig.editorAreaFrameState);
        windowManagerImpl.setToolbarConfigName(windowManagerConfig.toolbarConfiguration);
    }

    public synchronized void save() {
        if (DEBUG) {
            PersistenceHandler.debugLog("## PersistenceHandler.save");
        }
        WindowManagerConfig windowManagerConfig = this.getConfig();
        PersistenceManager.getDefault().saveWindowSystem(windowManagerConfig);
    }

    private ModeImpl getModeFromConfig(ModeConfig modeConfig) {
        ModeImpl modeImpl;
        if (DEBUG) {
            PersistenceHandler.debugLog("Getting mode name=" + modeConfig.name);
        }
        if ((modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(modeConfig.name)) == null) {
            modeImpl = this.createModeFromConfig(modeConfig);
        }
        return modeImpl;
    }

    private ModeImpl createModeFromConfig(ModeConfig modeConfig) {
        if (DEBUG) {
            PersistenceHandler.debugLog("");
            PersistenceHandler.debugLog("Creating mode name=\"" + modeConfig.name + "\"");
        }
        ModeImpl modeImpl = modeConfig.kind == 2 ? WindowManagerImpl.getInstance().createSlidingMode(modeConfig.name, modeConfig.permanent, modeConfig.side) : WindowManagerImpl.getInstance().createMode(modeConfig.name, modeConfig.kind, modeConfig.permanent, modeConfig.constraints);
        this.name2mode.put(modeConfig.name, modeImpl);
        return modeImpl;
    }

    private void initPreviousModes(ModeImpl modeImpl, ModeConfig modeConfig, Map map) {
        for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
            TCRefConfig tCRefConfig = modeConfig.tcRefConfigs[i];
            if (DEBUG) {
                PersistenceHandler.debugLog("\tTopComponent[" + i + "] id=\"" + tCRefConfig.tc_id + "\", \topened=" + tCRefConfig.opened);
            }
            if (tCRefConfig.previousMode == null) continue;
            Iterator iterator = map.keySet().iterator();
            ModeImpl modeImpl2 = null;
            while (iterator.hasNext()) {
                ModeImpl modeImpl3 = (ModeImpl)iterator.next();
                if (!tCRefConfig.previousMode.equals(modeImpl3.getName())) continue;
                modeImpl2 = modeImpl3;
                break;
            }
            if (modeImpl2 != null) {
                WindowManagerImpl.getInstance().setPreviousModeForTopComponent(tCRefConfig.tc_id, modeImpl, modeImpl2);
                continue;
            }
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Cannot find previous mode named '" + tCRefConfig.previousMode + "'"));
        }
    }

    private ModeImpl initModeFromConfig(ModeImpl modeImpl, ModeConfig modeConfig) {
        Object object;
        Object object2;
        for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
            object2 = modeConfig.tcRefConfigs[i];
            if (DEBUG) {
                PersistenceHandler.debugLog("\tTopComponent[" + i + "] id=\"" + ((TCRefConfig)object2).tc_id + "\", \topened=" + ((TCRefConfig)object2).opened);
            }
            if (((TCRefConfig)object2).opened) {
                object = this.getTopComponentForID(((TCRefConfig)object2).tc_id);
                if (object == null) continue;
                modeImpl.addOpenedTopComponent((TopComponent)object);
                continue;
            }
            modeImpl.addUnloadedTopComponent(((TCRefConfig)object2).tc_id);
        }
        Rectangle rectangle = modeConfig.bounds == null ? new Rectangle() : modeConfig.bounds;
        object2 = modeConfig.relativeBounds == null ? new Rectangle() : modeConfig.relativeBounds;
        object = PersistenceHandler.computeBounds(false, false, rectangle.x, rectangle.y, rectangle.width, rectangle.height, (float)((Rectangle)object2).x / 100.0f, (float)((Rectangle)object2).y / 100.0f, (float)((Rectangle)object2).width / 100.0f, (float)((Rectangle)object2).height / 100.0f);
        modeImpl.setBounds((Rectangle)object);
        modeImpl.setFrameState(modeConfig.frameState);
        return modeImpl;
    }

    TopComponent getTopComponentForID(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        TopComponent topComponent = PersistenceManager.getDefault().getTopComponentForID(string);
        return topComponent;
    }

    private TopComponentGroupImpl createTopComponentGroupFromConfig(GroupConfig groupConfig) {
        if (DEBUG) {
            PersistenceHandler.debugLog("");
            PersistenceHandler.debugLog("Creating group name=\"" + groupConfig.name + "\" \t[opened=" + groupConfig.opened + "]");
        }
        TopComponentGroupImpl topComponentGroupImpl = new TopComponentGroupImpl(groupConfig.name, groupConfig.opened);
        this.name2group.put(groupConfig.name, topComponentGroupImpl);
        for (int i = 0; i < groupConfig.tcGroupConfigs.length; ++i) {
            TCGroupConfig tCGroupConfig = groupConfig.tcGroupConfigs[i];
            if (DEBUG) {
                PersistenceHandler.debugLog("\tTopComponent[" + i + "] id=\"" + tCGroupConfig.tc_id + "\", \topen=" + tCGroupConfig.open + ", \tclose=" + tCGroupConfig.close + ", \twasOpened=" + tCGroupConfig.wasOpened);
            }
            topComponentGroupImpl.addUnloadedTopComponent(tCGroupConfig.tc_id);
            if (tCGroupConfig.open) {
                topComponentGroupImpl.addUnloadedOpeningTopComponent(tCGroupConfig.tc_id);
            }
            if (tCGroupConfig.close) {
                topComponentGroupImpl.addUnloadedClosingTopComponent(tCGroupConfig.tc_id);
            }
            if (!groupConfig.opened || !tCGroupConfig.wasOpened) continue;
            topComponentGroupImpl.addGroupUnloadedOpenedTopComponent(tCGroupConfig.tc_id);
        }
        WindowManagerImpl.getInstance().addTopComponentGroup(topComponentGroupImpl);
        return topComponentGroupImpl;
    }

    private WindowManagerConfig getConfig() {
        WindowManagerConfig windowManagerConfig = new WindowManagerConfig();
        windowManagerConfig.preferredToolbarIconSize = ToolbarPool.getDefault().getPreferredIconSize();
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        Rectangle rectangle = windowManagerImpl.getMainWindowBoundsJoined();
        if (DEBUG) {
            PersistenceHandler.debugLog("joinedBouds=" + rectangle);
        }
        windowManagerConfig.xJoined = rectangle.x;
        windowManagerConfig.yJoined = rectangle.y;
        windowManagerConfig.widthJoined = rectangle.width;
        windowManagerConfig.heightJoined = rectangle.height;
        Rectangle rectangle2 = windowManagerImpl.getMainWindowBoundsSeparated();
        if (DEBUG) {
            PersistenceHandler.debugLog("separatedBounds=" + rectangle2);
        }
        windowManagerConfig.xSeparated = rectangle2.x;
        windowManagerConfig.ySeparated = rectangle2.y;
        windowManagerConfig.widthSeparated = rectangle2.width;
        windowManagerConfig.heightSeparated = rectangle2.height;
        windowManagerConfig.mainWindowFrameStateJoined = windowManagerImpl.getMainWindowFrameStateJoined();
        if (windowManagerConfig.mainWindowFrameStateJoined == 1) {
            windowManagerConfig.mainWindowFrameStateJoined = 0;
        }
        if (DEBUG) {
            PersistenceHandler.debugLog("mainWindowFrameStateJoined=" + windowManagerConfig.mainWindowFrameStateJoined);
        }
        windowManagerConfig.mainWindowFrameStateSeparated = windowManagerImpl.getMainWindowFrameStateSeparated();
        if (windowManagerConfig.mainWindowFrameStateSeparated == 1) {
            windowManagerConfig.mainWindowFrameStateSeparated = 0;
        }
        if (DEBUG) {
            PersistenceHandler.debugLog("mainWindowFrameStateSeparated=" + windowManagerConfig.mainWindowFrameStateSeparated);
        }
        windowManagerConfig.editorAreaState = windowManagerImpl.getEditorAreaState();
        if (DEBUG) {
            PersistenceHandler.debugLog("editorAreaState=" + windowManagerConfig.editorAreaState);
        }
        windowManagerConfig.editorAreaBounds = windowManagerImpl.getEditorAreaBounds();
        if (DEBUG) {
            PersistenceHandler.debugLog("editorAreaBounds=" + windowManagerConfig.editorAreaBounds);
        }
        windowManagerConfig.editorAreaConstraints = windowManagerImpl.getEditorAreaConstraints();
        if (DEBUG) {
            PersistenceHandler.debugLog("editorAreaConstraints=" + windowManagerConfig.editorAreaConstraints);
        }
        windowManagerConfig.editorAreaFrameState = windowManagerImpl.getEditorAreaFrameState();
        if (DEBUG) {
            PersistenceHandler.debugLog("editorAreaFrameState=" + windowManagerConfig.editorAreaFrameState);
        }
        windowManagerConfig.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ModeImpl modeImpl = windowManagerImpl.getActiveMode();
        if (DEBUG) {
            PersistenceHandler.debugLog("active mode=" + modeImpl);
        }
        if (modeImpl != null) {
            windowManagerConfig.activeModeName = modeImpl.getName();
        }
        modeImpl = windowManagerImpl.getMaximizedMode();
        if (DEBUG) {
            PersistenceHandler.debugLog("maximized mode=" + modeImpl);
        }
        if (modeImpl != null) {
            windowManagerConfig.maximizedModeName = modeImpl.getName();
        }
        windowManagerConfig.toolbarConfiguration = windowManagerImpl.getToolbarConfigName();
        if (DEBUG) {
            PersistenceHandler.debugLog("toolbarConfiguration=" + windowManagerConfig.toolbarConfiguration);
        }
        Set set = windowManagerImpl.getModes();
        ArrayList<ModeConfig> arrayList = new ArrayList<ModeConfig>(set.size());
        Object object = set.iterator();
        while (object.hasNext()) {
            arrayList.add(this.getConfigFromMode((ModeImpl)object.next()));
        }
        windowManagerConfig.modes = arrayList.toArray(new ModeConfig[0]);
        object = windowManagerImpl.getTopComponentGroups();
        ArrayList<GroupConfig> arrayList2 = new ArrayList<GroupConfig>(object.size());
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            arrayList2.add(this.getConfigFromGroup((TopComponentGroupImpl)object2.next()));
        }
        windowManagerConfig.groups = arrayList2.toArray(new GroupConfig[0]);
        object2 = PersistenceManager.getDefault();
        TopComponent[] topComponentArray = windowManagerImpl.getRecentViewList();
        ArrayList<String> arrayList3 = new ArrayList<String>(topComponentArray.length);
        for (int i = 0; i < topComponentArray.length; ++i) {
            if (!((PersistenceManager)object2).isTopComponentPersistent(topComponentArray[i])) continue;
            String string = WindowManager.getDefault().findTopComponentID(topComponentArray[i]);
            string = PersistenceManager.escapeTcId4XmlContent(string);
            arrayList3.add(string);
        }
        windowManagerConfig.tcIdViewList = arrayList3.toArray(new String[arrayList3.size()]);
        return windowManagerConfig;
    }

    private ModeConfig getConfigFromMode(ModeImpl modeImpl) {
        Object object;
        TopComponent topComponent;
        Object var5_5;
        PersistenceManager persistenceManager = PersistenceManager.getDefault();
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeConfig modeConfig = new ModeConfig();
        modeConfig.name = modeImpl.getName();
        if (DEBUG) {
            PersistenceHandler.debugLog("");
            PersistenceHandler.debugLog("mode name=" + modeConfig.name);
        }
        modeConfig.state = modeImpl.getState();
        if (DEBUG) {
            PersistenceHandler.debugLog("mode state=" + modeConfig.state);
        }
        modeConfig.kind = modeImpl.getKind();
        if (DEBUG) {
            PersistenceHandler.debugLog("mode kind=" + modeConfig.kind);
        }
        if (windowManagerImpl instanceof WindowManagerImpl) {
            modeConfig.side = windowManagerImpl.getCentral().getModeSide(modeImpl);
        }
        if (DEBUG) {
            PersistenceHandler.debugLog("mode side=" + modeConfig.side);
        }
        modeConfig.constraints = modeImpl.getConstraints();
        if (DEBUG) {
            PersistenceHandler.debugLog("mode constraints=" + modeConfig.constraints);
        }
        if ((var5_5 = null) != null) {
            modeConfig.relativeBounds = var5_5;
        } else {
            modeConfig.bounds = modeImpl.getBounds();
            if (DEBUG) {
                PersistenceHandler.debugLog("mode bounds=" + modeConfig.bounds);
            }
        }
        modeConfig.frameState = modeImpl.getFrameState();
        if (DEBUG) {
            PersistenceHandler.debugLog("mode frame state=" + modeConfig.frameState);
        }
        if ((topComponent = modeImpl.getSelectedTopComponent()) != null && persistenceManager.isTopComponentPersistent(topComponent)) {
            object = windowManagerImpl.findTopComponentID(topComponent);
            if (DEBUG) {
                PersistenceHandler.debugLog("selected tc=" + topComponent.getName());
            }
            modeConfig.selectedTopComponentID = object;
        }
        modeConfig.permanent = modeImpl.isPermanent();
        if (DEBUG) {
            PersistenceHandler.debugLog("mode permanent=" + modeConfig.permanent);
        }
        object = new ArrayList();
        List list = modeImpl.getOpenedTopComponentsIDs();
        Iterator iterator = modeImpl.getTopComponentsIDs().iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            String string = (String)iterator.next();
            boolean bl = list.contains(string);
            if (bl && ((object3 = windowManagerImpl.findTopComponent(string)) == null || !persistenceManager.isTopComponentPersistent((TopComponent)object3))) continue;
            object3 = null;
            if (modeImpl.getKind() == 2 && (object2 = windowManagerImpl.getPreviousModeForTopComponent(string, modeImpl)) != null) {
                object3 = ((ModeImpl)object2).getName();
            }
            if (DEBUG) {
                PersistenceHandler.debugLog("tc ID=" + string + " opened=" + bl);
            }
            object2 = new TCRefConfig();
            ((TCRefConfig)object2).tc_id = string;
            ((TCRefConfig)object2).opened = bl;
            ((TCRefConfig)object2).previousMode = object3;
            object.add(object2);
        }
        modeConfig.tcRefConfigs = object.toArray(new TCRefConfig[object.size()]);
        return modeConfig;
    }

    private GroupConfig getConfigFromGroup(TopComponentGroupImpl topComponentGroupImpl) {
        GroupConfig groupConfig = new GroupConfig();
        groupConfig.name = topComponentGroupImpl.getName();
        groupConfig.opened = topComponentGroupImpl.isOpened();
        if (DEBUG) {
            PersistenceHandler.debugLog("");
            PersistenceHandler.debugLog("group name=" + groupConfig.name);
        }
        Set set = topComponentGroupImpl.getOpeningSetIDs();
        Set set2 = topComponentGroupImpl.getClosingSetIDs();
        Set set3 = topComponentGroupImpl.getGroupOpenedTopComponentsIDs();
        HashMap<String, TCGroupConfig> hashMap = new HashMap<String, TCGroupConfig>();
        Iterator iterator = topComponentGroupImpl.getTopComponentsIDs().iterator();
        while (iterator.hasNext()) {
            TCGroupConfig tCGroupConfig;
            String string = (String)iterator.next();
            if (hashMap.containsKey(string)) {
                tCGroupConfig = (TCGroupConfig)hashMap.get(string);
            } else {
                tCGroupConfig = new TCGroupConfig();
                tCGroupConfig.tc_id = string;
                hashMap.put(string, tCGroupConfig);
            }
            tCGroupConfig.open = set.contains(string);
            tCGroupConfig.close = set2.contains(string);
            if (groupConfig.opened) {
                tCGroupConfig.wasOpened = set3.contains(string);
            }
            if (!DEBUG) continue;
            PersistenceHandler.debugLog("tc id=" + tCGroupConfig.tc_id + ", open=" + tCGroupConfig.open + ", close=" + tCGroupConfig.close + ", wasOpened=" + tCGroupConfig.wasOpened);
        }
        groupConfig.tcGroupConfigs = hashMap.values().toArray(new TCGroupConfig[0]);
        return groupConfig;
    }

    public synchronized void modeConfigAdded(ModeConfig modeConfig) {
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.modeConfigAdded mo:" + modeConfig.name);
        }
        ModeImpl modeImpl = this.getModeFromConfig(modeConfig);
        this.initModeFromConfig(modeImpl, modeConfig);
    }

    public synchronized void modeConfigRemoved(String string) {
        ModeImpl modeImpl;
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.modeConfigRemoved mo:" + string);
        }
        if ((modeImpl = (ModeImpl)this.name2mode.remove(string)) != null) {
            WindowManagerImpl.getInstance().removeMode(modeImpl);
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Mode for name=" + string + " was not created"));
        }
    }

    public synchronized void topComponentRefConfigAdded(String string, TCRefConfig tCRefConfig, String[] stringArray) {
        ModeImpl modeImpl;
        TopComponent topComponent;
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.topComponentRefConfigAdded mo:" + string + " tcRef:" + tCRefConfig.tc_id);
        }
        if ((topComponent = this.getTopComponentForID(tCRefConfig.tc_id)) != null && (modeImpl = (ModeImpl)this.name2mode.get(string)) != null) {
            if (tCRefConfig.opened) {
                modeImpl.addOpenedTopComponent(topComponent);
            } else {
                modeImpl.addClosedTopComponent(topComponent);
            }
        }
    }

    public synchronized void topComponentRefConfigRemoved(String string) {
        WindowManagerImpl windowManagerImpl;
        ModeImpl modeImpl;
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.topComponentRefConfigRemoved tcRef:" + string);
        }
        if ((modeImpl = (windowManagerImpl = WindowManagerImpl.getInstance()).findModeForOpenedID(string)) != null) {
            TopComponent topComponent = this.getTopComponentForID(string);
            if (topComponent != null) {
                modeImpl.removeTopComponent(topComponent);
            }
        } else {
            modeImpl = windowManagerImpl.findModeForClosedID(string);
            if (modeImpl != null) {
                modeImpl.removeClosedTopComponentID(string);
            }
        }
    }

    public synchronized void groupConfigAdded(GroupConfig groupConfig) {
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.groupConfigAdded group:" + groupConfig.name);
        }
        this.createTopComponentGroupFromConfig(groupConfig);
    }

    public synchronized void groupConfigRemoved(String string) {
        TopComponentGroupImpl topComponentGroupImpl;
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.groupConfigRemoved group:" + string);
        }
        if ((topComponentGroupImpl = (TopComponentGroupImpl)this.name2group.remove(string)) != null) {
            WindowManagerImpl.getInstance().removeTopComponentGroup(topComponentGroupImpl);
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Null group for name=" + string));
        }
    }

    public synchronized void topComponentGroupConfigAdded(String string, TCGroupConfig tCGroupConfig) {
        TopComponentGroupImpl topComponentGroupImpl;
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.topComponentGroupConfigAdded group:" + string + " tcGroup:" + tCGroupConfig.tc_id);
        }
        if ((topComponentGroupImpl = (TopComponentGroupImpl)this.name2group.get(string)) != null) {
            topComponentGroupImpl.addUnloadedTopComponent(tCGroupConfig.tc_id);
            if (tCGroupConfig.open) {
                topComponentGroupImpl.addUnloadedOpeningTopComponent(tCGroupConfig.tc_id);
            }
            if (tCGroupConfig.close) {
                topComponentGroupImpl.addUnloadedClosingTopComponent(tCGroupConfig.tc_id);
            }
        }
    }

    public synchronized void topComponentGroupConfigRemoved(String string, String string2) {
        TopComponentGroupImpl topComponentGroupImpl;
        if (DEBUG) {
            PersistenceHandler.debugLog("WMI.topComponentGroupConfigRemoved group:" + string + " tcGroup:" + string2);
        }
        if ((topComponentGroupImpl = (TopComponentGroupImpl)this.name2group.get(string)) != null) {
            topComponentGroupImpl.removeUnloadedTopComponent(string2);
        }
    }

    private static String dumpConfig(WindowManagerConfig windowManagerConfig) {
        Object object;
        int n;
        Object object2;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n-- wmc: [" + Integer.toHexString(System.identityHashCode(windowManagerConfig)) + "]");
        stringBuffer.append("\n-- JOINED --");
        stringBuffer.append("\n-- x: " + windowManagerConfig.xJoined);
        stringBuffer.append("\n-- y: " + windowManagerConfig.yJoined);
        stringBuffer.append("\n--  width: " + windowManagerConfig.widthJoined);
        stringBuffer.append("\n-- height: " + windowManagerConfig.heightJoined);
        stringBuffer.append("\n--  relativeX: " + windowManagerConfig.relativeXJoined);
        stringBuffer.append("\n--  relativeY: " + windowManagerConfig.relativeYJoined);
        stringBuffer.append("\n--  relativeWidth: " + windowManagerConfig.relativeWidthJoined);
        stringBuffer.append("\n-- relativeHeight: " + windowManagerConfig.relativeHeightJoined);
        stringBuffer.append("\n-- centeredHorizontally: " + windowManagerConfig.centeredHorizontallyJoined);
        stringBuffer.append("\n--   centeredVertically: " + windowManagerConfig.centeredVerticallyJoined);
        stringBuffer.append("\n--    maximizeIfWidthBelowJoined: " + windowManagerConfig.maximizeIfWidthBelowJoined);
        stringBuffer.append("\n--   maximizeIfHeightBelowJoined: " + windowManagerConfig.maximizeIfHeightBelowJoined);
        stringBuffer.append("\n-- SEPARATED --");
        stringBuffer.append("\n-- x: " + windowManagerConfig.xSeparated);
        stringBuffer.append("\n-- y: " + windowManagerConfig.ySeparated);
        stringBuffer.append("\n--  width: " + windowManagerConfig.widthSeparated);
        stringBuffer.append("\n-- height: " + windowManagerConfig.heightSeparated);
        stringBuffer.append("\n--  relativeX: " + windowManagerConfig.relativeXSeparated);
        stringBuffer.append("\n--  relativeY: " + windowManagerConfig.relativeYSeparated);
        stringBuffer.append("\n--  relativeWidth: " + windowManagerConfig.relativeWidthSeparated);
        stringBuffer.append("\n-- relativeHeight: " + windowManagerConfig.relativeHeightSeparated);
        stringBuffer.append("\n-- centeredHorizontally: " + windowManagerConfig.centeredHorizontallySeparated);
        stringBuffer.append("\n--   centeredVertically: " + windowManagerConfig.centeredVerticallySeparated);
        stringBuffer.append("\n-- editorAreaState: " + windowManagerConfig.editorAreaState);
        if (windowManagerConfig.editorAreaConstraints != null) {
            for (n2 = 0; n2 < windowManagerConfig.editorAreaConstraints.length; ++n2) {
                stringBuffer.append("\n-- co[" + n2 + "]: " + windowManagerConfig.editorAreaConstraints[n2]);
            }
        }
        stringBuffer.append("\n--         editorAreaBounds: " + windowManagerConfig.editorAreaBounds);
        stringBuffer.append("\n-- editorAreaRelativeBounds: " + windowManagerConfig.editorAreaRelativeBounds);
        stringBuffer.append("\n--     screenSize: " + windowManagerConfig.screenSize);
        stringBuffer.append("\n--    activeModeName: " + windowManagerConfig.activeModeName);
        stringBuffer.append("\n-- maximizedModeName: " + windowManagerConfig.maximizedModeName);
        stringBuffer.append("\n--     toolbarconfig: " + windowManagerConfig.toolbarConfiguration);
        stringBuffer.append("\n-- modes: " + windowManagerConfig.modes + " size " + (windowManagerConfig.modes == null ? -1 : windowManagerConfig.modes.length));
        for (n2 = 0; n2 < windowManagerConfig.modes.length; ++n2) {
            object2 = windowManagerConfig.modes[n2];
            stringBuffer.append("\n-- --");
            stringBuffer.append("\n-- -- mode[" + n2 + "]: " + ((ModeConfig)object2).name);
            stringBuffer.append("\n-- -- state: " + ((ModeConfig)object2).state + " " + (((ModeConfig)object2).state == 0 ? "joined" : "separated"));
            if (((ModeConfig)object2).constraints != null) {
                for (n = 0; n < ((ModeConfig)object2).constraints.length; ++n) {
                    stringBuffer.append("\n-- -- co[" + n + "]: " + ((ModeConfig)object2).constraints[n]);
                }
            }
            stringBuffer.append("\n-- -- kind: " + ((ModeConfig)object2).kind + " " + (((ModeConfig)object2).kind == 1 ? "editor" : "view"));
            stringBuffer.append("\n-- --         bounds: " + ((ModeConfig)object2).bounds);
            stringBuffer.append("\n-- -- relativeBounds: " + ((ModeConfig)object2).relativeBounds);
            stringBuffer.append("\n-- --          state: " + ((ModeConfig)object2).frameState);
            stringBuffer.append("\n-- -- active-tc: " + ((ModeConfig)object2).selectedTopComponentID);
            stringBuffer.append("\n-- -- permanent: " + ((ModeConfig)object2).permanent);
            if (((ModeConfig)object2).tcRefConfigs == null) continue;
            for (n = 0; n < ((ModeConfig)object2).tcRefConfigs.length; ++n) {
                object = ((ModeConfig)object2).tcRefConfigs[n];
                stringBuffer.append("\n++ ++ ++ tcRef[" + n + "]: " + ((TCRefConfig)object).tc_id);
                stringBuffer.append("\n++ ++ ++   opened: " + ((TCRefConfig)object).opened);
            }
        }
        stringBuffer.append("\n-- groups: " + windowManagerConfig.groups + " size " + (windowManagerConfig.groups == null ? -1 : windowManagerConfig.groups.length));
        for (n2 = 0; n2 < windowManagerConfig.groups.length; ++n2) {
            object2 = windowManagerConfig.groups[n2];
            stringBuffer.append("\n-- --");
            stringBuffer.append("\n-- -- group[" + n2 + "]: " + ((GroupConfig)object2).name);
            if (((GroupConfig)object2).tcGroupConfigs == null) continue;
            for (n = 0; n < ((GroupConfig)object2).tcGroupConfigs.length; ++n) {
                object = ((GroupConfig)object2).tcGroupConfigs[n];
                stringBuffer.append("\n++ ++ ++ tcGroup[" + n + "]: " + ((TCGroupConfig)object).tc_id);
                stringBuffer.append("\n++ ++ ++   open: " + ((TCGroupConfig)object).open);
                stringBuffer.append("\n++ ++ ++  close: " + ((TCGroupConfig)object).close);
            }
        }
        return stringBuffer.toString();
    }

    private static void debugLog(String string) {
        Debug.log(PersistenceHandler.class, string);
    }

    private static Rectangle computeBounds(boolean bl, boolean bl2, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        Rectangle rectangle;
        Rectangle rectangle2;
        if (n3 > 0 && n4 > 0) {
            rectangle2 = new Rectangle(n, n2, n3, n4);
            rectangle = Utilities.getUsableScreenBounds();
            int n5 = rectangle.x + rectangle.width - 20;
            int n6 = rectangle.y + rectangle.height - 20;
            while (rectangle2.x > n5) {
                rectangle2.x = Math.max(rectangle2.x - rectangle.width, rectangle.x);
            }
            while (rectangle2.y > n6) {
                rectangle2.y = Math.max(rectangle2.y - n6, rectangle.y);
            }
        } else if (f3 > 0.0f && f4 > 0.0f) {
            rectangle = Utilities.getUsableScreenBounds();
            rectangle2 = new Rectangle((int)((float)rectangle.width * f), (int)((float)rectangle.height * f2), (int)((float)rectangle.width * f3), (int)((float)rectangle.height * f4));
        } else {
            return null;
        }
        if (bl || bl2) {
            rectangle = Utilities.findCenterBounds((Dimension)new Dimension(rectangle2.width, rectangle2.height));
            if (bl) {
                rectangle2.x = rectangle.x;
            }
            if (bl2) {
                rectangle2.y = rectangle.y;
            }
        }
        return rectangle2;
    }

    static {
        DEBUG = Debug.isLoggable(PersistenceHandler.class);
    }
}

