/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.awt.Rectangle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.persistence.InternalConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.TCRefParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ModeParser {
    public static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Mode Properties 1.0//EN";
    public static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Mode Properties 1.1//EN";
    public static final String INSTANCE_DTD_ID_1_2 = "-//NetBeans//DTD Mode Properties 1.2//EN";
    public static final String INSTANCE_DTD_ID_2_0 = "-//NetBeans//DTD Mode Properties 2.0//EN";
    public static final String INSTANCE_DTD_ID_2_1 = "-//NetBeans//DTD Mode Properties 2.1//EN";
    private static final String EA_ORDER = "WinSys-TCRef-Order";
    private static final char SEP = '/';
    private static final boolean DEBUG = Debug.isLoggable(ModeParser.class);
    private FileObject moduleParentFolder;
    private FileObject localParentFolder;
    private InternalConfig internalConfig;
    private Map tcRefParserMap = new HashMap(19);
    private Map tcRefOrder;
    private String modeName;
    private boolean inModuleFolder;
    private boolean inLocalFolder;
    private Set maskSet;

    public ModeParser(String string, Set set) {
        this.modeName = string;
        this.maskSet = set;
    }

    ModeConfig load() throws IOException {
        ModeConfig modeConfig = new ModeConfig();
        this.readProperties(modeConfig);
        if (modeConfig.kind == 2 && modeConfig.side != null && !modeConfig.permanent) {
            modeConfig.permanent = true;
        }
        this.readTCRefs(modeConfig);
        return modeConfig;
    }

    void save(ModeConfig modeConfig) throws IOException {
        this.writeProperties(modeConfig);
        this.writeTCRefs(modeConfig);
    }

    private void readProperties(ModeConfig modeConfig) throws IOException {
        if (DEBUG) {
            Debug.log(ModeParser.class, "readProperties ENTER mo:" + this.getName());
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        internalConfig.clear();
        propertyHandler.readData(modeConfig, internalConfig);
        if (DEBUG) {
            Debug.log(ModeParser.class, "readProperties LEAVE mo:" + this.getName());
        }
    }

    private void readTCRefs(ModeConfig modeConfig) throws IOException {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        if (DEBUG) {
            Debug.log(ModeParser.class, "readTCRefs ENTER mo:" + this.getName());
        }
        Object object4 = this.tcRefParserMap.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (FileObject[])this.tcRefParserMap.get(object4.next());
            ((TCRefParser)object3).setInModuleFolder(false);
            ((TCRefParser)object3).setInLocalFolder(false);
        }
        if (this.isInModuleFolder() && (object4 = this.moduleParentFolder.getFileObject(this.modeName)) != null) {
            object3 = object4.getChildren();
            for (n2 = 0; n2 < ((FileObject[])object3).length; ++n2) {
                if (object3[n2].isFolder() || !"wstcref".equals(object3[n2].getExt())) continue;
                if (this.tcRefParserMap.containsKey(object3[n2].getName())) {
                    object2 = (TCRefParser)this.tcRefParserMap.get(object3[n2].getName());
                } else {
                    object2 = new TCRefParser(object3[n2].getName());
                    this.tcRefParserMap.put(object3[n2].getName(), object2);
                }
                ((TCRefParser)object2).setInModuleFolder(true);
                ((TCRefParser)object2).setModuleParentFolder((FileObject)object4);
            }
        }
        if (this.isInLocalFolder() && (object4 = this.localParentFolder.getFileObject(this.modeName)) != null) {
            object3 = object4.getChildren();
            for (n2 = 0; n2 < ((FileObject[])object3).length; ++n2) {
                if (object3[n2].isFolder() || !"wstcref".equals(object3[n2].getExt())) continue;
                object2 = (TCRefParser)this.tcRefParserMap.get(object3[n2].getName());
                if (object2 == null) {
                    object2 = new TCRefParser(object3[n2].getName());
                    this.tcRefParserMap.put(object3[n2].getName(), object2);
                }
                ((TCRefParser)object2).setInLocalFolder(true);
                ((TCRefParser)object2).setLocalParentFolder((FileObject)object4);
            }
        }
        this.readOrder();
        object4 = new ArrayList(10);
        object3 = (Map)((HashMap)this.tcRefParserMap).clone();
        if (this.tcRefOrder != null) {
            Object object5;
            TCRefParser[] tCRefParserArray = new TCRefParser[this.tcRefOrder.size()];
            object2 = this.tcRefOrder.entrySet().iterator();
            while (object2.hasNext()) {
                TCRefParser tCRefParser;
                object5 = (Map.Entry)object2.next();
                object = (String)object5.getKey();
                int n3 = (Integer)object5.getValue();
                tCRefParserArray[n3] = tCRefParser = (TCRefParser)object3.remove(object);
            }
            for (int i = 0; i < tCRefParserArray.length; ++i) {
                if (tCRefParserArray[i] == null) continue;
                object4.add(tCRefParserArray[i]);
            }
            object2 = object3.keySet().iterator();
            while (object2.hasNext()) {
                object5 = (TCRefParser)object3.get(object2.next());
                object4.add(object5);
            }
        } else {
            Iterator iterator = object3.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (TCRefParser)object3.get(iterator.next());
                object4.add(object2);
            }
            object4 = this.carefullySort((List)object4);
            if (this.tcRefOrder == null) {
                this.tcRefOrder = new HashMap(19);
            }
            this.tcRefOrder.clear();
            for (int i = 0; i < object4.size(); ++i) {
                object2 = (TCRefParser)object4.get(i);
                this.tcRefOrder.put(((TCRefParser)object2).getName(), new Integer(i));
            }
            this.writeOrder();
        }
        ArrayList<TCRefConfig> arrayList = new ArrayList<TCRefConfig>(object4.size());
        object2 = new ArrayList<Object>(object4.size());
        for (n = 0; n < object4.size(); ++n) {
            TCRefConfig tCRefConfig;
            object = (TCRefParser)object4.get(n);
            if (this.maskSet.contains(((TCRefParser)object).getName()) && ((TCRefParser)object).isInModuleFolder() && !((TCRefParser)object).isInLocalFolder()) {
                object2.add(object);
                continue;
            }
            try {
                tCRefConfig = ((TCRefParser)object).load();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                continue;
            }
            boolean bl = this.acceptTCRef((TCRefParser)object, tCRefConfig);
            if (bl) {
                arrayList.add(tCRefConfig);
                continue;
            }
            object2.add(object);
            this.deleteLocalTCRef(((TCRefParser)object).getName());
        }
        for (n = 0; n < object2.size(); ++n) {
            object = (TCRefParser)object2.get(n);
            object4.remove(object);
            this.tcRefParserMap.remove(((TCRefParser)object).getName());
        }
        if (object2.size() > 0) {
            if (this.tcRefOrder == null) {
                this.tcRefOrder = new HashMap(19);
            }
            this.tcRefOrder.clear();
            for (n = 0; n < object4.size(); ++n) {
                object = (TCRefParser)object4.get(n);
                this.tcRefOrder.put(((TCRefParser)object).getName(), new Integer(n));
            }
            this.writeOrder();
        }
        modeConfig.tcRefConfigs = arrayList.toArray(new TCRefConfig[arrayList.size()]);
        PersistenceManager persistenceManager = PersistenceManager.getDefault();
        for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
            persistenceManager.addUsedTCId(modeConfig.tcRefConfigs[i].tc_id);
        }
        if (DEBUG) {
            Debug.log(ModeParser.class, "readTCRefs LEAVE mo:" + this.getName());
        }
    }

    private boolean acceptTCRef(TCRefParser tCRefParser, TCRefConfig tCRefConfig) {
        InternalConfig internalConfig = tCRefParser.getInternalConfig();
        if (internalConfig.moduleCodeNameBase != null) {
            ModuleInfo moduleInfo = PersistenceManager.findModule(internalConfig.moduleCodeNameBase, internalConfig.moduleCodeNameRelease, internalConfig.moduleSpecificationVersion);
            if (moduleInfo == null) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(1, "Cannot find module '" + internalConfig.moduleCodeNameBase + " " + internalConfig.moduleCodeNameRelease + " " + internalConfig.moduleSpecificationVersion + "' for tcref with id '" + tCRefConfig.tc_id + "'");
            }
            return moduleInfo != null && moduleInfo.isEnabled();
        }
        return true;
    }

    private void writeProperties(ModeConfig modeConfig) throws IOException {
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeProperties ENTER mo:" + this.getName());
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        propertyHandler.writeData(modeConfig, internalConfig);
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeProperties LEAVE mo:" + this.getName());
        }
    }

    private void writeTCRefs(ModeConfig modeConfig) throws IOException {
        int n;
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeTCRefs ENTER mo:" + this.getName());
        }
        if (modeConfig.tcRefConfigs.length > 0) {
            if (this.tcRefOrder == null) {
                this.tcRefOrder = new HashMap(19);
            }
            this.tcRefOrder.clear();
            for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
                this.tcRefOrder.put(modeConfig.tcRefConfigs[i].tc_id, new Integer(i));
            }
        } else {
            this.tcRefOrder = null;
        }
        this.writeOrder();
        HashMap<String, TCRefConfig> hashMap = new HashMap<String, TCRefConfig>(19);
        for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
            hashMap.put(modeConfig.tcRefConfigs[i].tc_id, modeConfig.tcRefConfigs[i]);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        Iterator iterator = this.tcRefParserMap.keySet().iterator();
        while (iterator.hasNext()) {
            TCRefParser tCRefParser = (TCRefParser)this.tcRefParserMap.get(iterator.next());
            if (hashMap.containsKey(tCRefParser.getName())) continue;
            arrayList.add(tCRefParser.getName());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.tcRefParserMap.remove(arrayList.get(n));
            this.deleteLocalTCRef((String)arrayList.get(n));
        }
        for (n = 0; n < modeConfig.tcRefConfigs.length; ++n) {
            if (this.tcRefParserMap.containsKey(modeConfig.tcRefConfigs[n].tc_id)) continue;
            TCRefParser tCRefParser = new TCRefParser(modeConfig.tcRefConfigs[n].tc_id);
            this.tcRefParserMap.put(modeConfig.tcRefConfigs[n].tc_id, tCRefParser);
        }
        FileObject fileObject = this.localParentFolder.getFileObject(this.getName());
        if (fileObject == null && this.tcRefParserMap.size() > 0) {
            fileObject = FileUtil.createFolder((FileObject)this.localParentFolder, (String)this.getName());
        }
        Iterator iterator2 = this.tcRefParserMap.keySet().iterator();
        while (iterator2.hasNext()) {
            TCRefParser tCRefParser = (TCRefParser)this.tcRefParserMap.get(iterator2.next());
            tCRefParser.setLocalParentFolder(fileObject);
            tCRefParser.setInLocalFolder(true);
            tCRefParser.save((TCRefConfig)hashMap.get(tCRefParser.getName()));
        }
        if (DEBUG) {
            Debug.log(ModeParser.class, "writeTCRefs LEAVE mo:" + this.getName());
        }
    }

    private void deleteLocalTCRef(String string) {
        if (DEBUG) {
            Debug.log(ModeParser.class, "deleteLocalTCRef tcRefName:" + string);
        }
        if (this.localParentFolder == null) {
            return;
        }
        FileObject fileObject = this.localParentFolder.getFileObject(this.modeName);
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject(string, "wstcref");
        if (fileObject2 != null) {
            PersistenceManager.deleteOneFO(fileObject2);
        }
    }

    private void readOrder() {
        FileObject fileObject;
        if (this.localParentFolder == null) {
            this.localParentFolder = PersistenceManager.getDefault().getModesLocalFolder();
        }
        if ((fileObject = this.localParentFolder.getFileObject(this.modeName)) == null) {
            this.tcRefOrder = null;
            return;
        }
        Object object = fileObject.getAttribute(EA_ORDER);
        if (object == null) {
            this.tcRefOrder = null;
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(19);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                hashMap.put(string2, new Integer(n));
                ++n;
            }
            this.tcRefOrder = hashMap;
            return;
        }
        this.tcRefOrder = null;
    }

    private void writeOrder() throws IOException {
        FileObject fileObject;
        if (this.localParentFolder == null) {
            this.localParentFolder = PersistenceManager.getDefault().getModesLocalFolder();
        }
        if ((fileObject = this.localParentFolder.getFileObject(this.modeName)) == null) {
            fileObject = FileUtil.createFolder((FileObject)this.localParentFolder, (String)this.modeName);
        }
        if (this.tcRefOrder == null) {
            fileObject.setAttribute(EA_ORDER, null);
        } else {
            Object object;
            Iterator iterator = this.tcRefOrder.entrySet().iterator();
            String[] stringArray = new String[this.tcRefOrder.size()];
            while (iterator.hasNext()) {
                object = iterator.next();
                String string = (String)object.getKey();
                int n = (Integer)object.getValue();
                stringArray[n] = string;
            }
            object = new StringBuffer(255);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append('/');
                }
                ((StringBuffer)object).append(stringArray[i]);
            }
            fileObject.setAttribute(EA_ORDER, (Object)((StringBuffer)object).toString());
        }
    }

    private Set readPartials() {
        HashSet<String> hashSet = new HashSet<String>(19);
        if (this.moduleParentFolder == null) {
            return hashSet;
        }
        FileObject fileObject = this.moduleParentFolder.getFileObject(this.modeName);
        if (fileObject == null) {
            return hashSet;
        }
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (string.indexOf(47) == -1 || !((object = fileObject.getAttribute(string)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            int n = string.indexOf(47);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int n2 = string2.indexOf(46);
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
            if ((n2 = string3.indexOf(46)) != -1) {
                string3 = string3.substring(0, n2);
            }
            string = string2 + '/' + string3;
            hashSet.add(string);
        }
        return hashSet;
    }

    private Map getOrderingConstraints(List list) {
        String string;
        Object object;
        Set set = this.readPartials();
        if (set.isEmpty()) {
            return null;
        }
        if (this.tcRefOrder != null) {
            object = set.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                int n = string2.indexOf(47);
                string = string2.substring(0, n);
                String string3 = string2.substring(n + 1);
                if (!this.tcRefOrder.containsKey(string) || !this.tcRefOrder.containsKey(string3)) continue;
                object.remove();
            }
        }
        object = new HashMap(19);
        for (int i = 0; i < list.size(); ++i) {
            TCRefParser tCRefParser = (TCRefParser)list.get(i);
            object.put(tCRefParser.getName(), tCRefParser);
        }
        HashMap<TCRefParser, LinkedList<TCRefParser>> hashMap = new HashMap<TCRefParser, LinkedList<TCRefParser>>(19);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TCRefParser tCRefParser;
            TCRefParser tCRefParser2;
            string = (String)iterator.next();
            int n = string.indexOf(47);
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1);
            if (this.tcRefOrder != null && this.tcRefOrder.containsKey(string4) && this.tcRefOrder.containsKey(string5) || (tCRefParser2 = (TCRefParser)object.get(string4)) == null || (tCRefParser = (TCRefParser)object.get(string5)) == null) continue;
            LinkedList<TCRefParser> linkedList = (LinkedList<TCRefParser>)hashMap.get(tCRefParser2);
            if (linkedList == null) {
                linkedList = new LinkedList<TCRefParser>();
                hashMap.put(tCRefParser2, linkedList);
            }
            linkedList.add(tCRefParser);
        }
        return hashMap;
    }

    private List carefullySort(List list) {
        Map map = this.getOrderingConstraints(list);
        if (map == null) {
            return list;
        }
        try {
            return Utilities.topologicalSort((Collection)list, (Map)map);
        }
        catch (TopologicalSortException topologicalSortException) {
            List list2 = topologicalSortException.partialSort();
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.log(16, "Note: Mode " + this.getName() + " cannot be consistently sorted due to ordering conflicts.");
            errorManager.notify(1, (Throwable)topologicalSortException);
            errorManager.log(16, "Using partial sort: " + list2);
            return list2;
        }
    }

    void removeTCRef(String string) {
        int n;
        Object object;
        if (DEBUG) {
            Debug.log(ModeParser.class, "removeTCRef ENTER tcRef:" + string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        Map map = (Map)((HashMap)this.tcRefParserMap).clone();
        this.tcRefParserMap.remove(string);
        TCRefParser[] tCRefParserArray = new TCRefParser[this.tcRefOrder.size()];
        Iterator iterator = this.tcRefOrder.entrySet().iterator();
        while (iterator.hasNext()) {
            TCRefParser tCRefParser;
            object = iterator.next();
            String string2 = (String)object.getKey();
            int n2 = (Integer)object.getValue();
            tCRefParserArray[n2] = tCRefParser = (TCRefParser)map.remove(string2);
        }
        for (int i = 0; i < tCRefParserArray.length; ++i) {
            arrayList.add(tCRefParserArray[i]);
        }
        Iterator iterator2 = map.keySet().iterator();
        while (iterator2.hasNext()) {
            object = (TCRefParser)map.get(iterator2.next());
            arrayList.add(object);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (TCRefParser)arrayList.get(n);
            if (!string.equals(((TCRefParser)object).getName())) continue;
            arrayList.remove(n);
            break;
        }
        this.tcRefOrder.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            object = (TCRefParser)arrayList.get(n);
            this.tcRefOrder.put(((TCRefParser)object).getName(), new Integer(n));
        }
        try {
            this.writeOrder();
        }
        catch (IOException iOException) {
            object = ErrorManager.getDefault();
            object.log(16, "[WinSys.ModeParser.removeTCRef] Warning: Cannot write order of mode: " + this.getName());
            object.notify(1, (Throwable)iOException);
        }
        this.deleteLocalTCRef(string);
        if (DEBUG) {
            Debug.log(ModeParser.class, "removeTCRef LEAVE tcRef:" + string);
        }
    }

    TCRefConfig addTCRef(String string, List list) {
        ErrorManager errorManager;
        Object object;
        TCRefParser tCRefParser;
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRef ENTER mo:" + this.getName() + " tcRef:" + string);
        }
        if ((tCRefParser = (TCRefParser)this.tcRefParserMap.get(string)) != null) {
            ErrorManager.getDefault().log(16, "[WinSys.ModeParser.addTCRef] Warning: ModeParser " + this.getName() + ". TCRefParser " + string + " exists but it should not.");
            this.tcRefParserMap.remove(string);
        }
        tCRefParser = new TCRefParser(string);
        FileObject fileObject = this.moduleParentFolder.getFileObject(this.modeName);
        tCRefParser.setModuleParentFolder(fileObject);
        tCRefParser.setInModuleFolder(true);
        this.tcRefParserMap.put(string, tCRefParser);
        TCRefConfig tCRefConfig = null;
        try {
            tCRefConfig = tCRefParser.load();
        }
        catch (IOException iOException) {
            object = ErrorManager.getDefault();
            object.log(16, "[WinSys.ModeParser.addTCRef] Warning: ModeParser " + this.getName() + ". Cannot load tcRef " + string);
            object.notify(1, (Throwable)iOException);
        }
        List<TCRefParser> list2 = new ArrayList<TCRefParser>(10);
        object = (Map)((HashMap)this.tcRefParserMap).clone();
        TCRefParser[] tCRefParserArray = new TCRefParser[this.tcRefOrder.size()];
        Iterator iterator = this.tcRefOrder.entrySet().iterator();
        while (iterator.hasNext()) {
            errorManager = iterator.next();
            String string2 = (String)errorManager.getKey();
            int n = (Integer)errorManager.getValue();
            tCRefParserArray[n] = tCRefParser = (TCRefParser)object.remove(string2);
        }
        for (int i = 0; i < tCRefParserArray.length; ++i) {
            list2.add(tCRefParserArray[i]);
        }
        Iterator iterator2 = object.keySet().iterator();
        while (iterator2.hasNext()) {
            tCRefParser = (TCRefParser)object.get(iterator2.next());
            list2.add(tCRefParser);
        }
        list2 = this.carefullySort(list2);
        this.tcRefOrder.clear();
        for (int i = 0; i < list2.size(); ++i) {
            tCRefParser = (TCRefParser)list2.get(i);
            this.tcRefOrder.put(tCRefParser.getName(), new Integer(i));
        }
        try {
            this.writeOrder();
        }
        catch (IOException iOException) {
            errorManager = ErrorManager.getDefault();
            errorManager.log(16, "[WinSys.ModeParser.addTCRef] Warning: Cannot write order of mode: " + this.getName());
            errorManager.notify(1, (Throwable)iOException);
        }
        list.clear();
        for (int i = 0; i < list2.size(); ++i) {
            tCRefParser = (TCRefParser)list2.get(i);
            list.add(tCRefParser.getName());
        }
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRef LEAVE mo:" + this.getName() + " tcRef:" + string);
        }
        return tCRefConfig;
    }

    void addTCRefImport(String string, InternalConfig internalConfig) {
        TCRefParser tCRefParser;
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRefImport ENTER mo:" + this.getName() + " tcRef:" + string);
        }
        if ((tCRefParser = (TCRefParser)this.tcRefParserMap.get(string)) != null) {
            ErrorManager.getDefault().log(16, "[WinSys.ModeParser.addTCRef] Warning: ModeParser " + this.getName() + ". TCRefParser " + string + " exists but it should not.");
            this.tcRefParserMap.remove(string);
        }
        tCRefParser = new TCRefParser(string);
        FileObject fileObject = this.localParentFolder.getFileObject(this.modeName);
        tCRefParser.setLocalParentFolder(fileObject);
        tCRefParser.setInternalConfig(internalConfig);
        this.tcRefParserMap.put(string, tCRefParser);
        if (DEBUG) {
            Debug.log(ModeParser.class, "addTCRefImport LEAVE mo:" + this.getName() + " tcRef:" + string);
        }
    }

    TCRefParser findTCRefParser(String string) {
        return (TCRefParser)this.tcRefParserMap.get(string);
    }

    InternalConfig getInternalConfig() {
        if (this.internalConfig == null) {
            this.internalConfig = new InternalConfig();
        }
        return this.internalConfig;
    }

    void setModuleParentFolder(FileObject fileObject) {
        this.moduleParentFolder = fileObject;
    }

    void setLocalParentFolder(FileObject fileObject) {
        this.localParentFolder = fileObject;
    }

    String getName() {
        return this.modeName;
    }

    boolean isInModuleFolder() {
        return this.inModuleFolder;
    }

    void setInModuleFolder(boolean bl) {
        this.inModuleFolder = bl;
    }

    boolean isInLocalFolder() {
        return this.inLocalFolder;
    }

    void setInLocalFolder(boolean bl) {
        this.inLocalFolder = bl;
    }

    private final class PropertyHandler
    extends DefaultHandler {
        private ModeConfig modeConfig = null;
        private InternalConfig internalConfig = null;
        private List itemList = new ArrayList(10);
        private final Object RW_LOCK = new Object();

        private FileObject getConfigFOInput() {
            FileObject fileObject = ModeParser.this.isInLocalFolder() ? ModeParser.this.localParentFolder.getFileObject(ModeParser.this.getName(), "wsmode") : (ModeParser.this.isInModuleFolder() ? ModeParser.this.moduleParentFolder.getFileObject(ModeParser.this.getName(), "wsmode") : null);
            return fileObject;
        }

        private FileObject getConfigFOOutput() throws IOException {
            FileObject fileObject = ModeParser.this.localParentFolder.getFileObject(ModeParser.this.getName(), "wsmode");
            if (fileObject != null) {
                return fileObject;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ModeParser.this.getName());
            stringBuffer.append('.');
            stringBuffer.append("wsmode");
            fileObject = FileUtil.createData((FileObject)ModeParser.this.localParentFolder, (String)stringBuffer.toString());
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        void readData(ModeConfig modeConfig, InternalConfig internalConfig) throws IOException {
            block13: {
                this.modeConfig = modeConfig;
                this.internalConfig = internalConfig;
                this.itemList.clear();
                FileObject fileObject = this.getConfigFOInput();
                if (fileObject == null) {
                    throw new FileNotFoundException("[WinSys] Missing Mode configuration file:" + ModeParser.this.getName());
                }
                InputStream inputStream = null;
                Object object = this.RW_LOCK;
                synchronized (object) {
                    inputStream = fileObject.getInputStream();
                    PersistenceManager.getDefault().getXMLParser(this).parse(new InputSource(inputStream));
                }
                Object var9_9 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block13;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                break block13;
                {
                    catch (SAXException sAXException) {
                        String string = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$persistence$ModeParser == null ? (class$org$netbeans$core$windows$persistence$ModeParser = ModeParser.class$("org.netbeans.core.windows.persistence.ModeParser")) : class$org$netbeans$core$windows$persistence$ModeParser), (String)"EXC_ModeParse", (Object)fileObject);
                        IOException iOException = new IOException(string);
                        ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)sAXException);
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    throw throwable;
                }
            }
            this.modeConfig.constraints = this.itemList.toArray(new SplitConstraint[this.itemList.size()]);
            modeConfig = this.modeConfig;
            internalConfig = this.internalConfig;
            this.modeConfig = null;
            this.internalConfig = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("mode".equals(string3)) {
                this.handleMode(attributes);
            } else if (this.internalConfig.specVersion != null && this.internalConfig.specVersion.compareTo((Object)new SpecificationVersion("2.0")) >= 0) {
                if ("module".equals(string3)) {
                    this.handleModule(attributes);
                } else if ("name".equals(string3)) {
                    this.handleName(attributes);
                } else if ("kind".equals(string3)) {
                    this.handleKind(attributes);
                } else if ("slidingSide".equals(string3)) {
                    this.handleSlidingSide(attributes);
                } else if ("state".equals(string3)) {
                    this.handleState(attributes);
                } else if ("constraints".equals(string3)) {
                    this.handleConstraints(attributes);
                } else if ("path".equals(string3)) {
                    this.handlePath(attributes);
                } else if ("bounds".equals(string3)) {
                    this.handleBounds(attributes);
                } else if ("relative-bounds".equals(string3)) {
                    this.handleRelativeBounds(attributes);
                } else if ("frame".equals(string3)) {
                    this.handleFrame(attributes);
                } else if ("active-tc".equals(string3)) {
                    this.handleActiveTC(attributes);
                } else if ("empty-behavior".equals(string3)) {
                    this.handleEmptyBehavior(attributes);
                }
            } else if (DEBUG) {
                Debug.log(class$org$netbeans$core$windows$persistence$ModeParser == null ? (class$org$netbeans$core$windows$persistence$ModeParser = ModeParser.class$("org.netbeans.core.windows.persistence.ModeParser")) : class$org$netbeans$core$windows$persistence$ModeParser, "-- ModeParser.startElement PARSING OLD");
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private void handleMode(Attributes attributes) {
            String string = attributes.getValue("version");
            if (string != null) {
                this.internalConfig.specVersion = new SpecificationVersion(string);
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleMode] Warning: Missing attribute \"version\" of element \"mode\".");
                this.internalConfig.specVersion = new SpecificationVersion("2.0");
            }
        }

        private void handleModule(Attributes attributes) {
            String string = attributes.getValue("name");
            this.internalConfig.moduleCodeNameBase = null;
            this.internalConfig.moduleCodeNameRelease = null;
            this.internalConfig.moduleSpecificationVersion = null;
            if (string != null) {
                int n = string.indexOf(47);
                if (n != -1) {
                    this.internalConfig.moduleCodeNameBase = string.substring(0, n);
                    this.internalConfig.moduleCodeNameRelease = string.substring(n + 1);
                    this.checkReleaseCode(this.internalConfig);
                } else {
                    this.internalConfig.moduleCodeNameBase = string;
                }
                this.internalConfig.moduleSpecificationVersion = attributes.getValue("spec");
            }
        }

        private void checkReleaseCode(InternalConfig internalConfig) {
            if ("null".equals(internalConfig.moduleCodeNameRelease)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Module release code was saved as null string for module " + internalConfig.moduleCodeNameBase + "! Repairing."));
                internalConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleName(Attributes attributes) throws SAXException {
            String string = attributes.getValue("unique");
            if (string != null) {
                this.modeConfig.name = string;
                if (!string.equals(ModeParser.this.getName())) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleName] Error: Value of attribute \"unique\" of element \"name\" and configuration file name must be the same.");
                    throw new SAXException("Invalid attribute value");
                }
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleName] Error: Missing required attribute \"unique\" of element \"name\".");
                throw new SAXException("Missing required attribute");
            }
        }

        private void handleKind(Attributes attributes) {
            String string = attributes.getValue("type");
            if (string != null) {
                if ("editor".equals(string)) {
                    this.modeConfig.kind = 1;
                } else if ("view".equals(string)) {
                    this.modeConfig.kind = 0;
                } else if ("sliding".equals(string)) {
                    this.modeConfig.kind = 2;
                } else {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleKind] Warning: Invalid value of attribute \"type\".");
                    this.modeConfig.kind = 0;
                }
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleKind] Error: Missing required attribute \"type\" of element \"kind\".");
                this.modeConfig.kind = 0;
            }
        }

        private void handleSlidingSide(Attributes attributes) {
            String string = attributes.getValue("side");
            if (string != null) {
                if ("left".equals(string) || "right".equals(string) || "bottom".equals(string)) {
                    this.modeConfig.side = string;
                } else {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleSlidingSide] Warning: Wrong value \"" + string + "\" of attribute \"side\" for sliding mode");
                    this.modeConfig.side = "left";
                }
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleSlidingSide] Warning: Missing value of attribute \"side\" for sliding mode.");
                this.modeConfig.side = "left";
            }
        }

        private void handleState(Attributes attributes) throws SAXException {
            String string = attributes.getValue("type");
            if (string != null) {
                if ("joined".equals(string)) {
                    this.modeConfig.state = 0;
                } else if ("separated".equals(string)) {
                    this.modeConfig.state = 1;
                } else {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleState] Warning: Invalid value of attribute \"type\" of element \"state\".");
                    this.modeConfig.kind = 0;
                }
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleState] Error: Missing required attribute \"type\" of element \"state\".");
                this.modeConfig.kind = 0;
            }
        }

        private void handleConstraints(Attributes attributes) {
        }

        private void handlePath(Attributes attributes) {
            double d;
            int n;
            int n2;
            String string = attributes.getValue("orientation");
            if ("horizontal".equals(string)) {
                n2 = 1;
            } else if ("vertical".equals(string)) {
                n2 = 0;
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handlePath] Warning: Invalid or missing value of attribute \"orientation\".");
                n2 = 0;
            }
            try {
                string = attributes.getValue("number");
                if (string != null) {
                    n = Integer.parseInt(string);
                } else {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handlePath] Warning: Missing value of attribute \"number\".");
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(1, "[WinSys.ModeParser.handlePath] Warning: Cannot read element \"path\", attribute \"number\"");
                errorManager.notify(1, (Throwable)numberFormatException);
                n = 0;
            }
            try {
                string = attributes.getValue("weight");
                d = string != null ? Double.parseDouble(string) : 0.5;
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(16, "[WinSys.ModeParser.handlePath] Warning: Cannot read element \"path\", attribute \"weight\".");
                errorManager.notify(1, (Throwable)numberFormatException);
                d = 0.5;
            }
            SplitConstraint splitConstraint = new SplitConstraint(n2, n, d);
            this.itemList.add(splitConstraint);
        }

        private void handleBounds(Attributes attributes) {
            try {
                this.modeConfig.bounds = null;
                String string = attributes.getValue("x");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"x\" of element \"bounds\".");
                    return;
                }
                int n = Integer.parseInt(string);
                string = attributes.getValue("y");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"y\" of element \"bounds\".");
                    return;
                }
                int n2 = Integer.parseInt(string);
                string = attributes.getValue("width");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"width\" of element \"bounds\".");
                    return;
                }
                int n3 = Integer.parseInt(string);
                string = attributes.getValue("height");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleBounds] Warning: Missing attribute \"height\" of element \"bounds\".");
                    return;
                }
                int n4 = Integer.parseInt(string);
                this.modeConfig.bounds = new Rectangle(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(16, "[WinSys.ModeParser.handleBounds] Warning: Cannot read element \"bounds\".");
                errorManager.notify(1, (Throwable)numberFormatException);
            }
        }

        private void handleRelativeBounds(Attributes attributes) {
            try {
                this.modeConfig.relativeBounds = null;
                String string = attributes.getValue("x");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"x\" of element \"relative-bounds\".");
                    return;
                }
                int n = Integer.parseInt(string);
                string = attributes.getValue("y");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"y\" of element \"relative-bounds\".");
                    return;
                }
                int n2 = Integer.parseInt(string);
                string = attributes.getValue("width");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"width\" of element \"relative-bounds\".");
                    return;
                }
                int n3 = Integer.parseInt(string);
                string = attributes.getValue("height");
                if (string == null) {
                    ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleRelativeBounds] Warning: Missing attribute \"height\" of element \"relative-bounds\".");
                    return;
                }
                int n4 = Integer.parseInt(string);
                this.modeConfig.relativeBounds = new Rectangle(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(16, "[WinSys.ModeParser.handleRelativeBounds] Warning: Cannot read element \"relative-bounds\".");
                errorManager.notify(1, (Throwable)numberFormatException);
            }
        }

        private void handleFrame(Attributes attributes) {
            String string = attributes.getValue("state");
            if (string != null) {
                try {
                    this.modeConfig.frameState = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.log(16, "[WinSys.ModeParser.handleFrame] Warning: Cannot read attribute \"state\" of element \"frame\".");
                    errorManager.notify(1, (Throwable)numberFormatException);
                    this.modeConfig.frameState = 0;
                }
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleFrame] Warning: Missing value of attribute \"state\" of element \"frame\".");
                this.modeConfig.frameState = 0;
            }
        }

        private void handleActiveTC(Attributes attributes) {
            String string = attributes.getValue("id");
            this.modeConfig.selectedTopComponentID = string != null ? string : "";
        }

        private void handleEmptyBehavior(Attributes attributes) {
            String string = attributes.getValue("permanent");
            if ("true".equals(string)) {
                this.modeConfig.permanent = true;
            } else if ("false".equals(string)) {
                this.modeConfig.permanent = false;
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.ModeParser.handleEmptyBehavior] Warning: Invalid value of attribute \"permanent\".");
                this.modeConfig.permanent = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeData(ModeConfig modeConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = this.fillBuffer(modeConfig, internalConfig);
            Object object = this.RW_LOCK;
            synchronized (object) {
                FileObject fileObject = this.getConfigFOOutput();
                FileLock fileLock = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(stringBuffer.toString());
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    throw throwable;
                }
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        private StringBuffer fillBuffer(ModeConfig modeConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(800);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n").append("<mode version=\"2.1\">\n");
            this.appendModule(internalConfig, stringBuffer);
            this.appendName(modeConfig, stringBuffer);
            this.appendKind(modeConfig, stringBuffer);
            if (modeConfig.kind == 2) {
                this.appendSlidingSide(modeConfig, stringBuffer);
            }
            this.appendState(modeConfig, stringBuffer);
            this.appendConstraints(modeConfig, stringBuffer);
            if (modeConfig.bounds != null) {
                this.appendBounds(modeConfig, stringBuffer);
            } else if (modeConfig.relativeBounds != null) {
                this.appendRelativeBounds(modeConfig, stringBuffer);
            }
            this.appendFrame(modeConfig, stringBuffer);
            this.appendActiveTC(modeConfig, stringBuffer);
            this.appendEmptyBehavior(modeConfig, stringBuffer);
            stringBuffer.append("</mode>\n");
            return stringBuffer;
        }

        private void appendModule(InternalConfig internalConfig, StringBuffer stringBuffer) {
            if (internalConfig == null) {
                return;
            }
            if (internalConfig.moduleCodeNameBase != null) {
                stringBuffer.append("    <module name=\"");
                stringBuffer.append(internalConfig.moduleCodeNameBase);
                if (internalConfig.moduleCodeNameRelease != null) {
                    stringBuffer.append("/").append(internalConfig.moduleCodeNameRelease);
                }
                if (internalConfig.moduleSpecificationVersion != null) {
                    stringBuffer.append("\" spec=\"");
                    stringBuffer.append(internalConfig.moduleSpecificationVersion);
                }
                stringBuffer.append("\" />\n");
            }
        }

        private void appendName(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <name unique=\"");
            stringBuffer.append(modeConfig.name);
            stringBuffer.append("\" />\n");
        }

        private void appendKind(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <kind type=\"");
            if (modeConfig.kind == 1) {
                stringBuffer.append("editor");
            } else if (modeConfig.kind == 0) {
                stringBuffer.append("view");
            } else if (modeConfig.kind == 2) {
                stringBuffer.append("sliding");
            }
            stringBuffer.append("\" />\n");
        }

        private void appendSlidingSide(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <slidingSide side=\"");
            stringBuffer.append(modeConfig.side);
            stringBuffer.append("\" ");
            stringBuffer.append("/>\n");
        }

        private void appendState(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <state type=\"");
            if (modeConfig.state == 0) {
                stringBuffer.append("joined");
            } else if (modeConfig.state == 1) {
                stringBuffer.append("separated");
            }
            stringBuffer.append("\" />\n");
        }

        private void appendConstraints(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.constraints.length == 0) {
                return;
            }
            stringBuffer.append("  <constraints>\n");
            for (int i = 0; i < modeConfig.constraints.length; ++i) {
                SplitConstraint splitConstraint = modeConfig.constraints[i];
                stringBuffer.append("    <path orientation=\"");
                if (splitConstraint.orientation == 1) {
                    stringBuffer.append("horizontal");
                } else {
                    stringBuffer.append("vertical");
                }
                stringBuffer.append("\" number=\"").append(splitConstraint.index).append("\" weight=\"").append(splitConstraint.splitWeight).append("\"/>\n");
            }
            stringBuffer.append("  </constraints>\n");
        }

        private void appendBounds(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.bounds == null) {
                return;
            }
            stringBuffer.append("  <bounds x=\"").append(modeConfig.bounds.x).append("\" y=\"").append(modeConfig.bounds.y).append("\" width=\"").append(modeConfig.bounds.width).append("\" height=\"").append(modeConfig.bounds.height).append("\" />\n");
        }

        private void appendRelativeBounds(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.relativeBounds == null) {
                return;
            }
            stringBuffer.append("  <relative-bounds x=\"").append(modeConfig.relativeBounds.x).append("\" y=\"").append(modeConfig.relativeBounds.y).append("\" width=\"").append(modeConfig.relativeBounds.width).append("\" height=\"").append(modeConfig.relativeBounds.height).append("\" />\n");
        }

        private void appendFrame(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("  <frame state=\"").append(modeConfig.frameState).append("\"/>\n");
        }

        private void appendActiveTC(ModeConfig modeConfig, StringBuffer stringBuffer) {
            if (modeConfig.selectedTopComponentID != null && !"".equals(modeConfig.selectedTopComponentID)) {
                String string = PersistenceManager.escapeTcId4XmlContent(modeConfig.selectedTopComponentID);
                stringBuffer.append("    <active-tc id=\"").append(string).append("\"/>\n");
            }
        }

        private void appendEmptyBehavior(ModeConfig modeConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <empty-behavior permanent=\"").append(modeConfig.permanent).append("\"/>\n");
        }
    }
}

