/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.view.EditorAccessor;
import org.netbeans.core.windows.view.ElementAccessor;
import org.netbeans.core.windows.view.ModeAccessor;
import org.netbeans.core.windows.view.ModeStructureAccessor;
import org.netbeans.core.windows.view.SlidingAccessor;
import org.netbeans.core.windows.view.SplitAccessor;
import org.openide.windows.TopComponent;

final class ModeStructureAccessorImpl
implements ModeStructureAccessor {
    private final ElementAccessor splitRootAccessor;
    private final Set separateModeAccessors;
    private final Set slidingModeAccessors;

    public ModeStructureAccessorImpl(ElementAccessor elementAccessor, Set set, Set set2) {
        this.splitRootAccessor = elementAccessor;
        this.separateModeAccessors = set;
        this.slidingModeAccessors = set2;
    }

    public ElementAccessor getSplitRootAccessor() {
        return this.splitRootAccessor;
    }

    public ModeAccessor[] getSeparateModeAccessors() {
        return this.separateModeAccessors.toArray(new ModeAccessor[0]);
    }

    public SlidingAccessor[] getSlidingModeAccessors() {
        return this.slidingModeAccessors.toArray(new SlidingAccessor[0]);
    }

    public ModeAccessor findModeAccessor(String string) {
        ModeAccessor modeAccessor = ModeStructureAccessorImpl.findModeAccessorOfName(this.splitRootAccessor, string);
        if (modeAccessor != null) {
            return modeAccessor;
        }
        Iterator iterator = this.separateModeAccessors.iterator();
        while (iterator.hasNext()) {
            modeAccessor = (ModeAccessor)iterator.next();
            if (!string.equals(modeAccessor.getName())) continue;
            return modeAccessor;
        }
        iterator = this.slidingModeAccessors.iterator();
        while (iterator.hasNext()) {
            modeAccessor = (ModeAccessor)iterator.next();
            if (!string.equals(modeAccessor.getName())) continue;
            return modeAccessor;
        }
        return null;
    }

    private static ModeAccessor findModeAccessorOfName(ElementAccessor elementAccessor, String string) {
        EditorAccessor editorAccessor;
        ModeAccessor modeAccessor;
        if (elementAccessor instanceof ModeAccessor) {
            ModeAccessor modeAccessor2 = (ModeAccessor)elementAccessor;
            if (string.equals(modeAccessor2.getName())) {
                return modeAccessor2;
            }
        } else if (elementAccessor instanceof SplitAccessor) {
            SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
            ElementAccessor[] elementAccessorArray = splitAccessor.getChildren();
            for (int i = 0; i < elementAccessorArray.length; ++i) {
                ModeAccessor modeAccessor3 = ModeStructureAccessorImpl.findModeAccessorOfName(elementAccessorArray[i], string);
                if (modeAccessor3 == null) continue;
                return modeAccessor3;
            }
        } else if (elementAccessor instanceof EditorAccessor && (modeAccessor = ModeStructureAccessorImpl.findModeAccessorOfName((editorAccessor = (EditorAccessor)elementAccessor).getEditorAreaAccessor(), string)) != null) {
            return modeAccessor;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nModesAccessorImpl hashCode=" + this.hashCode());
        stringBuffer.append("\nSplit modes:\n");
        stringBuffer.append(ModeStructureAccessorImpl.dumpAccessor(this.splitRootAccessor, 0));
        stringBuffer.append("\nSeparate Modes:");
        stringBuffer.append(ModeStructureAccessorImpl.dumpSet(this.separateModeAccessors));
        return stringBuffer.toString();
    }

    private static String dumpAccessor(ElementAccessor elementAccessor, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ModeStructureAccessorImpl.createIndentString(n);
        if (elementAccessor instanceof SplitAccessor) {
            SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
            stringBuffer.append(string + "split=" + splitAccessor);
            ++n;
            ElementAccessor[] elementAccessorArray = splitAccessor.getChildren();
            for (int i = 0; i < elementAccessorArray.length; ++i) {
                stringBuffer.append("\n" + ModeStructureAccessorImpl.dumpAccessor(elementAccessorArray[i], n));
            }
        } else if (elementAccessor instanceof ModeAccessor) {
            stringBuffer.append(string + "mode=" + elementAccessor);
        } else if (elementAccessor instanceof EditorAccessor) {
            stringBuffer.append(string + "editor=" + elementAccessor);
            stringBuffer.append(ModeStructureAccessorImpl.dumpAccessor(((EditorAccessor)elementAccessor).getEditorAreaAccessor(), ++n));
        }
        return stringBuffer.toString();
    }

    private static String createIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String dumpSet(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nmode=" + iterator.next());
        }
        return stringBuffer.toString();
    }

    static final class EditorAccessorImpl
    extends ElementAccessorImpl
    implements EditorAccessor {
        private final ElementAccessor editorAreaAccessor;
        private final double resizeWeight;

        public EditorAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ElementSnapshot elementSnapshot, ElementAccessor elementAccessor, double d) {
            super(modelElement, elementSnapshot);
            this.editorAreaAccessor = elementAccessor;
            this.resizeWeight = d;
        }

        public double getResizeWeight() {
            return this.resizeWeight;
        }

        public ElementAccessor getEditorAreaAccessor() {
            return this.editorAreaAccessor;
        }

        public String toString() {
            return super.toString() + "\n" + this.editorAreaAccessor;
        }
    }

    static final class SlidingAccessorImpl
    extends ModeAccessorImpl
    implements SlidingAccessor {
        private final String side;

        public SlidingAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ModeSnapshot modeSnapshot, String string) {
            super(modelElement, modeSnapshot);
            this.side = string;
        }

        public String getSide() {
            return this.side;
        }

        public boolean originatorEquals(ElementAccessor elementAccessor) {
            if (!super.originatorEquals(elementAccessor)) {
                return false;
            }
            SlidingAccessor slidingAccessor = (SlidingAccessor)elementAccessor;
            return this.getSide() == slidingAccessor.getSide();
        }
    }

    static class ModeAccessorImpl
    extends ElementAccessorImpl
    implements ModeAccessor {
        public ModeAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ModeSnapshot modeSnapshot) {
            super(modelElement, modeSnapshot);
        }

        private ModeStructureSnapshot.ModeSnapshot getModeSnapShot() {
            return (ModeStructureSnapshot.ModeSnapshot)this.getSnapshot();
        }

        public boolean originatorEquals(ElementAccessor elementAccessor) {
            if (!super.originatorEquals(elementAccessor)) {
                return false;
            }
            ModeAccessor modeAccessor = (ModeAccessor)elementAccessor;
            return this.getState() == modeAccessor.getState();
        }

        public ModeImpl getMode() {
            return this.getModeSnapShot().getMode();
        }

        public String getName() {
            return this.getModeSnapShot().getName();
        }

        public int getState() {
            return this.getModeSnapShot().getState();
        }

        public int getKind() {
            return this.getModeSnapShot().getKind();
        }

        public Rectangle getBounds() {
            return this.getModeSnapShot().getBounds();
        }

        public int getFrameState() {
            return this.getModeSnapShot().getFrameState();
        }

        public TopComponent getSelectedTopComponent() {
            return this.getModeSnapShot().getSelectedTopComponent();
        }

        public TopComponent[] getOpenedTopComponents() {
            return this.getModeSnapShot().getOpenedTopComponents();
        }

        public double getResizeWeight() {
            return this.getModeSnapShot().getResizeWeight();
        }

        public String toString() {
            return super.toString() + "[name=" + this.getName() + " ]";
        }
    }

    static final class SplitAccessorImpl
    extends ElementAccessorImpl
    implements SplitAccessor {
        private final int orientation;
        private final double[] splitPositions;
        private final ElementAccessor[] children;
        private final double resizeWeight;

        public SplitAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ElementSnapshot elementSnapshot, int n, double[] dArray, ElementAccessor[] elementAccessorArray, double d) {
            super(modelElement, elementSnapshot);
            this.orientation = n;
            this.splitPositions = dArray;
            this.children = elementAccessorArray;
            this.resizeWeight = d;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public double[] getSplitWeights() {
            return this.splitPositions;
        }

        public ElementAccessor[] getChildren() {
            return this.children;
        }

        public double getResizeWeight() {
            return this.resizeWeight;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("[orientation=" + this.orientation);
            stringBuffer.append(", splitPosition=");
            for (int i = 0; i < this.splitPositions.length; ++i) {
                stringBuffer.append(this.splitPositions[i]);
                if (i >= this.splitPositions.length - 1) continue;
                stringBuffer.append(" : ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    static abstract class ElementAccessorImpl
    implements ElementAccessor {
        private final ModelElement originator;
        private final ModeStructureSnapshot.ElementSnapshot snapshot;

        public ElementAccessorImpl(ModelElement modelElement, ModeStructureSnapshot.ElementSnapshot elementSnapshot) {
            this.originator = modelElement;
            this.snapshot = elementSnapshot;
        }

        public final ModelElement getOriginator() {
            return this.originator;
        }

        public final ModeStructureSnapshot.ElementSnapshot getSnapshot() {
            return this.snapshot;
        }

        public boolean originatorEquals(ElementAccessor elementAccessor) {
            if (elementAccessor instanceof ElementAccessorImpl) {
                return this.getClass().equals(elementAccessor.getClass()) && ((ElementAccessorImpl)elementAccessor).originator == this.originator;
            }
            return false;
        }

        public String toString() {
            return super.toString() + "[originatorHash=" + (this.originator != null ? Integer.toHexString(this.originator.hashCode()) : "null") + "]";
        }
    }
}

