/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.EditorAccessor;
import org.netbeans.core.windows.view.EditorView;
import org.netbeans.core.windows.view.ElementAccessor;
import org.netbeans.core.windows.view.ModeAccessor;
import org.netbeans.core.windows.view.ModeStructureAccessor;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.SlidingAccessor;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.SplitAccessor;
import org.netbeans.core.windows.view.SplitView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.WindowSystemAccessor;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.DesktopImpl;
import org.netbeans.core.windows.view.ui.EditorAreaFrame;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.openide.windows.TopComponent;

final class ViewHierarchy {
    private final Controller controller;
    private final WindowDnDManager windowDnDManager;
    private DesktopImpl desktop = new DesktopImpl();
    private final Map separateModeViews = new HashMap(10);
    private final Map slidingModeViews = new HashMap(10);
    private EditorAreaFrame editorAreaFrame;
    private ModeView activeModeView;
    private ModeView maximizedModeView;
    private ViewElement currentSplitRoot;
    private ModeView lastNonSlidingActive;
    private final Map accessor2view = new HashMap(10);
    private final Map view2accessor = new HashMap(10);
    private MainWindow mainWindow;
    private final MainWindowListener mainWindowListener;

    public ViewHierarchy(Controller controller, WindowDnDManager windowDnDManager) {
        this.controller = controller;
        this.windowDnDManager = windowDnDManager;
        this.mainWindowListener = new MainWindowListener(controller, this);
    }

    public boolean isDragInProgress() {
        return this.windowDnDManager.isDragging();
    }

    public MainWindow getMainWindow() {
        if (this.mainWindow == null) {
            this.mainWindow = new MainWindow();
        }
        return this.mainWindow;
    }

    public void installMainWindowListeners() {
        this.mainWindow.addComponentListener(this.mainWindowListener);
        this.mainWindow.addWindowStateListener(this.mainWindowListener);
    }

    public void uninstallMainWindowListeners() {
        this.mainWindow.removeComponentListener(this.mainWindowListener);
        this.mainWindow.removeWindowStateListener(this.mainWindowListener);
    }

    public void updateViewHierarchy(ModeStructureAccessor modeStructureAccessor) {
        this.updateAccessors(modeStructureAccessor);
        this.currentSplitRoot = this.updateViewForAccessor(modeStructureAccessor.getSplitRootAccessor());
        if (this.desktop.getSplitRoot() == null) {
            this.setSplitRootIntoDesktop(this.currentSplitRoot);
        }
        this.updateSeparateViews(modeStructureAccessor.getSeparateModeAccessors());
        this.updateSlidingViews(modeStructureAccessor.getSlidingModeAccessors());
    }

    public void updateAccessors(ModeStructureAccessor modeStructureAccessor) {
        HashMap hashMap = new HashMap(this.accessor2view);
        this.accessor2view.clear();
        this.view2accessor.clear();
        Set set = this.getAllAccessorsForTree(modeStructureAccessor.getSplitRootAccessor());
        set.addAll(Arrays.asList(modeStructureAccessor.getSeparateModeAccessors()));
        set.addAll(Arrays.asList(modeStructureAccessor.getSlidingModeAccessors()));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementAccessor elementAccessor = (ElementAccessor)iterator.next();
            ElementAccessor elementAccessor2 = this.findSimilarAccessor(elementAccessor, hashMap);
            if (elementAccessor2 == null) continue;
            Object v = hashMap.get(elementAccessor2);
            this.accessor2view.put(elementAccessor, v);
            this.view2accessor.put(v, elementAccessor);
        }
    }

    private Set getAllAccessorsForTree(ElementAccessor elementAccessor) {
        HashSet<ElementAccessor> hashSet = new HashSet<ElementAccessor>();
        if (elementAccessor instanceof ModeAccessor) {
            hashSet.add(elementAccessor);
        } else if (elementAccessor instanceof SplitAccessor) {
            SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
            hashSet.add(splitAccessor);
            ElementAccessor[] elementAccessorArray = splitAccessor.getChildren();
            for (int i = 0; i < elementAccessorArray.length; ++i) {
                hashSet.addAll(this.getAllAccessorsForTree(elementAccessorArray[i]));
            }
        } else if (elementAccessor instanceof EditorAccessor) {
            EditorAccessor editorAccessor = (EditorAccessor)elementAccessor;
            hashSet.add(editorAccessor);
            hashSet.addAll(this.getAllAccessorsForTree(editorAccessor.getEditorAreaAccessor()));
        }
        return hashSet;
    }

    private ElementAccessor findSimilarAccessor(ElementAccessor elementAccessor, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ElementAccessor elementAccessor2 = (ElementAccessor)iterator.next();
            if (!elementAccessor.originatorEquals(elementAccessor2)) continue;
            return elementAccessor2;
        }
        return null;
    }

    private ViewElement updateViewForAccessor(ElementAccessor elementAccessor) {
        if (elementAccessor == null) {
            return null;
        }
        ViewElement viewElement = (ViewElement)this.accessor2view.get(elementAccessor);
        if (viewElement != null) {
            if (elementAccessor instanceof SplitAccessor) {
                SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
                ElementAccessor[] elementAccessorArray = splitAccessor.getChildren();
                ArrayList<ViewElement> arrayList = new ArrayList<ViewElement>(elementAccessorArray.length);
                for (int i = 0; i < elementAccessorArray.length; ++i) {
                    arrayList.add(this.updateViewForAccessor(elementAccessorArray[i]));
                }
                double[] dArray = splitAccessor.getSplitWeights();
                ArrayList<Double> arrayList2 = new ArrayList<Double>(dArray.length);
                for (int i = 0; i < dArray.length; ++i) {
                    arrayList2.add(new Double(dArray[i]));
                }
                SplitView splitView = (SplitView)viewElement;
                splitView.setOrientation(splitAccessor.getOrientation());
                splitView.setSplitWeights(arrayList2);
                splitView.setChildren(arrayList);
                return splitView;
            }
            if (elementAccessor instanceof EditorAccessor) {
                EditorAccessor editorAccessor = (EditorAccessor)elementAccessor;
                EditorView editorView = (EditorView)viewElement;
                editorView.setEditorArea(this.updateViewForAccessor(editorAccessor.getEditorAreaAccessor()));
                return editorView;
            }
            if (elementAccessor instanceof SlidingAccessor) {
                SlidingAccessor slidingAccessor = (SlidingAccessor)elementAccessor;
                SlidingView slidingView = (SlidingView)viewElement;
                slidingView.setTopComponents(slidingAccessor.getOpenedTopComponents(), slidingAccessor.getSelectedTopComponent());
                slidingView.setSlideBounds(slidingAccessor.getBounds());
                return slidingView;
            }
            if (elementAccessor instanceof ModeAccessor) {
                ModeAccessor modeAccessor = (ModeAccessor)elementAccessor;
                ModeView modeView = (ModeView)viewElement;
                modeView.setTopComponents(modeAccessor.getOpenedTopComponents(), modeAccessor.getSelectedTopComponent());
                if (modeAccessor.getState() == 1) {
                    modeView.setFrameState(modeAccessor.getFrameState());
                }
                return modeView;
            }
        } else {
            if (elementAccessor instanceof SplitAccessor) {
                SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
                ArrayList<Double> arrayList = new ArrayList<Double>(splitAccessor.getSplitWeights().length);
                for (int i = 0; i < splitAccessor.getSplitWeights().length; ++i) {
                    arrayList.add(new Double(splitAccessor.getSplitWeights()[i]));
                }
                ArrayList<ViewElement> arrayList3 = new ArrayList<ViewElement>(splitAccessor.getChildren().length);
                for (int i = 0; i < splitAccessor.getChildren().length; ++i) {
                    arrayList3.add(this.updateViewForAccessor(splitAccessor.getChildren()[i]));
                }
                SplitView splitView = new SplitView(this.controller, splitAccessor.getResizeWeight(), splitAccessor.getOrientation(), arrayList, arrayList3);
                this.accessor2view.put(elementAccessor, splitView);
                this.view2accessor.put(splitView, elementAccessor);
                return splitView;
            }
            if (elementAccessor instanceof SlidingAccessor) {
                SlidingAccessor slidingAccessor = (SlidingAccessor)elementAccessor;
                SlidingView slidingView = new SlidingView(this.controller, this.windowDnDManager, slidingAccessor.getOpenedTopComponents(), slidingAccessor.getSelectedTopComponent(), slidingAccessor.getSide());
                slidingView.setSlideBounds(slidingAccessor.getBounds());
                this.accessor2view.put(elementAccessor, slidingView);
                this.view2accessor.put(slidingView, elementAccessor);
                return slidingView;
            }
            if (elementAccessor instanceof ModeAccessor) {
                ModeAccessor modeAccessor = (ModeAccessor)elementAccessor;
                ModeView modeView = modeAccessor.getState() == 0 ? new ModeView(this.controller, this.windowDnDManager, modeAccessor.getResizeWeight(), modeAccessor.getKind(), modeAccessor.getOpenedTopComponents(), modeAccessor.getSelectedTopComponent()) : new ModeView(this.controller, this.windowDnDManager, modeAccessor.getBounds(), modeAccessor.getFrameState(), modeAccessor.getOpenedTopComponents(), modeAccessor.getSelectedTopComponent());
                this.accessor2view.put(elementAccessor, modeView);
                this.view2accessor.put(modeView, elementAccessor);
                return modeView;
            }
            if (elementAccessor instanceof EditorAccessor) {
                EditorAccessor editorAccessor = (EditorAccessor)elementAccessor;
                EditorView editorView = new EditorView(this.controller, this.windowDnDManager, editorAccessor.getResizeWeight(), this.updateViewForAccessor(editorAccessor.getEditorAreaAccessor()));
                this.accessor2view.put(elementAccessor, editorView);
                this.view2accessor.put(editorView, elementAccessor);
                return editorView;
            }
        }
        throw new IllegalStateException("Unknown accessor type, accessor=" + elementAccessor);
    }

    private void updateSeparateViews(ModeAccessor[] modeAccessorArray) {
        Component component;
        ModeView modeView;
        Iterator iterator;
        HashMap<ModeView, ModeAccessor> hashMap = new HashMap<ModeView, ModeAccessor>();
        for (int i = 0; i < modeAccessorArray.length; ++i) {
            iterator = modeAccessorArray[i];
            modeView = (ModeView)this.updateViewForAccessor((ElementAccessor)((Object)iterator));
            hashMap.put(modeView, (ModeAccessor)((Object)iterator));
        }
        HashSet hashSet = new HashSet(this.separateModeViews.keySet());
        hashSet.removeAll(hashMap.keySet());
        this.separateModeViews.clear();
        this.separateModeViews.putAll(hashMap);
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            modeView = (ModeView)iterator.next();
            component = modeView.getComponent();
            if (!component.isVisible()) continue;
            component.setVisible(false);
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            modeView = (ModeView)iterator.next();
            component = modeView.getComponent();
            if (component.isVisible()) continue;
            component.setVisible(true);
        }
    }

    private void updateSlidingViews(SlidingAccessor[] slidingAccessorArray) {
        SlidingView slidingView;
        Object object;
        HashMap<SlidingView, SlidingAccessor> hashMap = new HashMap<SlidingView, SlidingAccessor>();
        for (int i = 0; i < slidingAccessorArray.length; ++i) {
            object = slidingAccessorArray[i];
            slidingView = (SlidingView)this.updateViewForAccessor((ElementAccessor)object);
            hashMap.put(slidingView, (SlidingAccessor)object);
        }
        HashSet hashSet = new HashSet(this.slidingModeViews.keySet());
        hashSet.removeAll(hashMap.keySet());
        object = new HashSet(hashMap.keySet());
        object.removeAll(this.slidingModeViews.keySet());
        this.slidingModeViews.clear();
        this.slidingModeViews.putAll(hashMap);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            slidingView = (SlidingView)iterator.next();
            this.desktop.removeSlidingView(slidingView);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            slidingView = (SlidingView)iterator.next();
            this.desktop.addSlidingView(slidingView);
        }
    }

    public ModeView getModeViewForAccessor(ModeAccessor modeAccessor) {
        return (ModeView)this.accessor2view.get(modeAccessor);
    }

    public ElementAccessor getAccessorForView(ViewElement viewElement) {
        return (ElementAccessor)this.view2accessor.get(viewElement);
    }

    public void activateMode(ModeAccessor modeAccessor) {
        ModeView modeView = this.getModeViewForAccessor(modeAccessor);
        this.activateModeView(modeView);
    }

    private void activateModeView(ModeView modeView) {
        this.setActiveModeView(modeView);
        if (modeView != null) {
            modeView.focusSelectedTopComponent();
            if (!(modeView instanceof SlidingView)) {
                this.lastNonSlidingActive = modeView;
            }
        }
    }

    private void setActiveModeView(ModeView modeView) {
        if (modeView == this.activeModeView && this.activeModeView != null && this.activeModeView.isActive()) {
            return;
        }
        if (this.activeModeView != null && modeView != this.activeModeView) {
            this.activeModeView.setActive(false);
        }
        this.activeModeView = modeView;
        if (this.activeModeView != null) {
            this.activeModeView.setActive(true);
        }
    }

    public ModeView getActiveModeView() {
        return this.activeModeView;
    }

    ModeView getLastNonSlidingActiveModeView() {
        return this.lastNonSlidingActive;
    }

    public void setMaximizedModeView(ModeView modeView) {
        if (modeView == this.maximizedModeView) {
            return;
        }
        this.maximizedModeView = modeView;
    }

    public ModeView getMaximizedModeView() {
        return this.maximizedModeView;
    }

    public void removeModeView(ModeView modeView) {
        if (!this.view2accessor.containsKey(modeView)) {
            return;
        }
        Object v = this.view2accessor.remove(modeView);
        this.accessor2view.remove(v);
        if (this.separateModeViews.keySet().contains(modeView)) {
            this.separateModeViews.keySet().remove(modeView);
            modeView.getComponent().setVisible(false);
            return;
        }
        this.setSplitRootIntoDesktop((SplitView)this.removeModeViewFromElement(this.desktop.getSplitRoot(), modeView));
    }

    public Set getModeComponents() {
        HashSet<Component> hashSet = new HashSet<Component>();
        Iterator iterator = this.view2accessor.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof ModeView)) continue;
            ModeView modeView = (ModeView)k;
            hashSet.add(modeView.getComponent());
        }
        return hashSet;
    }

    public Component getSlidingModeComponent(String string) {
        Iterator iterator = this.slidingModeViews.keySet().iterator();
        while (iterator.hasNext()) {
            SlidingView slidingView = (SlidingView)iterator.next();
            if (!slidingView.getSide().equals(string)) continue;
            return slidingView.getComponent();
        }
        return null;
    }

    public Set getSeparateModeFrames() {
        HashSet<Component> hashSet = new HashSet<Component>();
        Iterator iterator = this.separateModeViews.keySet().iterator();
        while (iterator.hasNext()) {
            ModeView modeView = (ModeView)iterator.next();
            hashSet.add(modeView.getComponent());
        }
        if (this.editorAreaFrame != null) {
            hashSet.add(this.editorAreaFrame);
        }
        return hashSet;
    }

    private ViewElement removeModeViewFromElement(ViewElement viewElement, ModeView modeView) {
        if (viewElement == modeView) {
            return null;
        }
        if (viewElement instanceof SplitView) {
            SplitView splitView = (SplitView)viewElement;
            List list = splitView.getChildren();
            ArrayList<ViewElement> arrayList = new ArrayList<ViewElement>(list.size());
            ViewElement viewElement2 = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ViewElement viewElement3 = (ViewElement)iterator.next();
                ViewElement viewElement4 = this.removeModeViewFromElement(viewElement3, modeView);
                if (viewElement4 != viewElement3) {
                    viewElement2 = viewElement3;
                }
                if (null == viewElement4) continue;
                arrayList.add(viewElement4);
            }
            if (arrayList.size() == 0) {
                return (ViewElement)arrayList.get(0);
            }
            if (null != viewElement2) {
                splitView.remove(viewElement2);
            }
            splitView.setChildren(arrayList);
            return splitView;
        }
        if (viewElement instanceof EditorView) {
            EditorView editorView = (EditorView)viewElement;
            editorView.setEditorArea(this.removeModeViewFromElement(editorView.getEditorArea(), modeView));
            return editorView;
        }
        return viewElement;
    }

    private Component getDesktopComponent() {
        return this.currentSplitRoot == null ? null : this.desktop.getDesktopComponent();
    }

    public ViewElement getSplitRootElement() {
        return this.currentSplitRoot;
    }

    public void releaseAll() {
        this.setSplitRootIntoDesktop(null);
        this.separateModeViews.clear();
        this.activeModeView = null;
        this.accessor2view.clear();
    }

    public void setSplitModesVisible(boolean bl) {
        ViewHierarchy.setVisibleModeElement(this.desktop.getSplitRoot(), bl);
    }

    private static void setVisibleModeElement(ViewElement viewElement, boolean bl) {
        if (viewElement instanceof ModeView) {
            viewElement.getComponent().setVisible(bl);
        } else if (viewElement instanceof SplitView) {
            SplitView splitView = (SplitView)viewElement;
            List list = splitView.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ViewElement viewElement2 = (ViewElement)iterator.next();
                ViewHierarchy.setVisibleModeElement(viewElement2, bl);
            }
        } else if (viewElement instanceof EditorView) {
            ViewHierarchy.setVisibleModeElement(((EditorView)viewElement).getEditorArea(), bl);
        }
    }

    public void setSeparateModesVisible(boolean bl) {
        if (this.editorAreaFrame != null && this.editorAreaFrame.isVisible() != bl) {
            this.editorAreaFrame.setVisible(bl);
        }
        Iterator iterator = this.separateModeViews.keySet().iterator();
        while (iterator.hasNext()) {
            ModeView modeView = (ModeView)iterator.next();
            if (modeView.getComponent().isVisible() == bl) continue;
            modeView.getComponent().setVisible(bl);
        }
    }

    public void updateEditorAreaFrameState(int n) {
        if (this.editorAreaFrame != null) {
            this.editorAreaFrame.setExtendedState(n);
        }
    }

    public void updateFrameStates() {
        Iterator iterator = this.separateModeViews.keySet().iterator();
        while (iterator.hasNext()) {
            ModeView modeView = (ModeView)iterator.next();
            modeView.updateFrameState();
        }
    }

    public void updateMainWindowBounds(WindowSystemAccessor windowSystemAccessor) {
        if (windowSystemAccessor.getEditorAreaState() == 0) {
            this.mainWindow.setBounds(windowSystemAccessor.getMainWindowBoundsJoined());
        } else {
            this.setMainWindowDesktop(null);
            this.mainWindow.invalidate();
            this.mainWindow.setBounds(windowSystemAccessor.getMainWindowBoundsSeparated());
        }
        this.mainWindow.validate();
    }

    public void setProjectName(String string) {
        this.mainWindow.setProjectName(string);
    }

    private void setMaximizedViewIntoDesktop(ViewElement viewElement) {
        boolean bl = viewElement.updateAWTHierarchy(this.desktop.getInnerPaneDimension());
        this.desktop.setMaximizedView(viewElement);
        if (bl) {
            this.desktop.getDesktopComponent().invalidate();
            ((JComponent)this.desktop.getDesktopComponent()).revalidate();
            this.desktop.getDesktopComponent().repaint();
        }
    }

    private void setSplitRootIntoDesktop(ViewElement viewElement) {
        boolean bl = false;
        this.desktop.setSplitRoot(viewElement);
        if (viewElement != null) {
            Dimension dimension = this.desktop.getInnerPaneDimension();
            bl = viewElement.updateAWTHierarchy(dimension);
        }
        if (bl) {
            this.desktop.getDesktopComponent().invalidate();
            ((JComponent)this.desktop.getDesktopComponent()).revalidate();
            this.desktop.getDesktopComponent().repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDesktop(WindowSystemAccessor windowSystemAccessor) {
        List list;
        Component component;
        block12: {
            Class clazz;
            block13: {
                block10: {
                    block11: {
                        component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        list = component != null ? this.getComponentAWTHierarchyChain(component) : Collections.EMPTY_LIST;
                        try {
                            if (windowSystemAccessor.getEditorAreaState() == 0 && this.maximizedModeView != null) {
                                this.setMainWindowDesktop(this.getDesktopComponent());
                                this.setMaximizedViewIntoDesktop(this.maximizedModeView);
                                Object var8_4 = null;
                                if (component == null) return;
                                if (((Object)list).equals(this.getComponentAWTHierarchyChain(component))) return;
                                if (class$java$awt$Window != null) break block10;
                                break block11;
                            }
                            int n = windowSystemAccessor.getEditorAreaState();
                            if (n == 0) {
                                if (this.editorAreaFrame != null) {
                                    this.editorAreaFrame.setVisible(false);
                                    this.editorAreaFrame = null;
                                }
                                this.setMainWindowDesktop(this.getDesktopComponent());
                                this.setSplitRootIntoDesktop(this.getSplitRootElement());
                                break block12;
                            }
                            boolean bl = this.hasEditorAreaVisibleView();
                            if (this.editorAreaFrame == null && bl) {
                                this.editorAreaFrame = this.createEditorAreaFrame();
                                Rectangle rectangle = windowSystemAccessor.getEditorAreaBounds();
                                if (rectangle != null) {
                                    this.editorAreaFrame.setBounds(rectangle);
                                }
                            } else if (this.editorAreaFrame != null && !bl) {
                                this.editorAreaFrame.setVisible(false);
                                this.editorAreaFrame = null;
                            }
                            this.setMainWindowDesktop(null);
                            if (bl) {
                                this.setSplitRootIntoDesktop(this.getSplitRootElement());
                                this.setEditorAreaDesktop(this.getDesktopComponent());
                                this.updateEditorAreaFrameState(windowSystemAccessor.getEditorAreaFrameState());
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var8_6 = null;
                            if (component == null) throw throwable;
                            if (((Object)list).equals(this.getComponentAWTHierarchyChain(component))) throw throwable;
                            if (SwingUtilities.getAncestorOfClass(Window.class, component) == null) throw throwable;
                            component.requestFocus();
                            throw throwable;
                        }
                    }
                    clazz = class$java$awt$Window = ViewHierarchy.class$("java.awt.Window");
                    break block13;
                }
                clazz = class$java$awt$Window;
            }
            if (SwingUtilities.getAncestorOfClass(clazz, component) == null) return;
            component.requestFocus();
            return;
        }
        Object var8_5 = null;
        if (component == null) return;
        if (((Object)list).equals(this.getComponentAWTHierarchyChain(component))) return;
        if (SwingUtilities.getAncestorOfClass(Window.class, component) == null) return;
        component.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateDesktop() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        List list = component != null ? this.getComponentAWTHierarchyChain(component) : Collections.EMPTY_LIST;
        try {
            if (this.mainWindow.hasDesktop()) {
                this.setMainWindowDesktop(this.getDesktopComponent());
                if (this.maximizedModeView != null) {
                    this.setMaximizedViewIntoDesktop(this.maximizedModeView);
                } else {
                    this.setSplitRootIntoDesktop(this.getSplitRootElement());
                }
            } else {
                boolean bl = this.hasEditorAreaVisibleView();
                if (this.editorAreaFrame != null) {
                    if (bl) {
                        this.editorAreaFrame.setDesktop(this.getDesktopComponent());
                    } else {
                        this.editorAreaFrame.setVisible(false);
                        this.editorAreaFrame = null;
                    }
                }
            }
            Object var5_4 = null;
            if (component == null || ((Object)list).equals(this.getComponentAWTHierarchyChain(component))) return;
            if (SwingUtilities.getAncestorOfClass(Window.class, component) == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (component == null || ((Object)list).equals(this.getComponentAWTHierarchyChain(component)) || SwingUtilities.getAncestorOfClass(Window.class, component) == null) throw throwable;
            component.requestFocus();
            throw throwable;
        }
        component.requestFocus();
    }

    public void performSlideIn(SlideOperation slideOperation) {
        this.desktop.performSlideIn(slideOperation, this.getPureEditorAreaBounds());
    }

    public void performSlideOut(SlideOperation slideOperation) {
        this.desktop.performSlideOut(slideOperation, this.getPureEditorAreaBounds());
    }

    public void performSlideIntoDesktop(SlideOperation slideOperation) {
        this.desktop.performSlideIntoDesktop(slideOperation, this.getPureEditorAreaBounds());
    }

    public void performSlideIntoEdge(SlideOperation slideOperation) {
        this.desktop.performSlideIntoEdge(slideOperation, this.getPureEditorAreaBounds());
    }

    public void performSlideResize(SlideOperation slideOperation) {
        this.desktop.performSlideResize(slideOperation);
    }

    private void setMainWindowDesktop(Component component) {
        this.setDesktop(component, true);
    }

    private void setEditorAreaDesktop(Component component) {
        this.setDesktop(component, false);
    }

    private void setDesktop(Component component, boolean bl) {
        if (bl) {
            this.mainWindow.setDesktop(component);
        } else {
            this.editorAreaFrame.setDesktop(component);
        }
    }

    private List getComponentAWTHierarchyChain(Component component) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            arrayList.add(component2);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private boolean hasEditorAreaVisibleView() {
        EditorView editorView = this.findEditorAreaElement();
        return editorView != null ? editorView.getEditorArea() != null : false;
    }

    private EditorAreaFrame createEditorAreaFrame() {
        final EditorAreaFrame editorAreaFrame = new EditorAreaFrame();
        editorAreaFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (editorAreaFrame.getExtendedState() == 6) {
                    return;
                }
                ViewHierarchy.this.controller.userResizedEditorArea(editorAreaFrame.getBounds());
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if (editorAreaFrame.getExtendedState() == 6) {
                    return;
                }
                ViewHierarchy.this.controller.userResizedEditorArea(editorAreaFrame.getBounds());
            }
        });
        editorAreaFrame.setWindowActivationListener(this.controller);
        editorAreaFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ViewHierarchy.this.closeEditorModes();
            }
        });
        editorAreaFrame.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                long l = System.currentTimeMillis();
                if (l > editorAreaFrame.getUserStamp() + 500L && l > editorAreaFrame.getMainWindowStamp() + 1000L) {
                    ViewHierarchy.this.controller.userChangedFrameStateEditorArea(windowEvent.getNewState());
                    long l2 = System.currentTimeMillis();
                    editorAreaFrame.setUserStamp(l2);
                } else {
                    editorAreaFrame.setUserStamp(0L);
                    editorAreaFrame.setMainWindowStamp(0L);
                    editorAreaFrame.setExtendedState(windowEvent.getOldState());
                }
            }
        });
        return editorAreaFrame;
    }

    private void closeEditorModes() {
        this.closeModeForView(this.findEditorAreaElement().getEditorArea());
    }

    private void closeModeForView(ViewElement viewElement) {
        if (viewElement instanceof ModeView) {
            this.controller.userClosingMode((ModeView)viewElement);
        } else if (viewElement instanceof SplitView) {
            SplitView splitView = (SplitView)viewElement;
            List list = splitView.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ViewElement viewElement2 = (ViewElement)iterator.next();
                this.closeModeForView(viewElement2);
            }
        }
    }

    public void updateEditorAreaBounds(Rectangle rectangle) {
        if (this.editorAreaFrame != null) {
            this.editorAreaFrame.setBounds(rectangle);
        }
    }

    public Rectangle getPureEditorAreaBounds() {
        EditorView editorView = this.findEditorAreaElement();
        if (editorView == null) {
            return new Rectangle();
        }
        return editorView.getPureBounds();
    }

    private EditorView findEditorAreaElement() {
        return this.findEditorViewForElement(this.getSplitRootElement());
    }

    private EditorView findEditorViewForElement(ViewElement viewElement) {
        if (viewElement instanceof EditorView) {
            return (EditorView)viewElement;
        }
        if (viewElement instanceof SplitView) {
            SplitView splitView = (SplitView)viewElement;
            List list = splitView.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ViewElement viewElement2 = (ViewElement)iterator.next();
                EditorView editorView = this.findEditorViewForElement(viewElement2);
                if (null == editorView) continue;
                return editorView;
            }
        }
        return null;
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.mainWindow);
        if (this.editorAreaFrame != null) {
            SwingUtilities.updateComponentTreeUI(this.editorAreaFrame);
        }
        Iterator iterator = this.separateModeViews.keySet().iterator();
        while (iterator.hasNext()) {
            ModeView modeView = (ModeView)iterator.next();
            SwingUtilities.updateComponentTreeUI(modeView.getComponent());
        }
    }

    public Set getShowingTopComponents() {
        Object object;
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>();
        Iterator<Object> iterator = this.accessor2view.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof ModeAccessor)) continue;
            hashSet.add(((ModeAccessor)object).getSelectedTopComponent());
        }
        iterator = this.separateModeViews.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof ModeAccessor)) continue;
            hashSet.add(((ModeAccessor)object).getSelectedTopComponent());
        }
        return hashSet;
    }

    public String toString() {
        return this.dumpElement(this.desktop.getSplitRoot(), 0) + "\nseparateViews=" + this.separateModeViews.keySet();
    }

    private String dumpElement(ViewElement viewElement, int n) {
        String string = ViewHierarchy.createIndentString(n);
        StringBuffer stringBuffer = new StringBuffer();
        if (viewElement instanceof ModeView) {
            stringBuffer.append(string + viewElement + "->" + viewElement.getComponent().getClass() + "@" + viewElement.getComponent().hashCode());
        } else if (viewElement instanceof EditorView) {
            stringBuffer.append(string + viewElement);
            stringBuffer.append("\n" + this.dumpElement(((EditorView)viewElement).getEditorArea(), ++n));
        } else if (viewElement instanceof SplitView) {
            stringBuffer.append(string + viewElement + "->" + viewElement.getComponent().getClass() + "@" + viewElement.getComponent().hashCode());
            ++n;
            List list = ((SplitView)viewElement).getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ViewElement viewElement2 = (ViewElement)iterator.next();
                stringBuffer.append("\n" + this.dumpElement(viewElement2, n));
            }
        }
        return stringBuffer.toString();
    }

    private static String createIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    private String dumpAccessors() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.accessor2view.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append("accessor=" + k + "\tview=" + this.accessor2view.get(k) + "\n");
        }
        return stringBuffer.toString();
    }

    private void changeStateOfSeparateViews(boolean bl) {
        long l = System.currentTimeMillis();
        if (this.editorAreaFrame != null) {
            if (bl && l < this.editorAreaFrame.getUserStamp() + 500L) {
                int n = this.editorAreaFrame.getExtendedState() & 0xFFFFFFFE;
                this.controller.userChangedFrameStateEditorArea(n);
                this.editorAreaFrame.setExtendedState(n);
            }
            this.editorAreaFrame.setMainWindowStamp(l);
            this.editorAreaFrame.setVisible(!bl);
        }
        Iterator iterator = this.separateModeViews.keySet().iterator();
        while (iterator.hasNext()) {
            ModeView modeView = (ModeView)iterator.next();
            Component component = modeView.getComponent();
            if (!(component instanceof Frame)) continue;
            Frame frame = (Frame)component;
            if (bl && l < modeView.getUserStamp() + 500L) {
                int n = frame.getExtendedState() & 0xFFFFFFFE;
                this.controller.userChangedFrameStateMode(modeView, n);
                modeView.setFrameState(n);
            }
            modeView.setMainWindowStamp(l);
            frame.setVisible(!bl);
        }
    }

    private static void debugLog(String string) {
        Debug.log(ViewHierarchy.class, string);
    }

    private static class MainWindowListener
    extends ComponentAdapter
    implements WindowStateListener {
        private final Controller controller;
        private final ViewHierarchy hierarchy;

        public MainWindowListener(Controller controller, ViewHierarchy viewHierarchy) {
            this.controller = controller;
            this.hierarchy = viewHierarchy;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.controller.userResizedMainWindow(componentEvent.getComponent().getBounds());
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.controller.userMovedMainWindow(componentEvent.getComponent().getBounds());
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            int n = windowEvent.getOldState();
            int n2 = windowEvent.getNewState();
            this.controller.userChangedFrameStateMainWindow(n2);
            if ((n & 1) == 0 && (n2 & 1) == 1) {
                this.hierarchy.changeStateOfSeparateViews(true);
            } else if ((n & 1) == 1 && (n2 & 1) == 0) {
                this.hierarchy.changeStateOfSeparateViews(false);
            }
        }
    }
}

