/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlidingFx;

class SlideOperationImpl
implements SlideOperation,
ChangeListener {
    private final int type;
    private final Component component;
    private final SlidingFx effect;
    private final boolean requestsActivation;
    private final String side;
    protected Rectangle startBounds;
    protected Rectangle finishBounds;
    private JLayeredPane pane;
    private Integer layer;

    SlideOperationImpl(int n, Component component, int n2, SlidingFx slidingFx, boolean bl) {
        this(n, component, SlideOperationImpl.orientation2Side(n2), slidingFx, bl);
    }

    SlideOperationImpl(int n, Component component, String string, SlidingFx slidingFx, boolean bl) {
        this.type = n;
        this.component = component;
        this.effect = slidingFx;
        this.requestsActivation = bl;
        this.side = string;
    }

    public void run(JLayeredPane jLayeredPane, Integer n) {
        if (this.effect != null && this.effect.shouldOperationWait()) {
            this.pane = jLayeredPane;
            this.layer = n;
            this.effect.setFinishListener(this);
            this.effect.showEffect(jLayeredPane, n, this);
        } else {
            if (this.effect != null) {
                this.effect.showEffect(jLayeredPane, n, this);
            }
            this.performOperation(jLayeredPane, n);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.performOperation(this.pane, this.layer);
        this.pane = null;
        this.layer = null;
    }

    private void performOperation(JLayeredPane jLayeredPane, Integer n) {
        switch (this.type) {
            case 0: {
                this.component.setBounds(this.finishBounds);
                jLayeredPane.add(this.component, n);
                break;
            }
            case 1: {
                jLayeredPane.remove(this.component);
                break;
            }
            case 4: {
                this.component.setBounds(this.finishBounds);
                ((JComponent)this.component).revalidate();
            }
        }
    }

    public void setFinishBounds(Rectangle rectangle) {
        this.finishBounds = rectangle;
    }

    public void setStartBounds(Rectangle rectangle) {
        this.startBounds = rectangle;
    }

    public String getSide() {
        return this.side;
    }

    public Component getComponent() {
        return this.component;
    }

    public Rectangle getFinishBounds() {
        return this.finishBounds;
    }

    public Rectangle getStartBounds() {
        return this.startBounds;
    }

    public boolean requestsActivation() {
        return this.requestsActivation;
    }

    protected static String orientation2Side(int n) {
        String string = "left";
        if (n == 2) {
            string = "left";
        } else if (n == 1) {
            string = "right";
        } else if (n == 3) {
            string = "bottom";
        }
        return string;
    }

    public int getType() {
        return this.type;
    }

    public void prepareEffect() {
        if (this.effect != null) {
            this.effect.prepareEffect(this);
        }
    }
}

