/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.services.ToolbarFolderNode;
import org.netbeans.core.windows.view.ui.toolbars.ActionsTree;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;

public class ConfigureToolbarPanel
extends JPanel
implements Runnable {
    private static WeakReference dialogRef;
    private Node root;
    private boolean firstTimeInit = true;
    private JButton btnNewToolbar;
    private JCheckBox checkSmallIcons;
    private JLabel lblHint;
    private JPanel palettePanel;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private ConfigureToolbarPanel() {
        this.initComponents();
        this.setCursor(Cursor.getPredefinedCursor(3));
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Actions");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        this.root = new FolderActionNode((Node)new AbstractNode(dataFolder.createNodeChildren((DataFilter)new ActionIconDataFilter())));
        JLabel jLabel = new JLabel(ConfigureToolbarPanel.getBundleString("LBL_PleaseWait"));
        jLabel.setHorizontalAlignment(0);
        this.palettePanel.setPreferredSize(new Dimension(440, 350));
        this.palettePanel.add(jLabel);
        this.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_ToolbarCustomizer"));
    }

    public void run() {
        ActionsTree actionsTree = new ActionsTree(this.root);
        actionsTree.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_ActionsTree"));
        actionsTree.getAccessibleContext().setAccessibleName(ConfigureToolbarPanel.getBundleString("ACSN_ActionsTree"));
        this.palettePanel.removeAll();
        this.palettePanel.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane jScrollPane = new JScrollPane(actionsTree);
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleName(ConfigureToolbarPanel.getBundleString("ACSN_ActionsScrollBar"));
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_ActionsScrollBar"));
        this.palettePanel.add((Component)jScrollPane, "Center");
        this.lblHint.setLabelFor(actionsTree);
        this.invalidate();
        this.validate();
        this.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static void showConfigureDialog() {
        Dialog dialog = null;
        if (dialogRef != null) {
            dialog = (JDialog)dialogRef.get();
        }
        if (dialog == null) {
            JButton jButton = new JButton();
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigureToolbarPanel.endToolbarEditMode();
                }
            });
            jButton.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_Close"));
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)ConfigureToolbarPanel.getBundleString("CTL_Close"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new ConfigureToolbarPanel(), ConfigureToolbarPanel.getBundleString("CustomizerTitle"), false, new Object[]{jButton}, (Object)jButton, 0, null, null);
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialogRef = new WeakReference<JDialog>((JDialog)dialog);
        }
        dialog.setVisible(true);
        ConfigureToolbarPanel.startToolbarEditMode();
    }

    static void startToolbarEditMode() {
        ToolbarPool.getDefault().putClientProperty((Object)"editMode", new Object());
    }

    static void endToolbarEditMode() {
        ToolbarPool.getDefault().putClientProperty((Object)"editMode", null);
        DataFolder dataFolder = ToolbarPool.getDefault().getFolder();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            final DataFolder dataFolder2 = (DataFolder)dataObjectArray[i].getCookie(class$org$openide$loaders$DataFolder == null ? ConfigureToolbarPanel.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (null == dataFolder2 || dataFolder2.getChildren().length != 0) continue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        dataFolder2.delete();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            });
        }
    }

    static final String getBundleString(String string) {
        return NbBundle.getMessage((Class)ConfigureToolbarPanel.class, (String)string);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.firstTimeInit) {
            this.firstTimeInit = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Node[] nodeArray = ConfigureToolbarPanel.this.root.getChildren().getNodes(true);
                    for (int i = 0; i < nodeArray.length; ++i) {
                        nodeArray[i].getChildren().getNodes(true);
                    }
                    SwingUtilities.invokeLater(ConfigureToolbarPanel.this);
                }
            });
        }
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.palettePanel = new JPanel();
        this.checkSmallIcons = new JCheckBox();
        this.btnNewToolbar = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblHint.setText(ConfigureToolbarPanel.getBundleString("CTL_TreeLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 1, 10);
        this.add((Component)this.lblHint, gridBagConstraints);
        this.palettePanel.setLayout(new BorderLayout());
        this.palettePanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 10, 5, 10);
        this.add((Component)this.palettePanel, gridBagConstraints);
        this.checkSmallIcons.setMnemonic(ConfigureToolbarPanel.getBundleString("CTL_SmallIconsMnemonic").charAt(0));
        this.checkSmallIcons.setText(ConfigureToolbarPanel.getBundleString("CTL_SmallIcons"));
        this.checkSmallIcons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkSmallIcons.setMargin(new Insets(0, 0, 0, 0));
        this.checkSmallIcons.setSelected(ToolbarPool.getDefault().getPreferredIconSize() == 16);
        this.checkSmallIcons.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.switchIconSize(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.checkSmallIcons, gridBagConstraints);
        this.checkSmallIcons.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_SmallIcons"));
        this.btnNewToolbar.setMnemonic(ConfigureToolbarPanel.getBundleString("CTL_NewToolbarMnemonic").charAt(0));
        this.btnNewToolbar.setText(ConfigureToolbarPanel.getBundleString("CTL_NewToolbar"));
        this.btnNewToolbar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.this.newToolbar(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.btnNewToolbar, gridBagConstraints);
        this.btnNewToolbar.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_NewToolbar"));
    }

    private void newToolbar(ActionEvent actionEvent) {
        ToolbarFolderNode toolbarFolderNode = new ToolbarFolderNode();
        NewType[] newTypeArray = toolbarFolderNode.getNewTypes();
        if (null != newTypeArray && newTypeArray.length > 0) {
            try {
                newTypeArray[0].create();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void switchIconSize(ActionEvent actionEvent) {
        boolean bl = this.checkSmallIcons.isSelected();
        if (bl) {
            ToolbarPool.getDefault().setPreferredIconSize(16);
        } else {
            ToolbarPool.getDefault().setPreferredIconSize(24);
        }
        String string = ToolbarPool.getDefault().getConfiguration();
        ToolbarConfiguration toolbarConfiguration = ToolbarConfiguration.findConfiguration(string);
        if (toolbarConfiguration != null) {
            toolbarConfiguration.refresh();
        }
    }

    private static class ActionIconDataFilter
    implements DataFilter {
        private InstanceCookie instanceCookie;
        private boolean hasIcon;

        private ActionIconDataFilter() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            this.instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = ConfigureToolbarPanel.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (null != this.instanceCookie) {
                try {
                    Action action;
                    Object object = this.instanceCookie.instanceCreate();
                    if (null != object && (object instanceof Action ? null == (action = (Action)object).getValue("iconBase") : object instanceof JSeparator)) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(1, throwable);
                }
                return true;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject.isFolder()) {
                boolean bl = false;
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    DataObject dataObject2 = null;
                    try {
                        dataObject2 = DataObject.find((FileObject)fileObjectArray[i]);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        continue;
                    }
                    if (null == dataObject2 || !this.acceptDataObject(dataObject2)) continue;
                    bl = true;
                    break;
                }
                return bl;
            }
            return true;
        }
    }

    private static class ItemActionNode
    extends FilterNode {
        private static DataFlavor nodeDataFlavor = new DataFlavor(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = ConfigureToolbarPanel.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node, "Action Node");

        public ItemActionNode(Node node) {
            super(node, FilterNode.Children.LEAF);
        }

        public Transferable drag() throws IOException {
            return new ExTransferable.Single(this, nodeDataFlavor){
                private final /* synthetic */ ItemActionNode this$0;
                {
                    this.this$0 = itemActionNode;
                    super(dataFlavor);
                }

                public Object getData() {
                    return this.this$0;
                }
            };
        }

        public String getDisplayName() {
            return Actions.cutAmpersand((String)super.getDisplayName());
        }
    }

    private static class FolderActionNode
    extends FilterNode {
        public FolderActionNode(Node node) {
            super(node, (Children)new MyChildren(node));
        }

        public String getDisplayName() {
            return Actions.cutAmpersand((String)super.getDisplayName());
        }

        public Transferable drag() throws IOException {
            return Node.EMPTY.drag();
        }

        public Transferable clipboardCut() throws IOException {
            return Node.EMPTY.clipboardCut();
        }

        public Transferable clipboardCopy() throws IOException {
            return Node.EMPTY.clipboardCopy();
        }

        private static class MyChildren
        extends FilterNode.Children {
            public MyChildren(Node node) {
                super(node);
            }

            protected Node copyNode(Node node) {
                DataFolder dataFolder = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ConfigureToolbarPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (null == dataFolder) {
                    return new ItemActionNode(node);
                }
                return new FolderActionNode(node);
            }
        }
    }
}

