/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;

class HTMLAutoCompletion {
    private static int equalsSignInsertedOffset = -1;

    HTMLAutoCompletion() {
    }

    static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (baseDocument.getSyntaxSupport() instanceof ExtSyntaxSupport) {
            if (c == '=') {
                HTMLAutoCompletion.completeQuotes(baseDocument, n, caret, c);
            } else if (c == '\"') {
                HTMLAutoCompletion.handleQuotationMark(baseDocument, n, caret, c);
            } else {
                equalsSignInsertedOffset = -1;
            }
        }
    }

    static void charDeleted(BaseDocument baseDocument, int n, Caret caret, char c) {
        equalsSignInsertedOffset = -1;
    }

    private static void handleQuotationMark(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (equalsSignInsertedOffset != -1) {
            if (n == equalsSignInsertedOffset + "=\"".length()) {
                baseDocument.remove(n, 1);
                caret.setDot(n);
            }
        } else {
            TokenItem tokenItem = ((HTMLSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n - 1, n);
            if (tokenItem != null && tokenItem.getTokenID() == HTMLTokenContext.VALUE && "\"\"".equals(baseDocument.getText(n, 2))) {
                baseDocument.remove(n, 1);
                caret.setDot(n + 1);
            }
        }
        equalsSignInsertedOffset = -1;
    }

    private static void completeQuotes(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        TokenItem tokenItem = ((HTMLSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n - 1, n);
        int n2 = n + 1;
        if (tokenItem != null && tokenItem.getTokenID() == HTMLTokenContext.ARGUMENT) {
            baseDocument.insertString(n2, "\"\"", null);
            caret.setDot(n2 + 1);
            equalsSignInsertedOffset = n;
        }
    }
}

