/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.html.HTMLCompletion;
import org.netbeans.editor.ext.html.HTMLDrawLayerFactory;
import org.netbeans.editor.ext.html.HTMLFormatter;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.html.HTMLAutoCompletion;
import org.netbeans.modules.editor.html.NbReaderProvider;
import org.netbeans.modules.html.editor.folding.HTMLFoldTypes;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HTMLKit
extends NbEditorKit
implements HelpCtx.Provider {
    static final long serialVersionUID = -1381945567613910297L;
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String shiftInsertBreakAction = "shift-insert-break";
    public static final String collapseAllCommentsAction = "collapse-all-comment-folds";
    public static final String expandAllCommentsAction = "expand-all-comment-folds";
    private static boolean setupReadersInitialized = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HTMLKit.class);
    }

    public HTMLKit() {
        if (!setupReadersInitialized) {
            NbReaderProvider.setupReaders();
            setupReadersInitialized = true;
        }
    }

    public String getContentType() {
        return HTML_MIME_TYPE;
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return null;
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.addDocumentListener((DocumentListener)new HTMLDrawLayerFactory.TagParenWatcher());
    }

    public Syntax createSyntax(Document document) {
        return new HTMLSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new HTMLSyntaxSupport(baseDocument);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    public Completion createCompletionForProvider(ExtEditorUI extEditorUI) {
        return new HTMLCompletion(extEditorUI);
    }

    public Formatter createFormatter() {
        return new HTMLFormatter(((Object)((Object)this)).getClass());
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        jEditorPane.setTransferHandler(new HTMLTransferHandler());
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new HTMLDefaultKeyTypedAction(), new HTMLDeleteCharAction("delete-previous", false), new HTMLDeleteCharAction("delete-next", true), new HTMLShiftBreakAction(), new MatchBraceAction("match-brace", false), new MatchBraceAction("selection-match-brace", true), new HTMLGenerateFoldPopupAction(), new CollapseAllCommentsFolds(), new ExpandAllCommentsFolds()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    private static class BasicTransferable
    implements Transferable,
    UIResource {
        protected String plainData;
        protected String htmlData;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        public BasicTransferable(String string, String string2) {
            this.plainData = string;
            this.htmlData = string2;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            int n2 = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int n3 = this.isPlainSupported() ? plainFlavors.length : 0;
            int n4 = this.isPlainSupported() ? stringFlavors.length : 0;
            int n5 = n + n2 + n3 + n4;
            DataFlavor[] dataFlavorArray2 = new DataFlavor[n5];
            int n6 = 0;
            if (n > 0) {
                System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n6, n);
                n6 += n;
            }
            if (n2 > 0) {
                System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n6, n2);
                n6 += n2;
            }
            if (n3 > 0) {
                System.arraycopy(plainFlavors, 0, dataFlavorArray2, n6, n3);
                n6 += n3;
            }
            if (n4 > 0) {
                System.arraycopy(stringFlavors, 0, dataFlavorArray2, n6, n4);
                n6 += n4;
            }
            return dataFlavorArray2;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            if (this.isRicherFlavor(dataFlavor)) {
                return this.getRicherData(dataFlavor);
            }
            if (this.isHTMLFlavor(dataFlavor)) {
                String string = this.getHTMLData();
                string = string == null ? "" : string;
                if ((class$java$lang$String == null ? (class$java$lang$String = HTMLKit.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = HTMLKit.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = HTMLKit.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(string);
                }
            } else if (this.isPlainFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                if ((class$java$lang$String == null ? (class$java$lang$String = HTMLKit.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = HTMLKit.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = HTMLKit.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(string);
                }
            } else if (this.isStringFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                return string;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        protected boolean isRicherFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            for (int i = 0; i < n; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = htmlFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = plainFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = stringFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
            }
        }
    }

    static class HTMLTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;

        HTMLTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            DataFlavor dataFlavor3 = null;
            if (jTextComponent instanceof JEditorPane) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    String string = dataFlavorArray[i].getMimeType();
                    if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) continue;
                    if (dataFlavor == null && string.startsWith("text/plain")) {
                        dataFlavor = dataFlavorArray[i];
                        continue;
                    }
                    if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == (class$java$lang$String == null ? HTMLKit.class$("java.lang.String") : class$java$lang$String)) {
                        dataFlavor2 = dataFlavorArray[i];
                        continue;
                    }
                    if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                    dataFlavor3 = dataFlavorArray[i];
                }
                if (dataFlavor != null) {
                    return dataFlavor;
                }
                if (dataFlavor2 != null) {
                    return dataFlavor2;
                }
                if (dataFlavor3 != null) {
                    return dataFlavor3;
                }
                return null;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                String string = dataFlavorArray[i].getMimeType();
                if (string.startsWith("text/plain")) {
                    return dataFlavorArray[i];
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == (class$java$lang$String == null ? HTMLKit.class$("java.lang.String") : class$java$lang$String)) {
                    dataFlavor2 = dataFlavorArray[i];
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavorArray[i];
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }

        protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
            if (bl) {
                int n = jTextComponent.getSelectionStart();
                int n2 = jTextComponent.getSelectionEnd();
                int n3 = n2 - n;
                EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
                Document document = jTextComponent.getDocument();
                if (n3 > 0) {
                    document.remove(n, n3);
                }
                editorKit.read(reader, document, n);
            } else {
                int n;
                char[] cArray = new char[1024];
                boolean bl2 = false;
                StringBuffer stringBuffer = null;
                while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n);
                    }
                    int n4 = 0;
                    block5: for (int i = 0; i < n; ++i) {
                        switch (cArray[i]) {
                            case '\r': {
                                if (bl2) {
                                    if (i == 0) {
                                        stringBuffer.append('\n');
                                        continue block5;
                                    }
                                    cArray[i - 1] = 10;
                                    continue block5;
                                }
                                bl2 = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!bl2) continue block5;
                                if (i > n4 + 1) {
                                    stringBuffer.append(cArray, n4, i - n4 - 1);
                                }
                                bl2 = false;
                                n4 = i;
                                continue block5;
                            }
                            default: {
                                if (!bl2) continue block5;
                                if (i == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[i - 1] = 10;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (n4 >= n) continue;
                    if (bl2) {
                        if (n4 >= n - 1) continue;
                        stringBuffer.append(cArray, n4, n - n4 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n4, n - n4);
                }
                if (bl2) {
                    stringBuffer.append('\n');
                }
                jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
            }
        }

        public int getSourceActions(JComponent jComponent) {
            int n = 0;
            if (!(jComponent instanceof JPasswordField)) {
                n = ((JTextComponent)jComponent).isEditable() ? 3 : 1;
            }
            return n;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.exportComp = (JTextComponent)jComponent;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new HTMLTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (this.shouldRemove && n == 2) {
                HTMLTransferable hTMLTransferable = (HTMLTransferable)transferable;
                hTMLTransferable.removeText();
            }
            this.exportComp = null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean bl = false;
            DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
            if (dataFlavor != null) {
                try {
                    Object object;
                    boolean bl2 = false;
                    if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                        bl2 = true;
                    }
                    if ((object = jTextComponent.getInputContext()) != null) {
                        ((InputContext)object).endComposition();
                    }
                    Reader reader = dataFlavor.getReaderForText(transferable);
                    this.handleReaderImport(reader, jTextComponent, bl2);
                    bl = true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bl;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
        }

        static class HTMLTransferable
        extends BasicTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            HTMLTransferable(JTextComponent jTextComponent, int n, int n2) {
                super(null, null);
                this.c = jTextComponent;
                Document document = jTextComponent.getDocument();
                try {
                    this.p0 = document.createPosition(n);
                    this.p1 = document.createPosition(n2);
                    this.plainData = jTextComponent.getSelectedText();
                    if (jTextComponent instanceof JEditorPane) {
                        JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                        this.mimeType = jEditorPane.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter stringWriter = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        jEditorPane.getEditorKit().write(stringWriter, document, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith(HTMLKit.HTML_MIME_TYPE)) {
                            this.htmlData = stringWriter.toString();
                        } else {
                            this.richText = stringWriter.toString();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document document = this.c.getDocument();
                        document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return dataFlavorArray;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if ((class$java$lang$String == null ? (class$java$lang$String = HTMLKit.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                    return this.richText;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = HTMLKit.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = HTMLKit.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(this.richText);
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
    }

    public static class CollapseAllCommentsFolds
    extends BaseAction {
        public CollapseAllCommentsFolds() {
            super(HTMLKit.collapseAllCommentsAction);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString(HTMLKit.collapseAllCommentsAction));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString("popup-collapse-all-comment-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, (FoldType)HTMLFoldTypes.COMMENT);
        }
    }

    public static class ExpandAllCommentsFolds
    extends BaseAction {
        public ExpandAllCommentsFolds() {
            super(HTMLKit.expandAllCommentsAction);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString(HTMLKit.expandAllCommentsAction));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString("popup-expand-all-comment-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, (FoldType)HTMLFoldTypes.COMMENT);
        }
    }

    public static class HTMLGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent jTextComponent, JMenu jMenu) {
            this.addAction(jTextComponent, jMenu, HTMLKit.collapseAllCommentsAction);
            this.addAction(jTextComponent, jMenu, HTMLKit.expandAllCommentsAction);
        }
    }

    public static class MatchBraceAction
    extends ExtKit.MatchBraceAction {
        private boolean select;

        public MatchBraceAction(String string, boolean bl) {
            super(string, bl);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                    int n = caret.getDot();
                    ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
                    TokenItem tokenItem = extSyntaxSupport.getTokenChain(n - 1, n);
                    if (tokenItem != null && tokenItem.getTokenContextPath().contains(HTMLTokenContext.contextPath)) {
                        int[] nArray;
                        if (n > 0 && (nArray = extSyntaxSupport.findMatchingBlock(n - 1, false)) != null) {
                            if (this.select) {
                                caret.moveDot(nArray[1]);
                            } else {
                                caret.setDot(nArray[1]);
                            }
                        }
                    } else {
                        super.actionPerformed(actionEvent, jTextComponent);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class HTMLShiftBreakAction
    extends BaseAction {
        static final long serialVersionUID = 4004043376345356061L;

        public HTMLShiftBreakAction() {
            super(HTMLKit.shiftInsertBreakAction, 14);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Completion completion;
            if (jTextComponent != null && (completion = ExtUtilities.getCompletion((JTextComponent)jTextComponent)) != null && completion.isPaneVisible() && !completion.substituteText(true)) {
                completion.refresh(false);
            }
        }
    }

    public static class HTMLDeleteCharAction
    extends BaseKit.DeleteCharAction {
        public HTMLDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            super.charBackspaced(baseDocument, n, caret, c);
            HTMLAutoCompletion.charDeleted(baseDocument, n, caret, c);
        }
    }

    public static class HTMLDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            super.insertString(baseDocument, n, caret, string, bl);
            HTMLAutoCompletion.charInserted(baseDocument, n, caret, string.charAt(0));
        }
    }
}

