/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.folding;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.HTMLSettingsDefaults;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.modules.html.editor.folding.HTMLFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;

public class HTMLFoldManager
implements FoldManager,
SettingsChangeListener {
    private static final boolean SHOW_TIMES;
    private FoldOperation operation;
    private HTMLSyntaxSupport sup;
    private Timer timer;
    private TimerTask timerTask;
    private int foldsUpdateInterval = -1;
    private boolean documentDirty = true;
    private BaseDocument doc = null;
    private static final boolean debug = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.foldsUpdateInterval = this.getSetting("code-folding-update-interval");
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        Document document = this.getOperation().getHierarchy().getComponent().getDocument();
        if (document instanceof BaseDocument) {
            this.doc = (BaseDocument)document;
            this.sup = new HTMLSyntaxSupport(this.getDocument());
            this.timer = new Timer();
            this.restartTimer();
        }
    }

    private BaseDocument getDocument() {
        return this.doc;
    }

    private void restartTimer() {
        this.documentDirty = true;
        if (this.timer == null) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = this.createTimerTask();
        this.timer.schedule(this.timerTask, this.foldsUpdateInterval);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                Thread thread = new Thread(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        try {
                            HTMLFoldManager.access$102(1.access$000(this.this$1), false);
                            HTMLFoldManager.access$200(1.access$000(this.this$1));
                        }
                        catch (ParsingCancelledException parsingCancelledException) {
                            // empty catch block
                        }
                    }
                });
                thread.setPriority(2);
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            static /* synthetic */ HTMLFoldManager access$000(1 var0) {
                return var0.HTMLFoldManager.this;
            }
        };
    }

    public void release() {
        Settings.removeSettingsChangeListener((SettingsChangeListener)this);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
    }

    public void removeDamagedNotify(Fold fold) {
    }

    public void expandNotify(Fold fold) {
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (settingsChangeEvent.getSettingName() == "code-folding-update-interval") {
            this.foldsUpdateInterval = this.getSetting("code-folding-update-interval");
            this.restartTimer();
        }
    }

    private List generateFolds() throws BadLocationException, ParsingCancelledException {
        HTMLSyntaxSupport hTMLSyntaxSupport = (HTMLSyntaxSupport)this.getDocument().getSyntaxSupport();
        Stack<Object> stack = new Stack<Object>();
        ArrayList<FoldInfo> arrayList = new ArrayList<FoldInfo>(100);
        SyntaxElement syntaxElement = hTMLSyntaxSupport.getElementChain(0);
        while (syntaxElement != null) {
            SyntaxElement.Tag tag;
            if (this.documentDirty) {
                throw new ParsingCancelledException();
            }
            if (syntaxElement.getType() == 4) {
                tag = (SyntaxElement.Tag)syntaxElement;
                if (tag.isEmpty()) {
                    arrayList.add(new FoldInfo(syntaxElement.getElementOffset() - 1, syntaxElement.getElementOffset() + syntaxElement.getElementLength(), HTMLFoldTypes.TAG, this.getSingletonTagFoldName(tag.getName())));
                } else {
                    stack.push(syntaxElement);
                }
            } else if (syntaxElement.getType() == 5) {
                tag = (SyntaxElement.Named)syntaxElement;
                if (!stack.isEmpty()) {
                    SyntaxElement syntaxElement2 = (SyntaxElement)stack.peek();
                    if (syntaxElement2.getType() == 4 && ((SyntaxElement.Tag)syntaxElement2).getName().equals(tag.getName())) {
                        arrayList.add(new FoldInfo(syntaxElement2.getElementOffset() - 1, tag.getElementOffset() + tag.getElementLength(), HTMLFoldTypes.TAG, this.getTagFoldName(((SyntaxElement.Tag)syntaxElement2).getName())));
                        stack.pop();
                    } else {
                        ArrayList<SyntaxElement.Tag> arrayList2 = new ArrayList<SyntaxElement.Tag>();
                        boolean bl = false;
                        while (!stack.isEmpty()) {
                            SyntaxElement.Tag tag2 = (SyntaxElement.Tag)stack.pop();
                            arrayList2.add(tag2);
                            if (!tag2.getName().equals(tag.getName())) continue;
                            arrayList.add(new FoldInfo(tag2.getElementOffset() - 1, tag.getElementOffset() + tag.getElementLength(), HTMLFoldTypes.TAG, this.getTagFoldName(tag2.getName())));
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                                stack.push(arrayList2.get(i));
                            }
                        }
                    }
                }
            } else if (syntaxElement.getType() == 0) {
                arrayList.add(new FoldInfo(syntaxElement.getElementOffset(), syntaxElement.getElementOffset() + syntaxElement.getElementLength(), HTMLFoldTypes.COMMENT, "<!--...-->"));
            }
            syntaxElement = this.getNextSyntaxElement(syntaxElement);
        }
        return arrayList;
    }

    private String getSingletonTagFoldName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    private String getTagFoldName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append(">...</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateFolds() throws ParsingCancelledException {
        FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
        long l = System.currentTimeMillis();
        try {
            FoldInfo foldInfo;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            List list = this.generateFolds();
            if (SHOW_TIMES) {
                System.out.println("[html folding] parsing of text of " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - l) + " millis.");
            }
            Iterator iterator = list.iterator();
            HashSet<Object> hashSet = new HashSet<Object>();
            while (iterator.hasNext()) {
                object4 = (FoldInfo)iterator.next();
                if (!this.isOneLineElement((FoldInfo)object4)) continue;
                hashSet.add(object4);
            }
            list.removeAll(hashSet);
            object4 = FoldUtilities.findRecursive((Fold)foldHierarchy.getRootFold());
            if (!$assertionsDisabled && object4 == null) {
                throw new AssertionError((Object)"Existing folds is null!");
            }
            final ArrayList<Object> arrayList = new ArrayList<Object>(list.size() / 2);
            final ArrayList<Object> arrayList2 = new ArrayList<Object>(list.size() / 2);
            Iterator iterator2 = list.iterator();
            Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            while (iterator2.hasNext()) {
                object3 = (FoldInfo)iterator2.next();
                int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)((FoldInfo)object3).startOffset);
                object2 = (FoldInfo)hashtable.get(new Integer(n));
                if (object2 != null && ((FoldInfo)object2).endOffset < ((FoldInfo)object3).endOffset) {
                    arrayList3.add(object2);
                }
                hashtable.put(new Integer(n), object3);
                object = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)((FoldInfo)object3).startOffset);
                if (object != null && object.getStartOffset() == ((FoldInfo)object3).startOffset && object.getEndOffset() == ((FoldInfo)object3).endOffset) {
                    if (((FoldInfo)object3).foldType == object.getType() && ((FoldInfo)object3).description.equals(object.getDescription())) continue;
                    arrayList2.add(object);
                    arrayList.add(object3);
                    continue;
                }
                arrayList.add(object3);
            }
            arrayList.removeAll(arrayList3);
            object4.removeAll(arrayList2);
            object3 = new Hashtable();
            Iterator iterator3 = object4.iterator();
            while (iterator3.hasNext()) {
                object2 = (Fold)iterator3.next();
                object = list.iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    foldInfo = (FoldInfo)object.next();
                    if (object2.getStartOffset() != foldInfo.startOffset || object2.getEndOffset() != foldInfo.endOffset) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    arrayList2.add(object2);
                    continue;
                }
                int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)object2.getStartOffset());
                ((Hashtable)object3).put(new Integer(n), object2);
            }
            object2 = arrayList.iterator();
            object = new ArrayList();
            while (object2.hasNext()) {
                FoldInfo foldInfo2 = (FoldInfo)object2.next();
                foldInfo = (Fold)((Hashtable)object3).get(new Integer(Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo2.startOffset)));
                if (foldInfo == null) continue;
                if (foldInfo.getEndOffset() < foldInfo2.endOffset) {
                    arrayList2.add(foldInfo);
                    continue;
                }
                ((ArrayList)object).add(foldInfo2);
            }
            arrayList.removeAll((Collection<?>)object);
            if (SHOW_TIMES) {
                System.out.println("[html folding] parsing and mangles with elements for " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - l) + " millis.");
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    HTMLFoldManager.this.getDocument().readLock();
                    try {
                        FoldHierarchy foldHierarchy = HTMLFoldManager.this.getOperation().getHierarchy();
                        foldHierarchy.lock();
                        try {
                            FoldHierarchyTransaction foldHierarchyTransaction = HTMLFoldManager.this.getOperation().openTransaction();
                            try {
                                Object object;
                                Iterator iterator = arrayList2.iterator();
                                while (iterator.hasNext()) {
                                    object = (Fold)iterator.next();
                                    if (HTMLFoldManager.this.getDocument().getLength() == 0) break;
                                    HTMLFoldManager.this.getOperation().removeFromHierarchy((Fold)object, foldHierarchyTransaction);
                                }
                                object = arrayList.iterator();
                                while (object.hasNext()) {
                                    FoldInfo foldInfo = (FoldInfo)object.next();
                                    if (HTMLFoldManager.this.getDocument().getLength() == 0) {
                                        break;
                                    }
                                    if (foldInfo.startOffset < 0 || foldInfo.endOffset < 0 || foldInfo.startOffset >= foldInfo.endOffset || foldInfo.endOffset >= HTMLFoldManager.this.getDocument().getLength()) continue;
                                    HTMLFoldManager.this.getOperation().addToHierarchy(foldInfo.foldType, foldInfo.description, false, foldInfo.startOffset, foldInfo.endOffset, 0, 0, null, foldHierarchyTransaction);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                Document document = HTMLFoldManager.this.getOperation().getHierarchy().getComponent().getDocument();
                                if (document.getLength() > 0) {
                                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                                }
                            }
                            finally {
                                foldHierarchyTransaction.commit();
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        HTMLFoldManager.this.getDocument().readUnlock();
                    }
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Document document = this.getOperation().getHierarchy().getComponent().getDocument();
            if (document.getLength() > 0) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
        catch (ParsingCancelledException parsingCancelledException) {
            throw new ParsingCancelledException();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        long l2 = System.currentTimeMillis() - l;
        if (SHOW_TIMES) {
            System.out.println("[html folding] folds for " + this.getDocument().getProperty((Object)"title") + " generated in " + l2 + " millis.");
        }
    }

    private boolean isOneLineElement(FoldInfo foldInfo) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.startOffset) == Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.endOffset);
    }

    private boolean foldsBoundariesEquals(Fold fold, Fold fold2) {
        return fold.getStartOffset() == fold2.getStartOffset() && fold.getEndOffset() == fold2.getEndOffset();
    }

    private SyntaxElement getNextSyntaxElement(SyntaxElement syntaxElement) throws BadLocationException {
        SyntaxElement syntaxElement2 = syntaxElement.getNext();
        if (syntaxElement2 != null && syntaxElement2.getType() == 4 && ((SyntaxElement.Named)syntaxElement2).getName().startsWith("<") && (syntaxElement2 = syntaxElement2.getNext()) == null) {
            return null;
        }
        return syntaxElement2;
    }

    private int getSetting(String string) {
        JTextComponent jTextComponent = this.getOperation().getHierarchy().getComponent();
        return SettingsUtil.getInteger((Class)Utilities.getKitClass((JTextComponent)jTextComponent), (String)string, (Integer)HTMLSettingsDefaults.defaultCodeFoldingUpdateInterval);
    }

    static /* synthetic */ boolean access$102(HTMLFoldManager hTMLFoldManager, boolean bl) {
        hTMLFoldManager.documentDirty = bl;
        return hTMLFoldManager.documentDirty;
    }

    static /* synthetic */ void access$200(HTMLFoldManager hTMLFoldManager) throws ParsingCancelledException {
        hTMLFoldManager.updateFolds();
    }

    static {
        $assertionsDisabled = !HTMLFoldManager.class.desiredAssertionStatus();
        SHOW_TIMES = Boolean.getBoolean("org.netbeans.modules.html.editor.folding.measure");
    }

    private static class ParsingCancelledException
    extends Exception {
    }

    private static class FoldInfo {
        public int startOffset;
        public int endOffset;
        public FoldType foldType = null;
        public String description = null;

        public FoldInfo(int n, int n2, FoldType foldType, String string) {
            this.startOffset = n;
            this.endOffset = n2;
            this.foldType = foldType;
            this.description = string;
        }

        public String toString() {
            return "FI(" + this.description + ", " + this.foldType + ", <" + this.startOffset + "-" + this.endOffset + ">)";
        }
    }
}

