/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.sql.execute.ColumnDef;
import org.netbeans.modules.db.sql.execute.FetchLimitHandler;
import org.netbeans.modules.db.sql.execute.NullValue;

public class ResultSetTableModelSupport {
    static final Map TYPE_TO_DEF = new HashMap();
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Object;

    private static ColumnTypeDef getColumnTypeDef(int n) {
        return (ColumnTypeDef)TYPE_TO_DEF.get(new Integer(n));
    }

    public static List createColumnDefs(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        ArrayList<ColumnDef> arrayList = new ArrayList<ColumnDef>(n);
        for (int i = 1; i <= n; ++i) {
            int n2 = resultSetMetaData.getColumnType(i);
            ColumnTypeDef columnTypeDef = ResultSetTableModelSupport.getColumnTypeDef(n2);
            ColumnDef columnDef = new ColumnDef(resultSetMetaData.getColumnName(i), resultSetMetaData.isWritable(i) && columnTypeDef.isWritable(), columnTypeDef.getColumnClass());
            arrayList.add(columnDef);
        }
        return arrayList;
    }

    public static List retrieveRows(ResultSet resultSet, ResultSetMetaData resultSetMetaData, FetchLimitHandler fetchLimitHandler) throws SQLException, IOException {
        ArrayList arrayList = new ArrayList();
        int n = resultSetMetaData.getColumnCount();
        int n2 = fetchLimitHandler.getFetchLimit();
        while (resultSet.next()) {
            int n3 = arrayList.size();
            if (n2 > 0 && n3 >= n2 && (n2 = fetchLimitHandler.fetchLimitReached(n3)) != 0 && n2 <= n3) break;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int i = 1; i <= n; ++i) {
                Object object = resultSet.getObject(i);
                if (object != null) {
                    int n4 = resultSetMetaData.getColumnType(i);
                    ColumnTypeDef columnTypeDef = ResultSetTableModelSupport.getColumnTypeDef(n4);
                    object = columnTypeDef.getColumnValue(resultSet, i);
                }
                arrayList2.add(object != null ? object : NullValue.getDefault());
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    static {
        GenericWritableColumnDef genericWritableColumnDef = new GenericWritableColumnDef(Boolean.class);
        TYPE_TO_DEF.put(new Integer(16), genericWritableColumnDef);
        TYPE_TO_DEF.put(new Integer(-7), genericWritableColumnDef);
        GenericWritableColumnDef genericWritableColumnDef2 = new GenericWritableColumnDef(Integer.class);
        TYPE_TO_DEF.put(new Integer(-6), genericWritableColumnDef2);
        TYPE_TO_DEF.put(new Integer(5), genericWritableColumnDef2);
        TYPE_TO_DEF.put(new Integer(4), genericWritableColumnDef2);
        GenericWritableColumnDef genericWritableColumnDef3 = new GenericWritableColumnDef(String.class);
        TYPE_TO_DEF.put(new Integer(1), genericWritableColumnDef3);
        TYPE_TO_DEF.put(new Integer(12), genericWritableColumnDef3);
        GenericWritableColumnDef genericWritableColumnDef4 = new GenericWritableColumnDef(Long.class);
        TYPE_TO_DEF.put(new Integer(-5), genericWritableColumnDef4);
        GenericWritableColumnDef genericWritableColumnDef5 = new GenericWritableColumnDef(Double.class);
        TYPE_TO_DEF.put(new Integer(6), genericWritableColumnDef5);
        TYPE_TO_DEF.put(new Integer(8), genericWritableColumnDef5);
        GenericWritableColumnDef genericWritableColumnDef6 = new GenericWritableColumnDef(BigDecimal.class);
        TYPE_TO_DEF.put(new Integer(7), genericWritableColumnDef6);
        TYPE_TO_DEF.put(new Integer(2), genericWritableColumnDef6);
        TYPE_TO_DEF.put(new Integer(3), genericWritableColumnDef6);
        GenericWritableColumnDef genericWritableColumnDef7 = new GenericWritableColumnDef(Date.class);
        TYPE_TO_DEF.put(new Integer(91), genericWritableColumnDef7);
        TYPE_TO_DEF.put(new Integer(92), genericWritableColumnDef7);
        TYPE_TO_DEF.put(new Integer(93), new ColumnTypeDef(){

            public boolean isWritable() {
                return true;
            }

            public Class getColumnClass() {
                return class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ResultSetTableModelSupport.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return resultSet.getTimestamp(n);
            }
        });
        ColumnTypeDef columnTypeDef = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return BinaryColumnValue.forBinaryColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(new Integer(-2), columnTypeDef);
        TYPE_TO_DEF.put(new Integer(-3), columnTypeDef);
        TYPE_TO_DEF.put(new Integer(-4), columnTypeDef);
        ColumnTypeDef columnTypeDef2 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return BinaryColumnValue.forBlobColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(new Integer(2004), columnTypeDef2);
        ColumnTypeDef columnTypeDef3 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return LongVarCharColumnValue.forCharColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(new Integer(-1), columnTypeDef3);
        ColumnTypeDef columnTypeDef4 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
                return LongVarCharColumnValue.forClobColumn(resultSet, n);
            }
        };
        TYPE_TO_DEF.put(new Integer(2005), columnTypeDef4);
        ColumnTypeDef columnTypeDef5 = new ColumnTypeDef(){

            public boolean isWritable() {
                return false;
            }

            public Class getColumnClass() {
                return class$java$lang$Object == null ? (class$java$lang$Object = ResultSetTableModelSupport.class$("java.lang.Object")) : class$java$lang$Object;
            }

            public Object getColumnValue(ResultSet resultSet, int n) throws SQLException {
                return resultSet.getObject(n);
            }
        };
        TYPE_TO_DEF.put(new Integer(0), columnTypeDef5);
        TYPE_TO_DEF.put(new Integer(1111), columnTypeDef5);
        TYPE_TO_DEF.put(new Integer(2000), columnTypeDef5);
        TYPE_TO_DEF.put(new Integer(2001), columnTypeDef5);
        TYPE_TO_DEF.put(new Integer(2002), columnTypeDef5);
        TYPE_TO_DEF.put(new Integer(2003), columnTypeDef5);
        TYPE_TO_DEF.put(new Integer(2006), columnTypeDef5);
        TYPE_TO_DEF.put(new Integer(70), columnTypeDef5);
    }

    private static final class BinaryColumnValue {
        private static final int COUNT = 100;
        private String data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BinaryColumnValue forBinaryColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            InputStream inputStream = resultSet.getBinaryStream(n);
            try {
                BinaryColumnValue binaryColumnValue = new BinaryColumnValue(inputStream);
                return binaryColumnValue;
            }
            finally {
                inputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BinaryColumnValue forBlobColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            Blob blob = resultSet.getBlob(n);
            InputStream inputStream = blob.getBinaryStream();
            try {
                BinaryColumnValue binaryColumnValue = new BinaryColumnValue(inputStream);
                return binaryColumnValue;
            }
            finally {
                inputStream.close();
            }
        }

        private BinaryColumnValue(InputStream inputStream) throws SQLException, IOException {
            byte[] byArray = new byte[100];
            int n = inputStream.read(byArray, 0, byArray.length);
            if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer(2 + 2 * n);
                stringBuffer.append("0x");
                for (int i = 0; i < n; ++i) {
                    int n2 = byArray[i];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    if (n2 < 16) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(Integer.toHexString(n2).toUpperCase());
                }
                if (inputStream.read() != -1) {
                    stringBuffer.append("...");
                }
                this.data = stringBuffer.toString();
            } else {
                this.data = "";
            }
        }

        public String toString() {
            return this.data;
        }
    }

    private static final class LongVarCharColumnValue {
        private static final int COUNT = 100;
        private String data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LongVarCharColumnValue forCharColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            Reader reader = resultSet.getCharacterStream(n);
            try {
                LongVarCharColumnValue longVarCharColumnValue = new LongVarCharColumnValue(reader);
                return longVarCharColumnValue;
            }
            finally {
                reader.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LongVarCharColumnValue forClobColumn(ResultSet resultSet, int n) throws SQLException, IOException {
            Clob clob = resultSet.getClob(n);
            Reader reader = clob.getCharacterStream();
            try {
                LongVarCharColumnValue longVarCharColumnValue = new LongVarCharColumnValue(reader);
                return longVarCharColumnValue;
            }
            finally {
                reader.close();
            }
        }

        private LongVarCharColumnValue(Reader reader) throws SQLException, IOException {
            char[] cArray = new char[100];
            int n = reader.read(cArray, 0, cArray.length);
            if (n >= 0) {
                this.data = new String(cArray, 0, n);
                if (reader.read() != -1) {
                    this.data = this.data + "...";
                }
            } else {
                this.data = "";
            }
        }

        public String toString() {
            return this.data;
        }
    }

    private static final class GenericWritableColumnDef
    implements ColumnTypeDef {
        private Class columnClass;

        public GenericWritableColumnDef(Class clazz) {
            this.columnClass = clazz;
        }

        public boolean isWritable() {
            return true;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }

        public Object getColumnValue(ResultSet resultSet, int n) throws SQLException, IOException {
            return resultSet.getObject(n);
        }
    }

    private static interface ColumnTypeDef {
        public boolean isWritable();

        public Class getColumnClass();

        public Object getColumnValue(ResultSet var1, int var2) throws SQLException, IOException;
    }
}

