/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.openide.ErrorManager;

public final class SQLExecuteHelper {
    private static final ErrorManager LOGGER;
    private static final boolean LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static SQLExecutionResults execute(String[] stringArray, Connection connection) throws SQLException {
        ArrayList<SQLExecutionResult> arrayList = new ArrayList<SQLExecutionResult>();
        for (int i = 0; i < stringArray.length; ++i) {
            Statement statement;
            String string = SQLExecuteHelper.removeComments(stringArray[i]).trim();
            if (LOG) {
                LOGGER.log(1, "Executing: " + string);
            }
            SQLExecutionResult sQLExecutionResult = null;
            String string2 = string.substring(0, Math.min(6, string.length())).toUpperCase();
            if (string2.startsWith("{")) {
                statement = connection.prepareCall(string);
                sQLExecutionResult = statement.execute() ? new SQLExecutionResult(statement, statement.getResultSet()) : new SQLExecutionResult(statement, statement.getUpdateCount());
            } else {
                statement = connection.createStatement();
                sQLExecutionResult = "SELECT".equals(string2) ? new SQLExecutionResult(statement, statement.executeQuery(string)) : new SQLExecutionResult(statement, statement.executeUpdate(string));
            }
            if (!$assertionsDisabled && sQLExecutionResult == null) {
                throw new AssertionError();
            }
            if (LOG) {
                if (sQLExecutionResult.getResultSet() != null) {
                    LOGGER.log(1, "Result: " + sQLExecutionResult.getResultSet());
                } else {
                    LOGGER.log(1, "Result: " + sQLExecutionResult.getRowCount() + " rows affected");
                }
            }
            arrayList.add(sQLExecutionResult);
        }
        SQLExecutionResult[] sQLExecutionResultArray = arrayList.toArray(new SQLExecutionResult[arrayList.size()]);
        return new SQLExecutionResults(sQLExecutionResultArray);
    }

    private static int[] getSupportedResultSetTypeConcurrency(Connection connection) throws SQLException {
        int n;
        int n2;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (!databaseMetaData.supportsResultSetConcurrency(n2 = 1004, n = 1008) && !databaseMetaData.supportsResultSetConcurrency(n2, n = 1007)) {
            n2 = 1003;
        }
        return new int[]{n2, n};
    }

    static String removeComments(String string) {
        return new CommentRemover(string).getResult();
    }

    static {
        $assertionsDisabled = !SQLExecuteHelper.class.desiredAssertionStatus();
        LOGGER = ErrorManager.getDefault().getInstance(SQLExecuteHelper.class.getName());
        LOG = LOGGER.isLoggable(1);
    }

    private static final class CommentRemover {
        private static final int STATE_START = 0;
        private static final int STATE_MAYBE_LINE_COMMENT = 1;
        private static final int STATE_LINE_COMMENT = 2;
        private static final int STATE_MAYBE_BLOCK_COMMENT = 3;
        private static final int STATE_BLOCK_COMMENT = 4;
        private static final int STATE_MAYBE_END_BLOCK_COMMENT = 5;
        private String sql;
        private StringBuffer result = new StringBuffer();
        private int length;
        private int pos = 0;
        private int state = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CommentRemover(String string) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            this.sql = string;
            this.length = string.length();
            this.parse();
        }

        private void parse() {
            block8: while (this.pos < this.length) {
                char c = this.sql.charAt(this.pos);
                switch (this.state) {
                    case 0: {
                        if (c == '-') {
                            this.state = 1;
                        }
                        if (c != '/') break;
                        this.state = 3;
                        break;
                    }
                    case 1: {
                        if (c == '-') {
                            this.state = 2;
                            break;
                        }
                        this.state = 0;
                        this.result.append('-');
                        break;
                    }
                    case 2: {
                        if (c != '\n') break;
                        this.state = 0;
                        ++this.pos;
                        continue block8;
                    }
                    case 3: {
                        if (c == '*') {
                            this.state = 4;
                            break;
                        }
                        this.result.append('/');
                        if (c == '/') break;
                        this.state = 0;
                        break;
                    }
                    case 4: {
                        if (c != '*') break;
                        this.state = 5;
                        break;
                    }
                    case 5: {
                        if (c == '/') {
                            this.state = 0;
                            ++this.pos;
                            continue block8;
                        }
                        if (c == '*') break;
                        this.state = 4;
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                if (this.state == 0) {
                    this.result.append(c);
                }
                ++this.pos;
            }
        }

        public String getResult() {
            return this.result.toString();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$db$sql$execute$SQLExecuteHelper == null ? (class$org$netbeans$modules$db$sql$execute$SQLExecuteHelper = SQLExecuteHelper.class$("org.netbeans.modules.db.sql.execute.SQLExecuteHelper")) : class$org$netbeans$modules$db$sql$execute$SQLExecuteHelper).desiredAssertionStatus();
        }
    }
}

