/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.db.sql.execute.NullValue;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.ui.ResultSetTableModel;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanelModel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

public class SQLResultPanel
extends JPanel {
    private static final String CARD_RESULT_SET = "resultSet";
    private static final String CARD_ROW_COUNT = "rowCount";
    private SQLExecutionResults executionResults;
    private String currentCardName;
    private JMenuItem copyCellValueMenuItem;
    private JMenuItem copyRowValuesMenuItem;
    private JScrollPane resultScrollPane;
    private JPanel resultSetPanel;
    private JTable resultTable;
    private JLabel rowCountLabel;
    private JPanel rowCountPanel;
    private JPopupMenu tablePopupMenu;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Object;

    public SQLResultPanel() {
        this.initComponents();
    }

    public void setModel(SQLResultPanelModel sQLResultPanelModel) {
        ResultSetTableModel resultSetTableModel = null;
        String string = null;
        if (sQLResultPanelModel != null) {
            if (sQLResultPanelModel.getResultSetModel() != null) {
                resultSetTableModel = sQLResultPanelModel.getResultSetModel();
                string = CARD_RESULT_SET;
            } else if (sQLResultPanelModel.getAffectedRows() != null) {
                resultSetTableModel = new ResultSetTableModel.Empty();
                this.rowCountLabel.setText(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"LBL_AffectedRows", (Object)sQLResultPanelModel.getAffectedRows()));
                string = CARD_ROW_COUNT;
            } else {
                resultSetTableModel = new ResultSetTableModel.Empty();
                string = CARD_RESULT_SET;
            }
        } else {
            resultSetTableModel = new ResultSetTableModel.Empty();
            string = CARD_RESULT_SET;
        }
        if (!$assertionsDisabled && resultSetTableModel == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.resultTable.setModel(resultSetTableModel);
        this.showCard(string);
    }

    private void showCard(String string) {
        if (!string.equals(this.currentCardName)) {
            ((CardLayout)this.getLayout()).show(this, string);
        }
        this.currentCardName = string;
    }

    private void setClipboard(String string) {
        ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        StringSelection stringSelection = new StringSelection(string);
        exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
    }

    private void initComponents() {
        this.tablePopupMenu = new JPopupMenu();
        this.copyCellValueMenuItem = new JMenuItem();
        this.copyRowValuesMenuItem = new JMenuItem();
        this.resultSetPanel = new JPanel();
        this.resultScrollPane = new JScrollPane();
        this.resultTable = new SQLResultTable();
        this.rowCountPanel = new JPanel();
        this.rowCountLabel = new JLabel();
        this.copyCellValueMenuItem.setText(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"LBL_CopyCellValue"));
        this.copyCellValueMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLResultPanel.this.copyCellValueMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.copyCellValueMenuItem);
        this.copyCellValueMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"ACSD_CopyCellValue"));
        this.copyRowValuesMenuItem.setText(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"LBL_CopyRowValues"));
        this.copyRowValuesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLResultPanel.this.copyRowValuesMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.copyRowValuesMenuItem);
        this.copyRowValuesMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SQLResultPanel.class, (String)"ACSD_CopyRowValues"));
        this.setLayout(new CardLayout());
        this.resultSetPanel.setLayout(new BorderLayout());
        this.resultScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resultScrollPane.getViewport().setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.resultTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setOpaque(false);
        this.resultTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SQLResultPanel.this.resultTableMouseReleased(mouseEvent);
            }
        });
        this.resultScrollPane.setViewportView(this.resultTable);
        this.resultSetPanel.add((Component)this.resultScrollPane, "Center");
        this.add((Component)this.resultSetPanel, CARD_RESULT_SET);
        this.rowCountPanel.setLayout(new FlowLayout(0, 2, 2));
        this.rowCountPanel.setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.rowCountLabel.setText("jLabel1");
        this.rowCountPanel.add(this.rowCountLabel);
        this.add((Component)this.rowCountPanel, CARD_ROW_COUNT);
    }

    private void copyRowValuesMenuItemActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.resultTable.getSelectedRows();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.resultTable.getColumnCount(); ++j) {
                if (j > 0) {
                    stringBuffer.append('\t');
                }
                Object object = this.resultTable.getValueAt(nArray[i], j);
                stringBuffer.append(object.toString());
            }
            stringBuffer.append('\n');
        }
        this.setClipboard(stringBuffer.toString());
    }

    private void copyCellValueMenuItemActionPerformed(ActionEvent actionEvent) {
        Object object = this.resultTable.getValueAt(this.resultTable.getSelectedRow(), this.resultTable.getSelectedColumn());
        this.setClipboard(object.toString());
    }

    private void resultTableMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 3) {
            return;
        }
        int n = this.resultTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.resultTable.columnAtPoint(mouseEvent.getPoint());
        boolean bl = false;
        int[] nArray = this.resultTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.resultTable.changeSelection(n, n2, false, false);
        }
        this.tablePopupMenu.show(this.resultTable, mouseEvent.getX(), mouseEvent.getY());
    }

    static {
        $assertionsDisabled = !SQLResultPanel.class.desiredAssertionStatus();
    }

    private static final class SQLResultTable
    extends JTable {
        public SQLResultTable() {
            this.setDefaultRenderer(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLResultPanel.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new DateTimeRenderer());
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            Object object = this.getValueAt(n, n2);
            if (object instanceof NullValue) {
                return this.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = SQLResultPanel.class$("java.lang.Object")) : class$java$lang$Object);
            }
            return super.getCellRenderer(n, n2);
        }

        private static final class DateTimeRenderer
        extends DefaultTableCellRenderer.UIResource {
            DateFormat formatter;

            public void setValue(Object object) {
                if (this.formatter == null) {
                    this.formatter = DateFormat.getDateTimeInstance();
                }
                this.setText(object == null ? "" : this.formatter.format(object));
            }
        }
    }
}

