/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.api.sql.SQLExecuteCookie;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanel;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanelModel;
import org.netbeans.modules.db.sql.loader.SQLDataObject;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.TopComponent;

public class SQLEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
SQLExecuteCookie {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(SQLEditorSupport.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static final String EDITOR_CONTAINER = "sqlEditorContainer";
    private static final String MIME_TYPE = "text/x-sql";
    private String encoding;
    private SQLExecutionResults executionResults;
    private RequestProcessor rp = new RequestProcessor("SQLExecution");
    private Task task;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            SQLEditorSupport.this.saveDocument();
        }
    };

    public SQLEditorSupport(SQLDataObject sQLDataObject) {
        super((DataObject)sQLDataObject, (CloneableEditorSupport.Env)new Environment(sQLDataObject));
        this.setMIMEType(MIME_TYPE);
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        if (!this.isConsole()) {
            FileObject fileObject = this.getDataObject().getPrimaryFile();
            SQLDataObject sQLDataObject = (SQLDataObject)this.getDataObject();
            if (sQLDataObject.getCookie(SaveCookie.class) == null) {
                sQLDataObject.addSaveCookie(this.saveCookie);
                sQLDataObject.setModified(true);
            }
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        SQLDataObject sQLDataObject = (SQLDataObject)this.getDataObject();
        Node.Cookie cookie = sQLDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            sQLDataObject.removeSaveCookie(this.saveCookie);
            sQLDataObject.setModified(false);
        }
    }

    protected String messageToolTip() {
        if (this.isConsole()) {
            return this.getDataObject().getPrimaryFile().getName();
        }
        return super.messageToolTip();
    }

    protected String messageName() {
        if (!this.getDataObject().isValid()) {
            return "";
        }
        if (this.isConsole()) {
            return this.getDataObject().getName();
        }
        return super.messageName();
    }

    protected String messageHtmlName() {
        if (!this.getDataObject().isValid()) {
            return "";
        }
        if (this.isConsole()) {
            String string = this.getDataObject().getName();
            if (string != null && !string.startsWith("<html>")) {
                string = "<html>" + string;
            }
            return string;
        }
        return super.messageHtmlName();
    }

    protected void notifyClosed() {
        super.notifyClosed();
        this.closeExecutionResult();
        if (this.isConsole() && this.getDataObject().isValid()) {
            try {
                this.getDataObject().delete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    protected boolean canClose() {
        if (this.isConsole()) {
            return true;
        }
        return super.canClose();
    }

    private boolean isConsole() {
        try {
            return "nbfs".equals(this.getDataObject().getPrimaryFile().getURL().getProtocol());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
    }

    protected Component wrapEditorComponent(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName(EDITOR_CONTAINER);
        jPanel.add(component, "Center");
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSQL(final DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.task != null && !this.task.isFinished()) {
                throw new IllegalStateException("Statements are already being executed.");
            }
            if (LOG) {
                LOGGER.log(1, "Executing against " + databaseConnection);
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().notify((Throwable)interruptedException);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                    return;
                }
            } else {
                ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
            }
            final Connection connection = databaseConnection.getJDBCConnection();
            if (LOG) {
                LOGGER.log(1, "SQL connection: " + connection);
            }
            if (connection == null) {
                return;
            }
            JEditorPane[] jEditorPaneArray = this.getOpenedPanes();
            if (jEditorPaneArray.length <= 0) {
                throw new IllegalStateException("Cannot execute if the DataObject is not open in an editor.");
            }
            final String string = jEditorPaneArray[0].getText();
            this.task = this.rp.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (LOG) {
                        LOGGER.log("Started the SQL execution task");
                    }
                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutingStatements"));
                    progressHandle.start();
                    progressHandle.switchToIndeterminate();
                    StatusDisplayer.getDefault().setStatusText("");
                    if (LOG) {
                        LOGGER.log(1, "Closing the old execution result");
                    }
                    SQLEditorSupport.this.closeExecutionResult();
                    SQLEditorSupport.this.executionResults = null;
                    String string2 = null;
                    SQLResultPanelModel sQLResultPanelModel = null;
                    try {
                        SQLEditorSupport.this.executionResults = SQLExecuteHelper.execute(new String[]{string}, connection);
                        sQLResultPanelModel = new SQLResultPanelModel(SQLEditorSupport.this.executionResults);
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutedSuccessfully"));
                    }
                    catch (SQLException sQLException) {
                        string2 = sQLException.getMessage();
                    }
                    catch (IOException iOException) {
                        string2 = iOException.getMessage();
                    }
                    finally {
                        progressHandle.finish();
                    }
                    if (string2 != null) {
                        SQLEditorSupport.this.showExecuteError(string2);
                        return;
                    }
                    if (sQLResultPanelModel != null) {
                        SQLEditorSupport.this.setResultModelToEditors(sQLResultPanelModel);
                    }
                }
            });
        }
    }

    private void setResultModelToEditors(final SQLResultPanelModel sQLResultPanelModel) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                Enumeration enumeration = SQLEditorSupport.this.allEditors.getComponents();
                while (enumeration.hasMoreElements()) {
                    SQLCloneableEditor sQLCloneableEditor = (SQLCloneableEditor)((Object)enumeration.nextElement());
                    SQLResultPanel sQLResultPanel = sQLCloneableEditor.getResultComponent();
                    if (sQLResultPanel == null) continue;
                    sQLResultPanel.setModel(sQLResultPanelModel);
                }
            }
        });
    }

    private void showExecuteError(String string) {
        String string2 = MessageFormat.format(NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ExecutionErrorMessage"), string);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string2, NbBundle.getMessage((Class)SQLEditorSupport.class, (String)"LBL_ExecutionErrorTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    private void closeExecutionResult() {
        this.setResultModelToEditors(null);
        Runnable runnable = new Runnable(){

            public void run() {
                if (SQLEditorSupport.this.executionResults != null) {
                    try {
                        SQLEditorSupport.this.executionResults.close();
                    }
                    catch (SQLException sQLException) {
                        ErrorManager.getDefault().notify((Throwable)sQLException);
                    }
                    SQLEditorSupport.this.executionResults = null;
                }
            }
        };
        if (this.rp.isRequestProcessorThread()) {
            runnable.run();
        } else {
            this.rp.post(runnable);
        }
    }

    protected CloneableEditor createCloneableEditor() {
        return new SQLCloneableEditor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        this.encoding = SQLEditorSupport.getEncoding(inputStream);
        if (LOG) {
            LOGGER.log(1, "Encoding: " + this.encoding);
        }
        if (this.encoding != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.encoding);
            try {
                editorKit.read(inputStreamReader, (Document)styledDocument, 0);
            }
            finally {
                inputStream.close();
            }
        } else {
            super.loadFromStreamToKit(styledDocument, inputStream, editorKit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        if (this.encoding != null) {
            if ("utf-8".equals(this.encoding)) {
                outputStream.write(239);
                outputStream.write(187);
                outputStream.write(191);
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            try {
                editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
            }
            finally {
                outputStreamWriter.close();
            }
        } else {
            super.saveFromKitToStream(styledDocument, editorKit, outputStream);
        }
    }

    private static String getEncoding(InputStream inputStream) throws IOException {
        boolean bl;
        if (!inputStream.markSupported()) {
            return null;
        }
        inputStream.mark(3);
        boolean bl2 = bl = inputStream.read() == 239 && inputStream.read() == 187 && inputStream.read() == 191;
        if (bl) {
            return "utf-8";
        }
        inputStream.reset();
        return null;
    }

    private static final class DelegateActionMap
    extends ActionMap {
        private ActionMap delegate;
        private JEditorPane editorPane;

        public DelegateActionMap(ActionMap actionMap, JEditorPane jEditorPane) {
            this.delegate = actionMap;
            this.editorPane = jEditorPane;
        }

        public void remove(Object object) {
            super.remove(object);
        }

        public Action get(Object object) {
            boolean bl;
            boolean bl2 = bl = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == this.editorPane;
            if (bl) {
                return this.delegate.get(object);
            }
            return null;
        }

        public void put(Object object, Action action) {
            this.delegate.put(object, action);
        }

        public void setParent(ActionMap actionMap) {
            this.delegate.setParent(actionMap);
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] keys() {
            return this.delegate.keys();
        }

        public ActionMap getParent() {
            return this.delegate.getParent();
        }

        public void clear() {
            this.delegate.clear();
        }

        public Object[] allKeys() {
            return this.delegate.allKeys();
        }
    }

    static final class Environment
    extends DataEditorSupport.Env {
        public static final long serialVersionUID = 7968926994844480435L;
        private transient boolean modified = false;
        private transient FileLock fileLock;

        public Environment(SQLDataObject sQLDataObject) {
            super((DataObject)sQLDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            MultiDataObject multiDataObject = (MultiDataObject)this.getDataObject();
            this.fileLock = multiDataObject.getPrimaryEntry().takeLock();
            return this.fileLock;
        }

        public void markModified() throws IOException {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = true;
            } else {
                super.markModified();
            }
        }

        public void unmarkModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = false;
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
            } else {
                super.unmarkModified();
            }
        }

        public boolean isModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                return this.modified;
            }
            return super.isModified();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.findSQLEditorSupport();
        }

        private SQLEditorSupport findSQLEditorSupport() {
            return (SQLEditorSupport)this.getDataObject().getCookie(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport);
        }
    }

    static class SQLCloneableEditor
    extends CloneableEditor {
        private JPanel container;
        private JSplitPane splitter;
        private SQLResultPanel resultComponent;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SQLCloneableEditor() {
            super(null);
        }

        public SQLCloneableEditor(SQLEditorSupport sQLEditorSupport) {
            super((CloneableEditorSupport)sQLEditorSupport);
        }

        public SQLResultPanel getResultComponent() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (this.resultComponent == null) {
                this.createResultComponent();
            }
            return this.resultComponent;
        }

        private void createResultComponent() {
            JPanel jPanel = this.findContainer((Component)((Object)this));
            if (jPanel == null) {
                return;
            }
            Component component = jPanel.getComponent(0);
            this.resultComponent = new SQLResultPanel();
            this.splitter = new JSplitPane(0, component, this.resultComponent);
            this.splitter.setBorder(null);
            jPanel.removeAll();
            jPanel.add(this.splitter);
            this.splitter.setDividerLocation(250);
            this.splitter.setDividerSize(7);
            this.getActionMap().setParent(new DelegateActionMap(this.getActionMap().getParent(), this.getEditorPane()));
            if (((Object)((Object)this)).equals(TopComponent.getRegistry().getActivated())) {
                this.requestFocusInWindow();
            }
        }

        private JPanel findContainer(Component component) {
            if (!(component instanceof JComponent)) {
                return null;
            }
            Component[] componentArray = ((JComponent)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2 = componentArray[i];
                if (component2 instanceof JPanel && SQLEditorSupport.EDITOR_CONTAINER.equals(component2.getName())) {
                    return (JPanel)component2;
                }
                JPanel jPanel = this.findContainer(component2);
                if (jPanel == null) continue;
                return jPanel;
            }
            return null;
        }

        protected void componentDeactivated() {
            if (((SQLEditorSupport)this.cloneableEditorSupport()).isConsole()) {
                try {
                    this.cloneableEditorSupport().saveDocument();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            super.componentDeactivated();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            if (((SQLEditorSupport)this.cloneableEditorSupport()).isConsole()) {
                try {
                    this.cloneableEditorSupport().saveDocument();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            super.writeExternal(objectOutput);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport).desiredAssertionStatus();
        }
    }
}

