/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private transient Object currentPC;
    private transient Object currentPCLock = new Object();
    private transient boolean currentPCSet = false;
    private JPDAThread currentThread;
    private JPDADebugger currentDebugger;
    private HashMap stackAnnotations = new HashMap();
    private RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private CallStackFrame[] stackToAnnotate;
    private SourcePath sourcePathToAnnotate;

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "currentEngine") {
            this.updateCurrentDebugger();
            this.updateCurrentThread();
            this.annotate();
        } else if (propertyChangeEvent.getPropertyName() == "currentThread") {
            this.updateCurrentThread();
            this.annotate();
        } else if (propertyChangeEvent.getPropertyName() == "currentCallStackFrame") {
            this.updateCurrentThread();
            this.annotate();
        } else if (propertyChangeEvent.getPropertyName() == "state") {
            this.annotate();
        }
    }

    private void updateCurrentDebugger() {
        JPDADebugger jPDADebugger = CurrentThreadAnnotationListener.getCurrentDebugger();
        if (this.currentDebugger == jPDADebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (jPDADebugger != null) {
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.currentDebugger = jPDADebugger;
    }

    private static JPDADebugger getCurrentDebugger() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
    }

    private void updateCurrentThread() {
        this.currentThread = this.currentDebugger != null ? this.currentDebugger.getCurrentThread() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        String string;
        CallStackFrame[] callStackFrameArray;
        if (this.currentThread == null || this.currentDebugger.getState() != 3) {
            Object object = this.currentPCLock;
            synchronized (object) {
                this.currentPCSet = false;
            }
            this.removeAnnotations();
            return;
        }
        try {
            callStackFrameArray = this.currentThread.getCallStack();
        }
        catch (AbsentInformationException absentInformationException) {
            Object object = this.currentPCLock;
            synchronized (object) {
                this.currentPCSet = false;
            }
            this.removeAnnotations();
            return;
        }
        final CallStackFrame callStackFrame = this.currentDebugger.getCurrentCallStackFrame();
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string2 = string = session == null ? null : session.getCurrentLanguage();
        final SourcePath sourcePath = debuggerEngine == null ? null : (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
        Object object = this.currentPCLock;
        synchronized (object) {
            this.currentPCSet = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                synchronized (object) {
                    if (CurrentThreadAnnotationListener.this.currentPC != null) {
                        EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                    }
                    if (callStackFrame != null && sourcePath != null && CurrentThreadAnnotationListener.this.currentThread != null) {
                        sourcePath.showSource(callStackFrame, string);
                        CurrentThreadAnnotationListener.this.currentPC = sourcePath.annotate(CurrentThreadAnnotationListener.this.currentThread, string);
                    }
                }
            }
        });
        this.annotateCallStack(callStackFrameArray, sourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Iterator iterator = CurrentThreadAnnotationListener.this.currentPCLock;
                        synchronized (iterator) {
                            if (CurrentThreadAnnotationListener.this.currentPCSet) {
                                return;
                            }
                            if (CurrentThreadAnnotationListener.this.currentPC != null) {
                                EditorContextBridge.removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                            }
                            CurrentThreadAnnotationListener.this.currentPC = null;
                        }
                        iterator = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (iterator.hasNext()) {
                            EditorContextBridge.removeAnnotation(iterator.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations.clear();
                    }
                });
            }
        }
        this.taskRemove.schedule(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(CallStackFrame[] callStackFrameArray, SourcePath sourcePath) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = callStackFrameArray;
            this.sourcePathToAnnotate = sourcePath;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        SourcePath sourcePath;
                        CallStackFrame[] callStackFrameArray;
                        Object object2 = CurrentThreadAnnotationListener.this.rp;
                        synchronized (object2) {
                            if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                                return;
                            }
                            callStackFrameArray = CurrentThreadAnnotationListener.this.stackToAnnotate;
                            sourcePath = CurrentThreadAnnotationListener.this.sourcePathToAnnotate;
                            CurrentThreadAnnotationListener.access$602(CurrentThreadAnnotationListener.this, null);
                            CurrentThreadAnnotationListener.this.sourcePathToAnnotate = null;
                        }
                        object2 = new HashMap();
                        int n = callStackFrameArray.length;
                        for (int i = 1; i < n; ++i) {
                            object = callStackFrameArray[i].getDefaultStratum();
                            String string = EditorContextBridge.getRelativePath(callStackFrameArray[i], (String)object);
                            int n2 = callStackFrameArray[i].getLineNumber((String)object);
                            String string2 = string + n2;
                            if (((HashMap)object2).containsKey(string2)) continue;
                            Object object3 = CurrentThreadAnnotationListener.this.stackAnnotations.remove(string2);
                            if (object3 == null) {
                                object3 = sourcePath.annotate(callStackFrameArray[i], (String)object);
                            }
                            if (object3 == null) continue;
                            ((HashMap)object2).put(string2, object3);
                        }
                        object = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
                        while (object.hasNext()) {
                            EditorContextBridge.removeAnnotation(object.next());
                        }
                        CurrentThreadAnnotationListener.this.stackAnnotations = (HashMap)object2;
                    }
                });
            }
        }
        this.taskAnnotate.schedule(500);
    }

    static /* synthetic */ CallStackFrame[] access$602(CurrentThreadAnnotationListener currentThreadAnnotationListener, CallStackFrame[] callStackFrameArray) {
        currentThreadAnnotationListener.stackToAnnotate = callStackFrameArray;
        return callStackFrameArray;
    }
}

