/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LaunchingDICookie;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.IOManager;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class DebuggerOutput
extends LazyActionsManagerListener
implements PropertyChangeListener {
    private static Set managers = new HashSet();
    private JPDADebugger debugger;
    private SourcePath engineContext;
    private IOManager ioManager;
    private ContextProvider contextProvider;

    public DebuggerOutput(ContextProvider contextProvider) {
        Object object;
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.engineContext = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        if (DebuggerManager.getDebuggerManager().getSessions().length == 1) {
            object = managers.iterator();
            while (object.hasNext()) {
                ((IOManager)object.next()).close();
            }
            managers = new HashSet();
        }
        if ((object = (String)contextProvider.lookupFirst(null, String.class)) == null) {
            object = NbBundle.getBundle((Class)IOManager.class).getString("CTL_DebuggerConsole_Title");
        }
        this.ioManager = new IOManager((String)object);
        managers.add(this.ioManager);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    protected synchronized void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        this.debugger = null;
        this.engineContext = null;
        this.ioManager = null;
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        IOManager iOManager;
        int n;
        JPDAThread jPDAThread;
        Object object = this;
        synchronized (object) {
            if (this.debugger == null) {
                return;
            }
            jPDAThread = this.debugger.getCurrentThread();
            n = this.debugger.getState();
            iOManager = this.ioManager;
        }
        if (n == 1) {
            object = (AbstractDICookie)this.contextProvider.lookupFirst(null, AbstractDICookie.class);
            if (object instanceof AttachingDICookie) {
                AttachingDICookie attachingDICookie = (AttachingDICookie)object;
                if (attachingDICookie.getHostName() != null) {
                    this.print("CTL_Attaching_socket", new String[]{attachingDICookie.getHostName(), "" + attachingDICookie.getPortNumber()}, null);
                } else if (attachingDICookie.getSharedMemoryName() != null) {
                    this.print("CTL_Attaching_shmem", new String[]{attachingDICookie.getSharedMemoryName()}, null);
                } else if (attachingDICookie.getArgs().get("pid") != null) {
                    this.print("CTL_Attaching_pid", new String[]{attachingDICookie.getArgs().get("pid").toString()}, null);
                } else {
                    this.print("CTL_Attaching", null, null);
                }
            } else if (object instanceof ListeningDICookie) {
                ListeningDICookie listeningDICookie = (ListeningDICookie)object;
                if (listeningDICookie.getSharedMemoryName() != null) {
                    this.print("CTL_Listening_shmem", new String[]{listeningDICookie.getSharedMemoryName()}, null);
                } else {
                    this.print("CTL_Listening_socket", new String[]{"" + listeningDICookie.getPortNumber()}, null);
                }
            } else if (object instanceof LaunchingDICookie) {
                LaunchingDICookie launchingDICookie = (LaunchingDICookie)object;
                this.print("CTL_Launching", new String[]{launchingDICookie.getCommandLine()}, null);
            }
        } else if (n == 2) {
            this.print("CTL_Debugger_running", new String[0], null);
        } else if (n == 4) {
            Object object2;
            object = null;
            try {
                object2 = this;
                synchronized (object2) {
                    if (this.debugger != null) {
                        this.debugger.waitRunning();
                    }
                }
            }
            catch (DebuggerStartException debuggerStartException) {
                object = debuggerStartException.getTargetException();
            }
            if (object == null) {
                this.print("CTL_Debugger_finished", null, null);
            } else {
                object2 = ((Throwable)object).getMessage();
                if (object instanceof ConnectException) {
                    object2 = NbBundle.getBundle((Class)DebuggerOutput.class).getString("CTL_Connection_refused");
                }
                if (object instanceof UnknownHostException) {
                    object2 = NbBundle.getBundle((Class)DebuggerOutput.class).getString("CTL_Unknown_host");
                }
                if (object2 != null) {
                    iOManager.println((String)object2, null);
                } else {
                    iOManager.println(((Throwable)object).toString(), null);
                }
            }
            iOManager.closeStream();
        } else if (n == 3) {
            if (jPDAThread == null) {
                this.print("CTL_Debugger_stopped", null, null);
                return;
            }
            object = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
            String string = jPDAThread.getName();
            String string2 = jPDAThread.getMethodName();
            String string3 = jPDAThread.getClassName();
            int n2 = jPDAThread.getLineNumber((String)object);
            try {
                String string4 = jPDAThread.getSourceName((String)object);
                String string5 = EditorContextBridge.getRelativePath(jPDAThread, (String)object);
                String string6 = null;
                Object object3 = this;
                synchronized (object3) {
                    if (string5 != null && this.engineContext != null) {
                        string6 = this.engineContext.getURL(string5, true);
                    }
                }
                object3 = null;
                if (n2 > 0 && string6 != null) {
                    object3 = new IOManager.Line(string6, n2, this.debugger);
                }
                if (n2 > 0) {
                    this.print("CTL_Thread_stopped", new String[]{string, string4, string2, "" + n2}, (IOManager.Line)object3);
                } else if (string4.length() > 0 && string2.length() > 0) {
                    this.print("CTL_Thread_stopped_no_line", new String[]{string, string4, string2}, (IOManager.Line)object3);
                } else {
                    this.print("CTL_Thread_stopped_no_line_no_source", new String[]{string}, (IOManager.Line)object3);
                }
            }
            catch (AbsentInformationException absentInformationException) {
                if (n2 > 0) {
                    this.print("CTL_Thread_stopped_no_info", new String[]{string, string3, string2, n2 > 0 ? "" + n2 : ""}, null);
                }
                this.print("CTL_Thread_stopped_no_info_no_line", new String[]{string, string3, string2}, null);
            }
        }
    }

    public void actionPerformed(Object object, boolean bl) {
        if (!bl) {
            return;
        }
        if (object == ActionsManager.ACTION_CONTINUE) {
            this.print("CTL_Continue", null, null);
        } else if (object == ActionsManager.ACTION_STEP_INTO) {
            this.print("CTL_Step_Into", null, null);
        } else if (object == ActionsManager.ACTION_STEP_OUT) {
            this.print("CTL_Step_Out", null, null);
        } else if (object == ActionsManager.ACTION_STEP_OVER) {
            this.print("CTL_Step_Over", null, null);
        }
    }

    IOManager getIOManager() {
        return this.ioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String string, String[] stringArray, IOManager.Line line) {
        IOManager iOManager;
        String string2 = stringArray == null ? NbBundle.getMessage((Class)DebuggerOutput.class, (String)string) : new MessageFormat(NbBundle.getMessage((Class)DebuggerOutput.class, (String)string)).format(stringArray);
        DebuggerOutput debuggerOutput = this;
        synchronized (debuggerOutput) {
            iOManager = this.ioManager;
            if (iOManager == null) {
                return;
            }
        }
        iOManager.println(string2, line);
    }
}

