/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.spi.debugger.jpda.EditorContext;

public class EditorContextBridge {
    public static final String FIELD = "field";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String LINE = "line";
    private static EditorContext context;

    private static EditorContext getContext() {
        if (context == null) {
            List list = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                context = new CompoundContextProvider((EditorContext)list.get(i), context);
            }
        }
        return context;
    }

    public static boolean showSource(String string, int n, Object object) {
        return EditorContextBridge.getContext().showSource(string, n, object);
    }

    public static void createTimeStamp(Object object) {
        EditorContextBridge.getContext().createTimeStamp(object);
    }

    public static void disposeTimeStamp(Object object) {
        EditorContextBridge.getContext().disposeTimeStamp(object);
    }

    public static Object annotate(String string, int n, String string2, Object object) {
        return EditorContextBridge.getContext().annotate(string, n, string2, object);
    }

    public static void removeAnnotation(Object object) {
        EditorContextBridge.getContext().removeAnnotation(object);
    }

    public static int getLineNumber(Object object, Object object2) {
        return EditorContextBridge.getContext().getLineNumber(object, object2);
    }

    public static int getCurrentLineNumber() {
        return EditorContextBridge.getContext().getCurrentLineNumber();
    }

    public static String getCurrentClassName() {
        return EditorContextBridge.getContext().getCurrentClassName();
    }

    public static String getCurrentURL() {
        return EditorContextBridge.getContext().getCurrentURL();
    }

    public static String getCurrentMethodName() {
        return EditorContextBridge.getContext().getCurrentMethodName();
    }

    public static String getCurrentFieldName() {
        return EditorContextBridge.getContext().getCurrentFieldName();
    }

    public static String getSelectedIdentifier() {
        return EditorContextBridge.getContext().getSelectedIdentifier();
    }

    public static String getSelectedMethodName() {
        return EditorContextBridge.getContext().getSelectedMethodName();
    }

    public static int getFieldLineNumber(String string, String string2, String string3) {
        return EditorContextBridge.getContext().getFieldLineNumber(string, string2, string3);
    }

    public static String getClassName(String string, int n) {
        return EditorContextBridge.getContext().getClassName(string, n);
    }

    public static String[] getImports(String string) {
        return EditorContextBridge.getContext().getImports(string);
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextBridge.getContext().addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextBridge.getContext().removePropertyChangeListener(propertyChangeListener);
    }

    public static String getFileName(LineBreakpoint lineBreakpoint) {
        try {
            return new File(new URL(lineBreakpoint.getURL()).getFile()).getName();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean showSource(LineBreakpoint lineBreakpoint, Object object) {
        if (lineBreakpoint.getLineNumber() < 1) {
            return EditorContextBridge.showSource(lineBreakpoint.getURL(), 1, object);
        }
        return EditorContextBridge.showSource(lineBreakpoint.getURL(), lineBreakpoint.getLineNumber(), object);
    }

    public static String getDefaultType() {
        String string = EditorContextBridge.getSelectedIdentifier();
        if (string != null) {
            if (string.equals(EditorContextBridge.getCurrentMethodName())) {
                return METHOD;
            }
            String string2 = EditorContextBridge.getCurrentClassName();
            int n = string2.lastIndexOf(46);
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            if (string.equals(string2)) {
                return CLASS;
            }
            return FIELD;
        }
        String string3 = EditorContextBridge.getCurrentFieldName();
        if (string3 != null && string3.length() > 0) {
            return FIELD;
        }
        string3 = EditorContextBridge.getCurrentMethodName();
        if (string3 != null && string3.length() > 0) {
            return METHOD;
        }
        if (string3 != null && string3.length() < 1 && (string3 = EditorContextBridge.getCurrentClassName()).length() > 0) {
            return CLASS;
        }
        return CLASS;
    }

    public static Object annotate(LineBreakpoint lineBreakpoint) {
        boolean bl;
        String string = lineBreakpoint.getURL();
        int n = lineBreakpoint.getLineNumber();
        if (n < 1) {
            return null;
        }
        String string2 = lineBreakpoint.getCondition();
        boolean bl2 = bl = string2 != null && !string2.trim().equals("");
        String string3 = lineBreakpoint.isEnabled() ? (bl ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (bl ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        return EditorContextBridge.annotate(string, n, string3, null);
    }

    public static String getRelativePath(JPDAThread jPDAThread, String string) {
        try {
            return EditorContextBridge.convertSlash(jPDAThread.getSourcePath(string));
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.getRelativePath(jPDAThread.getClassName());
        }
    }

    public static String getRelativePath(CallStackFrame callStackFrame, String string) {
        try {
            return EditorContextBridge.convertSlash(callStackFrame.getSourcePath(string));
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.getRelativePath(callStackFrame.getClassName());
        }
    }

    public static String getRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;

        private CompoundAnnotation() {
        }
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext editorContext, EditorContext editorContext2) {
            this.cp1 = editorContext;
            this.cp2 = editorContext2;
        }

        public void createTimeStamp(Object object) {
            this.cp1.createTimeStamp(object);
            this.cp2.createTimeStamp(object);
        }

        public void disposeTimeStamp(Object object) {
            this.cp1.disposeTimeStamp(object);
            this.cp2.disposeTimeStamp(object);
        }

        public void updateTimeStamp(Object object, String string) {
            this.cp1.updateTimeStamp(object, string);
            this.cp2.updateTimeStamp(object, string);
        }

        public String getCurrentClassName() {
            String string = this.cp1.getCurrentClassName();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentClassName();
            }
            return string;
        }

        public String getCurrentURL() {
            String string = this.cp1.getCurrentURL();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return string;
        }

        public String getCurrentFieldName() {
            String string = this.cp1.getCurrentFieldName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentFieldName();
            }
            return string;
        }

        public int getCurrentLineNumber() {
            int n = this.cp1.getCurrentLineNumber();
            if (n < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return n;
        }

        public String getCurrentMethodName() {
            String string = this.cp1.getCurrentMethodName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentMethodName();
            }
            return string;
        }

        public String getSelectedIdentifier() {
            String string = this.cp1.getSelectedIdentifier();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedIdentifier();
            }
            return string;
        }

        public String getSelectedMethodName() {
            String string = this.cp1.getSelectedMethodName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedMethodName();
            }
            return string;
        }

        public void removeAnnotation(Object object) {
            CompoundAnnotation compoundAnnotation = (CompoundAnnotation)object;
            this.cp1.removeAnnotation(compoundAnnotation.annotation1);
            this.cp2.removeAnnotation(compoundAnnotation.annotation2);
        }

        public Object annotate(String string, int n, String string2, Object object) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(string, n, string2, object);
            compoundAnnotation.annotation2 = this.cp2.annotate(string, n, string2, object);
            return compoundAnnotation;
        }

        public int getLineNumber(Object object, Object object2) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            int n = this.cp1.getLineNumber(compoundAnnotation.annotation1, object2);
            if (n >= 0) {
                return n;
            }
            return this.cp2.getLineNumber(compoundAnnotation.annotation2, object2);
        }

        public boolean showSource(String string, int n, Object object) {
            return this.cp1.showSource(string, n, object) | this.cp2.showSource(string, n, object);
        }

        public int getFieldLineNumber(String string, String string2, String string3) {
            int n = this.cp1.getFieldLineNumber(string, string2, string3);
            if (n != -1) {
                return n;
            }
            return this.cp2.getFieldLineNumber(string, string2, string3);
        }

        public String getClassName(String string, int n) {
            String string2 = this.cp1.getClassName(string, n);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getClassName(string, n);
        }

        public String[] getImports(String string) {
            String[] stringArray = this.cp1.getImports(string);
            String[] stringArray2 = this.cp2.getImports(string);
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(string, propertyChangeListener);
            this.cp2.addPropertyChangeListener(string, propertyChangeListener);
        }

        public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(string, propertyChangeListener);
            this.cp2.removePropertyChangeListener(string, propertyChangeListener);
        }
    }
}

