/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Evaluator
extends JPanel {
    private static final int MAX_ITEMS_TO_KEEP = 20;
    private JPDADebugger debugger;
    private EvaluatorModelListener viewModelListener;
    private Variable result;
    private RequestProcessor.Task evalTask = new RequestProcessor("Debugger Evaluator", 1).create((Runnable)new EvaluateTask());
    private boolean ignoreEvents = false;
    private SessionListener sessionListener;
    private JComboBox expressionComboBox;
    private JLabel expressionLabel;
    private JLabel resultLabel;
    private JPanel resultPanel;
    private static Dialog evalDialog;
    private static volatile Evaluator currentEvaluator;
    static /* synthetic */ Class class$org$netbeans$api$debugger$jpda$JPDADebugger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TreeModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TreeModelFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TreeExpansionModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeModelFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TableModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$TableModelFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeActionsProvider;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$ColumnModel;
    static /* synthetic */ Class class$org$netbeans$spi$viewmodel$Model;

    public Evaluator(JPDADebugger jPDADebugger) {
        this.debugger = jPDADebugger;
        this.initComponents();
        this.initCombo();
        this.initResult();
        this.expressionLabel.setLabelFor(this.expressionComboBox);
        this.expressionLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Expression_Mnc").charAt(0));
        this.resultLabel.setLabelFor(this.resultPanel);
        this.resultLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Result_Mnc").charAt(0));
        this.sessionListener = new SessionListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)this.sessionListener);
    }

    private void initComponents() {
        this.expressionLabel = new JLabel();
        this.expressionComboBox = new JComboBox();
        this.resultLabel = new JLabel();
        this.resultPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.expressionLabel.setText(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Expression"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 12);
        this.add((Component)this.expressionLabel, gridBagConstraints);
        this.expressionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Evaluator.this.expressionComboBoxItemStateChanged(itemEvent);
            }
        });
        this.expressionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Evaluator.this.expressionComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 12, 12);
        this.add((Component)this.expressionComboBox, gridBagConstraints);
        this.resultLabel.setText(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Result"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 11, 12);
        this.add((Component)this.resultLabel, gridBagConstraints);
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 12, 12);
        this.add((Component)this.resultPanel, gridBagConstraints);
    }

    private void expressionComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.ignoreEvents) {
            return;
        }
        this.evaluate();
    }

    private void expressionComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void initCombo() {
        this.expressionComboBox.setEditor(new CompletionedEditor());
        this.expressionComboBox.setEditable(true);
    }

    private void initResult() {
        JComponent jComponent = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
        this.resultPanel.add((Component)jComponent, "Center");
        this.viewModelListener = new EvaluatorModelListener(jComponent);
        Dimension dimension = jComponent.getPreferredSize();
        dimension.height = dimension.width / 2;
        jComponent.setPreferredSize(dimension);
    }

    private void destroy() {
        this.viewModelListener.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpression() {
        String string = (String)this.expressionComboBox.getEditor().getItem();
        String string2 = (String)this.expressionComboBox.getSelectedItem();
        if (string != null && !string.equals(string2)) {
            try {
                this.ignoreEvents = true;
                this.expressionComboBox.setSelectedItem(string);
                string2 = string;
            }
            finally {
                this.ignoreEvents = false;
            }
        }
        return string2;
    }

    private void evaluate() {
        this.evalTask.schedule(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExpressionToHistory(String string) {
        try {
            int n;
            this.ignoreEvents = true;
            int n2 = this.expressionComboBox.getItemCount();
            for (n = 0; n < n2; ++n) {
                String string2 = (String)this.expressionComboBox.getItemAt(n);
                if (!string2.equals(string)) continue;
                this.expressionComboBox.removeItemAt(n);
                break;
            }
            if (n >= 20) {
                this.expressionComboBox.removeItemAt(n - 1);
            }
            if (n2 > 0) {
                this.expressionComboBox.insertItemAt(string, 0);
            } else {
                this.expressionComboBox.addItem(string);
            }
            this.expressionComboBox.setSelectedItem(string);
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private void displayResult(Variable variable) {
        this.result = variable;
        this.viewModelListener.updateModel();
    }

    public static void open(JPDADebugger jPDADebugger) {
        if (evalDialog != null) {
            evalDialog.setVisible(true);
            evalDialog.requestFocus();
            return;
        }
        final Evaluator evaluator = new Evaluator(jPDADebugger);
        final String string = NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Evaluate");
        final String string2 = NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Watch");
        final String string3 = NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Close");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)evaluator, NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.Title"), false, new Object[]{string, string2, string3}, (Object)string, 0, new HelpCtx(Evaluator.class.getName()), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (string.equals(object)) {
                    evaluator.evaluate();
                } else if (string2.equals(object)) {
                    DebuggerManager.getDebuggerManager().createWatch(evaluator.getExpression());
                } else if (string3.equals(object)) {
                    Evaluator.close();
                }
            }
        });
        evalDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        evalDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)Evaluator.class, (String)"Evaluator.A11YDescr"));
        currentEvaluator = evaluator;
        evalDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close() {
        evalDialog.setVisible(false);
        try {
            Evaluator.currentEvaluator.ignoreEvents = true;
            Evaluator.currentEvaluator.expressionComboBox.setSelectedItem("");
        }
        finally {
            Evaluator.currentEvaluator.ignoreEvents = false;
        }
        Evaluator.currentEvaluator.result = null;
        Evaluator.currentEvaluator.viewModelListener.updateModel();
    }

    private static class EvaluatorModel
    implements TreeModel,
    NodeModel {
        private Models.CompoundModel treeModel;
        private Models.CompoundModel nodeModel;

        public EvaluatorModel(Models.CompoundModel compoundModel, Models.CompoundModel compoundModel2) {
            this.treeModel = compoundModel;
            this.nodeModel = compoundModel2;
        }

        public void addModelListener(ModelListener modelListener) {
            this.treeModel.addModelListener(modelListener);
        }

        public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
            if ("Root".equals(object)) {
                Evaluator evaluator = currentEvaluator;
                if (evaluator == null || evaluator.result == null) {
                    return new Object[0];
                }
                return new Object[]{evaluator.result};
            }
            return this.treeModel.getChildren(object, n, n2);
        }

        public int getChildrenCount(Object object) throws UnknownTypeException {
            if ("Root".equals(object)) {
                return currentEvaluator == null ? 0 : 1;
            }
            return this.treeModel.getChildrenCount(object);
        }

        public Object getRoot() {
            return "Root";
        }

        public boolean isLeaf(Object object) throws UnknownTypeException {
            if ("Root".equals(object)) {
                return false;
            }
            return this.treeModel.isLeaf(object);
        }

        public void removeModelListener(ModelListener modelListener) {
            this.treeModel.removeModelListener(modelListener);
        }

        public String getDisplayName(Object object) throws UnknownTypeException {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null && evaluator.result != null && object == evaluator.result) {
                return evaluator.getExpression();
            }
            return this.nodeModel.getDisplayName(object);
        }

        public String getIconBase(Object object) throws UnknownTypeException {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null && evaluator.result != null && object == evaluator.result) {
                return "org/netbeans/modules/debugger/resources/watchesView/Watch";
            }
            return this.nodeModel.getIconBase(object);
        }

        public String getShortDescription(Object object) throws UnknownTypeException {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null && evaluator.result != null && object == evaluator.result) {
                return evaluator.getExpression();
            }
            return this.nodeModel.getShortDescription(object);
        }
    }

    private static class EvaluatorModelListener
    extends DebuggerManagerAdapter {
        private String viewType = "LocalsView";
        private JComponent view;

        public EvaluatorModelListener(JComponent jComponent) {
            this.view = jComponent;
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.updateModel();
        }

        public void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.EMPTY_MODEL);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Evaluator evaluator = currentEvaluator;
            if (evaluator != null) {
                DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                if (debuggerEngine == null) {
                    return;
                }
                JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = Evaluator.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
                evaluator.debugger = jPDADebugger;
            }
            this.updateModel();
        }

        private List joinLookups(DebuggerEngine debuggerEngine, DebuggerManager debuggerManager, Class clazz) {
            List list = debuggerEngine.lookup(this.viewType, clazz);
            List list2 = debuggerManager.lookup(this.viewType, clazz);
            list2.removeAll(list);
            list.addAll(list2);
            return list;
        }

        public void updateModel() {
            int n;
            List list;
            List list2;
            List list3;
            List list4;
            List list5;
            List list6;
            List list7;
            List list8;
            List list9;
            List list10;
            List list11;
            DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
            DebuggerEngine debuggerEngine = debuggerManager.getCurrentEngine();
            if (debuggerEngine != null) {
                list11 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$TreeModel == null ? (class$org$netbeans$spi$viewmodel$TreeModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModel")) : class$org$netbeans$spi$viewmodel$TreeModel);
                list10 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$TreeModelFilter == null ? (class$org$netbeans$spi$viewmodel$TreeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModelFilter")) : class$org$netbeans$spi$viewmodel$TreeModelFilter);
                list9 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$TreeExpansionModel == null ? (class$org$netbeans$spi$viewmodel$TreeExpansionModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeExpansionModel")) : class$org$netbeans$spi$viewmodel$TreeExpansionModel);
                list8 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$NodeModel == null ? (class$org$netbeans$spi$viewmodel$NodeModel = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModel")) : class$org$netbeans$spi$viewmodel$NodeModel);
                list7 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$NodeModelFilter == null ? (class$org$netbeans$spi$viewmodel$NodeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModelFilter")) : class$org$netbeans$spi$viewmodel$NodeModelFilter);
                list6 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$TableModel == null ? (class$org$netbeans$spi$viewmodel$TableModel = Evaluator.class$("org.netbeans.spi.viewmodel.TableModel")) : class$org$netbeans$spi$viewmodel$TableModel);
                list5 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$TableModelFilter == null ? (class$org$netbeans$spi$viewmodel$TableModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TableModelFilter")) : class$org$netbeans$spi$viewmodel$TableModelFilter);
                list4 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$NodeActionsProvider == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProvider = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProvider")) : class$org$netbeans$spi$viewmodel$NodeActionsProvider);
                list3 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProviderFilter")) : class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter);
                list2 = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$ColumnModel == null ? (class$org$netbeans$spi$viewmodel$ColumnModel = Evaluator.class$("org.netbeans.spi.viewmodel.ColumnModel")) : class$org$netbeans$spi$viewmodel$ColumnModel);
                list = this.joinLookups(debuggerEngine, debuggerManager, class$org$netbeans$spi$viewmodel$Model == null ? (class$org$netbeans$spi$viewmodel$Model = Evaluator.class$("org.netbeans.spi.viewmodel.Model")) : class$org$netbeans$spi$viewmodel$Model);
            } else {
                list11 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TreeModel == null ? (class$org$netbeans$spi$viewmodel$TreeModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModel")) : class$org$netbeans$spi$viewmodel$TreeModel);
                list10 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TreeModelFilter == null ? (class$org$netbeans$spi$viewmodel$TreeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TreeModelFilter")) : class$org$netbeans$spi$viewmodel$TreeModelFilter);
                list9 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TreeExpansionModel == null ? (class$org$netbeans$spi$viewmodel$TreeExpansionModel = Evaluator.class$("org.netbeans.spi.viewmodel.TreeExpansionModel")) : class$org$netbeans$spi$viewmodel$TreeExpansionModel);
                list8 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeModel == null ? (class$org$netbeans$spi$viewmodel$NodeModel = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModel")) : class$org$netbeans$spi$viewmodel$NodeModel);
                list7 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeModelFilter == null ? (class$org$netbeans$spi$viewmodel$NodeModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeModelFilter")) : class$org$netbeans$spi$viewmodel$NodeModelFilter);
                list6 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TableModel == null ? (class$org$netbeans$spi$viewmodel$TableModel = Evaluator.class$("org.netbeans.spi.viewmodel.TableModel")) : class$org$netbeans$spi$viewmodel$TableModel);
                list5 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$TableModelFilter == null ? (class$org$netbeans$spi$viewmodel$TableModelFilter = Evaluator.class$("org.netbeans.spi.viewmodel.TableModelFilter")) : class$org$netbeans$spi$viewmodel$TableModelFilter);
                list4 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeActionsProvider == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProvider = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProvider")) : class$org$netbeans$spi$viewmodel$NodeActionsProvider);
                list3 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter == null ? (class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter = Evaluator.class$("org.netbeans.spi.viewmodel.NodeActionsProviderFilter")) : class$org$netbeans$spi$viewmodel$NodeActionsProviderFilter);
                list2 = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$ColumnModel == null ? (class$org$netbeans$spi$viewmodel$ColumnModel = Evaluator.class$("org.netbeans.spi.viewmodel.ColumnModel")) : class$org$netbeans$spi$viewmodel$ColumnModel);
                list = debuggerManager.lookup(this.viewType, class$org$netbeans$spi$viewmodel$Model == null ? (class$org$netbeans$spi$viewmodel$Model = Evaluator.class$("org.netbeans.spi.viewmodel.Model")) : class$org$netbeans$spi$viewmodel$Model);
            }
            ArrayList<List> arrayList = new ArrayList<List>(11);
            arrayList.add(list11);
            for (n = 0; n < 2; ++n) {
                arrayList.add(Collections.EMPTY_LIST);
            }
            arrayList.add(list8);
            for (n = 0; n < 7; ++n) {
                arrayList.add(Collections.EMPTY_LIST);
            }
            Models.CompoundModel compoundModel = Models.createCompoundModel(arrayList);
            EvaluatorModel evaluatorModel = new EvaluatorModel(compoundModel, compoundModel);
            ArrayList<List> arrayList2 = new ArrayList<List>(11);
            list11.clear();
            list11.add(evaluatorModel);
            arrayList2.add(list11);
            arrayList2.add(list10);
            arrayList2.add(list9);
            list8.clear();
            list8.add(evaluatorModel);
            arrayList2.add(list8);
            arrayList2.add(list7);
            arrayList2.add(list6);
            arrayList2.add(list5);
            arrayList2.add(list4);
            arrayList2.add(list3);
            arrayList2.add(list2);
            arrayList2.add(list);
            Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.createCompoundModel(arrayList2));
        }
    }

    private static final class CompletionedEditor
    implements ComboBoxEditor {
        private JEditorPane editor = new JEditorPane("text/x-java", "");
        private Component component;
        private Object oldValue;

        public CompletionedEditor() {
            this.editor.setBorder(null);
            this.editor.setKeymap(new FilteredKeymap(this.editor.getKeymap()));
            this.component = new JScrollPane(this.editor, 21, 31);
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }

        public Component getEditorComponent() {
            return this.component;
        }

        public Object getItem() {
            Object object = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (object.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> clazz = this.oldValue.getClass();
                try {
                    Method method = clazz.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = Evaluator.class$("java.lang.String")) : class$java$lang$String);
                    object = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }

        public void setItem(Object object) {
            if (object != null) {
                this.editor.setText(object.toString());
                this.oldValue = object;
            } else {
                this.editor.setText("");
            }
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        public void run() {
            String string = Evaluator.this.getExpression();
            if (string == null || string.equals("")) {
                return;
            }
            try {
                Variable variable = Evaluator.this.debugger.evaluate(string);
                Evaluator.this.addExpressionToHistory(string);
                Evaluator.this.displayResult(variable);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)invalidExpressionException.getLocalizedMessage()));
            }
        }
    }

    private class SessionListener
    extends DebuggerManagerAdapter {
        private boolean autoClosed = false;

        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (session != null && session.getCurrentLanguage().equals("Java")) {
                if (this.autoClosed) {
                    DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                    if (debuggerEngine == null) {
                        return;
                    }
                    JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = Evaluator.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
                    if (jPDADebugger == null) {
                        return;
                    }
                    Evaluator.open(jPDADebugger);
                    this.autoClosed = false;
                }
            } else if (evalDialog.isVisible()) {
                this.autoClosed = true;
                Evaluator.close();
            }
        }
    }
}

