/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class FixedWatchesManager
implements TreeModelFilter,
NodeActionsProviderFilter,
NodeModelFilter {
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch";
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)FixedWatchesManager.class).getString("CTL_DeleteFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                FixedWatchesManager.this.fixedWatches.remove(objectArray[i]);
            }
            FixedWatchesManager.this.fireModelChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action CREATE_FIXED_WATCH_ACTION;
    private Map fixedWatches;
    private HashSet listeners;
    private ContextProvider contextProvider;

    public FixedWatchesManager(ContextProvider contextProvider) {
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.CREATE_FIXED_WATCH_ACTION = Models.createAction((String)NbBundle.getBundle((Class)FixedWatchesManager.class).getString("CTL_CreateFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    FixedWatchesManager.this.createFixedWatch(objectArray[i]);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
        this.fixedWatches = new HashMap();
        this.contextProvider = contextProvider;
    }

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            if (this.fixedWatches.size() == 0) {
                return treeModel.getChildren(object, n, n2);
            }
            int n3 = this.fixedWatches.size();
            int n4 = n - n3;
            int n5 = n2 - n3;
            if (n4 < 0) {
                n4 = 0;
            }
            Object[] objectArray = n5 > n4 ? treeModel.getChildren(object, n4, n5) : new Object[]{};
            Object[] objectArray2 = new Object[objectArray.length + n3];
            this.fixedWatches.keySet().toArray(objectArray2);
            System.arraycopy(objectArray, 0, objectArray2, n3, objectArray.length);
            Object[] objectArray3 = new Object[n2 - n];
            System.arraycopy(objectArray2, n, objectArray3, 0, n2 - n);
            return objectArray3;
        }
        return treeModel.getChildren(object, n, n2);
    }

    public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object == "Root") {
            int n = treeModel.getChildrenCount(object);
            return n + this.fixedWatches.size();
        }
        return treeModel.getChildrenCount(object);
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        return treeModel.isLeaf(object);
    }

    public void addModelListener(ModelListener modelListener) {
        HashSet hashSet = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        hashSet.add(modelListener);
        this.listeners = hashSet;
    }

    public void removeModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            return;
        }
        HashSet hashSet = (HashSet)this.listeners.clone();
        hashSet.remove(modelListener);
        this.listeners = hashSet;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Action[] actionArray = nodeActionsProvider.getActions(object);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (this.fixedWatches.containsKey(object)) {
            return new Action[]{this.DELETE_ACTION};
        }
        if (object instanceof Variable) {
            arrayList.add(this.CREATE_FIXED_WATCH_ACTION);
        } else if (object instanceof JPDAWatch) {
            arrayList.add(this.CREATE_FIXED_WATCH_ACTION);
        } else {
            return actionArray;
        }
        arrayList.addAll(Arrays.asList(actionArray));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(object)) {
            return (String)this.fixedWatches.get(object);
        }
        return nodeModel.getDisplayName(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(object)) {
            Variable variable = (Variable)object;
            return (String)this.fixedWatches.get(object) + " = (" + variable.getType() + ") " + variable.getValue();
        }
        return nodeModel.getShortDescription(object);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(object)) {
            return FIXED_WATCH;
        }
        return nodeModel.getIconBase(object);
    }

    private void createFixedWatch(Object object) {
        if (object instanceof JPDAWatch) {
            JPDAWatch jPDAWatch = (JPDAWatch)object;
            this.addFixedWatch(jPDAWatch.getExpression(), (Variable)jPDAWatch);
        } else {
            Variable variable = (Variable)object;
            String string = null;
            string = variable instanceof LocalVariable ? ((LocalVariable)variable).getName() : (variable instanceof Field ? ((Field)variable).getName() : (variable instanceof This ? "this" : (variable instanceof ObjectVariable ? "object" : "unnamed")));
            this.addFixedWatch(string, variable);
        }
    }

    private void addFixedWatch(String string, Variable variable) {
        this.fixedWatches.put(variable, string);
        this.fireModelChanged();
    }

    private void fireModelChanged() {
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ModelListener modelListener = (ModelListener)iterator.next();
            modelListener.modelChanged(null);
        }
    }
}

