/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class WatchPanel {
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    public JComponent getPanel() {
        Object object;
        JScrollPane jScrollPane;
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel(resourceBundle.getString("CTL_Watch_Name"));
        this.editorPane = new JEditorPane("text/x-java", this.expression);
        this.editorPane.setKeymap(new FilteredKeymap(this.editorPane.getKeymap()));
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        CallStackFrame callStackFrame = jPDADebugger.getCurrentCallStackFrame();
        if (callStackFrame != null) {
            jScrollPane = null;
            object = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
            String string = ((SourcePath)object).getURL(callStackFrame, "Java");
            try {
                FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
                if (fileObject != null) {
                    try {
                        jScrollPane = DataObject.find((FileObject)fileObject);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.editorPane.getDocument().putProperty("stream", jScrollPane);
        }
        jScrollPane = new JScrollPane(this.editorPane, 21, 31);
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.panel.add("Center", jScrollPane);
        object = this.editorPane.getFontMetrics(this.editorPane.getFont());
        int n = 2 * ((FontMetrics)object).getLeading() + ((FontMetrics)object).getMaxAscent() + ((FontMetrics)object).getMaxDescent() + 4;
        this.editorPane.setPreferredSize(new Dimension(30 * n, 1 * n));
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setBorder(new CompoundBorder(this.editorPane.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        jLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_Watch_Name_Mnemonic").charAt(0));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }
}

