/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsActionsProvider;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class LineBreakpointCustomizeAction
extends NodeAction {
    static LineBreakpoint getCurrentBreakpoint() {
        URL uRL;
        String string = EditorContextBridge.getCurrentURL();
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        int n = EditorContextBridge.getCurrentLineNumber();
        if (n < 0) {
            return null;
        }
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            URL uRL2;
            if (!(breakpointArray[i] instanceof LineBreakpoint)) continue;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpointArray[i];
            try {
                uRL2 = new URL(lineBreakpoint.getURL());
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            if (!uRL.equals(uRL2) || n != lineBreakpoint.getLineNumber()) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enable(null);
    }

    protected boolean enable(Node[] nodeArray) {
        LineBreakpoint lineBreakpoint = LineBreakpointCustomizeAction.getCurrentBreakpoint();
        return lineBreakpoint != null;
    }

    public String getName() {
        return NbBundle.getMessage((Class)LineBreakpointCustomizeAction.class, (String)"CTL_customize");
    }

    protected void performAction(Node[] nodeArray) {
        LineBreakpoint lineBreakpoint = LineBreakpointCustomizeAction.getCurrentBreakpoint();
        if (lineBreakpoint == null) {
            return;
        }
        BreakpointsActionsProvider.customize((Breakpoint)lineBreakpoint);
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

