/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.actions.RunToCursorActionProvider;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class RunIntoMethodActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener,
ActionsManagerListener {
    private JPDADebugger debugger;
    private Session session;
    private LineBreakpoint breakpoint;
    private ActionsManager lastActionsManager;
    private SourcePath sourcePath;

    public RunIntoMethodActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.addPropertyChangeListener(this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.removePropertyChangeListener(this);
    }

    private ActionsManager getActionsManager() {
        ActionsManager actionsManager = RunToCursorActionProvider.getCurrentActionsManager();
        if (actionsManager != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            actionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = actionsManager;
        }
        return actionsManager;
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChange(PropertyChangeEvent var1_1) {
        if (!this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE)) ** GOTO lbl-1000
        if (this.debugger.getState() == 3 && EditorContextBridge.getCurrentLineNumber() >= 0 && EditorContextBridge.getCurrentURL().endsWith(".java")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, v0);
        if (this.debugger.getState() != 2 && this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
        if (this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_INTO_METHOD);
    }

    public void doAction(Object object) {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
        final String string = EditorContextBridge.getSelectedMethodName();
        final int n = EditorContextBridge.getCurrentLineNumber();
        if (string.length() < 1) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)RunIntoMethodActionProvider.class, (String)"MSG_Put_cursor_on_some_method_call"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        try {
            if (this.debugger.getCurrentThread().getCallStack()[0].getLineNumber(null) == EditorContextBridge.getCurrentLineNumber()) {
                this.traceLineForMethod(string, n);
                this.session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            absentInformationException.printStackTrace();
        }
        this.breakpoint = LineBreakpoint.create((String)EditorContextBridge.getCurrentURL(), (int)EditorContextBridge.getCurrentLineNumber());
        this.breakpoint.setHidden(true);
        this.breakpoint.setSuspend(0);
        this.breakpoint.addJPDABreakpointListener(new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
                RunIntoMethodActionProvider.this.traceLineForMethod(string, n);
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)RunIntoMethodActionProvider.this.breakpoint);
            }
        });
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        this.session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
    }

    private void traceLineForMethod(final String string, final int n) {
        final int n2 = this.debugger.getCurrentThread().getStackDepth();
        final JPDAStep jPDAStep = this.debugger.createJPDAStep(-2, 1);
        jPDAStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ((RunIntoMethodActionProvider.this.debugger.getCurrentThread().getMethodName().equals(string) || RunIntoMethodActionProvider.this.debugger.getCurrentThread().getStackDepth() == n2 && RunIntoMethodActionProvider.this.debugger.getCurrentCallStackFrame().getLineNumber("java") != n) && RunIntoMethodActionProvider.this.sourcePath.sourceAvailable(RunIntoMethodActionProvider.this.debugger.getCurrentThread(), "java", false)) {
                    jPDAStep.setHidden(false);
                } else {
                    jPDAStep.setHidden(true);
                    if (jPDAStep.getDepth() == 1) {
                        jPDAStep.setDepth(3);
                    } else {
                        jPDAStep.setDepth(1);
                    }
                    jPDAStep.addStep(RunIntoMethodActionProvider.this.debugger.getCurrentThread());
                }
            }
        });
        jPDAStep.addStep(this.debugger.getCurrentThread());
    }

    public void actionPerformed(Object object) {
    }

    /*
     * Unable to fully structure code
     */
    public void actionStateChanged(Object var1_1, boolean var2_2) {
        block2: {
            if (ActionsManager.ACTION_CONTINUE != var1_1) break block2;
            if (!var2_2) ** GOTO lbl-1000
            if (this.debugger.getState() == 3 && EditorContextBridge.getCurrentLineNumber() >= 0 && EditorContextBridge.getCurrentURL().endsWith(".java")) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, v0);
        }
    }
}

