/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.BreakpointAnnotationListener;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;
    private BreakpointAnnotationListener breakpointAnnotationListener;

    public ToggleBreakpointActionProvider() {
        EditorContextBridge.addPropertyChangeListener(this);
    }

    public ToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.addPropertyChangeListener(this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, EditorContextBridge.getCurrentLineNumber() >= 0 && EditorContextBridge.getCurrentURL().endsWith(".java"));
        if (this.debugger != null) {
            if (this.debugger.getState() == 4) {
                this.destroy();
            }
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = EditorContextBridge.getCurrentLineNumber();
        String string = EditorContextBridge.getCurrentURL();
        if (string.trim().equals("")) {
            return;
        }
        LineBreakpoint lineBreakpoint = this.getBreakpointAnnotationListener().findBreakpoint(string, n);
        if (lineBreakpoint != null) {
            debuggerManager.removeBreakpoint((Breakpoint)lineBreakpoint);
            return;
        }
        lineBreakpoint = LineBreakpoint.create((String)string, (int)n);
        lineBreakpoint.setPrintText(NbBundle.getBundle((Class)ToggleBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
        debuggerManager.addBreakpoint((Breakpoint)lineBreakpoint);
    }

    private BreakpointAnnotationListener getBreakpointAnnotationListener() {
        if (this.breakpointAnnotationListener == null) {
            this.breakpointAnnotationListener = (BreakpointAnnotationListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, BreakpointAnnotationListener.class));
        }
        return this.breakpointAnnotationListener;
    }
}

