/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(string.equals(LineBreakpoint.PROP_CONDITION) || string.equals(LineBreakpoint.PROP_URL) || string.equals(LineBreakpoint.PROP_LINE_NUMBER) || string.equals("enabled"))) {
            return;
        }
        LineBreakpoint lineBreakpoint = (LineBreakpoint)propertyChangeEvent.getSource();
        this.annotate(lineBreakpoint);
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            ((LineBreakpoint)breakpoint).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((LineBreakpoint)breakpoint);
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            ((LineBreakpoint)breakpoint).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((LineBreakpoint)breakpoint);
        }
    }

    public LineBreakpoint findBreakpoint(String string, int n) {
        Iterator iterator = this.breakpointToAnnotation.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            int n2;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)iterator.next();
            if (!lineBreakpoint.getURL().equals(string) || (n2 = EditorContextBridge.getLineNumber(v = this.breakpointToAnnotation.get(lineBreakpoint), null)) != n) continue;
            return lineBreakpoint;
        }
        return null;
    }

    private void annotate(LineBreakpoint lineBreakpoint) {
        Object object = this.breakpointToAnnotation.get(lineBreakpoint);
        if (object != null) {
            EditorContextBridge.removeAnnotation(object);
        }
        if (lineBreakpoint.isHidden()) {
            return;
        }
        object = EditorContextBridge.annotate(lineBreakpoint);
        if (object == null) {
            return;
        }
        this.breakpointToAnnotation.put(lineBreakpoint, object);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object object2 = null;
        if (debuggerEngine != null) {
            object2 = debuggerEngine.lookupFirst(null, JPDADebugger.class);
        }
        this.update(lineBreakpoint, object2);
    }

    public void updateLineBreakpoints() {
        Iterator iterator = this.breakpointToAnnotation.keySet().iterator();
        while (iterator.hasNext()) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)iterator.next();
            this.update(lineBreakpoint, null);
        }
    }

    private void update(LineBreakpoint lineBreakpoint, Object object) {
        Object v = this.breakpointToAnnotation.get(lineBreakpoint);
        int n = EditorContextBridge.getLineNumber(v, object);
        this.listen = false;
        lineBreakpoint.setLineNumber(n);
        this.listen = true;
    }

    private void removeAnnotation(LineBreakpoint lineBreakpoint) {
        Object v = this.breakpointToAnnotation.remove(lineBreakpoint);
        if (v != null) {
            EditorContextBridge.removeAnnotation(v);
        }
    }
}

