/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClassBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ActionsPanel actionsPanel;
    private ClassLoadUnloadBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JComboBox cbBreakpointType;
    private JCheckBox cbExclusionFilter;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfClassName;
    private JTextField tfPackageName;

    private static ClassLoadUnloadBreakpoint creteBreakpoint() {
        ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = ClassLoadUnloadBreakpoint.create((String)EditorContextBridge.getCurrentClassName(), (boolean)false, (int)3);
        classLoadUnloadBreakpoint.setPrintText(NbBundle.getBundle((Class)ClassBreakpointPanel.class).getString("CTL_Class_Breakpoint_Print_Text"));
        return classLoadUnloadBreakpoint;
    }

    public ClassBreakpointPanel() {
        this(ClassBreakpointPanel.creteBreakpoint());
        this.createBreakpoint = true;
    }

    public ClassBreakpointPanel(ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint) {
        this.breakpoint = classLoadUnloadBreakpoint;
        this.initComponents();
        String[] stringArray = classLoadUnloadBreakpoint.getClassExclusionFilters();
        String string = "";
        if (stringArray.length > 0) {
            this.cbExclusionFilter.setSelected(true);
            string = stringArray[0];
        } else {
            this.cbExclusionFilter.setSelected(false);
            stringArray = classLoadUnloadBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            this.tfPackageName.setText("");
            this.tfClassName.setText(string);
        } else {
            this.tfPackageName.setText(string.substring(0, n));
            this.tfClassName.setText(string.substring(n + 1, string.length()));
        }
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Class_Breakpoint_Type_Prepare"));
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Class_Breakpoint_Type_Unload"));
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Class_Breakpoint_Type_Prepare_or_Unload"));
        switch (classLoadUnloadBreakpoint.getBreakpointType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)classLoadUnloadBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", "debug.add.breakpoint.java.class");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointClassJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tfPackageName = new JTextField();
        this.jLabel3 = new JLabel();
        this.tfClassName = new JTextField();
        this.cbExclusionFilter = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(new TitledBorder(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Class_Breakpoint_BorderTitle")));
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Class_Breakpoint_filter_hint"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Class_Breakpoint_filter_hint"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Class_Breakpoint_Package_Name").charAt(0));
        this.jLabel2.setLabelFor(this.tfPackageName);
        this.jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Class_Breakpoint_Package_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Class_Breakpoint_Package_Name"));
        this.tfPackageName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Class_Breakpoint_Package_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfPackageName, gridBagConstraints);
        this.tfPackageName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Class_Breakpoint_Package_Name"));
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Class_Breakpoint_Class_Name").charAt(0));
        this.jLabel3.setLabelFor(this.tfClassName);
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Class_Breakpoint_Class_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Class_Breakpoint_Class_Name"));
        this.tfClassName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Class_Breakpoint_Class_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfClassName, gridBagConstraints);
        this.tfClassName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Class_Breakpoint_Class_Name"));
        this.cbExclusionFilter.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_CB_Class_Breakpoint_Exclusion_Filter").charAt(0));
        this.cbExclusionFilter.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("CB_Class_Breakpoint_Exclusion_Filter"));
        this.cbExclusionFilter.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_CB_Class_Breakpoint_Exclusion_Filter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbExclusionFilter, gridBagConstraints);
        this.cbExclusionFilter.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_CB_Class_Breakpoint_Exclusion_Filter"));
        this.jLabel4.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Class_Breakpoint_Type").charAt(0));
        this.jLabel4.setLabelFor(this.cbBreakpointType);
        this.jLabel4.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ASCD_L_Class_Breakpoint_Type"));
        this.cbBreakpointType.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_CB_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_CB_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public boolean ok() {
        if (!this.isFilled()) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MSG_No_Class_Name_Spec"));
            return false;
        }
        this.actionsPanel.ok();
        String string = this.tfPackageName.getText().trim();
        if (string.length() > 0) {
            string = string + '.';
        }
        string = string + this.tfClassName.getText().trim();
        if (this.cbExclusionFilter.isSelected()) {
            this.breakpoint.setClassFilters(new String[0]);
            this.breakpoint.setClassExclusionFilters(new String[]{string});
        } else {
            this.breakpoint.setClassFilters(new String[]{string});
            this.breakpoint.setClassExclusionFilters(new String[0]);
        }
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setBreakpointType(1);
                break;
            }
            case 1: {
                this.breakpoint.setBreakpointType(2);
                break;
            }
            case 2: {
                this.breakpoint.setBreakpointType(3);
            }
        }
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    boolean isFilled() {
        return this.tfClassName.getText().trim().length() > 0;
    }
}

