/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExceptionBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ActionsPanel actionsPanel;
    private ExceptionBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private static Map exceptions = new TreeMap();
    private JComboBox cbBreakpointType;
    private JComboBox cbExceptionClassName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfCondition;
    private JTextField tfPackageName;

    private static ExceptionBreakpoint creteBreakpoint() {
        ExceptionBreakpoint exceptionBreakpoint = ExceptionBreakpoint.create((String)EditorContextBridge.getCurrentClassName(), (int)3);
        exceptionBreakpoint.setPrintText(NbBundle.getBundle((Class)ExceptionBreakpointPanel.class).getString("CTL_Exception_Breakpoint_Print_Text"));
        return exceptionBreakpoint;
    }

    public ExceptionBreakpointPanel() {
        this(ExceptionBreakpointPanel.creteBreakpoint());
        this.createBreakpoint = true;
    }

    public ExceptionBreakpointPanel(ExceptionBreakpoint exceptionBreakpoint) {
        this.breakpoint = exceptionBreakpoint;
        this.initComponents();
        Iterator iterator = exceptions.keySet().iterator();
        while (iterator.hasNext()) {
            this.cbExceptionClassName.addItem(iterator.next());
        }
        String string = exceptionBreakpoint.getExceptionClassName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            this.tfPackageName.setText("");
            this.cbExceptionClassName.setSelectedItem(string);
        } else {
            this.tfPackageName.setText(string.substring(0, n));
            this.cbExceptionClassName.setSelectedItem(string.substring(n + 1, string.length()));
        }
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Exception_Breakpoint_Type_Catched"));
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Exception_Breakpoint_Type_Uncatched"));
        this.cbBreakpointType.addItem(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("LBL_Exception_Breakpoint_Type_Catched_or_Uncatched"));
        switch (exceptionBreakpoint.getCatchType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.tfCondition.setText(exceptionBreakpoint.getCondition());
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)exceptionBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", "debug.add.breakpoint.java.exception");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointExceptionJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.jLabel5 = new JLabel();
        this.tfCondition = new JTextField();
        this.cbExceptionClassName = new JComboBox();
        this.tfPackageName = new JTextField();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(new TitledBorder(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Exception_Breakpoint_BorderTitle")));
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Exception_Breakpoint_filter_hint"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Exception_Breakpoint_filter_hint"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Exception_Breakpoint_Package_Name").charAt(0));
        this.jLabel2.setLabelFor(this.tfPackageName);
        this.jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Exception_Breakpoint_Package_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Exception_Breakpoint_Package_Name"));
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Exception_Breakpoint_Class_Name").charAt(0));
        this.jLabel3.setLabelFor(this.cbExceptionClassName);
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Exception_Breakpoint_Class_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Exception_Breakpoint_Class_Name"));
        this.jLabel4.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Exception_Breakpoint_Type").charAt(0));
        this.jLabel4.setLabelFor(this.cbBreakpointType);
        this.jLabel4.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Exception_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ASCD_L_Exception_Breakpoint_Type"));
        this.cbBreakpointType.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_CB_Exception_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_CB_Exception_Breakpoint_Type"));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Exception_Breakpoint_Condition").charAt(0));
        this.jLabel5.setLabelFor(this.tfCondition);
        this.jLabel5.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Exception_Breakpoint_Condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Exception_Breakpoint_Condition"));
        this.tfCondition.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Exception_Breakpoint_Condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfCondition, gridBagConstraints);
        this.tfCondition.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Exception_Breakpoint_Condition"));
        this.cbExceptionClassName.setEditable(true);
        this.cbExceptionClassName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_CB_Exception_Breakpoint_Class_Name"));
        this.cbExceptionClassName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionBreakpointPanel.this.cbExceptionClassNameActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbExceptionClassName, gridBagConstraints);
        this.cbExceptionClassName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_CB_Exception_Breakpoint_Class_Name"));
        this.tfPackageName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_CB_Exception_Breakpoint_Package_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfPackageName, gridBagConstraints);
        this.tfPackageName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Exception_Breakpoint_Package_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void cbExceptionClassNameActionPerformed(ActionEvent actionEvent) {
        String string = (String)exceptions.get(this.cbExceptionClassName.getSelectedItem());
        if (string != null) {
            this.tfPackageName.setText(string);
        }
    }

    public boolean ok() {
        if (!this.isFilled()) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MSG_No_Exception_Class_Name_Spec"));
            return false;
        }
        this.actionsPanel.ok();
        String string = this.tfPackageName.getText().trim();
        if (string.length() > 0) {
            string = string + '.';
        }
        string = string + ((String)this.cbExceptionClassName.getSelectedItem()).trim();
        this.breakpoint.setExceptionClassName(string);
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setCatchType(1);
                break;
            }
            case 1: {
                this.breakpoint.setCatchType(2);
                break;
            }
            case 2: {
                this.breakpoint.setCatchType(3);
            }
        }
        this.breakpoint.setCondition(this.tfCondition.getText());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    boolean isFilled() {
        return ((String)this.cbExceptionClassName.getSelectedItem()).trim().length() > 0;
    }

    static {
        exceptions.put("ArrayIndexOutOfBoundsException", "java.lang");
        exceptions.put("AssertionError", "java.lang");
        exceptions.put("ClassCastException", "java.lang");
        exceptions.put("ClassNotFoundException", "java.lang");
        exceptions.put("IllegalAccessException", "java.lang");
        exceptions.put("IllegalArgumentException", "java.lang");
        exceptions.put("IndexOutOfBoundsException", "java.lang");
        exceptions.put("NullPointerException", "java.lang");
        exceptions.put("RuntimeException", "java.lang");
        exceptions.put("SecurityException", "java.lang");
        exceptions.put("StringIndexOutOfBoundsException", "java.lang");
        exceptions.put("UnsupportedOperationException", "java.lang");
        exceptions.put("IOException", "java.io");
    }
}

