/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LineBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    private static LineBreakpoint createBreakpoint() {
        LineBreakpoint lineBreakpoint = LineBreakpoint.create((String)EditorContextBridge.getCurrentURL(), (int)EditorContextBridge.getCurrentLineNumber());
        lineBreakpoint.setPrintText(NbBundle.getBundle((Class)LineBreakpointPanel.class).getString("CTL_Line_Breakpoint_Print_Text"));
        return lineBreakpoint;
    }

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint) {
        this.breakpoint = lineBreakpoint;
        this.initComponents();
        String string = lineBreakpoint.getURL();
        try {
            URI uRI = new URI(string);
            this.tfFileName.setText(uRI.getPath());
        }
        catch (Exception exception) {
            this.tfFileName.setText(string);
        }
        this.tfLineNumber.setText(Integer.toString(lineBreakpoint.getLineNumber()));
        this.tfCondition.setText(lineBreakpoint.getCondition());
        this.setupConditionPane();
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)lineBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private static int findNumLines(String string) {
        DataObject dataObject;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return 0;
        }
        if (fileObject == null) {
            return 0;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return 0;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return 0;
        }
        editorCookie.prepareDocument().waitFinished();
        StyledDocument styledDocument = editorCookie.getDocument();
        if (!(styledDocument instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument styledDocument2 = styledDocument;
        return NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getLength());
    }

    private void setupConditionPane() {
        this.tfCondition.setKeymap(new FilteredKeymap(this.tfCondition.getKeymap()));
        String string = this.breakpoint.getURL();
        DataObject dataObject = null;
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (fileObject != null) {
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.tfCondition.getDocument().putProperty("stream", dataObject);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.tfFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfLineNumber = new JTextField();
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(new TitledBorder(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Line_Breakpoint_BorderTitle")));
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_File_Name").charAt(0));
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Line_Breakpoint_File_Name"));
        this.jLabel3.setLabelFor(this.tfFileName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_Condition").charAt(0));
        this.jLabel5.setLabelFor(this.tfCondition);
        this.jLabel5.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Line_Breakpoint_Condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_Condition"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Line_Breakpoint_File_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_Line_Number").charAt(0));
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Line_Breakpoint_Line_Number"));
        this.jLabel1.setLabelFor(this.tfLineNumber);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName("Line number");
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        this.spCondition.setHorizontalScrollBarPolicy(31);
        this.spCondition.setToolTipText(NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"ACSD_TF_Line_Breakpoint_Condition"));
        this.tfCondition.setToolTipText(NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"ACSD_TF_Line_Breakpoint_Condition"));
        this.tfCondition.setContentType("text/x-java");
        this.spCondition.setViewportView(this.tfCondition);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.spCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        this.breakpoint.setLineNumber(Integer.parseInt(this.tfLineNumber.getText().trim()));
        this.breakpoint.setCondition(this.tfCondition.getText());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String valiadateMsg() {
        try {
            int n = Integer.parseInt(this.tfLineNumber.getText().trim());
            if (n <= 0) {
                return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec");
            }
            int n2 = LineBreakpointPanel.findNumLines(this.breakpoint.getURL());
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n > n2) {
                return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(n), (Object)Integer.toString(n2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec");
        }
        return null;
    }
}

