/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MethodBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ActionsPanel actionsPanel;
    private MethodBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JCheckBox cbAllMethods;
    private JCheckBox cbInnerClasses;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfClassName;
    private JTextField tfCondition;
    private JTextField tfMethodName;
    private JTextField tfPackageName;

    private static MethodBreakpoint creteBreakpoint() {
        MethodBreakpoint methodBreakpoint = MethodBreakpoint.create((String)EditorContextBridge.getCurrentClassName(), (String)EditorContextBridge.getCurrentMethodName());
        methodBreakpoint.setPrintText(NbBundle.getBundle((Class)MethodBreakpointPanel.class).getString("CTL_Method_Breakpoint_Print_Text"));
        return methodBreakpoint;
    }

    public MethodBreakpointPanel() {
        this(MethodBreakpointPanel.creteBreakpoint());
        this.createBreakpoint = true;
    }

    public MethodBreakpointPanel(MethodBreakpoint methodBreakpoint) {
        int n;
        this.breakpoint = methodBreakpoint;
        this.initComponents();
        String string = "";
        String[] stringArray = methodBreakpoint.getClassFilters();
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if ((n = string.lastIndexOf(46)) < 0) {
            this.tfPackageName.setText("");
            this.tfClassName.setText(string);
        } else {
            this.tfPackageName.setText(string.substring(0, n));
            this.tfClassName.setText(string.substring(n + 1, string.length()));
        }
        if (methodBreakpoint.getMethodName().equals("")) {
            this.tfMethodName.setText("<all methods>");
            this.cbAllMethods.setSelected(true);
            this.tfMethodName.setEnabled(false);
        } else if (methodBreakpoint.getMethodName().equals(this.tfClassName.getText())) {
            this.tfMethodName.setText("<init>");
        } else {
            this.tfMethodName.setText(methodBreakpoint.getMethodName());
        }
        this.tfCondition.setText(methodBreakpoint.getCondition());
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)methodBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", "debug.add.breakpoint.java.method");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointMethodJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.tfCondition = new JTextField();
        this.tfPackageName = new JTextField();
        this.tfClassName = new JTextField();
        this.cbInnerClasses = new JCheckBox();
        this.cbAllMethods = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.tfMethodName = new JTextField();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(new TitledBorder(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Method_Breakpoint_BorderTitle")));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Method_Breakpoint_Package_Name").charAt(0));
        this.jLabel2.setLabelFor(this.tfPackageName);
        this.jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Method_Breakpoint_Package_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Method_Breakpoint_Package_Name"));
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Method_Breakpoint_Class_Name").charAt(0));
        this.jLabel3.setLabelFor(this.tfClassName);
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Method_Breakpoint_Class_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Method_Breakpoint_Class_Name"));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Method_Breakpoint_Condition").charAt(0));
        this.jLabel5.setLabelFor(this.tfCondition);
        this.jLabel5.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Method_Breakpoint_Condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Method_Breakpoint_Condition"));
        this.tfCondition.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Method_Breakpoint_Condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfCondition, gridBagConstraints);
        this.tfCondition.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Method_Breakpoint_Condition"));
        this.tfPackageName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Method_Breakpoint_Package_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfPackageName, gridBagConstraints);
        this.tfPackageName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Method_Breakpoint_Package_Name"));
        this.tfClassName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Method_Breakpoint_Class_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfClassName, gridBagConstraints);
        this.tfClassName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Method_Breakpoint_Class_Name"));
        this.cbInnerClasses.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_CB_Method_Breakpoint_Inner_Classes").charAt(0));
        this.cbInnerClasses.setSelected(true);
        this.cbInnerClasses.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("CB_Method_Breakpoint_Inner_Classes"));
        this.cbInnerClasses.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_CB_Method_Breakpoint_Inner_Classes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbInnerClasses, gridBagConstraints);
        this.cbInnerClasses.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_CB_Method_Breakpoint_Inner_Classes"));
        this.cbAllMethods.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_CB_Method_Breakpoint_All_Methods").charAt(0));
        this.cbAllMethods.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("CB_Method_Breakpoint_All_Methods"));
        this.cbAllMethods.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_CB_Method_Breakpoint_All_Methods"));
        this.cbAllMethods.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodBreakpointPanel.this.cbAllMethodsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbAllMethods, gridBagConstraints);
        this.cbAllMethods.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_CB_Method_Breakpoint_All_Methods"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MN_L_Method_Breakpoint_Method_Name").charAt(0));
        this.jLabel1.setLabelFor(this.tfMethodName);
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("L_Method_Breakpoint_Method_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_L_Method_Breakpoint_Method_Name"));
        this.tfMethodName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("TTT_TF_Method_Breakpoint_Method_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfMethodName, gridBagConstraints);
        this.tfMethodName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("ACSD_TF_Method_Breakpoint_Method_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void cbAllMethodsActionPerformed(ActionEvent actionEvent) {
        if (this.cbAllMethods.isSelected()) {
            this.tfMethodName.setText("<all methods>");
            this.tfMethodName.setEnabled(false);
        } else {
            this.tfMethodName.setText("");
            this.tfMethodName.setEnabled(true);
        }
    }

    public boolean ok() {
        if (!this.isFilled()) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle").getString("MSG_No_Class_or_Method_Name_Spec"));
            return false;
        }
        this.actionsPanel.ok();
        String string = this.tfPackageName.getText().trim();
        if (string.length() > 0) {
            string = string + '.';
        }
        string = string + this.tfClassName.getText().trim();
        this.breakpoint.setClassFilters(new String[]{string});
        if (!this.cbAllMethods.isSelected()) {
            this.breakpoint.setMethodName(this.tfMethodName.getText().trim());
        } else {
            this.breakpoint.setMethodName("");
        }
        this.breakpoint.setCondition(this.tfCondition.getText());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    boolean isFilled() {
        return this.tfClassName.getText().trim().length() > 0 && (this.tfMethodName.getText().trim().length() > 0 || this.cbAllMethods.isSelected());
    }
}

