/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JPanel;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ExceptionBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.FieldBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.LineBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.MethodBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ThreadBreakpointPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BreakpointsActionsProvider
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.goToSource((LineBreakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_Customize_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BreakpointsActionsProvider.customize((Breakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    private static String loc(String string) {
        return NbBundle.getBundle((Class)BreakpointsActionsProvider.class).getString(string);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (!(object instanceof JPDABreakpoint)) {
            return nodeActionsProvider.getActions(object);
        }
        Action[] actionArray = nodeActionsProvider.getActions(object);
        if (object instanceof LineBreakpoint) {
            Action[] actionArray2 = new Action[actionArray.length + 3];
            actionArray2[0] = GO_TO_SOURCE_ACTION;
            actionArray2[1] = null;
            System.arraycopy(actionArray, 0, actionArray2, 2, actionArray.length);
            actionArray2[actionArray2.length - 1] = CUSTOMIZE_ACTION;
            return actionArray2;
        }
        Action[] actionArray3 = new Action[actionArray.length + 1];
        System.arraycopy(actionArray, 0, actionArray3, 0, actionArray.length);
        actionArray3[actionArray3.length - 1] = CUSTOMIZE_ACTION;
        return actionArray3;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            BreakpointsActionsProvider.goToSource((LineBreakpoint)object);
        } else if (object instanceof JPDABreakpoint) {
            BreakpointsActionsProvider.customize((Breakpoint)object);
        } else {
            nodeActionsProvider.performDefaultAction(object);
        }
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    public static void customize(Breakpoint breakpoint) {
        JPanel jPanel = null;
        if (breakpoint instanceof LineBreakpoint) {
            jPanel = new LineBreakpointPanel((LineBreakpoint)breakpoint);
        } else if (breakpoint instanceof FieldBreakpoint) {
            jPanel = new FieldBreakpointPanel((FieldBreakpoint)breakpoint);
        } else if (breakpoint instanceof ClassLoadUnloadBreakpoint) {
            jPanel = new ClassBreakpointPanel((ClassLoadUnloadBreakpoint)breakpoint);
        } else if (breakpoint instanceof MethodBreakpoint) {
            jPanel = new MethodBreakpointPanel((MethodBreakpoint)breakpoint);
        } else if (breakpoint instanceof ThreadBreakpoint) {
            jPanel = new ThreadBreakpointPanel((ThreadBreakpoint)breakpoint);
        } else if (breakpoint instanceof ExceptionBreakpoint) {
            jPanel = new ExceptionBreakpointPanel((ExceptionBreakpoint)breakpoint);
        }
        ((Component)jPanel).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BreakpointsActionsProvider.class, (String)"ACSD_Breakpoint_Customizer_Dialog"));
        HelpCtx helpCtx = HelpCtx.findHelp((Component)jPanel);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        final Controller[] controllerArray = new Controller[]{jPanel};
        final DialogDescriptor[] dialogDescriptorArray = new DialogDescriptor[1];
        final Dialog[] dialogArray = new Dialog[1];
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (dialogDescriptorArray[0].getValue() == DialogDescriptor.OK_OPTION) {
                    boolean bl = controllerArray[0].ok();
                    if (bl) {
                        dialogArray[0].setVisible(false);
                    }
                } else {
                    dialogArray[0].setVisible(false);
                }
            }
        };
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage((Class)BreakpointsActionsProvider.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, actionListener);
        dialogDescriptor.setClosingOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialogDescriptorArray[0] = dialogDescriptor;
        dialogArray[0] = dialog;
        dialog.setVisible(true);
    }

    private static void goToSource(LineBreakpoint lineBreakpoint) {
        EditorContextBridge.showSource(lineBreakpoint, null);
    }
}

