/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Vector;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsTreeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    private Vector listeners = new Vector();
    private static final String ZEROS = "            ";
    private JPDABreakpoint currentBreakpoint;

    static int log10(int n) {
        int n2 = 1;
        while ((n /= 10) > 0) {
            ++n2;
        }
        return n2;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String string = ZEROS;
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            int n;
            int n2;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)object;
            int n3 = lineBreakpoint.getLineNumber();
            String string = Integer.toString(n3);
            Integer n4 = (Integer)BreakpointsTreeModelFilter.MAX_LINES.get(lineBreakpoint);
            if (n4 != null && (n2 = BreakpointsNodeModel.log10(n = n4.intValue()) - BreakpointsNodeModel.log10(n3)) > 0) {
                string = BreakpointsNodeModel.zeros(n2) + string;
            }
            return this.bold((JPDABreakpoint)lineBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(lineBreakpoint), (Object)string));
        }
        if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint threadBreakpoint = (ThreadBreakpoint)object;
            if (threadBreakpoint.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)threadBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint"));
            }
            if (threadBreakpoint.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)threadBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint"));
            }
            return this.bold((JPDABreakpoint)threadBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint"));
        }
        if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)object;
            if (fieldBreakpoint.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)fieldBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)BreakpointsNodeModel.getShort(fieldBreakpoint.getClassName()), (Object)fieldBreakpoint.getFieldName()));
            }
            return this.bold((JPDABreakpoint)fieldBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)BreakpointsNodeModel.getShort(fieldBreakpoint.getClassName()), (Object)fieldBreakpoint.getFieldName()));
        }
        if (object instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)object;
            String string = "";
            String[] stringArray = methodBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (methodBreakpoint.getMethodName().equals("")) {
                return this.bold((JPDABreakpoint)methodBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            return this.bold((JPDABreakpoint)methodBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)BreakpointsNodeModel.getShort(string), (Object)methodBreakpoint.getMethodName()));
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)object;
            String string = "";
            String[] stringArray = classLoadUnloadBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string = stringArray[0];
            } else {
                stringArray = classLoadUnloadBreakpoint.getClassExclusionFilters();
                if (stringArray.length > 0) {
                    string = stringArray[0];
                }
            }
            if (classLoadUnloadBreakpoint.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)classLoadUnloadBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            if (classLoadUnloadBreakpoint.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)classLoadUnloadBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            return this.bold((JPDABreakpoint)classLoadUnloadBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
        }
        if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)object;
            if (exceptionBreakpoint.getCatchType() == 1) {
                return this.bold((JPDABreakpoint)exceptionBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)BreakpointsNodeModel.getShort(exceptionBreakpoint.getExceptionClassName())));
            }
            if (exceptionBreakpoint.getCatchType() == 2) {
                return this.bold((JPDABreakpoint)exceptionBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)BreakpointsNodeModel.getShort(exceptionBreakpoint.getExceptionClassName())));
            }
            return this.bold((JPDABreakpoint)exceptionBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)BreakpointsNodeModel.getShort(exceptionBreakpoint.getExceptionClassName())));
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)object), (Object)("" + ((LineBreakpoint)object).getLineNumber()));
        }
        if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint threadBreakpoint = (ThreadBreakpoint)object;
            if (threadBreakpoint.getBreakpointType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint");
            }
            if (threadBreakpoint.getBreakpointType() == 2) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint");
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint");
        }
        if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)object;
            if (fieldBreakpoint.getBreakpointType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)fieldBreakpoint.getClassName(), (Object)fieldBreakpoint.getFieldName());
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)fieldBreakpoint.getClassName(), (Object)fieldBreakpoint.getFieldName());
        }
        if (object instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)object;
            String string = "";
            String[] stringArray = methodBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (methodBreakpoint.getMethodName().equals("")) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)string);
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)string, (Object)methodBreakpoint.getMethodName());
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)object;
            String string = "";
            String[] stringArray = classLoadUnloadBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string = stringArray[0];
            } else {
                stringArray = classLoadUnloadBreakpoint.getClassExclusionFilters();
                if (stringArray.length > 0) {
                    string = stringArray[0];
                }
            }
            if (classLoadUnloadBreakpoint.getBreakpointType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)string);
            }
            if (classLoadUnloadBreakpoint.getBreakpointType() == 2) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)string);
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)string);
        }
        if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)object;
            if (exceptionBreakpoint.getCatchType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)exceptionBreakpoint.getExceptionClassName());
            }
            if (exceptionBreakpoint.getCatchType() == 2) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)exceptionBreakpoint.getExceptionClassName());
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)exceptionBreakpoint.getExceptionClassName());
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            return LINE_BREAKPOINT;
        }
        if (object instanceof ThreadBreakpoint) {
            return BREAKPOINT;
        }
        if (object instanceof FieldBreakpoint) {
            return BREAKPOINT;
        }
        if (object instanceof MethodBreakpoint) {
            return BREAKPOINT;
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            return BREAKPOINT;
        }
        if (object instanceof ExceptionBreakpoint) {
            return BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    void fireNodeChanged(JPDABreakpoint jPDABreakpoint) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)jPDABreakpoint));
        }
    }

    static String getShort(String string) {
        if (string.indexOf(42) >= 0) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private String bold(JPDABreakpoint jPDABreakpoint, String string) {
        return jPDABreakpoint == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(string, true, false, null) : string;
    }

    public void setCurrentBreakpoint(JPDABreakpoint jPDABreakpoint) {
        if (this.currentBreakpoint != null) {
            this.fireNodeChanged(this.currentBreakpoint);
        }
        this.currentBreakpoint = jPDABreakpoint;
        if (jPDABreakpoint != null) {
            this.fireNodeChanged(jPDABreakpoint);
        }
    }
}

