/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class CallStackActionsProvider
implements NodeActionsProvider {
    private final Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle((Class)ThreadsActionsProvider.class).getString("CTL_CallstackAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            CallStackActionsProvider.this.makeCurrent((CallStackFrame)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action POP_TO_HERE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)ThreadsActionsProvider.class).getString("CTL_CallstackAction_PopToHere_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            CallStackActionsProvider.popToHere((CallStackFrame)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private JPDADebugger debugger;
    private ContextProvider lookupProvider;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$ui$SourcePath;

    public CallStackActionsProvider(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[0];
        }
        if (!(object instanceof CallStackFrame)) {
            throw new UnknownTypeException(object);
        }
        boolean bl = this.debugger.canPopFrames();
        if (bl) {
            return new Action[]{this.MAKE_CURRENT_ACTION, POP_TO_HERE_ACTION};
        }
        return new Action[]{this.MAKE_CURRENT_ACTION};
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof CallStackFrame) {
            this.makeCurrent((CallStackFrame)object);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private static void popToHere(CallStackFrame callStackFrame) {
        try {
            JPDAThread jPDAThread = callStackFrame.getThread();
            CallStackFrame[] callStackFrameArray = jPDAThread.getCallStack();
            int n = callStackFrameArray.length;
            if (n < 2) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                if (!callStackFrameArray[i].equals(callStackFrame)) continue;
                if (i > 0) {
                    callStackFrameArray[i - 1].popFrame();
                }
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    private void makeCurrent(final CallStackFrame callStackFrame) {
        if (this.debugger.getCurrentCallStackFrame() != callStackFrame) {
            callStackFrame.makeCurrent();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
                    SourcePath sourcePath = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, class$org$netbeans$modules$debugger$jpda$ui$SourcePath == null ? (class$org$netbeans$modules$debugger$jpda$ui$SourcePath = CallStackActionsProvider.class$("org.netbeans.modules.debugger.jpda.ui.SourcePath")) : class$org$netbeans$modules$debugger$jpda$ui$SourcePath);
                    sourcePath.showSource(callStackFrame, string);
                }
            });
        }
    }
}

