/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.HashSet;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.jpda.VariablesFilterAdapter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;

public class JavaVariablesFilter
extends VariablesFilterAdapter {
    private static HashSet getValueType;
    private static HashSet leafType;
    private static HashSet toStringValueType;
    private static HashSet mapEntryType;
    private static HashSet mapMapType;
    private static HashSet toArrayType;

    public String[] getSupportedTypes() {
        return new String[]{"java.lang.String", "java.lang.StringBuffer", "java.lang.Character", "java.lang.Integer", "java.lang.Float", "java.lang.Byte", "java.lang.Boolean", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.lang.ref.WeakReference", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.Stack", "java.util.TreeSet", "java.util.Vector", "java.util.Hashtable", "java.util.Hashtable$Entry", "java.util.HashMap", "java.util.HashMap$Entry", "java.util.IdentityHashMap", "java.util.AbstractMap$SimpleEntry", "java.util.TreeMap", "java.util.TreeMap$Entry", "java.util.WeakHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry", "java.beans.PropertyChangeSupport"};
    }

    public String[] getSupportedAncestors() {
        return new String[0];
    }

    public Object[] getChildren(TreeModel treeModel, Variable variable, int n, int n2) throws UnknownTypeException {
        ObjectVariable objectVariable;
        String string = variable.getType();
        if (JavaVariablesFilter.isToArrayType(string)) {
            try {
                ObjectVariable objectVariable2 = (ObjectVariable)variable;
                objectVariable2 = (ObjectVariable)objectVariable2.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return treeModel.getChildren((Object)objectVariable2, n, n2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return treeModel.getChildren((Object)variable, n, n2);
                }
                ErrorManager.getDefault().notify((Throwable)invalidExpressionException);
            }
        }
        if (JavaVariablesFilter.isMapMapType(string)) {
            try {
                objectVariable = (ObjectVariable)variable;
                objectVariable = (ObjectVariable)objectVariable.invokeMethod("entrySet", "()Ljava/util/Set;", new Variable[0]);
                objectVariable = (ObjectVariable)objectVariable.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return treeModel.getChildren((Object)objectVariable, n, n2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return treeModel.getChildren((Object)variable, n, n2);
                }
                ErrorManager.getDefault().notify((Throwable)invalidExpressionException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
        }
        if (JavaVariablesFilter.isMapEntryType(string)) {
            objectVariable = (ObjectVariable)variable;
            Object[] objectArray = new Field[]{objectVariable.getField("key"), objectVariable.getField("value")};
            return objectArray;
        }
        if (string.equals("java.beans.PropertyChangeSupport")) {
            try {
                objectVariable = (ObjectVariable)variable;
                return ((ObjectVariable)objectVariable.invokeMethod("getPropertyChangeListeners", "()[Ljava/beans/PropertyChangeListener;", new Variable[0])).getFields(n, n2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return treeModel.getChildren((Object)variable, n, n2);
                }
                ErrorManager.getDefault().notify((Throwable)invalidExpressionException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
        }
        if (string.equals("java.lang.ref.WeakReference")) {
            objectVariable = (ObjectVariable)variable;
            return new Object[]{objectVariable.getField("referent")};
        }
        return treeModel.getChildren((Object)variable, n, n2);
    }

    public int getChildrenCount(TreeModel treeModel, Variable variable) throws UnknownTypeException {
        String string = variable.getType();
        if (JavaVariablesFilter.isToArrayType(string)) {
            try {
                ObjectVariable objectVariable = (ObjectVariable)variable;
                objectVariable = (ObjectVariable)objectVariable.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return treeModel.getChildrenCount((Object)objectVariable);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return treeModel.getChildrenCount((Object)variable);
                }
                ErrorManager.getDefault().notify((Throwable)invalidExpressionException);
            }
        } else if (JavaVariablesFilter.isMapMapType(string)) {
            try {
                ObjectVariable objectVariable = (ObjectVariable)variable;
                objectVariable = (ObjectVariable)objectVariable.invokeMethod("entrySet", "()Ljava/util/Set;", new Variable[0]);
                objectVariable = (ObjectVariable)objectVariable.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                return treeModel.getChildrenCount((Object)objectVariable);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return treeModel.getChildrenCount((Object)variable);
                }
                ErrorManager.getDefault().notify((Throwable)invalidExpressionException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
        } else {
            if (JavaVariablesFilter.isMapEntryType(string)) {
                return 2;
            }
            if (string.equals("java.beans.PropertyChangeSupport")) {
                return this.getChildren(treeModel, variable, 0, 0).length;
            }
            if (string.equals("java.lang.ref.WeakReference")) {
                return 1;
            }
        }
        return treeModel.getChildrenCount((Object)variable);
    }

    public boolean isLeaf(TreeModel treeModel, Variable variable) throws UnknownTypeException {
        String string = variable.getType();
        if (JavaVariablesFilter.isLeafType(string)) {
            return true;
        }
        return treeModel.isLeaf((Object)variable);
    }

    public Object getValueAt(TableModel tableModel, Variable variable, String string) throws UnknownTypeException {
        String string2 = variable.getType();
        ObjectVariable objectVariable = (ObjectVariable)variable;
        if (JavaVariablesFilter.isMapEntryType(string2) && (string == "LocalsValue" || string == "WatchValue")) {
            return objectVariable.getField("key").getValue() + "=>" + objectVariable.getField("value").getValue();
        }
        if (JavaVariablesFilter.isGetValueType(string2) && (string == "LocalsValue" || string == "WatchValue")) {
            return objectVariable.getField("value").getValue();
        }
        if (JavaVariablesFilter.isToStringValueType(string2) && (string == "LocalsValue" || string == "WatchValue")) {
            try {
                return objectVariable.getToStringValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return tableModel.getValueAt((Object)variable, string);
                }
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        return tableModel.getValueAt((Object)variable, string);
    }

    private static boolean isGetValueType(String string) {
        if (getValueType == null) {
            getValueType = new HashSet();
            getValueType.add("java.lang.Character");
            getValueType.add("java.lang.Integer");
            getValueType.add("java.lang.Float");
            getValueType.add("java.lang.Byte");
            getValueType.add("java.lang.Boolean");
            getValueType.add("java.lang.Double");
            getValueType.add("java.lang.Long");
            getValueType.add("java.lang.Short");
        }
        return getValueType.contains(string);
    }

    private static boolean isLeafType(String string) {
        if (leafType == null) {
            leafType = new HashSet();
            leafType.add("java.lang.String");
            leafType.add("java.lang.Character");
            leafType.add("java.lang.Integer");
            leafType.add("java.lang.Float");
            leafType.add("java.lang.Byte");
            leafType.add("java.lang.Boolean");
            leafType.add("java.lang.Double");
            leafType.add("java.lang.Long");
            leafType.add("java.lang.Short");
        }
        return leafType.contains(string);
    }

    private static boolean isToStringValueType(String string) {
        if (toStringValueType == null) {
            toStringValueType = new HashSet();
            toStringValueType.add("java.lang.StringBuffer");
        }
        return toStringValueType.contains(string);
    }

    private static boolean isMapEntryType(String string) {
        if (mapEntryType == null) {
            mapEntryType = new HashSet();
            mapEntryType.add("java.util.HashMap$Entry");
            mapEntryType.add("java.util.Hashtable$Entry");
            mapEntryType.add("java.util.AbstractMap$SimpleEntry");
            mapEntryType.add("java.util.LinkedHashMap$Entry");
            mapEntryType.add("java.util.TreeMap$Entry");
        }
        return mapEntryType.contains(string);
    }

    private static boolean isMapMapType(String string) {
        if (mapMapType == null) {
            mapMapType = new HashSet();
            mapMapType.add("java.util.HashMap");
            mapMapType.add("java.util.IdentityHashMap");
            mapMapType.add("java.util.Hashtable");
            mapMapType.add("java.util.TreeMap");
            mapMapType.add("java.util.WeakHashMap");
            mapMapType.add("java.util.LinkedHashMap");
            mapMapType.add("java.util.concurrent.ConcurrentHashMap");
            mapMapType.add("java.util.EnumMap");
        }
        return mapMapType.contains(string);
    }

    private static boolean isToArrayType(String string) {
        if (toArrayType == null) {
            toArrayType = new HashSet();
            toArrayType.add("java.util.ArrayList");
            toArrayType.add("java.util.HashSet");
            toArrayType.add("java.util.LinkedHashSet");
            toArrayType.add("java.util.LinkedList");
            toArrayType.add("java.util.Stack");
            toArrayType.add("java.util.TreeSet");
            toArrayType.add("java.util.Vector");
            toArrayType.add("java.util.concurrent.CopyOnWriteArraySet");
            toArrayType.add("java.util.EnumSet");
        }
        return toArrayType.contains(string);
    }
}

