/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NumericDisplayFilter
implements TableModelFilter,
NodeActionsProviderFilter,
Constants {
    private final Map variableToDisplaySettings = new HashMap();
    private HashSet listeners;

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if ((string == "WatchValue" || string == "LocalsValue") && object instanceof Variable && this.isIntegralType((Variable)object)) {
            Variable variable = (Variable)object;
            return this.getValue(variable, (NumericDisplaySettings)this.variableToDisplaySettings.get(variable));
        }
        return tableModel.getValueAt(object, string);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        return tableModel.isReadOnly(object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        tableModel.setValueAt(object, string, object2);
    }

    public void addModelListener(ModelListener modelListener) {
        HashSet hashSet = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        hashSet.add(modelListener);
        this.listeners = hashSet;
    }

    public void removeModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            return;
        }
        HashSet hashSet = (HashSet)this.listeners.clone();
        hashSet.remove(modelListener);
        this.listeners = hashSet;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Variable variable;
        Action[] actionArray;
        if (!(object instanceof Variable)) {
            return nodeActionsProvider.getActions(object);
        }
        try {
            actionArray = nodeActionsProvider.getActions(object);
        }
        catch (UnknownTypeException unknownTypeException) {
            actionArray = new Action[]{};
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (object instanceof Variable && this.isIntegralType(variable = (Variable)object)) {
            arrayList.add(new DisplayAsAction((Variable)object));
        }
        arrayList.addAll(Arrays.asList(actionArray));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private Object getValue(Variable variable, NumericDisplaySettings numericDisplaySettings) {
        if (numericDisplaySettings == null) {
            return variable.getValue();
        }
        String string = variable.getType();
        switch (numericDisplaySettings.getDisplayAs()) {
            case 0: {
                return variable.getValue();
            }
            case 1: {
                if (string.equals("int")) {
                    return "0x" + Integer.toHexString(Integer.parseInt(variable.getValue()));
                }
                if (string.equals("short")) {
                    String string2 = Integer.toHexString(Short.parseShort(variable.getValue()));
                    if (string2.length() > 4) {
                        string2 = string2.substring(string2.length() - 4, string2.length());
                    }
                    return "0x" + string2;
                }
                if (string.equals("byte")) {
                    String string3 = Integer.toHexString(Byte.parseByte(variable.getValue()));
                    if (string3.length() > 2) {
                        string3 = string3.substring(string3.length() - 2, string3.length());
                    }
                    return "0x" + string3;
                }
                return "0x" + Long.toHexString(Long.parseLong(variable.getValue()));
            }
            case 2: {
                if (string.equals("int")) {
                    return "0" + Integer.toOctalString(Integer.parseInt(variable.getValue()));
                }
                if (string.equals("short")) {
                    String string4 = Integer.toOctalString(Short.parseShort(variable.getValue()));
                    if (string4.length() > 5) {
                        string4 = string4.substring(string4.length() - 5, string4.length());
                    }
                    return "0" + (string4.charAt(0) == '0' ? "1" : "") + string4;
                }
                if (string.equals("byte")) {
                    String string5 = Integer.toOctalString(Byte.parseByte(variable.getValue()));
                    if (string5.length() > 3) {
                        string5 = "1" + string5.substring(string5.length() - 2, string5.length());
                    }
                    return "0" + string5;
                }
                return "0" + Long.toOctalString(Long.parseLong(variable.getValue()));
            }
            case 3: {
                if (string.equals("int")) {
                    return Integer.toBinaryString(Integer.parseInt(variable.getValue()));
                }
                if (string.equals("short")) {
                    String string6 = Integer.toBinaryString(Short.parseShort(variable.getValue()));
                    if (string6.length() > 16) {
                        string6 = string6.substring(string6.length() - 16, string6.length());
                    }
                    return string6;
                }
                if (string.equals("byte")) {
                    String string7 = Integer.toBinaryString(Byte.parseByte(variable.getValue()));
                    if (string7.length() > 8) {
                        string7 = string7.substring(string7.length() - 8, string7.length());
                    }
                    return string7;
                }
                return Long.toBinaryString(Long.parseLong(variable.getValue()));
            }
            case 4: {
                try {
                    return "'" + new Character((char)Integer.parseInt(variable.getValue())) + "'";
                }
                catch (Exception exception) {
                    return "?";
                }
            }
        }
        return variable.getValue();
    }

    private boolean isIntegralType(Variable variable) {
        if (!VariablesTreeModelFilter.isEvaluated(variable)) {
            return false;
        }
        String string = variable.getType();
        return string != null && (string.equals("int") || string.equals("char") || string.equals("byte") || string.equals("long") || string.equals("short"));
    }

    private String localize(String string) {
        return NbBundle.getBundle((Class)NumericDisplayFilter.class).getString(string);
    }

    private static class NumericDisplaySettings {
        public static final int DECIMAL = 0;
        public static final int HEXADECIMAL = 1;
        public static final int OCTAL = 2;
        public static final int BINARY = 3;
        public static final int CHAR = 4;
        private int displayAs;

        public NumericDisplaySettings(int n) {
            this.displayAs = n;
        }

        public int getDisplayAs() {
            return this.displayAs;
        }
    }

    private class DisplayAsAction
    extends AbstractAction
    implements Presenter.Popup {
        private Variable variable;

        public DisplayAsAction(Variable variable) {
            this.variable = variable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Popup"));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(this, NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Decimal")){
                private final /* synthetic */ DisplayAsAction this$1;
                {
                    this.this$1 = displayAsAction;
                    super(string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.access$100(this.this$1, 0);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new AbstractAction(this, NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Hexadecimal")){
                private final /* synthetic */ DisplayAsAction this$1;
                {
                    this.this$1 = displayAsAction;
                    super(string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.access$100(this.this$1, 1);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new AbstractAction(this, NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Octal")){
                private final /* synthetic */ DisplayAsAction this$1;
                {
                    this.this$1 = displayAsAction;
                    super(string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.access$100(this.this$1, 2);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(new AbstractAction(this, NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Binary")){
                private final /* synthetic */ DisplayAsAction this$1;
                {
                    this.this$1 = displayAsAction;
                    super(string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.access$100(this.this$1, 3);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem(new AbstractAction(this, NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Character")){
                private final /* synthetic */ DisplayAsAction this$1;
                {
                    this.this$1 = displayAsAction;
                    super(string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.access$100(this.this$1, 4);
                }
            });
            NumericDisplaySettings numericDisplaySettings = (NumericDisplaySettings)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable);
            if (numericDisplaySettings != null) {
                switch (numericDisplaySettings.getDisplayAs()) {
                    case 0: {
                        jRadioButtonMenuItem.setSelected(true);
                        break;
                    }
                    case 1: {
                        jRadioButtonMenuItem2.setSelected(true);
                        break;
                    }
                    case 2: {
                        jRadioButtonMenuItem3.setSelected(true);
                        break;
                    }
                    case 3: {
                        jRadioButtonMenuItem4.setSelected(true);
                        break;
                    }
                    case 4: {
                        jRadioButtonMenuItem5.setSelected(true);
                    }
                }
            } else {
                jRadioButtonMenuItem.setSelected(true);
            }
            jMenu.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem2);
            jMenu.add(jRadioButtonMenuItem3);
            jMenu.add(jRadioButtonMenuItem4);
            jMenu.add(jRadioButtonMenuItem5);
            return jMenu;
        }

        private void onDisplayAs(int n) {
            NumericDisplaySettings numericDisplaySettings = (NumericDisplaySettings)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable);
            if (numericDisplaySettings == null) {
                numericDisplaySettings = new NumericDisplaySettings(0);
            }
            if (numericDisplaySettings.getDisplayAs() == n) {
                return;
            }
            NumericDisplayFilter.this.variableToDisplaySettings.put(this.variable, new NumericDisplaySettings(n));
            this.fireModelChanged();
        }

        private void fireModelChanged() {
            if (NumericDisplayFilter.this.listeners == null) {
                return;
            }
            ModelEvent.TableValueChanged tableValueChanged = new ModelEvent.TableValueChanged((Object)this, (Object)this.variable, null);
            Iterator iterator = NumericDisplayFilter.this.listeners.iterator();
            while (iterator.hasNext()) {
                ModelListener modelListener = (ModelListener)iterator.next();
                modelListener.modelChanged((ModelEvent)tableValueChanged);
            }
        }

        static /* synthetic */ void access$100(DisplayAsAction displayAsAction, int n) {
            displayAsAction.onDisplayAs(n);
        }
    }
}

