/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class SessionsTableModel
implements TableModel,
Constants,
PropertyChangeListener {
    private Vector listeners = new Vector();
    private static final Integer SD = new Integer(4);

    private static String loc(String string) {
        return NbBundle.getBundle((Class)SessionsTableModel.class).getString(string);
    }

    public SessionsTableModel(ContextProvider contextProvider) {
        JPDADebugger jPDADebugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        jPDADebugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof Session) {
            if (string.equals("SessionState")) {
                return SessionsTableModel.getSessionState((Session)object);
            }
            if (string.equals("SessionLanguage")) {
                return object;
            }
            if (string.equals("SessionHostName")) {
                return ((Session)object).getLocationName();
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof Session) {
            if (string.equals("SessionState")) {
                return true;
            }
            if (string.equals("SessionLanguage")) {
                return false;
            }
            if (string.equals("SessionHostName")) {
                return true;
            }
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    private static String getSessionState(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return SessionsTableModel.loc("MSG_Session_State_Starting");
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        switch (jPDADebugger.getState()) {
            case 4: {
                return SessionsTableModel.loc("MSG_Session_State_Disconnected");
            }
            case 2: {
                return SessionsTableModel.loc("MSG_Session_State_Running");
            }
            case 1: {
                return SessionsTableModel.loc("MSG_Session_State_Starting");
            }
            case 3: {
                return SessionsTableModel.loc("MSG_Session_State_Stopped");
            }
        }
        return null;
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireTreeChanged();
        if (propertyChangeEvent.getNewValue().equals(SD)) {
            ((JPDADebugger)propertyChangeEvent.getSource()).removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
    }
}

