/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SourcesModel
implements TreeModel,
TableModel,
NodeActionsProvider {
    private static final String FILTER_PREFIX = "Do not stop in: ";
    private static final String DISP_FILTER_PREFIX = NbBundle.getBundle((Class)SourcesModel.class).getString("CTL_SourcesModel_Name_DoNotStopIn");
    private Listener listener;
    private SourcePath sourcePath;
    private JPDADebugger debugger;
    private Vector listeners = new Vector();
    private Set filters = new HashSet();
    private Set enabledFilters = new HashSet();
    private Set enabledSourceRoots = new HashSet();
    private Set disabledSourceRoots = new HashSet();
    private Properties filterProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private final Action NEW_FILTER_ACTION = new AbstractAction(NbBundle.getBundle((Class)SourcesModel.class).getString("CTL_SourcesModel_Action_AddFilter")){

        public void actionPerformed(ActionEvent actionEvent) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_NewFilter_Filter_Label"), NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_NewFilter_Title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
                String string = inputLine.getInputText();
                SourcesModel.this.filters.add(string);
                SourcesModel.this.enabledFilters.add(string);
                SourcesModel.this.debugger.getSmartSteppingFilter().addExclusionPatterns(Collections.singleton(string));
                SourcesModel.this.saveFilters();
                SourcesModel.this.fireTreeChanged();
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)SourcesModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                SourcesModel.this.filters.remove(((String)objectArray[i]).substring(DISP_FILTER_PREFIX.length()));
                SourcesModel.this.enabledFilters.remove(((String)objectArray[i]).substring(DISP_FILTER_PREFIX.length()));
            }
            SourcesModel.this.saveFilters();
            SourcesModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn;

    public SourcesModel(ContextProvider contextProvider) {
        this.sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.loadFilters();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            String[] stringArray = this.sourcePath.getOriginalSourceRoots();
            String[] stringArray2 = new String[this.filters.size()];
            stringArray2 = this.filters.toArray(stringArray2);
            int n3 = stringArray2.length;
            for (int i = 0; i < n3; ++i) {
                stringArray2[i] = DISP_FILTER_PREFIX + stringArray2[i];
            }
            Object[] objectArray = new Object[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, objectArray, stringArray.length, stringArray2.length);
            n2 = Math.min(objectArray.length, n2);
            n = Math.min(objectArray.length, n);
            Object[] objectArray2 = new Object[n2 - n];
            System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return objectArray2;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return this.sourcePath.getOriginalSourceRoots().length + this.filters.size();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (string.equals("use") && object instanceof String) {
            return this.isEnabled((String)object);
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (string.equals("use") && object instanceof String) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (string.equals("use") && object instanceof String) {
            this.setEnabled((String)object, (Boolean)object2);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            if (((String)object).startsWith(DISP_FILTER_PREFIX)) {
                return new Action[]{this.NEW_FILTER_ACTION, this.DELETE_ACTION};
            }
            return new Action[]{this.NEW_FILTER_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    private boolean isEnabled(String string) {
        if (string.startsWith(DISP_FILTER_PREFIX)) {
            return this.enabledFilters.contains(string.substring(DISP_FILTER_PREFIX.length()));
        }
        String[] stringArray = this.sourcePath.getSourceRoots();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void setEnabled(String string, boolean bl) {
        if (string.startsWith(DISP_FILTER_PREFIX)) {
            String string2 = string.substring(DISP_FILTER_PREFIX.length());
            if (bl) {
                this.enabledFilters.add(string2);
                this.debugger.getSmartSteppingFilter().addExclusionPatterns(Collections.singleton(string2));
            } else {
                this.enabledFilters.remove(string2);
                this.debugger.getSmartSteppingFilter().removeExclusionPatterns(Collections.singleton(string2));
            }
            this.saveFilters();
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.sourcePath.getSourceRoots()));
        if (bl) {
            this.enabledSourceRoots.add(string);
            this.disabledSourceRoots.remove(string);
            hashSet.add(string);
        } else {
            this.disabledSourceRoots.add(string);
            this.enabledSourceRoots.remove(string);
            hashSet.remove(string);
        }
        String[] stringArray = new String[hashSet.size()];
        this.sourcePath.setSourceRoots(hashSet.toArray(stringArray));
        this.saveFilters();
    }

    private void loadFilters() {
        this.filters = new HashSet(this.filterProperties.getProperties("class_filters").getCollection("all", (Collection)Collections.EMPTY_SET));
        this.enabledFilters = new HashSet(this.filterProperties.getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        this.enabledSourceRoots = new HashSet(this.filterProperties.getProperties("source_roots").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        this.disabledSourceRoots = new HashSet(this.filterProperties.getProperties("source_roots").getCollection("disabled", (Collection)Collections.EMPTY_SET));
    }

    private void saveFilters() {
        this.filterProperties.getProperties("class_filters").setCollection("all", (Collection)this.filters);
        this.filterProperties.getProperties("class_filters").setCollection("enabled", (Collection)this.enabledFilters);
        this.filterProperties.getProperties("source_roots").setCollection("enabled", (Collection)this.enabledSourceRoots);
        this.filterProperties.getProperties("source_roots").setCollection("disabled", (Collection)this.disabledSourceRoots);
    }

    public static abstract class AbstractColumn
    extends ColumnModel {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public void setVisible(boolean bl) {
            this.properties.setBoolean(this.getID() + ".visible", bl);
        }

        public void setSorted(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sorted", bl);
        }

        public void setSortedDescending(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sortedDescending", bl);
        }

        public int getCurrentOrderNumber() {
            return this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
        }

        public void setCurrentOrderNumber(int n) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", n);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int n) {
            this.properties.setInt(this.getID() + ".columnWidth", n);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", true);
        }

        public boolean isSorted() {
            return this.properties.getBoolean(this.getID() + ".sorted", false);
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference model;

        private Listener(SourcesModel sourcesModel) {
            this.model = new WeakReference<SourcesModel>(sourcesModel);
            sourcesModel.sourcePath.addPropertyChangeListener(this);
            sourcesModel.debugger.getSmartSteppingFilter().addPropertyChangeListener((PropertyChangeListener)this);
        }

        private SourcesModel getModel() {
            SourcesModel sourcesModel = (SourcesModel)this.model.get();
            if (sourcesModel == null) {
                sourcesModel.sourcePath.removePropertyChangeListener(this);
                sourcesModel.debugger.getSmartSteppingFilter().removePropertyChangeListener((PropertyChangeListener)this);
            }
            return sourcesModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourcesModel sourcesModel = this.getModel();
            if (sourcesModel == null) {
                return;
            }
            sourcesModel.fireTreeChanged();
        }
    }

    public static class SourcesUsedColumn
    extends AbstractColumn {
        public String getID() {
            return "use";
        }

        public String getDisplayName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_Column_Debugging_Name");
        }

        public Class getType() {
            return Boolean.TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel)).getString("CTL_SourcesModel_Column_Debugging_Desc");
        }

        public boolean initiallyVisible() {
            return true;
        }
    }

    public static class DefaultSourcesColumn
    extends AbstractColumn {
        public String getID() {
            return "DefaultSourcesColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel$DefaultSourcesColumn")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn)).getString("CTL_SourcesModel_Column_Name_Name");
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn == null ? (class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn = SourcesModel.class$("org.netbeans.modules.debugger.jpda.ui.models.SourcesModel$DefaultSourcesColumn")) : class$org$netbeans$modules$debugger$jpda$ui$models$SourcesModel$DefaultSourcesColumn)).getString("CTL_SourcesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }
}

